/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCombiner
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();

    @Test
    public void testSuccessiveUserFuncs1() throws Exception {
        LogicalPlanTester tester = new LogicalPlanTester();
        tester.buildPlan("a = load 'students.txt' as (c1,c2,c3,c4); ");
        tester.buildPlan("c = group a by c2; ");
        tester.buildPlan("f = foreach c generate COUNT(org.apache.pig.builtin.Distinct($1.$2)); ");
        LogicalPlan lp = tester.buildPlan("store f into 'out';");
        PigContext pc = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties()).getPigContext();
        TestCombiner.assertTrue((boolean)((MapReduceOper)Util.buildMRPlan((PhysicalPlan)Util.buildPhysicalPlan((LogicalPlan)lp, (PigContext)pc), (PigContext)pc).getRoots().get((int)0)).combinePlan.isEmpty());
    }

    @Test
    public void testSuccessiveUserFuncs2() throws Exception {
        LogicalPlanTester tester = new LogicalPlanTester();
        tester.buildPlan("a = load 'students.txt' as (c1,c2,c3,c4); ");
        tester.buildPlan("c = group a by c2; ");
        String dummyUDF = JiraPig1030.class.getName();
        tester.buildPlan("f = foreach c generate COUNT(" + dummyUDF + "" + "(org.apache.pig.builtin.Distinct($1.$2)," + dummyUDF + "())); ");
        LogicalPlan lp = tester.buildPlan("store f into 'out';");
        PigContext pc = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties()).getPigContext();
        TestCombiner.assertTrue((boolean)((MapReduceOper)Util.buildMRPlan((PhysicalPlan)Util.buildPhysicalPlan((LogicalPlan)lp, (PigContext)pc), (PigContext)pc).getRoots().get((int)0)).combinePlan.isEmpty());
    }

    @Test
    public void testOnCluster() throws Exception {
        String inputFileName = this.runTest(new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties()));
        Util.deleteFile(this.cluster, inputFileName);
    }

    protected void setUp() throws Exception {
        FileLocalizer.setInitialized((boolean)false);
    }

    @Test
    public void testLocal() throws Exception {
        FileLocalizer.deleteTempFiles();
        this.runTest(new PigServer(ExecType.LOCAL, new Properties()));
        FileLocalizer.deleteTempFiles();
    }

    private String runTest(PigServer pig) throws IOException {
        ArrayList<String> inputLines = new ArrayList<String>();
        inputLines.add("a,b,1");
        inputLines.add("a,b,1");
        inputLines.add("a,c,1");
        String inputFileName = this.loadWithTestLoadFunc("A", pig, inputLines);
        pig.registerQuery("B = group A by ($0, $1);");
        pig.registerQuery("C = foreach B generate flatten(group), COUNT($1);");
        Iterator resultIterator = pig.openIterator("C");
        Tuple tuple = (Tuple)resultIterator.next();
        TestCombiner.assertEquals((String)"(a,b,2L)", (String)tuple.toString());
        tuple = (Tuple)resultIterator.next();
        TestCombiner.assertEquals((String)"(a,c,1L)", (String)tuple.toString());
        return inputFileName;
    }

    private String loadWithTestLoadFunc(String loadAlias, PigServer pig, List<String> inputLines) throws IOException {
        File inputFile = File.createTempFile("test", "txt");
        inputFile.deleteOnExit();
        String inputFileName = inputFile.getAbsolutePath();
        if (pig.getPigContext().getExecType() == ExecType.LOCAL) {
            PrintStream ps = new PrintStream(new FileOutputStream(inputFile));
            for (String line : inputLines) {
                ps.println(line);
            }
            ps.close();
        } else {
            Util.createInputFile(this.cluster, inputFileName, inputLines.toArray(new String[0]));
        }
        pig.registerQuery(loadAlias + " = load '" + inputFileName + "' using " + PigStorage.class.getName() + "(',');");
        return inputFileName;
    }

    @Test
    public void testNoCombinerUse() {
    }

    @Test
    public void testMultiCombinerUse() throws Exception {
        String[] input = new String[512000];
        for (int i = 0; i < input.length; ++i) {
            input[i] = i % 2 == 0 ? Integer.toString(1) : Integer.toString(0);
        }
        Util.createInputFile(this.cluster, "MultiCombinerUseInput.txt", input);
        Properties props = this.cluster.getProperties();
        props.setProperty("io.sort.mb", "1");
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, props);
        pigServer.registerQuery("a = load 'MultiCombinerUseInput.txt' as (x:int);");
        pigServer.registerQuery("b = group a all;");
        pigServer.registerQuery("c = foreach b generate COUNT(a), SUM(a.$0), MIN(a.$0), MAX(a.$0), AVG(a.$0);");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        pigServer.explain("c", ps);
        TestCombiner.assertTrue((boolean)baos.toString().matches("(?si).*combine plan.*"));
        Iterator it = pigServer.openIterator("c");
        Tuple t = (Tuple)it.next();
        TestCombiner.assertEquals((Object)512000L, (Object)t.get(0));
        TestCombiner.assertEquals((Object)256000L, (Object)t.get(1));
        TestCombiner.assertEquals((Object)0, (Object)t.get(2));
        TestCombiner.assertEquals((Object)1, (Object)t.get(3));
        TestCombiner.assertEquals((Object)0.5, (Object)t.get(4));
        TestCombiner.assertFalse((boolean)it.hasNext());
        Util.deleteFile(this.cluster, "MultiCombinerUseInput.txt");
    }

    @Test
    public void testDistinctAggs1() throws Exception {
        String[] input = new String[]{"pig1\t18\t2.1", "pig2\t24\t3.3", "pig5\t45\t2.4", "pig1\t18\t2.1", "pig1\t19\t2.1", "pig2\t24\t4.5", "pig1\t20\t3.1"};
        Util.createInputFile(this.cluster, "distinctAggs1Input.txt", input);
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load 'distinctAggs1Input.txt' as (name:chararray, age:int, gpa:double);");
        pigServer.registerQuery("b = group a by name;");
        pigServer.registerQuery("c = foreach b  {        x = distinct a.age;        y = distinct a.gpa;        z = distinct a;        generate group, COUNT(x), SUM(x.age), SUM(y.gpa), SUM(a.age),                        SUM(a.gpa), COUNT(z.age), COUNT(z), SUM(z.age);};");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        pigServer.explain("c", ps);
        TestCombiner.assertTrue((boolean)baos.toString().matches("(?si).*combine plan.*"));
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        results.put("pig1", new Object[]{"pig1", 3L, 57L, 5.2, 75L, 9.4, 3L, 3L, 57L});
        results.put("pig2", new Object[]{"pig2", 1L, 24L, 7.8, 48L, 7.8, 2L, 2L, 48L});
        results.put("pig5", new Object[]{"pig5", 1L, 45L, 2.4, 45L, 2.4, 1L, 1L, 45L});
        Iterator it = pigServer.openIterator("c");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            List fields = t.getAll();
            Object[] expected = (Object[])results.get((String)fields.get(0));
            int i = 0;
            for (Object field : fields) {
                TestCombiner.assertEquals((Object)expected[i++], field);
            }
        }
        Util.deleteFile(this.cluster, "distinctAggs1Input.txt");
    }

    @Test
    public void testDistinctNoCombiner() throws Exception {
        String[] input = new String[]{"pig1\t18\t2.1", "pig2\t24\t3.3", "pig5\t45\t2.4", "pig1\t18\t2.1", "pig1\t19\t2.1", "pig2\t24\t4.5", "pig1\t20\t3.1"};
        Util.createInputFile(this.cluster, "distinctNoCombinerInput.txt", input);
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load 'distinctNoCombinerInput.txt' as (name:chararray, age:int, gpa:double);");
        pigServer.registerQuery("b = group a by name;");
        pigServer.registerQuery("c = foreach b  {        z = distinct a;        generate group, z, SUM(a.age), SUM(a.gpa);};");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        pigServer.explain("c", ps);
        TestCombiner.assertFalse((boolean)baos.toString().matches("(?si).*combine plan.*"));
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        results.put("pig1", new Object[]{"pig1", "bag-place-holder", 75L, 9.4});
        results.put("pig2", new Object[]{"pig2", "bag-place-holder", 48L, 7.8});
        results.put("pig5", new Object[]{"pig5", "bag-place-holder", 45L, 2.4});
        Iterator it = pigServer.openIterator("c");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            List fields = t.getAll();
            Object[] expected = (Object[])results.get((String)fields.get(0));
            int i = 0;
            for (Object field : fields) {
                if (i == 1) continue;
                TestCombiner.assertEquals((Object)expected[i++], field);
            }
        }
        Util.deleteFile(this.cluster, "distinctNoCombinerInput.txt");
    }

    @Test
    public void testForEachNoCombiner() throws Exception {
        String[] input = new String[]{"pig1\t18\t2.1", "pig2\t24\t3.3", "pig5\t45\t2.4", "pig1\t18\t2.1", "pig1\t19\t2.1", "pig2\t24\t4.5", "pig1\t20\t3.1"};
        Util.createInputFile(this.cluster, "forEachNoCombinerInput.txt", input);
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load 'forEachNoCombinerInput.txt' as (name:chararray, age:int, gpa:double);");
        pigServer.registerQuery("b = group a by name;");
        pigServer.registerQuery("c = foreach b  {        z = a.age;        generate group, z, SUM(a.age), SUM(a.gpa);};");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        pigServer.explain("c", ps);
        TestCombiner.assertFalse((boolean)baos.toString().matches("(?si).*combine plan.*"));
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        results.put("pig1", new Object[]{"pig1", "bag-place-holder", 75L, 9.4});
        results.put("pig2", new Object[]{"pig2", "bag-place-holder", 48L, 7.8});
        results.put("pig5", new Object[]{"pig5", "bag-place-holder", 45L, 2.4});
        Iterator it = pigServer.openIterator("c");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            List fields = t.getAll();
            Object[] expected = (Object[])results.get((String)fields.get(0));
            int i = 0;
            for (Object field : fields) {
                if (i == 1) continue;
                TestCombiner.assertEquals((Object)expected[i++], field);
            }
        }
        Util.deleteFile(this.cluster, "forEachNoCombinerInput.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJiraPig746() {
        String[] input = new String[]{"pig1\t18\t2.1", "pig2\t24\t3.3", "pig5\t45\t2.4", "pig1\t18\t2.1", "pig1\t19\t2.1", "pig2\t24\t4.5", "pig1\t20\t3.1"};
        String[] expected = new String[]{"(pig1,75L,{(pig1,18,2.1),(pig1,18,2.1),(pig1,19,2.1),(pig1,20,3.1)})", "(pig2,48L,{(pig2,24,3.3),(pig2,24,4.5)})", "(pig5,45L,{(pig5,45,2.4)})"};
        try {
            Util.createInputFile(this.cluster, "forEachNoCombinerInput.txt", input);
            PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
            pigServer.registerQuery("a = load 'forEachNoCombinerInput.txt' as (name:chararray, age:int, gpa:double);");
            pigServer.registerQuery("b = group a by name;");
            pigServer.registerQuery("c = foreach b         generate group, SUM(a.age), a;};");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            pigServer.explain("c", ps);
            TestCombiner.assertFalse((boolean)baos.toString().matches("(?si).*combine plan.*"));
            Iterator it = pigServer.openIterator("c");
            int count = 0;
            while (it.hasNext()) {
                Tuple t = (Tuple)it.next();
                TestCombiner.assertEquals((String)expected[count++], (String)t.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            try {
                Util.deleteFile(this.cluster, "forEachNoCombinerInput.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJiraPig1030() {
        String[] input = new String[]{"pig1\t18\t2.1", "pig2\t24\t3.3", "pig5\t45\t2.4", "pig1\t18\t2.1", "pig1\t19\t2.1", "pig2\t24\t4.5", "pig1\t20\t3.1"};
        try {
            Util.createInputFile(this.cluster, "forEachNoCombinerInput.txt", input);
            PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
            pigServer.registerQuery("a = load 'forEachNoCombinerInput.txt' as (name:chararray, age:int, gpa:double);");
            pigServer.registerQuery("b = group a all;");
            pigServer.registerQuery("c = foreach b  {        d = distinct a.age;        generate group, " + JiraPig1030.class.getName() + "(d, 0);};");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            pigServer.explain("c", ps);
            TestCombiner.assertFalse((boolean)baos.toString().matches("(?si).*combine plan.*"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            try {
                Util.deleteFile(this.cluster, "forEachNoCombinerInput.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JiraPig1030
    extends EvalFunc<String> {
        public String exec(Tuple input) throws IOException {
            return "";
        }
    }
}

