/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestCommit
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    TupleFactory mTf = TupleFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testCheckin1() throws Exception {
        Tuple expected1 = this.mTf.newTuple(2);
        Tuple expected2 = this.mTf.newTuple(2);
        expected1.set(0, (Object)"independent");
        expected1.set(1, (Object)50.0);
        expected2.set(0, (Object)"democrat");
        expected2.set(1, (Object)125.5);
        Util.createInputFile(this.cluster, "student", new String[]{"joe smith:18:3.5", "amy brown:25:2.5", "jim fox:20:4.0", "leo fu:55:3.0"});
        Util.createInputFile(this.cluster, "voter", new String[]{"amy brown,25,democrat,25.50", "amy brown,25,democrat,100", "jim fox,20,independent,50.0"});
        this.pigServer.registerQuery("a = load 'student' using " + PigStorage.class.getName() + "(':') as (name, age, gpa);");
        this.pigServer.registerQuery("b = load 'voter' using " + PigStorage.class.getName() + "(',') as (name, age, registration, contributions);");
        this.pigServer.registerQuery("c = filter a by age < 50;");
        this.pigServer.registerQuery("d = filter b by age < 50;");
        this.pigServer.registerQuery("e = cogroup c by (name, age), d by (name, age);");
        this.pigServer.registerQuery("f = foreach e generate flatten(c), flatten(d);");
        this.pigServer.registerQuery("g = group f by registration;");
        this.pigServer.registerQuery("h = foreach g generate (chararray)group, SUM(f.d::contributions);");
        this.pigServer.registerQuery("i = order h by $1;");
        Iterator iter = this.pigServer.openIterator("i");
        int count = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            if (++count == 1) {
                TestCommit.assertTrue((boolean)t.get(0).equals(expected1.get(0)));
                TestCommit.assertTrue((boolean)t.get(1).equals(expected1.get(1)));
                continue;
            }
            if (count != 2) continue;
            TestCommit.assertTrue((boolean)t.get(0).equals(expected2.get(0)));
            TestCommit.assertTrue((boolean)t.get(1).equals(expected2.get(1)));
        }
        TestCommit.assertEquals((int)count, (int)2);
        Util.deleteFile(this.cluster, "student");
        Util.deleteFile(this.cluster, "voter");
    }

    @Test
    public void testCheckin2() throws Exception {
        Tuple expected1 = this.mTf.newTuple(4);
        Tuple expected2 = this.mTf.newTuple(4);
        Util.createInputFile(this.cluster, "testCheckin2-input.txt", new String[]{"joe smith:18:3.5", "amy brown:18:2.5", "jim fox:20:4.0", "leo fu:55:3.0", "amy smith:20:3.0"});
        expected1.set(0, (Object)18);
        expected1.set(1, (Object)1L);
        expected1.set(2, (Object)"joe smith");
        expected1.set(3, (Object)18);
        expected2.set(0, (Object)55);
        expected2.set(1, (Object)1L);
        expected2.set(2, (Object)"leo fu");
        expected2.set(3, (Object)55);
        this.pigServer.registerQuery("a = load 'testCheckin2-input.txt' using " + PigStorage.class.getName() + "(':') as (name: chararray, age: int, gpa: float);");
        this.pigServer.registerQuery("b = group a by age;");
        this.pigServer.registerQuery("c = foreach b { d = filter a by gpa > 2.5;  e = order a by name; f = a.age; g = distinct f;  generate group, COUNT(d), MAX (e.name), MIN(g.$0);};");
        this.pigServer.registerQuery("h = order c by $1;");
        this.pigServer.registerQuery("i = limit h 2;");
        this.pigServer.store("i", "testCheckin2-output.txt");
        this.pigServer.registerQuery("x = load 'testCheckin2-output.txt' as (age: int, cnt: long, max: chararray, min: int);");
        this.pigServer.registerQuery("y = foreach x generate age, cnt, max, min;");
        Iterator iter = this.pigServer.openIterator("y");
        int count = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            if (++count == 1) {
                TestCommit.assertTrue((boolean)t.get(0).equals(expected1.get(0)));
                TestCommit.assertTrue((boolean)t.get(1).equals(expected1.get(1)));
                TestCommit.assertTrue((boolean)t.get(2).equals(expected1.get(2)));
                TestCommit.assertTrue((boolean)t.get(3).equals(expected1.get(3)));
                continue;
            }
            if (count != 2) continue;
            TestCommit.assertTrue((boolean)t.get(0).equals(expected2.get(0)));
            TestCommit.assertTrue((boolean)t.get(1).equals(expected2.get(1)));
            TestCommit.assertTrue((boolean)t.get(2).equals(expected2.get(2)));
            TestCommit.assertTrue((boolean)t.get(3).equals(expected2.get(3)));
        }
        TestCommit.assertEquals((int)count, (int)2);
        Util.deleteFile(this.cluster, "testCheckin2-input.txt");
    }
}

