/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ResourceSchema;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

public class TestConversions
extends TestCase {
    PigStorage ps = new PigStorage();
    Random r = new Random();
    final int MAX = 10;

    @Test
    public void testBytesToInteger() throws IOException {
        String[] a = new String[]{"1", "-2345", "1234567", "1.1", "-23.45", ""};
        Integer[] ia = new Integer[]{1, -2345, 1234567, 1, -23};
        for (int i = 0; i < ia.length; ++i) {
            byte[] b = a[i].getBytes();
            TestConversions.assertEquals((Object)ia[i], (Object)this.ps.getLoadCaster().bytesToInteger(b));
        }
        for (String s : a = new String[]{"1234567890123456", "This is an int", ""}) {
            byte[] b = s.getBytes();
            Integer i = this.ps.getLoadCaster().bytesToInteger(b);
            TestConversions.assertEquals(null, (Object)i);
        }
    }

    @Test
    public void testBytesToFloat() throws IOException {
        String[] a = new String[]{"1", "-2.345", "12.12334567", "1.02e-2", ".23344", "23.1234567897", "12312.33f", "002312.33F", "1.02e-2f", ""};
        Float[] f = new Float[]{Float.valueOf(1.0f), Float.valueOf(-2.345f), Float.valueOf(12.123345f), Float.valueOf(0.0102f), Float.valueOf(0.23344f), Float.valueOf(23.123457f), Float.valueOf(12312.33f), Float.valueOf(2312.33f), Float.valueOf(0.0102f)};
        for (int j = 0; j < f.length; ++j) {
            byte[] b = a[j].getBytes();
            TestConversions.assertEquals((Object)f[j], (Object)this.ps.getLoadCaster().bytesToFloat(b));
        }
        for (String s : a = new String[]{"1a.1", "23.1234567a890123456", "This is a float", ""}) {
            byte[] b = s.getBytes();
            Float fl = this.ps.getLoadCaster().bytesToFloat(b);
            TestConversions.assertEquals(null, (Object)fl);
        }
    }

    @Test
    public void testBytesToDouble() throws IOException {
        String[] a = new String[]{"1", "-2.345", "12.12334567890123456", "1.02e12", "-.23344", ""};
        Double[] d = new Double[]{1.0, -2.345, 12.123345678901234, 1.02E12, -0.23344};
        for (int j = 0; j < d.length; ++j) {
            byte[] b = a[j].getBytes();
            TestConversions.assertEquals((Object)d[j], (Object)this.ps.getLoadCaster().bytesToDouble(b));
        }
        for (String s : a = new String[]{"-0x1.1", "-23a.45", "This is a double", ""}) {
            byte[] b = s.getBytes();
            Double dl = this.ps.getLoadCaster().bytesToDouble(b);
            TestConversions.assertEquals(null, (Object)dl);
        }
    }

    @Test
    public void testBytesToLong() throws IOException {
        String[] a = new String[]{"1", "-2345", "123456789012345678", "1.1", "-23.45", "21345345l", "3422342L", ""};
        Long[] la = new Long[]{1L, -2345L, 123456789012345678L, 1L, -23L, 21345345L, 3422342L};
        for (int i = 0; i < la.length; ++i) {
            byte[] b = a[i].getBytes();
            TestConversions.assertEquals((Object)la[i], (Object)this.ps.getLoadCaster().bytesToLong(b));
        }
        for (String s : a = new String[]{"This is a long", "1.0e1000", ""}) {
            byte[] b = s.getBytes();
            Long l = this.ps.getLoadCaster().bytesToLong(b);
            TestConversions.assertEquals(null, (Object)l);
        }
    }

    @Test
    public void testBytesToChar() throws IOException {
        String[] a;
        for (String s : a = new String[]{"1", "-2345", "text", "hello\nworld", ""}) {
            byte[] b = s.getBytes();
            TestConversions.assertEquals((String)s, (String)this.ps.getLoadCaster().bytesToCharArray(b));
        }
    }

    @Test
    public void testBytesToTuple() throws IOException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = GenRandomData.genRandSmallBagTextTuple(this.r, 1, 100);
            ResourceSchema.ResourceFieldSchema fs = GenRandomData.getSmallBagTextTupleFieldSchema();
            Tuple convertedTuple = this.ps.getLoadCaster().bytesToTuple(t.toString().getBytes(), fs);
            TestConversions.assertTrue((boolean)TestHelper.tupleEquals(t, convertedTuple));
        }
    }

    @Test
    public void testBytesToBag() throws IOException {
        ResourceSchema.ResourceFieldSchema fs = GenRandomData.getFullTupTextDataBagFieldSchema();
        for (int i = 0; i < 10; ++i) {
            DataBag b = GenRandomData.genRandFullTupTextDataBag(this.r, 5, 100);
            DataBag convertedBag = this.ps.getLoadCaster().bytesToBag(b.toString().getBytes(), fs);
            TestConversions.assertTrue((boolean)TestHelper.bagEquals(b, convertedBag));
        }
    }

    @Test
    public void testBytesToMap() throws IOException {
        for (int i = 0; i < 10; ++i) {
            Map<String, Object> m = GenRandomData.genRandMap(this.r, 5);
            String expectedMapString = DataType.mapToString(m);
            Map convertedMap = this.ps.getLoadCaster().bytesToMap(expectedMapString.getBytes());
            TestConversions.assertTrue((boolean)TestHelper.mapEquals(m, convertedMap));
        }
    }

    @Test
    public void testIntegerToBytes() throws IOException {
        Integer i = this.r.nextInt();
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])i.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(i)));
    }

    @Test
    public void testLongToBytes() throws IOException {
        Long l = this.r.nextLong();
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])l.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(l)));
    }

    @Test
    public void testFloatToBytes() throws IOException {
        Float f = Float.valueOf(this.r.nextFloat());
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])f.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(f)));
    }

    @Test
    public void testDoubleToBytes() throws IOException {
        Double d = this.r.nextDouble();
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])d.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(d)));
    }

    @Test
    public void testCharArrayToBytes() throws IOException {
        String s = GenRandomData.genRandString(this.r);
        TestConversions.assertTrue((boolean)s.equals(new String(((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(s))));
    }

    @Test
    public void testTupleToBytes() throws IOException {
        Tuple t = GenRandomData.genRandSmallBagTextTuple(this.r, 1, 100);
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])t.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(t)));
    }

    @Test
    public void testBagToBytes() throws IOException {
        DataBag b = GenRandomData.genRandFullTupTextDataBag(this.r, 5, 100);
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])b.toString().getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(b)));
    }

    @Test
    public void testMapToBytes() throws IOException {
        Map<String, Object> m = GenRandomData.genRandMap(this.r, 5);
        TestConversions.assertTrue((boolean)DataType.equalByteArrays((byte[])DataType.mapToString(m).getBytes(), (byte[])((Utf8StorageConverter)this.ps.getLoadCaster()).toBytes(m)));
    }

    @Test
    public void testBytesToBagWithConversion() throws IOException {
        DataBag b = GenRandomData.genFloatDataBag(this.r, 5, 100);
        ResourceSchema.ResourceFieldSchema fs = GenRandomData.getFloatDataBagFieldSchema(5);
        DataBag convertedBag = this.ps.getLoadCaster().bytesToBag(b.toString().getBytes(), fs);
        Iterator iter1 = b.iterator();
        Iterator iter2 = convertedBag.iterator();
        for (int i = 0; i < 100; ++i) {
            Tuple t1 = (Tuple)iter1.next();
            TestConversions.assertTrue((boolean)iter2.hasNext());
            Tuple t2 = (Tuple)iter2.next();
            for (int j = 0; j < 5; ++j) {
                TestConversions.assertTrue((boolean)(t2.get(j) instanceof Integer));
                float expectedValue = ((Float)t1.get(j)).floatValue();
                TestConversions.assertTrue(((Integer)t2.get(j) == (int)expectedValue ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testBytesToTupleWithConversion() throws IOException {
        for (int i = 0; i < 100; ++i) {
            Tuple t = GenRandomData.genMixedTupleToConvert(this.r);
            ResourceSchema.ResourceFieldSchema fs = GenRandomData.getMixedTupleToConvertFieldSchema();
            Tuple convertedTuple = this.ps.getLoadCaster().bytesToTuple(t.toString().getBytes(), fs);
            TestConversions.assertTrue((boolean)(convertedTuple.get(0) instanceof String));
            TestConversions.assertTrue((boolean)convertedTuple.get(0).equals(((Integer)t.get(0)).toString()));
            TestConversions.assertTrue((boolean)(convertedTuple.get(1) instanceof Long));
            Integer origValue1 = (Integer)t.get(1);
            TestConversions.assertTrue((boolean)convertedTuple.get(1).equals(new Long(origValue1.longValue())));
            TestConversions.assertTrue((convertedTuple.get(2) == null ? 1 : 0) != 0);
            TestConversions.assertTrue((boolean)(convertedTuple.get(3) instanceof Double));
            Float origValue3 = (Float)t.get(3);
            TestConversions.assertTrue(((Double)convertedTuple.get(3) - origValue3.doubleValue() < 0.01 ? 1 : 0) != 0);
            TestConversions.assertTrue((boolean)(convertedTuple.get(4) instanceof Float));
            Double origValue4 = (Double)t.get(4);
            TestConversions.assertTrue(((double)(((Float)convertedTuple.get(4)).floatValue() - origValue4.floatValue()) < 0.01 ? 1 : 0) != 0);
            TestConversions.assertTrue((boolean)(convertedTuple.get(5) instanceof String));
            TestConversions.assertTrue((boolean)convertedTuple.get(5).equals(t.get(5)));
            TestConversions.assertTrue((convertedTuple.get(6) == null ? 1 : 0) != 0);
            TestConversions.assertTrue((convertedTuple.get(7) == null ? 1 : 0) != 0);
            TestConversions.assertTrue((convertedTuple.get(8) == null ? 1 : 0) != 0);
            TestConversions.assertTrue((boolean)(convertedTuple.get(9) instanceof Boolean));
            String origValue9 = (String)t.get(9);
            TestConversions.assertTrue((boolean)new Boolean(origValue9).equals(convertedTuple.get(9)));
        }
    }

    public void testBytesToComplexTypeMisc() throws IOException, ParseException {
        String s = "(a,b";
        Schema schema = Utils.getSchemaFromString((String)"t:tuple(a:chararray, b:chararray)");
        ResourceSchema.ResourceFieldSchema rfs = new ResourceSchema(schema).getFields()[0];
        Tuple t = this.ps.getLoadCaster().bytesToTuple(s.getBytes(), rfs);
        TestConversions.assertTrue((t == null ? 1 : 0) != 0);
        s = "{(a,b}";
        schema = Utils.getSchemaFromString((String)"b:bag{t:tuple(a:chararray, b:chararray)}");
        rfs = new ResourceSchema(schema).getFields()[0];
        DataBag b = this.ps.getLoadCaster().bytesToBag(s.getBytes(), rfs);
        TestConversions.assertTrue((b == null ? 1 : 0) != 0);
        s = "{(a,b)";
        schema = Utils.getSchemaFromString((String)"b:bag{t:tuple(a:chararray, b:chararray)}");
        rfs = new ResourceSchema(schema).getFields()[0];
        b = this.ps.getLoadCaster().bytesToBag(s.getBytes(), rfs);
        TestConversions.assertTrue((b == null ? 1 : 0) != 0);
        s = "[ab]";
        Map m = this.ps.getLoadCaster().bytesToMap(s.getBytes());
        TestConversions.assertTrue((m == null ? 1 : 0) != 0);
        s = "[a#b";
        m = this.ps.getLoadCaster().bytesToMap(s.getBytes());
        TestConversions.assertTrue((m == null ? 1 : 0) != 0);
        s = "[a#]";
        m = this.ps.getLoadCaster().bytesToMap(s.getBytes());
        Map.Entry entry = m.entrySet().iterator().next();
        TestConversions.assertTrue((boolean)((String)entry.getKey()).equals("a"));
        TestConversions.assertTrue((entry.getValue() == null ? 1 : 0) != 0);
        s = "[#]";
        m = this.ps.getLoadCaster().bytesToMap(s.getBytes());
        TestConversions.assertTrue((m == null ? 1 : 0) != 0);
        s = "(a,b)";
        schema = Utils.getSchemaFromString((String)"t:tuple()");
        rfs = new ResourceSchema(schema).getFields()[0];
        t = this.ps.getLoadCaster().bytesToTuple(s.getBytes(), rfs);
        TestConversions.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestConversions.assertTrue((boolean)(t.get(0) instanceof DataByteArray));
        TestConversions.assertTrue((boolean)t.get(0).toString().equals("a,b"));
        s = "[a#(1,2,3)]";
        m = this.ps.getLoadCaster().bytesToMap(s.getBytes());
        entry = m.entrySet().iterator().next();
        TestConversions.assertTrue((boolean)((String)entry.getKey()).equals("a"));
        TestConversions.assertTrue((boolean)(entry.getValue() instanceof DataByteArray));
        TestConversions.assertTrue((boolean)entry.getValue().toString().equals("(1,2,3)"));
        s = "(a,b,(123,456,{(1,2,3)}))";
        schema = Utils.getSchemaFromString((String)"t:tuple()");
        rfs = new ResourceSchema(schema).getFields()[0];
        t = this.ps.getLoadCaster().bytesToTuple(s.getBytes(), rfs);
        TestConversions.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestConversions.assertTrue((boolean)(t.get(0) instanceof DataByteArray));
        TestConversions.assertTrue((boolean)t.get(0).toString().equals("a,b,(123,456,{(1,2,3)})"));
        s = "(a,b,(123,456,{(1,2,3}))";
        schema = Utils.getSchemaFromString((String)"t:tuple()");
        rfs = new ResourceSchema(schema).getFields()[0];
        t = this.ps.getLoadCaster().bytesToTuple(s.getBytes(), rfs);
        TestConversions.assertTrue((t == null ? 1 : 0) != 0);
    }
}

