/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.tools.pigstats.PigStats;
import org.junit.Test;

public class TestCounters
extends TestCase {
    String file = "input.txt";
    MiniCluster cluster = MiniCluster.buildCluster();
    final int MAX = 100000;
    Random r = new Random();

    @Test
    public void testMapOnly() throws IOException, ExecException {
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        for (int i = 0; i < 100000; ++i) {
            int t = this.r.nextInt(100);
            pw.println(t);
            if (t <= 50) continue;
            ++count;
        }
        pw.close();
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = filter a by $0 > 50;");
        pigServer.registerQuery("c = foreach b generate $0 - 50;");
        PigStats pigStats = pigServer.store("c", "output_map_only").getStatistics();
        Map stats = pigStats.getPigStats();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output_map_only", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output_map_only"), true);
        System.out.println("============================================");
        System.out.println("Test case Map Only");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        TestCounters.assertNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertEquals((int)0, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        TestCounters.assertEquals((int)0, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMapOnlyBinStorage() throws IOException, ExecException {
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        for (int i = 0; i < 100000; ++i) {
            int t = this.r.nextInt(100);
            pw.println(t);
            if (t <= 50) continue;
            ++count;
        }
        pw.close();
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = filter a by $0 > 50;");
        pigServer.registerQuery("c = foreach b generate $0 - 50;");
        PigStats pigStats = pigServer.store("c", "output_map_only", "BinStorage").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output_map_only", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output_map_only"), true);
        System.out.println("============================================");
        System.out.println("Test case Map Only");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        TestCounters.assertNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertEquals((int)0, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        TestCounters.assertEquals((int)0, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMapReduceOnly() throws IOException, ExecException {
        int i;
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        int[] nos = new int[10];
        for (i = 0; i < 10; ++i) {
            nos[i] = 0;
        }
        for (i = 0; i < 100000; ++i) {
            int index = this.r.nextInt(10);
            int value = this.r.nextInt(100);
            int n = index;
            nos[n] = nos[n] + value;
            pw.println(index + "\t" + value);
        }
        pw.close();
        for (i = 0; i < 10; ++i) {
            if (nos[i] <= 0) continue;
            ++count;
        }
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = group a by $0;");
        pigServer.registerQuery("c = foreach b generate group;");
        PigStats pigStats = pigServer.store("c", "output").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output"), true);
        System.out.println("============================================");
        System.out.println("Test case MapReduce");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        System.out.println("Reduce input records : " + (String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        System.out.println("Reduce output records : " + (String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMapReduceOnlyBinStorage() throws IOException, ExecException {
        int i;
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        int[] nos = new int[10];
        for (i = 0; i < 10; ++i) {
            nos[i] = 0;
        }
        for (i = 0; i < 100000; ++i) {
            int index = this.r.nextInt(10);
            int value = this.r.nextInt(100);
            int n = index;
            nos[n] = nos[n] + value;
            pw.println(index + "\t" + value);
        }
        pw.close();
        for (i = 0; i < 10; ++i) {
            if (nos[i] <= 0) continue;
            ++count;
        }
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = group a by $0;");
        pigServer.registerQuery("c = foreach b generate group;");
        PigStats pigStats = pigServer.store("c", "output", "BinStorage").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output"), true);
        System.out.println("============================================");
        System.out.println("Test case MapReduce");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        System.out.println("Reduce input records : " + (String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        System.out.println("Reduce output records : " + (String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMapCombineReduce() throws IOException, ExecException {
        int i;
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        int[] nos = new int[10];
        for (i = 0; i < 10; ++i) {
            nos[i] = 0;
        }
        for (i = 0; i < 100000; ++i) {
            int index = this.r.nextInt(10);
            int value = this.r.nextInt(100);
            int n = index;
            nos[n] = nos[n] + value;
            pw.println(index + "\t" + value);
        }
        pw.close();
        for (i = 0; i < 10; ++i) {
            if (nos[i] <= 0) continue;
            ++count;
        }
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = group a by $0;");
        pigServer.registerQuery("c = foreach b generate group, SUM(a.$1);");
        PigStats pigStats = pigServer.store("c", "output").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output"), true);
        System.out.println("============================================");
        System.out.println("Test case MapCombineReduce");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        System.out.println("Reduce input records : " + (String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        System.out.println("Reduce output records : " + (String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMapCombineReduceBinStorage() throws IOException, ExecException {
        int i;
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        int[] nos = new int[10];
        for (i = 0; i < 10; ++i) {
            nos[i] = 0;
        }
        for (i = 0; i < 100000; ++i) {
            int index = this.r.nextInt(10);
            int value = this.r.nextInt(100);
            int n = index;
            nos[n] = nos[n] + value;
            pw.println(index + "\t" + value);
        }
        pw.close();
        for (i = 0; i < 10; ++i) {
            if (nos[i] <= 0) continue;
            ++count;
        }
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = group a by $0;");
        pigServer.registerQuery("c = foreach b generate group, SUM(a.$1);");
        PigStats pigStats = pigServer.store("c", "output", "BinStorage").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output"), true);
        System.out.println("============================================");
        System.out.println("Test case MapCombineReduce");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map.Entry e = stats.entrySet().iterator().next();
        Map jobStats = (Map)e.getValue();
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        System.out.println("Reduce input records : " + (String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        System.out.println("Reduce output records : " + (String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_COMBINE_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_MAP_PLAN"));
        TestCounters.assertNotNull(jobStats.get("PIG_STATS_REDUCE_PLAN"));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }

    @Test
    public void testMultipleMRJobs() throws IOException, ExecException {
        int i;
        int count = 0;
        PrintWriter pw = new PrintWriter(Util.createInputFile(this.cluster, this.file));
        int[] nos = new int[10];
        for (i = 0; i < 10; ++i) {
            nos[i] = 0;
        }
        for (i = 0; i < 100000; ++i) {
            int index = this.r.nextInt(10);
            int value = this.r.nextInt(100);
            int n = index;
            nos[n] = nos[n] + value;
            pw.println(index + "\t" + value);
        }
        pw.close();
        for (i = 0; i < 10; ++i) {
            if (nos[i] <= 0) continue;
            ++count;
        }
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pigServer.registerQuery("a = load '" + this.file + "';");
        pigServer.registerQuery("b = order a by $0;");
        pigServer.registerQuery("c = group b by $0;");
        pigServer.registerQuery("d = foreach c generate group, SUM(b.$1);");
        PigStats pigStats = pigServer.store("d", "output").getStatistics();
        InputStream is = FileLocalizer.open((String)FileLocalizer.fullPath((String)"output", (PigContext)pigServer.getPigContext()), (ExecType)ExecType.MAPREDUCE, (DataStorage)pigServer.getPigContext().getDfs());
        long filesize = 0L;
        while (is.read() != -1) {
            ++filesize;
        }
        is.close();
        Map stats = pigStats.getPigStats();
        this.cluster.getFileSystem().delete(new Path(this.file), true);
        this.cluster.getFileSystem().delete(new Path("output"), true);
        System.out.println("============================================");
        System.out.println("Test case MultipleMRJobs");
        System.out.println("============================================");
        System.out.println("MRPlan : \n" + pigStats.getMRPlan());
        for (Map.Entry entry : stats.entrySet()) {
            System.out.println("============================================");
            System.out.println("Job : " + (String)entry.getKey());
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                System.out.println(" - " + (String)e1.getKey() + " : \n" + (String)e1.getValue());
            }
            System.out.println("============================================");
        }
        Map jobStats = (Map)stats.get(pigStats.getRootJobIDs().get(0));
        System.out.println("Map input records : " + (String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_INPUT_RECORDS")));
        System.out.println("Map output records : " + (String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)100000, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_MAP_OUTPUT_RECORDS")));
        System.out.println("Reduce input records : " + (String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_INPUT_RECORDS")));
        System.out.println("Reduce output records : " + (String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS"));
        TestCounters.assertEquals((int)count, (int)Integer.parseInt((String)jobStats.get("PIG_STATS_REDUCE_OUTPUT_RECORDS")));
        TestCounters.assertEquals((long)count, (long)pigStats.getRecordsWritten());
        TestCounters.assertEquals((long)filesize, (long)pigStats.getBytesWritten());
    }
}

