/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.DistinctDataBag;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.InternalDistinctBag;
import org.apache.pig.data.InternalSortedBag;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.SingleTupleBag;
import org.apache.pig.data.SortedDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Spillable;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestDataBag
extends TestCase {
    private Random rand = new Random();

    protected void tearDown() throws Exception {
        BagFactory.resetSelf();
        System.clearProperty("pig.data.bag.factory.name");
        System.clearProperty("pig.data.bag.factory.jar");
    }

    @Test
    public void testDefaultInMemory() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDefaultBag();
        ArrayList<Tuple> rightAnswer = new ArrayList<Tuple>(10);
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDefaultSingleSpill() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDefaultBag();
        ArrayList<Tuple> rightAnswer = new ArrayList<Tuple>(10);
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDefaultTripleSpill() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDefaultBag();
        ArrayList<Tuple> rightAnswer = new ArrayList<Tuple>(30);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 10; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
                b.add(t);
                rightAnswer.add(t);
            }
            mgr.forceSpill();
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDefaultInMemInFile() throws Exception {
        Tuple t;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDefaultBag();
        ArrayList<Tuple> rightAnswer = new ArrayList<Tuple>(20);
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDefaultSpillDuringRead() throws Exception {
        Tuple t;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDefaultBag();
        ArrayList<Tuple> rightAnswer = new ArrayList<Tuple>(20);
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        for (int i2 = 0; i2 < 15; ++i2) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        mgr.forceSpill();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedInMemory() throws Exception {
        Tuple t;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(10);
        for (int i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedSingleSpill() throws Exception {
        Tuple t;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(10);
        for (int i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        Iterator bIter = b.iterator();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedTripleSpill() throws Exception {
        Tuple t;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(30);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 10; ++i) {
                Tuple t2 = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
                b.add(t2);
                rightAnswer.add(t2);
            }
            mgr.forceSpill();
        }
        Iterator bIter = b.iterator();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedInMemInFile() throws Exception {
        Tuple t;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(20);
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedSpillDuringRead() throws Exception {
        Tuple t;
        Tuple t2;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(20);
        for (i = 0; i < 10; ++i) {
            t2 = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t2);
            rightAnswer.add(t2);
        }
        mgr.forceSpill();
        for (i = 0; i < 10; ++i) {
            t2 = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t2);
            rightAnswer.add(t2);
        }
        Iterator bIter = b.iterator();
        for (int i2 = 0; i2 < 15; ++i2) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rightAnswer.poll());
        }
        mgr.forceSpill();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedFirstSpillDuringRead() throws Exception {
        Tuple t;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(20);
        for (int i = 0; i < 10; ++i) {
            Tuple t2 = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
            b.add(t2);
            rightAnswer.add(t2);
        }
        Iterator bIter = b.iterator();
        for (int i = 0; i < 5; ++i) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rightAnswer.poll());
        }
        mgr.forceSpill();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testSortedPreMerge() throws Exception {
        Tuple t;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newSortedBag(null);
        PriorityQueue<Tuple> rightAnswer = new PriorityQueue<Tuple>(30);
        for (int j = 0; j < 373; ++j) {
            for (int i = 0; i < 10; ++i) {
                Tuple t2 = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt()));
                b.add(t2);
                rightAnswer.add(t2);
            }
            mgr.forceSpill();
        }
        Iterator bIter = b.iterator();
        while ((t = (Tuple)rightAnswer.poll()) != null) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), (Object)t);
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctInMemory() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (int i = 0; i < 50; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctSingleSpill() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (int i = 0; i < 50; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctTripleSpill() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 50; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
                b.add(t);
                rightAnswer.add(t);
            }
            mgr.forceSpill();
        }
        TestDataBag.assertEquals((String)"Size of distinct data bag is incorrect", (long)b.size(), (long)rightAnswer.size());
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctInMemInFile() throws Exception {
        Tuple t;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (i = 0; i < 50; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        for (i = 0; i < 50; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctSpillDuringRead() throws Exception {
        Tuple t;
        int i;
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (i = 0; i < 50; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
            b.add(t);
            rightAnswer.add(t);
        }
        mgr.forceSpill();
        for (i = 0; i < 50; ++i) {
            t = TupleFactory.getInstance().newTuple((Object)new Integer(i));
            b.add(t);
            rightAnswer.add(t);
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        for (int i2 = 0; i2 < 5; ++i2) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        mgr.forceSpill();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDistinctPreMerge() throws Exception {
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag b = factory.newDistinctBag();
        TreeSet<Tuple> rightAnswer = new TreeSet<Tuple>();
        for (int j = 0; j < 321; ++j) {
            for (int i = 0; i < 50; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(this.rand.nextInt() % 5));
                b.add(t);
                rightAnswer.add(t);
            }
            mgr.forceSpill();
        }
        Iterator bIter = b.iterator();
        Iterator rIter = rightAnswer.iterator();
        while (rIter.hasNext()) {
            TestDataBag.assertTrue((String)"bag ran out of tuples before answer", (boolean)bIter.hasNext());
            TestDataBag.assertEquals((String)"tuples should be the same", bIter.next(), rIter.next());
        }
        TestDataBag.assertFalse((String)"right answer ran out of tuples before the bag", (boolean)bIter.hasNext());
    }

    @Test
    public void testDefaultBagFactory() throws Exception {
        BagFactory f = BagFactory.getInstance();
        DataBag bag = f.newDefaultBag();
        DataBag sorted = f.newSortedBag(null);
        DataBag distinct = f.newDistinctBag();
        TestDataBag.assertTrue((String)"Expected a default bag", (boolean)(bag instanceof DefaultDataBag));
        TestDataBag.assertTrue((String)"Expected a sorted bag", (boolean)(sorted instanceof SortedDataBag));
        TestDataBag.assertTrue((String)"Expected a distinct bag", (boolean)(distinct instanceof DistinctDataBag));
    }

    @Test
    public void testProvidedBagFactory() throws Exception {
        BagFactory f;
        BagFactory.resetSelf();
        System.setProperty("pig.data.bag.factory.name", "no such class");
        System.setProperty("pig.data.bag.factory.jar", "file:./pig.jar");
        boolean caughtIt = false;
        try {
            f = BagFactory.getInstance();
        }
        catch (RuntimeException re) {
            TestDataBag.assertEquals((String)"Expected Unable to instantiate message", (String)"Unable to instantiate bag factory no such class", (String)re.getMessage());
            caughtIt = true;
        }
        TestDataBag.assertTrue((String)"Expected to catch exception", (boolean)caughtIt);
        BagFactory.resetSelf();
        System.setProperty("pig.data.bag.factory.name", "org.apache.pig.test.TestDataBag");
        System.setProperty("pig.data.bag.factory.jar", "file:./pig.jar");
        caughtIt = false;
        try {
            f = BagFactory.getInstance();
        }
        catch (RuntimeException re) {
            TestDataBag.assertEquals((String)"Expected does not extend BagFactory message", (String)"Provided factory org.apache.pig.test.TestDataBag does not extend BagFactory!", (String)re.getMessage());
            caughtIt = true;
        }
        TestDataBag.assertTrue((String)"Expected to catch exception", (boolean)caughtIt);
        BagFactory.resetSelf();
        System.setProperty("pig.data.bag.factory.name", "org.apache.pig.test.NonDefaultBagFactory");
        System.setProperty("pig.data.bag.factory.jar", "file:./pig.jar");
        f = BagFactory.getInstance();
        DataBag b = f.newDefaultBag();
        b = f.newSortedBag(null);
        b = f.newDistinctBag();
        BagFactory.resetSelf();
    }

    @Test
    public void testNonSpillableDataBagEquals1() throws Exception {
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        NonSpillableDataBag bg1 = new NonSpillableDataBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        NonSpillableDataBag bg2 = new NonSpillableDataBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
    }

    @Test
    public void testNonSpillableDataBagEquals2() throws Exception {
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        NonSpillableDataBag bg1 = new NonSpillableDataBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        tupleContents = new String[][]{{"c", "d"}, {"a", "b"}, {"e", "f"}};
        NonSpillableDataBag bg2 = new NonSpillableDataBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
    }

    @Test
    public void testDefaultDataBagEquals1() throws Exception {
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag bg1 = factory.newDefaultBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        DataBag bg2 = factory.newDefaultBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
    }

    @Test
    public void testDefaultDataBagEquals2() throws Exception {
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        TestMemoryManager mgr = new TestMemoryManager();
        LocalBagFactory factory = new LocalBagFactory(mgr);
        DataBag bg1 = factory.newDefaultBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        tupleContents = new String[][]{{"c", "d"}, {"a", "b"}, {"e", "f"}};
        DataBag bg2 = factory.newDefaultBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
    }

    public void testInternalCachedBag() throws Exception {
        InternalCachedBag bg0 = new InternalCachedBag();
        bg0.add(TupleFactory.getInstance().newTuple());
        bg0.add(TupleFactory.getInstance().newTuple());
        TestDataBag.assertEquals((long)bg0.size(), (long)2L);
        InternalCachedBag bg1 = new InternalCachedBag(1, 0.5f);
        TestDataBag.assertEquals((long)bg1.size(), (long)0L);
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((long)bg1.size(), (long)3L);
        TestDataBag.assertFalse((boolean)bg1.isSorted());
        TestDataBag.assertFalse((boolean)bg1.isDistinct());
        tupleContents = new String[][]{{"c", "d"}, {"a", "b"}, {"e", "f"}};
        InternalCachedBag bg2 = new InternalCachedBag(1, 0.5f);
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
        InternalCachedBag bg3 = new InternalCachedBag(1, 0.0f);
        tupleContents = new String[][]{{"e", "f"}, {"c", "d"}, {"a", "b"}};
        for (int i = 0; i < tupleContents.length; ++i) {
            bg3.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg3);
        Iterator iter = bg3.iterator();
        InternalCachedBag bg4 = new InternalCachedBag(1, 0.0f);
        while (iter.hasNext()) {
            bg4.add((Tuple)iter.next());
        }
        TestDataBag.assertEquals((Object)bg3, (Object)bg4);
        iter = bg3.iterator();
        TestDataBag.assertTrue((boolean)iter.hasNext());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        InternalCachedBag bg5 = new InternalCachedBag(1, 0.0f);
        bg5.add((Tuple)iter.next());
        bg5.add((Tuple)iter.next());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        bg5.add((Tuple)iter.next());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertEquals((Object)bg3, (Object)bg5);
        bg4.clear();
        TestDataBag.assertEquals((long)bg4.size(), (long)0L);
    }

    public void testInternalSortedBag() throws Exception {
        int i;
        int i2;
        InternalSortedBag bg0 = new InternalSortedBag();
        bg0.add(TupleFactory.getInstance().newTuple());
        bg0.add(TupleFactory.getInstance().newTuple());
        TestDataBag.assertEquals((long)bg0.size(), (long)2L);
        InternalSortedBag bg1 = new InternalSortedBag();
        TestDataBag.assertEquals((long)bg1.size(), (long)0L);
        String[][] tupleContents = new String[][]{{"e", "f"}, {"a", "b"}, {"c", "d"}};
        for (int i3 = 0; i3 < tupleContents.length; ++i3) {
            bg1.add(Util.createTuple(tupleContents[i3]));
        }
        TestDataBag.assertEquals((long)bg1.size(), (long)3L);
        TestDataBag.assertTrue((boolean)bg1.isSorted());
        TestDataBag.assertFalse((boolean)bg1.isDistinct());
        tupleContents = new String[][]{{"c", "d"}, {"a", "b"}, {"e", "f"}};
        InternalSortedBag bg2 = new InternalSortedBag();
        for (int i4 = 0; i4 < tupleContents.length; ++i4) {
            bg2.add(Util.createTuple(tupleContents[i4]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
        Iterator iter = bg1.iterator();
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"a", "b"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"c", "d"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"e", "f"}));
        InternalSortedBag bg3 = new InternalSortedBag(1, 0.0, null);
        tupleContents = new String[][]{{"e", "f"}, {"c", "d"}, {"a", "b"}};
        for (int i5 = 0; i5 < tupleContents.length; ++i5) {
            bg3.add(Util.createTuple(tupleContents[i5]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg3);
        iter = bg3.iterator();
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"a", "b"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"c", "d"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"e", "f"}));
        iter = bg3.iterator();
        TestDataBag.assertTrue((boolean)iter.hasNext());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        InternalSortedBag bg4 = new InternalSortedBag(1, 0.0, null);
        bg4.add((Tuple)iter.next());
        bg4.add((Tuple)iter.next());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        bg4.add((Tuple)iter.next());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertEquals((Object)bg3, (Object)bg4);
        bg3.clear();
        TestDataBag.assertEquals((long)bg3.size(), (long)0L);
        InternalSortedBag bg5 = new InternalSortedBag();
        for (int j = 0; j < 3; ++j) {
            for (i2 = 0; i2 < tupleContents.length; ++i2) {
                bg5.add(Util.createTuple(tupleContents[i2]));
            }
            bg5.spill();
        }
        TestDataBag.assertEquals((long)bg5.size(), (long)9L);
        iter = bg5.iterator();
        for (i = 0; i < 3; ++i) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"a", "b"}));
        }
        for (i = 0; i < 3; ++i) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"c", "d"}));
        }
        for (i = 0; i < 3; ++i) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"e", "f"}));
        }
        InternalSortedBag bg6 = new InternalSortedBag();
        for (int j = 0; j < 104; ++j) {
            for (int i6 = 0; i6 < tupleContents.length; ++i6) {
                bg6.add(Util.createTuple(tupleContents[i6]));
            }
            if (j == 103) continue;
            bg6.spill();
        }
        TestDataBag.assertEquals((long)bg6.size(), (long)312L);
        iter = bg6.iterator();
        for (i2 = 0; i2 < 104; ++i2) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"a", "b"}));
        }
        for (i2 = 0; i2 < 104; ++i2) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"c", "d"}));
        }
        for (i2 = 0; i2 < 104; ++i2) {
            ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"e", "f"}));
        }
        SortedDataBag bg7 = new SortedDataBag(null);
        for (int j = 0; j < 104; ++j) {
            for (int i7 = 0; i7 < tupleContents.length; ++i7) {
                bg7.add(Util.createTuple(tupleContents[i7]));
            }
            if (j == 103) continue;
            bg7.spill();
        }
        TestDataBag.assertEquals((Object)bg6, (Object)bg7);
    }

    public void testInternalDistinctBag() throws Exception {
        InternalDistinctBag bg0 = new InternalDistinctBag();
        bg0.add(TupleFactory.getInstance().newTuple());
        bg0.add(TupleFactory.getInstance().newTuple());
        TestDataBag.assertEquals((long)bg0.size(), (long)1L);
        InternalDistinctBag bg1 = new InternalDistinctBag();
        TestDataBag.assertEquals((long)bg1.size(), (long)0L);
        String[][] tupleContents = new String[][]{{"e", "f"}, {"a", "b"}, {"e", "d"}, {"a", "b"}, {"e", "f"}};
        for (int i = 0; i < tupleContents.length; ++i) {
            bg1.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((long)bg1.size(), (long)3L);
        TestDataBag.assertFalse((boolean)bg1.isSorted());
        TestDataBag.assertTrue((boolean)bg1.isDistinct());
        tupleContents = new String[][]{{"a", "b"}, {"e", "d"}, {"e", "d"}, {"e", "f"}};
        InternalDistinctBag bg2 = new InternalDistinctBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg2.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg1, (Object)bg2);
        Iterator iter = bg1.iterator();
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"a", "b"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"c", "d"}));
        ((Tuple)iter.next()).equals(Util.createTuple(new String[]{"e", "f"}));
        InternalDistinctBag bg3 = new InternalDistinctBag(1, 0.0);
        tupleContents = new String[][]{{"e", "f"}, {"a", "b"}, {"e", "d"}, {"a", "b"}, {"e", "f"}};
        for (int i = 0; i < tupleContents.length; ++i) {
            bg3.add(Util.createTuple(tupleContents[i]));
        }
        TestDataBag.assertEquals((Object)bg2, (Object)bg3);
        TestDataBag.assertEquals((long)bg3.size(), (long)3L);
        iter = bg3.iterator();
        TestDataBag.assertTrue((boolean)iter.hasNext());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        InternalDistinctBag bg4 = new InternalDistinctBag(1, 0.0);
        bg4.add((Tuple)iter.next());
        bg4.add((Tuple)iter.next());
        TestDataBag.assertTrue((boolean)iter.hasNext());
        bg4.add((Tuple)iter.next());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertEquals((Object)bg3, (Object)bg4);
        bg3.clear();
        TestDataBag.assertEquals((long)bg3.size(), (long)0L);
        InternalDistinctBag bg5 = new InternalDistinctBag();
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < tupleContents.length; ++i) {
                bg5.add(Util.createTuple(tupleContents[i]));
            }
            bg5.spill();
        }
        TestDataBag.assertEquals((long)bg5.size(), (long)3L);
        InternalDistinctBag bg6 = new InternalDistinctBag();
        for (int j = 0; j < 104; ++j) {
            for (int i = 0; i < tupleContents.length; ++i) {
                bg6.add(Util.createTuple(tupleContents[i]));
            }
            if (j == 103) continue;
            bg6.spill();
        }
        TestDataBag.assertEquals((long)bg6.size(), (long)3L);
        DistinctDataBag bg7 = new DistinctDataBag();
        for (int j = 0; j < 104; ++j) {
            for (int i = 0; i < tupleContents.length; ++i) {
                bg7.add(Util.createTuple(tupleContents[i]));
            }
            if (j == 103) continue;
            bg7.spill();
        }
        TestDataBag.assertEquals((Object)bg6, (Object)bg7);
    }

    @Test
    public void testDataBagIterIdempotent() throws Exception {
        DefaultDataBag bg0 = new DefaultDataBag();
        this.processDataBag((DataBag)bg0, true);
        DistinctDataBag bg1 = new DistinctDataBag();
        this.processDataBag((DataBag)bg1, true);
        InternalDistinctBag bg2 = new InternalDistinctBag();
        this.processDataBag((DataBag)bg2, true);
        InternalSortedBag bg3 = new InternalSortedBag();
        this.processDataBag((DataBag)bg3, true);
        SortedDataBag bg4 = new SortedDataBag(null);
        this.processDataBag((DataBag)bg4, true);
        InternalCachedBag bg5 = new InternalCachedBag(0, 0.0f);
        this.processDataBag((DataBag)bg5, false);
    }

    @Test
    public void testSerializeSingleTupleBag() throws Exception {
        Tuple t = Util.createTuple(new String[]{"foo", "bar", "baz"});
        SingleTupleBag stBag = new SingleTupleBag(t);
        PipedOutputStream pos = new PipedOutputStream();
        DataOutputStream dos = new DataOutputStream(pos);
        PipedInputStream pis = new PipedInputStream(pos);
        DataInputStream dis = new DataInputStream(pis);
        stBag.write((DataOutput)dos);
        DefaultDataBag dfBag = new DefaultDataBag();
        dfBag.readFields((DataInput)dis);
        TestDataBag.assertTrue((boolean)dfBag.equals(stBag));
    }

    void processDataBag(DataBag bg, boolean doSpill) {
        Tuple t = TupleFactory.getInstance().newTuple((Object)new Integer(0));
        bg.add(t);
        if (doSpill) {
            bg.spill();
        }
        Iterator iter = bg.iterator();
        TestDataBag.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestDataBag.assertFalse((boolean)iter.hasNext());
        TestDataBag.assertFalse((String)"hasNext should be idempotent", (boolean)iter.hasNext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalBagFactory {
        TestMemoryManager mMemMgr;

        public LocalBagFactory(TestMemoryManager mgr) {
            this.mMemMgr = mgr;
        }

        public DataBag newDefaultBag() {
            DefaultDataBag bag = new DefaultDataBag();
            this.mMemMgr.register((Spillable)bag);
            return bag;
        }

        public DataBag newSortedBag(Comparator<Tuple> comp) {
            SortedDataBag bag = new SortedDataBag(comp);
            this.mMemMgr.register((Spillable)bag);
            return bag;
        }

        public DataBag newDistinctBag() {
            DistinctDataBag bag = new DistinctDataBag();
            this.mMemMgr.register((Spillable)bag);
            return bag;
        }
    }

    private class TestMemoryManager {
        ArrayList<Spillable> mManagedObjects = new ArrayList();

        private TestMemoryManager() {
        }

        public void register(Spillable s) {
            this.mManagedObjects.add(s);
        }

        public void forceSpill() throws IOException {
            Iterator<Spillable> i = this.mManagedObjects.iterator();
            while (i.hasNext()) {
                i.next().spill();
            }
        }
    }
}

