/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.Identity;
import org.junit.Before;
import org.junit.Test;

public class TestEvalPipeline2
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    TupleFactory mTf = TupleFactory.getInstance();
    BagFactory mBf = BagFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        FileLocalizer.setR((Random)new Random());
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testUdfInputOrder() throws IOException {
        String[] input = new String[]{"(123)", "((123)", "(123123123123)", "(asdf)"};
        Util.createInputFile(this.cluster, "table_udfInp", input);
        this.pigServer.registerQuery("a = load 'table_udfInp' as (i:int);");
        this.pigServer.registerQuery("b = foreach a {dec = 'hello'; str1 = " + Identity.class.getName() + "(dec,'abc','def');" + "generate dec,str1; };");
        Iterator it = this.pigServer.openIterator("b");
        Tuple tup = null;
        tup = (Tuple)it.next();
        Tuple out = (Tuple)tup.get(1);
        TestEvalPipeline2.assertEquals((String)out.get(0).toString(), (String)"hello");
        TestEvalPipeline2.assertEquals((String)out.get(1).toString(), (String)"abc");
        TestEvalPipeline2.assertEquals((String)out.get(2).toString(), (String)"def");
        Util.deleteFile(this.cluster, "table_udfInp");
    }

    @Test
    public void testUDFwithStarInput() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = group A by $0;");
        String query = "C = foreach B {generate " + Identity.class.getName() + "(*);" + "};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline2.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            Tuple tuple = (Tuple)iter.next();
            Tuple t = (Tuple)tuple.get(0);
            TestEvalPipeline2.assertEquals(DataByteArray.class, t.get(0).getClass());
            int group = Integer.parseInt(new String(((DataByteArray)t.get(0)).get()));
            TestEvalPipeline2.assertEquals((int)numIdentity, (int)group);
            TestEvalPipeline2.assertTrue((boolean)(t.get(1) instanceof DataBag));
            DataBag bag = (DataBag)t.get(1);
            TestEvalPipeline2.assertEquals((long)10L, (long)bag.size());
            TestEvalPipeline2.assertEquals((int)2, (int)t.size());
            ++numIdentity;
        }
        TestEvalPipeline2.assertEquals((int)LOOP_COUNT, (int)numIdentity);
    }

    @Test
    public void testBinStorageByteArrayCastsSimple() throws IOException {
        String[] input = new String[]{"asdf\t12\t1.1\t231\t234", "sa\t1231\t123.4\t12345678\t1234.567", "asdff\t1232123\t1.45345\t123456789\t123456789.9"};
        Util.createInputFile(this.cluster, "table_bs_ac", input);
        this.pigServer.registerQuery("a = load 'table_bs_ac';");
        String output = "/pig/out/TestEvalPipeline2_BinStorageByteArrayCasts";
        this.pigServer.deleteFile(output);
        this.pigServer.store("a", output, BinStorage.class.getName());
        this.pigServer.registerQuery("b = load '" + output + "' using BinStorage() " + "as (name: int, age: int, gpa: float, lage: long, dgpa: double);");
        Iterator it = this.pigServer.openIterator("b");
        Tuple tup = null;
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue(((Integer)tup.get(0) == 1634952294 ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((tup.get(1) == null ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((tup.get(2) == null ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((tup.get(3) == null ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((tup.get(4) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Integer)tup.get(1) == 0x31323331 ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((((Float)tup.get(2)).floatValue() == 2.5931501E-9f ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Long)tup.get(3) == 3544952156018063160L ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Double)tup.get(4) == 1.030084341992388E-71 ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue(((Integer)tup.get(0) == 1634952294 ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Integer)tup.get(1) == 0x31323332 ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue((((Float)tup.get(2)).floatValue() == 2.5350009E-9f ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Long)tup.get(3) == 3544952156018063160L ? 1 : 0) != 0);
        TestEvalPipeline2.assertTrue(((Double)tup.get(4) == 1.0300843656201408E-71 ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "table");
    }

    @Test
    public void testBinStorageByteArrayCastsComplexBag() throws IOException {
        String[] input = new String[]{"{(asdf)}", "{(2344)}", "{(2344}", "{(323423423423434)}", "{(323423423423434L)}", "{(asdff)}"};
        Util.createInputFile(this.cluster, "table_bs_ac_clx", input);
        this.pigServer.registerQuery("a = load 'table_bs_ac_clx' as (f1);");
        this.pigServer.registerQuery("b = foreach a generate (bag{tuple(int)})f1;");
        Iterator it = this.pigServer.openIterator("b");
        Tuple tup = null;
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) != null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) != null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((boolean)(tup.get(0) instanceof DataBag));
        DataBag db = (DataBag)tup.get(0);
        TestEvalPipeline2.assertTrue((boolean)db.iterator().hasNext());
        Tuple innerTuple = (Tuple)db.iterator().next();
        TestEvalPipeline2.assertTrue((innerTuple.get(0) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) != null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) != null ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "table_bs_ac_clx");
    }

    @Test
    public void testBinStorageByteArrayCastsComplexTuple() throws IOException {
        String[] input = new String[]{"(123)", "((123)", "(123123123123)", "(asdf)"};
        Util.createInputFile(this.cluster, "table_bs_ac_clxt", input);
        this.pigServer.registerQuery("a = load 'table_bs_ac_clxt' as (t:tuple(t:tuple(i:int)));");
        Iterator it = this.pigServer.openIterator("a");
        Tuple tup = null;
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        tup = (Tuple)it.next();
        TestEvalPipeline2.assertTrue((tup.get(0) == null ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "table_bs_ac_clxt");
    }

    @Test
    public void testPigStorageWithCtrlChars() throws Exception {
        String[] inputData = new String[]{"hello\u0001world", "good\u0001morning", "nice\u0001day"};
        Util.createInputFile(this.cluster, "testPigStorageWithCtrlCharsInput.txt", inputData);
        String script = "a = load 'testPigStorageWithCtrlCharsInput.txt' using PigStorage('\u0001');b = foreach a generate $0, CONCAT($0, '\u0005'), $1; store b into 'testPigStorageWithCtrlCharsOutput.txt' using PigStorage('\u0001');c = load 'testPigStorageWithCtrlCharsOutput.txt' using PigStorage('\u0001') as (f1:chararray, f2:chararray, f3:chararray);";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("c");
        HashMap<String, Tuple> expectedResults = new HashMap<String, Tuple>();
        expectedResults.put("hello", (Tuple)Util.getPigConstant("('hello','hello\u0005','world')"));
        expectedResults.put("good", (Tuple)Util.getPigConstant("('good','good\u0005','morning')"));
        expectedResults.put("nice", (Tuple)Util.getPigConstant("('nice','nice\u0005','day')"));
        HashMap<String, Boolean> seen = new HashMap<String, Boolean>();
        int numRows = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String firstCol = (String)t.get(0);
            TestEvalPipeline2.assertFalse((boolean)seen.containsKey(firstCol));
            seen.put(firstCol, true);
            TestEvalPipeline2.assertEquals(expectedResults.get(firstCol), (Object)t);
            ++numRows;
        }
        TestEvalPipeline2.assertEquals((int)3, (int)numRows);
    }

    @Test
    public void testLimitedSortWithDump() throws Exception {
        int LOOP_COUNT = 40;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        Random r = new Random(1L);
        for (int i = 0; i < LOOP_COUNT; ++i) {
            int rand = r.nextInt(100);
            ps.println(rand);
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigServer.getPigContext()) + "' AS (num:int);");
        this.pigServer.registerQuery("B = order A by num parallel 2;");
        this.pigServer.registerQuery("C = limit B 10;");
        Iterator result = this.pigServer.openIterator("C");
        int numIdentity = 0;
        while (result.hasNext()) {
            result.next();
            ++numIdentity;
        }
        TestEvalPipeline2.assertEquals((int)10, (int)numIdentity);
    }

    @Test
    public void testLimitAfterSort() throws Exception {
        int LOOP_COUNT = 40;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        Random r = new Random(1L);
        for (int i = 0; i < LOOP_COUNT; ++i) {
            int rand = r.nextInt(100);
            ps.println(rand);
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigServer.getPigContext()) + "' AS (num:int);");
        this.pigServer.registerQuery("B = order A by num parallel 2;");
        this.pigServer.registerQuery("C = limit B 10;");
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline2.fail((String)"No output found");
        }
        int numIdentity = 0;
        int oldNum = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            int newNum = (Integer)t.get(0);
            TestEvalPipeline2.assertTrue((newNum >= oldNum ? 1 : 0) != 0);
            oldNum = newNum;
            ++numIdentity;
        }
        TestEvalPipeline2.assertEquals((int)10, (int)numIdentity);
    }

    @Test
    public void testLimitAfterSortDesc() throws Exception {
        int LOOP_COUNT = 40;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        Random r = new Random(1L);
        for (int i = 0; i < LOOP_COUNT; ++i) {
            int rand = r.nextInt(100);
            ps.println(rand);
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigServer.getPigContext()) + "' AS (num:int);");
        this.pigServer.registerQuery("B = order A by num desc parallel 2;");
        this.pigServer.registerQuery("C = limit B 10;");
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline2.fail((String)"No output found");
        }
        int numIdentity = 0;
        int oldNum = Integer.MAX_VALUE;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            int newNum = (Integer)t.get(0);
            TestEvalPipeline2.assertTrue((newNum <= oldNum ? 1 : 0) != 0);
            oldNum = newNum;
            ++numIdentity;
        }
        TestEvalPipeline2.assertEquals((int)10, (int)numIdentity);
    }

    @Test
    public void testEmptySort() throws Exception {
        File tmpFile = File.createTempFile("test", "txt");
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = order A by $0;");
        Iterator iter = this.pigServer.openIterator("B");
        TestEvalPipeline2.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testLimitPOPackageAnnotator() throws Exception {
        File tmpFile1 = File.createTempFile("test1", "txt");
        PrintStream ps1 = new PrintStream(new FileOutputStream(tmpFile1));
        ps1.println("1\t2\t3");
        ps1.println("2\t5\t2");
        ps1.close();
        File tmpFile2 = File.createTempFile("test2", "txt");
        PrintStream ps2 = new PrintStream(new FileOutputStream(tmpFile2));
        ps2.println("1\t1");
        ps2.println("2\t2");
        ps2.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = LOAD '" + Util.generateURI(tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = LIMIT B 100;");
        this.pigServer.registerQuery("D = COGROUP C BY b0, A BY a0 PARALLEL 2;");
        Iterator iter = this.pigServer.openIterator("D");
        TestEvalPipeline2.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestEvalPipeline2.assertTrue((boolean)t.toString().equals("(1,{(1,1)},{(1,2,3)})"));
        TestEvalPipeline2.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestEvalPipeline2.assertTrue((boolean)t.toString().equals("(2,{(2,2)},{(2,5,2)})"));
        TestEvalPipeline2.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testNestedDescSort() throws Exception {
        Util.createInputFile(this.cluster, "table_testNestedDescSort", new String[]{"3", "4"});
        this.pigServer.registerQuery("A = LOAD 'table_testNestedDescSort' as (a0:int);");
        this.pigServer.registerQuery("B = group A ALL;");
        this.pigServer.registerQuery("C = foreach B { D = order A by a0 desc;generate D;};");
        Iterator iter = this.pigServer.openIterator("C");
        TestEvalPipeline2.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestEvalPipeline2.assertTrue((boolean)t.toString().equals("({(4),(3)})"));
        TestEvalPipeline2.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, "table_testNestedDescSort");
    }
}

