/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.optimizer.ProjectionPatcher;
import org.apache.pig.experimental.logical.optimizer.SchemaPatcher;
import org.apache.pig.experimental.logical.optimizer.UidStamper;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOForEach;
import org.apache.pig.experimental.logical.relational.LOGenerate;
import org.apache.pig.experimental.logical.relational.LOInnerLoad;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LOStore;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.logical.rules.FilterAboveForeach;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.optimizer.PlanOptimizer;
import org.apache.pig.experimental.plan.optimizer.PlanTransformListener;
import org.apache.pig.experimental.plan.optimizer.Rule;

public class TestExperimentalFilterAboveForeach
extends TestCase {
    public void testSimple() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, true};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 0);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        plan.connect((Operator)foreach, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertEquals((long)load.getSchema().getField((int)0).uid, (long)namePrj2.getUid());
        TestExperimentalFilterAboveForeach.assertEquals((long)namePrj2.getUid(), (long)prjName.getUid());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    public void testMultipleFilter() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, true};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 0);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        LOFilter filter2 = new LOFilter(plan);
        LogicalExpressionPlan filter2Plan = new LogicalExpressionPlan();
        ProjectExpression name2Prj2 = new ProjectExpression((OperatorPlan)filter2Plan, 55, 0, 1);
        filter2Plan.add((Operator)name2Prj2);
        ConstantExpression const2Exp = new ConstantExpression((OperatorPlan)filter2Plan, 55, (Object)"joe");
        filter2Plan.add((Operator)const2Exp);
        EqualExpression equal2 = new EqualExpression((OperatorPlan)filter2Plan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filter2Plan.add((Operator)equal2);
        filter2.setFilterPlan(filter2Plan);
        filter2.setAlias("C1");
        plan.add((Operator)filter2);
        plan.connect((Operator)foreach, (Operator)filter2);
        plan.connect((Operator)filter2, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertEquals((long)load.getSchema().getField((int)0).uid, (long)namePrj2.getUid());
        TestExperimentalFilterAboveForeach.assertEquals((long)namePrj2.getUid(), (long)prjName.getUid());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    public void testMultipleFilter2() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, true};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 0);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        LOFilter filter2 = new LOFilter(plan);
        LogicalExpressionPlan filter2Plan = new LogicalExpressionPlan();
        ProjectExpression name2Prj2 = new ProjectExpression((OperatorPlan)filter2Plan, 55, 0, 0);
        filter2Plan.add((Operator)name2Prj2);
        ConstantExpression const2Exp = new ConstantExpression((OperatorPlan)filter2Plan, 55, (Object)"joe2");
        filter2Plan.add((Operator)const2Exp);
        EqualExpression equal2 = new EqualExpression((OperatorPlan)filter2Plan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filter2Plan.add((Operator)equal2);
        filter2.setFilterPlan(filter2Plan);
        filter2.setAlias("C1");
        plan.add((Operator)filter2);
        plan.connect((Operator)foreach, (Operator)filter2);
        plan.connect((Operator)filter2, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertEquals((long)load.getSchema().getField((int)0).uid, (long)namePrj2.getUid());
        TestExperimentalFilterAboveForeach.assertEquals((long)namePrj2.getUid(), (long)name2Prj2.getUid());
        TestExperimentalFilterAboveForeach.assertEquals((long)name2Prj2.getUid(), (long)prjName.getUid());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    public void testMultipleFilterNotPossible() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, true};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 1);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        LOFilter filter2 = new LOFilter(plan);
        LogicalExpressionPlan filter2Plan = new LogicalExpressionPlan();
        ProjectExpression name2Prj2 = new ProjectExpression((OperatorPlan)filter2Plan, 55, 0, 1);
        filter2Plan.add((Operator)name2Prj2);
        ConstantExpression const2Exp = new ConstantExpression((OperatorPlan)filter2Plan, 55, (Object)"joe2");
        filter2Plan.add((Operator)const2Exp);
        EqualExpression equal2 = new EqualExpression((OperatorPlan)filter2Plan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filter2Plan.add((Operator)equal2);
        filter2.setFilterPlan(filter2Plan);
        filter2.setAlias("C1");
        plan.add((Operator)filter2);
        plan.connect((Operator)foreach, (Operator)filter2);
        plan.connect((Operator)filter2, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter2).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter2).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertFalse((prjCuisines.getUid() == namePrj2.getUid() ? 1 : 0) != 0);
        TestExperimentalFilterAboveForeach.assertFalse((prjCuisines.getUid() == name2Prj2.getUid() ? 1 : 0) != 0);
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(filter2));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    public void testNotPossibleFilter() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, true};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 1);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        plan.connect((Operator)foreach, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertFalse((prjCuisines.getUid() == namePrj2.getUid() ? 1 : 0) != 0);
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    public void testSimple2() throws Exception {
        LogicalPlan plan = null;
        LOLoad load = null;
        LOForEach foreach = null;
        LOFilter filter = null;
        LOStore stor = null;
        plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        LogicalSchema bagSchema = new LogicalSchema();
        LogicalSchema bagTupleSchema = new LogicalSchema();
        bagTupleSchema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        bagSchema.addField(new LogicalSchema.LogicalFieldSchema("t", bagTupleSchema, 110));
        schema.addField(new LogicalSchema.LogicalFieldSchema("cuisines", bagSchema, 120));
        load = new LOLoad(null, schema, plan);
        load.setAlias("A");
        plan.add((Operator)load);
        foreach = new LOForEach((OperatorPlan)plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad innerLoad = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)innerLoad);
        LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        innerPlan.add((Operator)innerLoad2);
        LogicalExpressionPlan namePrj = new LogicalExpressionPlan();
        ProjectExpression prjName = new ProjectExpression((OperatorPlan)namePrj, 55, 0, 0);
        namePrj.add((Operator)prjName);
        LogicalExpressionPlan cuisinesPrj = new LogicalExpressionPlan();
        ProjectExpression prjCuisines = new ProjectExpression((OperatorPlan)cuisinesPrj, 120, 1, 0);
        cuisinesPrj.add((Operator)prjCuisines);
        ArrayList<LogicalExpressionPlan> expPlans = new ArrayList<LogicalExpressionPlan>();
        expPlans.add(namePrj);
        expPlans.add(cuisinesPrj);
        boolean[] flatten = new boolean[]{false, false};
        LOGenerate generate = new LOGenerate((OperatorPlan)innerPlan, expPlans, flatten);
        innerPlan.add((Operator)generate);
        innerPlan.connect((Operator)innerLoad, (Operator)generate);
        innerPlan.connect((Operator)innerLoad2, (Operator)generate);
        foreach.setInnerPlan(innerPlan);
        foreach.setAlias("B");
        plan.add((Operator)foreach);
        plan.connect((Operator)load, (Operator)foreach);
        filter = new LOFilter(plan);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression namePrj2 = new ProjectExpression((OperatorPlan)filterPlan, 55, 0, 0);
        filterPlan.add((Operator)namePrj2);
        ConstantExpression constExp = new ConstantExpression((OperatorPlan)filterPlan, 55, (Object)"joe");
        filterPlan.add((Operator)constExp);
        EqualExpression equal = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)namePrj2, (LogicalExpression)constExp);
        filterPlan.add((Operator)equal);
        filter.setFilterPlan(filterPlan);
        filter.setAlias("C");
        plan.add((Operator)filter);
        plan.connect((Operator)foreach, (Operator)filter);
        stor = new LOStore(plan);
        stor.setAlias("D");
        plan.add((Operator)stor);
        plan.connect((Operator)filter, (Operator)stor);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)plan);
            stamper.visit();
        }
        catch (Exception e) {
            TestExperimentalFilterAboveForeach.assertTrue((String)"Failed to set a valid uid", (boolean)false);
        }
        FilterAboveForeach r = new FilterAboveForeach("FilterAboveFlatten");
        HashSet<FilterAboveForeach> s = new HashSet<FilterAboveForeach>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        List list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)plan, ls, 3);
        optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
        optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
        optimizer.optimize();
        list = plan.getSinks();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(stor));
        list = plan.getSources();
        TestExperimentalFilterAboveForeach.assertTrue((boolean)list.contains(load));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)stor).contains(foreach));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)stor).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)filter).contains(load));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)filter).size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)plan.getPredecessors((Operator)foreach).contains(filter));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)plan.getPredecessors((Operator)foreach).size());
        TestExperimentalFilterAboveForeach.assertEquals((long)load.getSchema().getField((int)0).uid, (long)namePrj2.getUid());
        TestExperimentalFilterAboveForeach.assertEquals((long)namePrj2.getUid(), (long)prjName.getUid());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSinks().contains(generate));
        TestExperimentalFilterAboveForeach.assertEquals((int)1, (int)foreach.getInnerPlan().getSinks().size());
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad));
        TestExperimentalFilterAboveForeach.assertTrue((boolean)foreach.getInnerPlan().getSources().contains(innerLoad2));
        TestExperimentalFilterAboveForeach.assertEquals((int)2, (int)foreach.getInnerPlan().getSources().size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyPlanOptimizer
    extends PlanOptimizer {
        protected MyPlanOptimizer(OperatorPlan p, List<Set<Rule>> rs, int iterations) {
            super(p, rs, iterations);
        }

        public void addPlanTransformListener(PlanTransformListener listener) {
            super.addPlanTransformListener(listener);
        }
    }
}

