/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.pig.experimental.logical.expression.AndExpression;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOJoin;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LOStore;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalRelationalOperator;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.logical.rules.MergeFilter;
import org.apache.pig.experimental.logical.rules.PushUpFilter;
import org.apache.pig.experimental.logical.rules.SplitFilter;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.optimizer.PlanOptimizer;
import org.apache.pig.experimental.plan.optimizer.PlanTransformListener;
import org.apache.pig.experimental.plan.optimizer.Rule;
import org.apache.pig.impl.util.MultiMap;

public class TestExperimentalFilterRule
extends TestCase {
    LogicalPlan plan = null;
    LogicalRelationalOperator load1 = null;
    LogicalRelationalOperator load2 = null;
    LogicalRelationalOperator filter = null;
    LogicalRelationalOperator join = null;
    LogicalRelationalOperator store = null;

    private void prep() {
        this.plan = new LogicalPlan();
        LogicalSchema schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 10));
        schema.addField(new LogicalSchema.LogicalFieldSchema("name", null, 55));
        schema.addField(new LogicalSchema.LogicalFieldSchema("age", null, 10));
        schema.getField((int)0).uid = 1L;
        schema.getField((int)1).uid = 2L;
        schema.getField((int)2).uid = 3L;
        LOLoad l1 = new LOLoad(null, schema, this.plan);
        l1.setAlias("A");
        this.plan.add((Operator)l1);
        schema = new LogicalSchema();
        schema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 10));
        schema.addField(new LogicalSchema.LogicalFieldSchema("dept", null, 10));
        schema.addField(new LogicalSchema.LogicalFieldSchema("salary", null, 20));
        schema.getField((int)0).uid = 4L;
        schema.getField((int)1).uid = 5L;
        schema.getField((int)2).uid = 6L;
        LOLoad l2 = new LOLoad(null, schema, this.plan);
        l2.setAlias("B");
        this.plan.add((Operator)l2);
        MultiMap joinPlans = new MultiMap();
        LogicalExpressionPlan p1 = new LogicalExpressionPlan();
        ProjectExpression lp1 = new ProjectExpression((OperatorPlan)p1, 55, 0, 1);
        p1.add((Operator)lp1);
        joinPlans.put((Object)0, (Object)p1);
        LogicalExpressionPlan p2 = new LogicalExpressionPlan();
        ProjectExpression lp2 = new ProjectExpression((OperatorPlan)p2, 10, 1, 1);
        p2.add((Operator)lp2);
        joinPlans.put((Object)1, (Object)p2);
        LOJoin j1 = new LOJoin(this.plan, joinPlans, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        j1.setAlias("C");
        this.plan.add((Operator)j1);
        LogicalExpressionPlan p3 = new LogicalExpressionPlan();
        ProjectExpression lp3 = new ProjectExpression((OperatorPlan)p3, 10, 0, 2);
        ConstantExpression cont = new ConstantExpression((OperatorPlan)p3, 10, (Object)new Integer(3));
        p3.add((Operator)lp3);
        p3.add((Operator)cont);
        EqualExpression eq = new EqualExpression((OperatorPlan)p3, (LogicalExpression)lp3, (LogicalExpression)cont);
        LOFilter f1 = new LOFilter(this.plan, p3);
        f1.setAlias("D");
        this.plan.add((Operator)f1);
        LOStore s1 = new LOStore(this.plan);
        this.plan.add((Operator)s1);
        this.plan.connect((Operator)l1, (Operator)j1);
        this.plan.connect((Operator)l2, (Operator)j1);
        this.plan.connect((Operator)j1, (Operator)f1);
        this.plan.connect((Operator)f1, (Operator)s1);
        try {
            lp1.setUid((LogicalRelationalOperator)j1);
            lp2.setUid((LogicalRelationalOperator)j1);
            lp3.setUid((LogicalRelationalOperator)f1);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.filter = f1;
        this.store = s1;
        this.join = j1;
        this.load1 = l1;
        this.load2 = l2;
    }

    public void testFilterRule() throws Exception {
        this.prep();
        SplitFilter r = new SplitFilter("SplitFilter");
        HashSet<SplitFilter> s = new HashSet<SplitFilter>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getPredecessors((Operator)this.filter).get(0), (Object)this.join);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.filter).get(0), (Object)this.store);
        r = new PushUpFilter("PushUpFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.load1).get(0), (Object)this.filter);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.filter).get(0), (Object)this.join);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.join).get(0), (Object)this.store);
        r = new MergeFilter("MergeFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.load1).get(0), (Object)this.filter);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.filter).get(0), (Object)this.join);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.join).get(0), (Object)this.store);
    }

    public void testFilterRuleWithAnd() throws Exception {
        this.prep();
        LogicalExpressionPlan p4 = new LogicalExpressionPlan();
        ProjectExpression lp3 = new ProjectExpression((OperatorPlan)p4, 10, 0, 2);
        ConstantExpression cont = new ConstantExpression((OperatorPlan)p4, 10, (Object)new Integer(3));
        p4.add((Operator)lp3);
        p4.add((Operator)cont);
        EqualExpression eq = new EqualExpression((OperatorPlan)p4, (LogicalExpression)lp3, (LogicalExpression)cont);
        ProjectExpression lp4 = new ProjectExpression((OperatorPlan)p4, 20, 0, 5);
        ConstantExpression cont2 = new ConstantExpression((OperatorPlan)p4, 20, (Object)new Float(100.0f));
        p4.add((Operator)lp4);
        p4.add((Operator)cont2);
        EqualExpression eq2 = new EqualExpression((OperatorPlan)p4, (LogicalExpression)lp4, (LogicalExpression)cont2);
        AndExpression and = new AndExpression((OperatorPlan)p4, (LogicalExpression)eq, (LogicalExpression)eq2);
        lp3.setUid(this.filter);
        lp4.setUid(this.filter);
        ((LOFilter)this.filter).setFilterPlan(p4);
        SplitFilter r = new SplitFilter("SplitFilter");
        HashSet<SplitFilter> s = new HashSet<SplitFilter>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getPredecessors((Operator)this.filter).get(0), (Object)this.join);
        Operator next = (Operator)this.plan.getSuccessors((Operator)this.filter).get(0);
        TestExperimentalFilterRule.assertEquals(LOFilter.class, next.getClass());
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(LOStore.class, next.getClass());
        r = new PushUpFilter("PushUpFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.join).get(0), (Object)this.store);
        r = new MergeFilter("MergeFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors((Operator)this.join).get(0), (Object)this.store);
    }

    public void testFilterRuleWith2And() throws Exception {
        this.prep();
        LogicalExpressionPlan p5 = new LogicalExpressionPlan();
        ProjectExpression lp3 = new ProjectExpression((OperatorPlan)p5, 10, 0, 2);
        ConstantExpression cont = new ConstantExpression((OperatorPlan)p5, 10, (Object)new Integer(3));
        p5.add((Operator)lp3);
        p5.add((Operator)cont);
        EqualExpression eq = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp3, (LogicalExpression)cont);
        ProjectExpression lp4 = new ProjectExpression((OperatorPlan)p5, 10, 0, 3);
        ConstantExpression cont2 = new ConstantExpression((OperatorPlan)p5, 10, (Object)new Integer(3));
        p5.add((Operator)lp4);
        p5.add((Operator)cont2);
        EqualExpression eq2 = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp4, (LogicalExpression)cont2);
        lp3.setUid(this.filter);
        lp4.setUid(this.filter);
        AndExpression and1 = new AndExpression((OperatorPlan)p5, (LogicalExpression)eq, (LogicalExpression)eq2);
        lp3 = new ProjectExpression((OperatorPlan)p5, 10, 0, 0);
        lp4 = new ProjectExpression((OperatorPlan)p5, 10, 0, 3);
        lp3.setUid(this.filter);
        lp4.setUid(this.filter);
        p5.add((Operator)lp3);
        p5.add((Operator)lp4);
        eq2 = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp3, (LogicalExpression)lp4);
        AndExpression and2 = new AndExpression((OperatorPlan)p5, (LogicalExpression)and1, (LogicalExpression)eq2);
        ((LOFilter)this.filter).setFilterPlan(p5);
        SplitFilter r = new SplitFilter("SplitFilter");
        HashSet<SplitFilter> s = new HashSet<SplitFilter>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        MyPlanTransformListener listener = new MyPlanTransformListener();
        optimizer.addPlanTransformListener(listener);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getPredecessors((Operator)this.filter).get(0), (Object)this.join);
        Operator next = (Operator)this.plan.getSuccessors((Operator)this.filter).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(LOStore.class, next.getClass());
        OperatorPlan transformed = listener.getTransformed();
        TestExperimentalFilterRule.assertEquals((int)transformed.size(), (int)3);
        r = new PushUpFilter("PushUpFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        listener = new MyPlanTransformListener();
        optimizer.addPlanTransformListener(listener);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.join).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOStore.class);
        transformed = listener.getTransformed();
        TestExperimentalFilterRule.assertEquals((int)transformed.size(), (int)4);
        TestExperimentalFilterRule.assertEquals(((Operator)transformed.getSinks().get(0)).getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(((Operator)transformed.getSources().get(0)).getClass(), LOLoad.class);
        r = new MergeFilter("MergeFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        listener = new MyPlanTransformListener();
        optimizer.addPlanTransformListener(listener);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.join).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOStore.class);
        transformed = listener.getTransformed();
        TestExperimentalFilterRule.assertNull((Object)transformed);
    }

    public void testFilterRuleWith2And2() throws Exception {
        this.prep();
        LogicalExpressionPlan p5 = new LogicalExpressionPlan();
        ProjectExpression lp3 = new ProjectExpression((OperatorPlan)p5, 10, 0, 2);
        lp3.setUid(this.filter);
        ConstantExpression cont = new ConstantExpression((OperatorPlan)p5, 10, (Object)new Integer(3));
        p5.add((Operator)lp3);
        p5.add((Operator)cont);
        EqualExpression eq = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp3, (LogicalExpression)cont);
        lp3 = new ProjectExpression((OperatorPlan)p5, 10, 0, 0);
        ProjectExpression lp4 = new ProjectExpression((OperatorPlan)p5, 10, 0, 3);
        p5.add((Operator)lp4);
        p5.add((Operator)lp3);
        lp3.setUid(this.filter);
        lp4.setUid(this.filter);
        EqualExpression eq2 = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp3, (LogicalExpression)lp4);
        AndExpression and1 = new AndExpression((OperatorPlan)p5, (LogicalExpression)eq, (LogicalExpression)eq2);
        lp3 = new ProjectExpression((OperatorPlan)p5, 10, 0, 2);
        lp4 = new ProjectExpression((OperatorPlan)p5, 20, 0, 5);
        p5.add((Operator)lp3);
        p5.add((Operator)lp4);
        lp3.setUid(this.filter);
        lp4.setUid(this.filter);
        eq2 = new EqualExpression((OperatorPlan)p5, (LogicalExpression)lp3, (LogicalExpression)lp4);
        AndExpression and2 = new AndExpression((OperatorPlan)p5, (LogicalExpression)and1, (LogicalExpression)eq2);
        ((LOFilter)this.filter).setFilterPlan(p5);
        SplitFilter r = new SplitFilter("SplitFilter");
        HashSet<SplitFilter> s = new HashSet<SplitFilter>();
        s.add(r);
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        ls.add(s);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        TestExperimentalFilterRule.assertEquals(this.plan.getPredecessors((Operator)this.filter).get(0), (Object)this.join);
        Operator next = (Operator)this.plan.getSuccessors((Operator)this.filter).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(LOStore.class, next.getClass());
        r = new PushUpFilter("PushUpFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals((Object)next, (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.join).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOStore.class);
        r = new MergeFilter("MergeFilter");
        s = new HashSet();
        s.add(r);
        ls = new ArrayList();
        ls.add(s);
        optimizer = new MyPlanOptimizer((OperatorPlan)this.plan, ls, 3);
        MyPlanTransformListener listener = new MyPlanTransformListener();
        optimizer.addPlanTransformListener(listener);
        optimizer.optimize();
        next = (Operator)this.plan.getSuccessors((Operator)this.load1).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        TestExperimentalFilterRule.assertEquals(this.plan.getSuccessors(next).get(0), (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.load2).get(0);
        TestExperimentalFilterRule.assertEquals((Object)next, (Object)this.join);
        next = (Operator)this.plan.getSuccessors((Operator)this.join).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOFilter.class);
        next = (Operator)this.plan.getSuccessors(next).get(0);
        TestExperimentalFilterRule.assertEquals(next.getClass(), LOStore.class);
        OperatorPlan transformed = listener.getTransformed();
        TestExperimentalFilterRule.assertEquals((int)transformed.size(), (int)2);
    }

    public class MyPlanTransformListener
    implements PlanTransformListener {
        private OperatorPlan tp;

        public void transformed(OperatorPlan fp, OperatorPlan tp) throws IOException {
            this.tp = tp;
        }

        public OperatorPlan getTransformed() {
            return this.tp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyPlanOptimizer
    extends PlanOptimizer {
        protected MyPlanOptimizer(OperatorPlan p, List<Set<Rule>> rs, int iterations) {
            super(p, rs, iterations);
        }

        public void addPlanTransformListener(PlanTransformListener listener) {
            super.addPlanTransformListener(listener);
        }
    }
}

