/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Add;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Divide;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LessThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Mod;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Multiply;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Subtract;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.experimental.logical.LogicalPlanMigrationVistor;
import org.apache.pig.experimental.logical.expression.AddExpression;
import org.apache.pig.experimental.logical.expression.BagDereferenceExpression;
import org.apache.pig.experimental.logical.expression.BinCondExpression;
import org.apache.pig.experimental.logical.expression.DivideExpression;
import org.apache.pig.experimental.logical.expression.IsNullExpression;
import org.apache.pig.experimental.logical.expression.LessThanExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.ModExpression;
import org.apache.pig.experimental.logical.expression.MultiplyExpression;
import org.apache.pig.experimental.logical.expression.NegativeExpression;
import org.apache.pig.experimental.logical.expression.NotExpression;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.expression.SubtractExpression;
import org.apache.pig.experimental.logical.expression.UserFuncExpression;
import org.apache.pig.experimental.logical.optimizer.UidStamper;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOForEach;
import org.apache.pig.experimental.logical.relational.LOGenerate;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogToPhyTranslationVisitor;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalRelationalOperator;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.test.utils.LogicalPlanTester;

public class TestExperimentalLogToPhyTranslationVisitor
extends TestCase {
    private PhysicalPlan translatePlan(OperatorPlan plan) throws IOException {
        LogToPhyTranslationVisitor visitor = new LogToPhyTranslationVisitor(plan);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    private LogicalPlan migratePlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp) throws VisitorException {
        LogicalPlanMigrationVistor visitor = new LogicalPlanMigrationVistor(lp);
        visitor.visit();
        LogicalPlan newPlan = visitor.getNewLogicalPlan();
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)newPlan);
            stamper.visit();
            return newPlan;
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
    }

    protected void setUp() throws Exception {
        LogicalExpression.resetNextUid();
    }

    public void testSimplePlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("b = filter a by $0==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)phyPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)phyPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)phyPlan.getLeaves().size());
        PhysicalOperator load = (PhysicalOperator)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, load.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)load).getLFile().getFileName().contains("d.txt"));
        PhysicalOperator fil = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)filPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)filPlan.getLeaves().size());
        PhysicalOperator eq = (PhysicalOperator)filPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(EqualToExpr.class, eq.getClass());
        PhysicalOperator prj1 = (PhysicalOperator)filPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj1.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj1).getColumn());
        PhysicalOperator constExp = (PhysicalOperator)filPlan.getRoots().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, constExp.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)((ConstantExpression)constExp).getValue());
        PhysicalOperator stor = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)fil).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testJoinPlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd1.txt' as (id, c);");
        lpt.buildPlan("b = load 'd2.txt'as (id, c);");
        lpt.buildPlan("c = join a by id, b by c;");
        lpt.buildPlan("d = filter c by a::id==NULL AND b::c==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store d into 'empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        PhysicalPlan physicalPlan = this.translatePlan((OperatorPlan)newPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)9, (int)physicalPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)physicalPlan.getRoots().size(), (int)2);
        PhysicalOperator LoR = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)physicalPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR.getClass());
        POLocalRearrange Lor = (POLocalRearrange)LoR;
        PhysicalOperator prj3 = (PhysicalOperator)((PhysicalPlan)Lor.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj3.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj3).getColumn());
        PhysicalOperator inp1 = (PhysicalOperator)Lor.getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, inp1.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)inp1).getLFile().getFileName().contains("d1.txt"));
        PhysicalOperator LoR1 = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)physicalPlan.getRoots().get(1)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR1.getClass());
        POLocalRearrange Lor1 = (POLocalRearrange)LoR1;
        PhysicalOperator prj4 = (PhysicalOperator)((PhysicalPlan)Lor1.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj4.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)prj4).getColumn());
        PhysicalOperator inp2 = (PhysicalOperator)Lor1.getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, inp2.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)inp2).getLFile().getFileName().contains("d2.txt"));
        PhysicalOperator GoR = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)LoR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, GoR.getClass());
        PhysicalOperator Pack = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)GoR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, Pack.getClass());
        PhysicalOperator ForE = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)Pack).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, ForE.getClass());
        PhysicalOperator prj5 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE).getInputPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj5.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)prj5).getColumn());
        PhysicalOperator prj6 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE).getInputPlans().get(1)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj6.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)((POProject)prj6).getColumn());
        PhysicalOperator fil = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)ForE).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        List filRoots = filPlan.getRoots();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots.get(1)).getClass());
        ConstantExpression ce1 = (ConstantExpression)filRoots.get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce1.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots.get(3)).getClass());
        ConstantExpression ce2 = (ConstantExpression)filRoots.get(3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce2.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots.get(0)).getClass());
        POProject prj1 = (POProject)filRoots.get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)prj1.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots.get(2)).getClass());
        POProject prj2 = (POProject)filRoots.get(2);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj2.getColumn());
        PhysicalOperator stor = (PhysicalOperator)physicalPlan.getSuccessors((org.apache.pig.impl.plan.Operator)fil).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testMultiStore() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd1.txt' as (id, c);");
        lpt.buildPlan("b = load 'd2.txt'as (id, c);");
        lpt.buildPlan("c = load 'd3.txt' as (id, c);");
        lpt.buildPlan("d = join a by id, b by c;");
        lpt.buildPlan("e = filter d by a::id==NULL AND b::c==NULL;");
        lpt.buildPlan("f = join e by b::c, c by id;");
        lpt.buildPlan("g = filter f by b::id==NULL AND c::c==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store g into 'empty2';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)16, (int)phyPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getRoots().size(), (int)3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getLeaves().size(), (int)1);
        PhysicalOperator LoR = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR.getClass());
        POLocalRearrange Lor = (POLocalRearrange)LoR;
        PhysicalOperator prj1 = (PhysicalOperator)((PhysicalPlan)Lor.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj1.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj1).getColumn());
        PhysicalOperator inp1 = (PhysicalOperator)Lor.getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, inp1.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)inp1).getLFile().getFileName().contains("d3.txt"));
        PhysicalOperator LoR1 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(1)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR1.getClass());
        POLocalRearrange Lor1 = (POLocalRearrange)LoR1;
        PhysicalOperator prj2 = (PhysicalOperator)((PhysicalPlan)Lor1.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj2.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)prj2).getColumn());
        PhysicalOperator inp2 = (PhysicalOperator)Lor1.getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, inp2.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)inp2).getLFile().getFileName().contains("d2.txt"));
        PhysicalOperator GoR = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)LoR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, GoR.getClass());
        PhysicalOperator Pack = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)GoR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, Pack.getClass());
        PhysicalOperator LoR2 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(2)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR2.getClass());
        POLocalRearrange Lor2 = (POLocalRearrange)LoR2;
        PhysicalOperator prj3 = (PhysicalOperator)((PhysicalPlan)Lor2.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj3.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj3).getColumn());
        PhysicalOperator inp3 = (PhysicalOperator)Lor2.getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, inp3.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)inp3).getLFile().getFileName().contains("d1.txt"));
        PhysicalOperator GoR2 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)LoR2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, GoR2.getClass());
        PhysicalOperator Pack2 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)GoR2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, Pack2.getClass());
        PhysicalOperator ForE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)Pack).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, ForE.getClass());
        PhysicalOperator prj4 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE).getInputPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj4.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)prj4).getColumn());
        PhysicalOperator prj5 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE).getInputPlans().get(1)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj5.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)((POProject)prj5).getColumn());
        PhysicalOperator ForE2 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)Pack2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, ForE2.getClass());
        PhysicalOperator prj6 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE2).getInputPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj6.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)prj6).getColumn());
        PhysicalOperator prj7 = (PhysicalOperator)((PhysicalPlan)((POForEach)ForE2).getInputPlans().get(1)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj7.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)((POProject)prj7).getColumn());
        PhysicalOperator fil = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)ForE).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        List filRoots = filPlan.getRoots();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots.get(0)).getClass());
        ConstantExpression ce1 = (ConstantExpression)filRoots.get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce1.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots.get(2)).getClass());
        ConstantExpression ce2 = (ConstantExpression)filRoots.get(2);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce2.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots.get(1)).getClass());
        POProject prj8 = (POProject)filRoots.get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)5, (int)prj8.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots.get(3)).getClass());
        POProject prj9 = (POProject)filRoots.get(3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)prj9.getColumn());
        PhysicalOperator fil2 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)ForE2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil2.getClass());
        PhysicalOperator LoR3 = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)fil2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, LoR3.getClass());
        POLocalRearrange Lor3 = (POLocalRearrange)LoR3;
        PhysicalOperator prj12 = (PhysicalOperator)((PhysicalPlan)Lor3.getPlans().get(0)).getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj12.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)((POProject)prj12).getColumn());
        PhysicalPlan filPlan2 = ((POFilter)fil2).getPlan();
        List filRoots2 = filPlan2.getRoots();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots2.get(0)).getClass());
        ConstantExpression ce3 = (ConstantExpression)filRoots2.get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce3.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, ((PhysicalOperator)filRoots2.get(2)).getClass());
        ConstantExpression ce4 = (ConstantExpression)filRoots2.get(2);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(null, (Object)ce4.getValue());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots2.get(1)).getClass());
        POProject prj10 = (POProject)filRoots2.get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)prj10.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)filRoots2.get(3)).getClass());
        POProject prj11 = (POProject)filRoots2.get(3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj11.getColumn());
        PhysicalOperator stor = (PhysicalOperator)phyPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)stor, phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)fil).get(0));
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testPlanWithCast() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c);");
        lpt.buildPlan("b = filter a by (int)id==10;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)phyPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getRoots().size(), (int)1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getLeaves().size(), (int)1);
        PhysicalOperator load = (PhysicalOperator)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, load.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)load).getLFile().getFileName().contains("d.txt"));
        PhysicalOperator fil = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        PhysicalOperator equal = (PhysicalOperator)filPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(EqualToExpr.class, equal.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)5, (byte)((EqualToExpr)equal).getResultType());
        ExpressionOperator constExpr = ((EqualToExpr)equal).getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, constExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)10, (Object)((ConstantExpression)constExpr).getValue());
        ExpressionOperator castExpr = ((EqualToExpr)equal).getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POCast.class, castExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)((POCast)castExpr).getResultType());
        PhysicalOperator prj = (PhysicalOperator)((POCast)castExpr).getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj).getColumn());
        PhysicalOperator stor = (PhysicalOperator)phyPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testPlanWithGreaterThan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c);");
        lpt.buildPlan("b = filter a by (int)id>10;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)phyPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getRoots().size(), (int)1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getLeaves().size(), (int)1);
        PhysicalOperator load = (PhysicalOperator)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, load.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)load).getLFile().getFileName().contains("d.txt"));
        PhysicalOperator fil = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        PhysicalOperator greaterThan = (PhysicalOperator)filPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(GreaterThanExpr.class, greaterThan.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)5, (byte)((GreaterThanExpr)greaterThan).getResultType());
        ExpressionOperator constExpr = ((GreaterThanExpr)greaterThan).getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, constExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)10, (Object)((ConstantExpression)constExpr).getValue());
        ExpressionOperator castExpr = ((GreaterThanExpr)greaterThan).getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POCast.class, castExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)((POCast)castExpr).getResultType());
        PhysicalOperator prj = (PhysicalOperator)((POCast)castExpr).getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj).getColumn());
        PhysicalOperator stor = (PhysicalOperator)phyPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testPlanWithLessThan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c);");
        lpt.buildPlan("b = filter a by (int)id<10;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)phyPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getRoots().size(), (int)1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.getLeaves().size(), (int)1);
        PhysicalOperator load = (PhysicalOperator)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, load.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POLoad)load).getLFile().getFileName().contains("d.txt"));
        PhysicalOperator fil = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POFilter.class, fil.getClass());
        PhysicalPlan filPlan = ((POFilter)fil).getPlan();
        PhysicalOperator lessThan = (PhysicalOperator)filPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LessThanExpr.class, lessThan.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)5, (byte)((LessThanExpr)lessThan).getResultType());
        ExpressionOperator constExpr = ((LessThanExpr)lessThan).getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ConstantExpression.class, constExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)10, (Object)((ConstantExpression)constExpr).getValue());
        ExpressionOperator castExpr = ((LessThanExpr)lessThan).getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POCast.class, castExpr.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)((POCast)castExpr).getResultType());
        PhysicalOperator prj = (PhysicalOperator)((POCast)castExpr).getInputs().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, prj.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)prj).getColumn());
        PhysicalOperator stor = (PhysicalOperator)phyPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POStore.class, stor.getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)((POStore)stor).getSFile().getFileName().contains("empty"));
    }

    public void testForeachPlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c);");
        lpt.buildPlan("b = foreach a generate id, c;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.size(), (int)3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(((PhysicalOperator)phyPlan.getLeaves().get(0)).getClass(), POStore.class);
        POForEach foreach = (POForEach)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)foreach.getInputPlans().size(), (int)2);
        PhysicalPlan inner = (PhysicalPlan)foreach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)inner.size(), (int)1);
        POProject prj = (POProject)inner.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)prj.getColumn(), (int)0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)prj.getInputs(), null);
        inner = (PhysicalPlan)foreach.getInputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)inner.size(), (int)1);
        prj = (POProject)inner.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)prj.getColumn(), (int)1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)prj.getInputs(), null);
        Boolean[] flat = foreach.getToBeFlattened().toArray(new Boolean[0]);
        TestExperimentalLogToPhyTranslationVisitor.assertFalse((boolean)flat[0]);
        TestExperimentalLogToPhyTranslationVisitor.assertFalse((boolean)flat[1]);
    }

    public void testForeachPlan2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c:bag{t:(s,v)});");
        lpt.buildPlan("b = foreach a generate id, flatten(c);");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)ld).get(0);
        LogicalSchema ls = fe.getSchema();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)4L, (long)ls.getField((int)1).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)5L, (long)ls.getField((int)2).uid);
        LogicalSchema expected = new LogicalSchema();
        expected.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        expected.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        expected.addField(new LogicalSchema.LogicalFieldSchema("v", null, 50));
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)expected.isEqual((Object)ls));
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)phyPlan.size(), (int)3);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(((PhysicalOperator)phyPlan.getLeaves().get(0)).getClass(), POStore.class);
        POForEach foreach = (POForEach)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)foreach.getInputPlans().size(), (int)2);
        PhysicalPlan inner = (PhysicalPlan)foreach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)inner.size(), (int)1);
        POProject prj = (POProject)inner.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)prj.getColumn(), (int)0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)prj.getInputs(), null);
        inner = (PhysicalPlan)foreach.getInputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)inner.size(), (int)1);
        prj = (POProject)inner.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)prj.getColumn(), (int)1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((Object)prj.getInputs(), null);
        Boolean[] flat = foreach.getToBeFlattened().toArray(new Boolean[0]);
        TestExperimentalLogToPhyTranslationVisitor.assertFalse((boolean)flat[0]);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((boolean)flat[1]);
    }

    public void testPlanwithPlus() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate a+b;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(AddExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        AddExpression add = (AddExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getLhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)add.getRhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(Add.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        Add pAdd = (Add)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pAdd.getLhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pAdd.getRhs().getClass());
    }

    public void testPlanwithSubtract() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate a-b;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(SubtractExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        SubtractExpression add = (SubtractExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getLhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)add.getRhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(Subtract.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        Subtract pSubtract = (Subtract)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pSubtract.getLhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pSubtract.getRhs().getClass());
    }

    public void testPlanwithMultiply() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate a*b;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(MultiplyExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        MultiplyExpression add = (MultiplyExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getLhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)add.getRhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(Multiply.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        Multiply pMultiply = (Multiply)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pMultiply.getLhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pMultiply.getRhs().getClass());
    }

    public void testPlanwithDivide() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate a/b;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(DivideExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        DivideExpression add = (DivideExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getLhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)add.getRhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(Divide.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        Divide pDivide = (Divide)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pDivide.getLhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pDivide.getRhs().getClass());
    }

    public void testPlanwithMod() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate a%b;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ModExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        ModExpression add = (ModExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getLhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)add.getRhs().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(Mod.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        Mod pMod = (Mod)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pMod.getLhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, pMod.getRhs().getClass());
    }

    public void testPlanwithNegative() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate -a;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(NegativeExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        NegativeExpression add = (NegativeExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)add.getExpression().getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != add.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(PONegative.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        PONegative pNegative = (PONegative)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)pNegative.getInputs().get(0)).getClass());
    }

    public void testPlanwithisNull() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = filter a by a is null;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fil = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)newLogicalPlan.getSources().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOFilter.class, fil.getClass());
        LOFilter filter = (LOFilter)fil;
        LogicalExpressionPlan filPlan = filter.getFilterPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)filPlan.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)filPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)filPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(IsNullExpression.class, ((Operator)filPlan.getSources().get(0)).getClass());
        IsNullExpression isNull = (IsNullExpression)filPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != isNull.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != isNull.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, isNull.getExpression().getClass());
        ProjectExpression prj = (ProjectExpression)isNull.getExpression();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj.getUid());
    }

    public void testPlanwithisNotNull() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = filter a by a is not null;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fil = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)newLogicalPlan.getSources().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOFilter.class, fil.getClass());
        LOFilter filter = (LOFilter)fil;
        LogicalExpressionPlan filPlan = filter.getFilterPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)filPlan.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)3, (int)filPlan.size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)filPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(NotExpression.class, ((Operator)filPlan.getSources().get(0)).getClass());
        NotExpression notExp = (NotExpression)filPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != notExp.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != notExp.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(IsNullExpression.class, notExp.getExpression().getClass());
        IsNullExpression isNull = (IsNullExpression)notExp.getExpression();
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)0).uid != isNull.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertTrue((ls.getField((int)1).uid != isNull.getUid() ? 1 : 0) != 0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, isNull.getExpression().getClass());
        ProjectExpression prj = (ProjectExpression)isNull.getExpression();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj.getUid());
    }

    public void testPlanwithBinCond() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:int);");
        lpt.buildPlan("b = foreach a generate ( a < b ? b : a );");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(BinCondExpression.class, ((Operator)genExp.getSources().get(0)).getClass());
        BinCondExpression add = (BinCondExpression)genExp.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LessThanExpression.class, add.getCondition().getClass());
        LessThanExpression lessThan = (LessThanExpression)add.getCondition();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, lessThan.getLhs().getClass());
        ProjectExpression prj1 = (ProjectExpression)lessThan.getLhs();
        ProjectExpression prj2 = (ProjectExpression)lessThan.getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj1.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, lessThan.getRhs().getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)prj2.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, add.getLhs().getClass());
        ProjectExpression prj3 = (ProjectExpression)add.getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)prj3.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, add.getRhs().getClass());
        ProjectExpression prj4 = (ProjectExpression)add.getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj4.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)4, (int)inputPln.getRoots().size());
        for (PhysicalOperator p : inputPln.getRoots()) {
            TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, p.getClass());
        }
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POBinCond.class, ((PhysicalOperator)inputPln.getLeaves().get(0)).getClass());
        POBinCond binCond = (POBinCond)inputPln.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, binCond.getLhs().getClass());
        POProject prj_1 = (POProject)binCond.getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)prj_1.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, binCond.getRhs().getClass());
        POProject prj_2 = (POProject)binCond.getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj_2.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LessThanExpr.class, binCond.getCond().getClass());
        LessThanExpr lessThan_p = (LessThanExpr)binCond.getCond();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, lessThan_p.getLhs().getClass());
        POProject prj_3 = (POProject)lessThan_p.getLhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj_3.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, lessThan_p.getRhs().getClass());
        POProject prj_4 = (POProject)lessThan_p.getRhs();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)prj_4.getColumn());
    }

    public void testPlanwithUserFunc() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:bag{t:tuple(b_a:int,b_b:int)});");
        lpt.buildPlan("b = foreach a generate a,COUNT(b);");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln1 = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp1 = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp1.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, ((Operator)genExp1.getSources().get(0)).getClass());
        ProjectExpression prj1 = (ProjectExpression)genExp1.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj1.getUid());
        LogicalExpressionPlan genExp2 = (LogicalExpressionPlan)gen.getOutputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(UserFuncExpression.class, ((Operator)genExp2.getSources().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, ((Operator)genExp2.getSinks().get(0)).getClass());
        ProjectExpression prj2 = (ProjectExpression)genExp2.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)prj2.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln1.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln1.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)inputPln1.getLeaves().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)inputPln1.getLeaves().get(0)).getColumn());
        PhysicalPlan inputPln2 = (PhysicalPlan)pForEach.getInputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POUserFunc.class, ((PhysicalOperator)inputPln2.getLeaves().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((String)"org.apache.pig.builtin.COUNT", (String)((POUserFunc)inputPln2.getLeaves().get(0)).getFuncSpec().getClassName());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)inputPln2.getRoots().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)inputPln2.getRoots().get(0)).getColumn());
    }

    public void testPlanwithUserFunc2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:int, b:bag{t:tuple(b_a:int,b_b:int)});");
        lpt.buildPlan("b = foreach a generate a,COUNT(b.b_a);");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        LogicalRelationalOperator ld = (LogicalRelationalOperator)newLogicalPlan.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOLoad.class, ld.getClass());
        LOLoad load = (LOLoad)ld;
        LogicalSchema ls = load.getSchema();
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        PhysicalOperator pFE = (PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)phyPlan.getRoots().get(0)).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POForEach.class, pFE.getClass());
        POForEach pForEach = (POForEach)pFE;
        PhysicalPlan inputPln = (PhysicalPlan)pForEach.getInputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)1L, (long)ls.getField((int)0).uid);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)2L, (long)ls.getField((int)1).uid);
        LogicalRelationalOperator fe = (LogicalRelationalOperator)newLogicalPlan.getSuccessors((Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOForEach.class, fe.getClass());
        LOForEach forEach = (LOForEach)fe;
        LogicalPlan innerPlan = forEach.getInnerPlan();
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)innerPlan.getSinks().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(LOGenerate.class, ((Operator)innerPlan.getSinks().get(0)).getClass());
        LOGenerate gen = (LOGenerate)innerPlan.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)gen.getOutputPlans().size());
        LogicalExpressionPlan genExp1 = (LogicalExpressionPlan)gen.getOutputPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)genExp1.getSources().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, ((Operator)genExp1.getSources().get(0)).getClass());
        ProjectExpression prj1 = (ProjectExpression)genExp1.getSources().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)0).uid, (long)prj1.getUid());
        LogicalExpressionPlan genExp2 = (LogicalExpressionPlan)gen.getOutputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(UserFuncExpression.class, ((Operator)genExp2.getSources().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(ProjectExpression.class, ((Operator)genExp2.getSinks().get(0)).getClass());
        ProjectExpression prj2 = (ProjectExpression)genExp2.getSinks().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((long)ls.getField((int)1).uid, (long)prj2.getUid());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(BagDereferenceExpression.class, ((Operator)genExp2.getPredecessors((Operator)prj2).get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((BagDereferenceExpression)genExp2.getPredecessors((Operator)prj2).get(0)).getBagColNum());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)inputPln.getRoots().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)inputPln.getRoots().get(0)).getColumn());
        PhysicalPlan inputPln2 = (PhysicalPlan)pForEach.getInputPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)inputPln2.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)inputPln2.getRoots().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)((POProject)inputPln2.getRoots().get(0)).getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POUserFunc.class, ((PhysicalOperator)inputPln2.getLeaves().get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((String)"org.apache.pig.builtin.COUNT", (String)((POUserFunc)inputPln2.getLeaves().get(0)).getFuncSpec().getClassName());
        POProject prj3 = (POProject)inputPln2.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)inputPln2.getSuccessors((org.apache.pig.impl.plan.Operator)prj3).get(0)).getClass());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)((POProject)inputPln2.getSuccessors((org.apache.pig.impl.plan.Operator)prj3).get(0)).getColumn());
    }

    public void testCogroup() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = group a by name;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)phyPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(0)).getClass());
        POLoad load = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0)).getClass());
        POLocalRearrange localR = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)localR.getInputs().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)localR.getPlans().size());
        PhysicalPlan cogroupPlan = (PhysicalPlan)localR.getPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)cogroupPlan.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)cogroupPlan.getLeaves().get(0)).getClass());
        POProject prj = (POProject)cogroupPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0)).getClass());
        POGlobalRearrange globalR = (POGlobalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)globalR.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0)).getClass());
        POPackage pack = (POPackage)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)pack.getResultType());
    }

    public void testCogroup2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = group a by ( name, age );");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)phyPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(0)).getClass());
        POLoad load = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0)).getClass());
        POLocalRearrange localR = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)localR.getInputs().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)localR.getPlans().size());
        PhysicalPlan cogroupPlan = (PhysicalPlan)localR.getPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)cogroupPlan.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)cogroupPlan.getLeaves().get(0)).getClass());
        POProject prj = (POProject)cogroupPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj.getResultType());
        PhysicalPlan cogroupPlan2 = (PhysicalPlan)localR.getPlans().get(1);
        POProject prj2 = (POProject)cogroupPlan2.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)prj2.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)prj2.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0)).getClass());
        POGlobalRearrange globalR = (POGlobalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)globalR.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0)).getClass());
        POPackage pack = (POPackage)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)pack.getResultType());
    }

    public void testCogroup3() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = load 'e.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("c = group a by name, b by name;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)phyPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(0)).getClass());
        POLoad load = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0)).getClass());
        POLocalRearrange localR = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)localR.getPlans().size());
        PhysicalPlan cogroupPlan = (PhysicalPlan)localR.getPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)cogroupPlan.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)cogroupPlan.getLeaves().get(0)).getClass());
        POProject prj = (POProject)cogroupPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0)).getClass());
        POGlobalRearrange globalR = (POGlobalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)globalR.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(1)).getClass());
        POLoad load2 = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load2).get(0)).getClass());
        POLocalRearrange localR2 = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)localR2.getPlans().size());
        PhysicalPlan cogroupPlan2 = (PhysicalPlan)localR2.getPlans().get(0);
        POProject prj2 = (POProject)cogroupPlan2.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj2.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj2.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0)).getClass());
        POPackage pack = (POPackage)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)pack.getResultType());
    }

    public void testCogroup4() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = load 'e.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("c = group a by ( name, age ), b by ( name, age );");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        PhysicalPlan phyPlan = this.translatePlan((OperatorPlan)newLogicalPlan);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)phyPlan.getRoots().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(0)).getClass());
        POLoad load = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0)).getClass());
        POLocalRearrange localR = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)localR.getPlans().size());
        PhysicalPlan cogroupPlan = (PhysicalPlan)localR.getPlans().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)cogroupPlan.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)cogroupPlan.getLeaves().get(0)).getClass());
        POProject prj = (POProject)cogroupPlan.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj.getResultType());
        PhysicalPlan cogroupPlan2 = (PhysicalPlan)localR.getPlans().get(1);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)cogroupPlan2.getLeaves().size());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POProject.class, ((PhysicalOperator)cogroupPlan2.getLeaves().get(0)).getClass());
        POProject prj2 = (POProject)cogroupPlan2.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)prj2.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)prj2.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POGlobalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0)).getClass());
        POGlobalRearrange globalR = (POGlobalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)localR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)globalR.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLoad.class, ((PhysicalOperator)phyPlan.getRoots().get(1)).getClass());
        POLoad load2 = (POLoad)phyPlan.getRoots().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POLocalRearrange.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load2).get(0)).getClass());
        POLocalRearrange localR3 = (POLocalRearrange)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)load2).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)2, (int)localR3.getPlans().size());
        PhysicalPlan cogroupPlan3 = (PhysicalPlan)localR3.getPlans().get(0);
        POProject prj3 = (POProject)cogroupPlan3.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)0, (int)prj3.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)55, (byte)prj3.getResultType());
        PhysicalPlan cogroupPlan4 = (PhysicalPlan)localR3.getPlans().get(1);
        POProject prj4 = (POProject)cogroupPlan4.getLeaves().get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((int)1, (int)prj4.getColumn());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)10, (byte)prj4.getResultType());
        TestExperimentalLogToPhyTranslationVisitor.assertEquals(POPackage.class, ((PhysicalOperator)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0)).getClass());
        POPackage pack = (POPackage)phyPlan.getSuccessors((org.apache.pig.impl.plan.Operator)globalR).get(0);
        TestExperimentalLogToPhyTranslationVisitor.assertEquals((byte)110, (byte)pack.getResultType());
    }
}

