/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.FuncSpec;
import org.apache.pig.experimental.logical.expression.AndExpression;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOJoin;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalPlanVisitor;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.plan.BaseOperatorPlan;
import org.apache.pig.experimental.plan.DependencyOrderWalker;
import org.apache.pig.experimental.plan.DepthFirstWalker;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.PlanEdge;
import org.apache.pig.experimental.plan.PlanVisitor;
import org.apache.pig.experimental.plan.PlanWalker;
import org.apache.pig.experimental.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;
import org.junit.Test;

public class TestExperimentalOperatorPlan
extends TestCase {
    @Test
    public void testPlanEdgeInsert() {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        PlanEdge edges = new PlanEdge();
        edges.put((Operator)fred, (Operator)joe, 0);
        Collection c = edges.get((Object)fred);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)c.size());
        Operator[] a = new Operator[1];
        Operator[] b = c.toArray(a);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)joe), (Object)b[0]);
        SillyOperator bob = new SillyOperator("bob", plan);
        edges.put((Object)fred, (Object)bob);
        c = edges.get((Object)fred);
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)c.size());
        a = new Operator[2];
        b = c.toArray(a);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)joe), (Object)b[0]);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), (Object)b[1]);
        SillyOperator jill = new SillyOperator("jill", plan);
        edges.put((Operator)fred, (Operator)jill, 1);
        c = edges.get((Object)fred);
        TestExperimentalOperatorPlan.assertEquals((int)3, (int)c.size());
        a = new Operator[3];
        b = c.toArray(a);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)joe), (Object)b[0]);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)jill), (Object)b[1]);
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), (Object)b[2]);
    }

    @Test
    public void testPlanEdgeInsertFirstIndexBad() {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        PlanEdge edges = new PlanEdge();
        boolean caught = false;
        try {
            edges.put((Operator)fred, (Operator)joe, 1);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        TestExperimentalOperatorPlan.assertTrue((boolean)caught);
        caught = false;
        edges.put((Object)fred, (Object)joe);
        SillyOperator bob = new SillyOperator("bob", plan);
        try {
            edges.put((Operator)fred, (Operator)bob, 2);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        TestExperimentalOperatorPlan.assertTrue((boolean)caught);
    }

    @Test
    public void testOperatorPlan() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jim = new SillyOperator("jim", plan);
        SillyOperator sam = new SillyOperator("sam", plan);
        List list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)0, (int)list.size());
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)0, (int)list.size());
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jim);
        plan.add(sam);
        list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)5, (int)list.size());
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)5, (int)list.size());
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jim);
        plan.connect(bob, sam);
        list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        for (Operator op : list) {
            TestExperimentalOperatorPlan.assertTrue((fred.isEqual(op) || joe.isEqual(op) ? 1 : 0) != 0);
        }
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        for (Operator op : list) {
            TestExperimentalOperatorPlan.assertTrue((jim.isEqual(op) || sam.isEqual(op) ? 1 : 0) != 0);
        }
        list = plan.getSuccessors(fred);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getSuccessors(joe);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(jim);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(sam);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(bob);
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)fred), list.get(0));
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)joe), list.get(1));
        list = plan.getSuccessors(bob);
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)jim), list.get(0));
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)sam), list.get(1));
        Pair p1 = plan.disconnect(bob, jim);
        Pair p2 = plan.disconnect(fred, bob);
        plan.connect(bob, (Integer)p1.first, fred, (Integer)p1.second);
        plan.connect(jim, (Integer)p2.first, bob, (Integer)p2.second);
        list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        for (Operator op : list) {
            TestExperimentalOperatorPlan.assertTrue((jim.isEqual(op) || joe.isEqual(op) ? 1 : 0) != 0);
        }
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        for (Operator op : list) {
            TestExperimentalOperatorPlan.assertTrue((fred.isEqual(op) || sam.isEqual(op) ? 1 : 0) != 0);
        }
        list = plan.getSuccessors(jim);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getSuccessors(joe);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(fred);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(sam);
        TestExperimentalOperatorPlan.assertEquals((int)1, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)bob), list.get(0));
        list = plan.getPredecessors(bob);
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)jim), list.get(0));
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)joe), list.get(1));
        list = plan.getSuccessors(bob);
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)fred), list.get(0));
        TestExperimentalOperatorPlan.assertEquals((Object)((Object)sam), list.get(1));
    }

    @Test
    public void testDisconnectAndRemove() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.connect(fred, joe);
        plan.remove(bob);
        plan.disconnect(fred, joe);
        List list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)2, (int)list.size());
        plan.remove(fred);
        plan.remove(joe);
        TestExperimentalOperatorPlan.assertEquals((int)0, (int)plan.size());
        list = plan.getSources();
        TestExperimentalOperatorPlan.assertEquals((int)0, (int)list.size());
        list = plan.getSinks();
        TestExperimentalOperatorPlan.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testRemoveNegative() {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        plan.add(fred);
        plan.add(joe);
        plan.connect(fred, joe);
        boolean caught = false;
        try {
            plan.remove(fred);
        }
        catch (IOException e) {
            caught = true;
        }
        TestExperimentalOperatorPlan.assertTrue((boolean)caught);
        caught = false;
        try {
            plan.remove(joe);
        }
        catch (IOException e) {
            caught = true;
        }
        TestExperimentalOperatorPlan.assertTrue((boolean)caught);
    }

    @Test
    public void testDisconnectNegative() {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        plan.add(fred);
        plan.add(joe);
        boolean caught = false;
        try {
            plan.disconnect(fred, joe);
        }
        catch (IOException e) {
            caught = true;
        }
        TestExperimentalOperatorPlan.assertTrue((boolean)caught);
    }

    @Test
    public void testDependencyOrderWalkerLinear() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.connect(fred, joe);
        plan.connect(joe, bob);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        TestExperimentalOperatorPlan.assertEquals((String)"fredjoebob", (String)s);
    }

    @Test
    public void testDependencyOrderWalkerTree() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jill);
        plan.connect(jane, jill);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        if (!(s.equals("fredjoebobjanejill") || s.equals("joefredbobjanejill") || s.equals("janefredjoebobjill") || s.equals("janejoefredbobjill"))) {
            System.out.println("Invalid order " + s);
            TestExperimentalOperatorPlan.fail();
        }
    }

    @Test
    public void testDependencyOrderWalkerGraph() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jill);
        plan.connect(bob, jane);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        if (!(s.equals("fredjoebobjanejill") || s.equals("joefredbobjanejill") || s.equals("fredjoebobjilljane") || s.equals("joefredbobjilljane"))) {
            System.out.println("Invalid order " + s);
            TestExperimentalOperatorPlan.fail();
        }
    }

    @Test
    public void testDepthFirstWalkerLinear() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.connect(fred, joe);
        plan.connect(joe, bob);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DepthFirstWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        TestExperimentalOperatorPlan.assertEquals((String)"fredjoebob", (String)s);
    }

    @Test
    public void testDepthFirstWalkerTree() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(fred, joe);
        plan.connect(joe, jill);
        plan.connect(joe, jane);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DepthFirstWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        TestExperimentalOperatorPlan.assertEquals((String)"fredbobjoejilljane", (String)s);
    }

    @Test
    public void testDepthFirstWalkerGraph() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jill);
        plan.connect(bob, jane);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new DepthFirstWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        if (!s.equals("fredbobjilljanejoe") && !s.equals("joebobjilljanefred")) {
            System.out.println("Invalid order " + s);
            TestExperimentalOperatorPlan.fail();
        }
    }

    @Test
    public void testReverseDependencyOrderWalkerLinear() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.connect(fred, joe);
        plan.connect(joe, bob);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new ReverseDependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        TestExperimentalOperatorPlan.assertEquals((String)"bobjoefred", (String)s);
    }

    @Test
    public void testReverseDependencyOrderWalkerTree() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jill);
        plan.connect(jane, jill);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new ReverseDependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        if (!(s.equals("jilljanebobjoefred") || s.equals("jilljanebobfredjoe") || s.equals("jillbobjoefredjane") || s.equals("jillbobjoejanefred") || s.equals("jillbobfredjoejane") || s.equals("jillbobfredjanejoe") || s.equals("jillbobjanejoefred") || s.equals("jillbobjanefredjoe"))) {
            System.out.println("Invalid order " + s);
            TestExperimentalOperatorPlan.fail();
        }
    }

    @Test
    public void testReverseDependencyOrderWalkerGraph() throws IOException {
        SillyPlan plan = new SillyPlan();
        SillyOperator fred = new SillyOperator("fred", plan);
        SillyOperator joe = new SillyOperator("joe", plan);
        SillyOperator bob = new SillyOperator("bob", plan);
        SillyOperator jill = new SillyOperator("jill", plan);
        SillyOperator jane = new SillyOperator("jane", plan);
        plan.add(fred);
        plan.add(joe);
        plan.add(bob);
        plan.add(jill);
        plan.add(jane);
        plan.connect(fred, bob);
        plan.connect(joe, bob);
        plan.connect(bob, jill);
        plan.connect(bob, jane);
        SillyVisitor v = new SillyVisitor((OperatorPlan)plan, (PlanWalker)new ReverseDependencyOrderWalker((OperatorPlan)plan));
        v.visit();
        String s = v.getVisitPattern();
        if (!(s.equals("jilljanebobjoefred") || s.equals("jilljanebobfredjoe") || s.equals("janejillbobjoefred") || s.equals("janejillbobfredjoe"))) {
            System.out.println("Invalid order " + s);
            TestExperimentalOperatorPlan.fail();
        }
    }

    @Test
    public void testLogicalPlanVisitor() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LOLoad load = new LOLoad(null, null, lp);
        lp.add((Operator)load);
        TestLogicalVisitor v = new TestLogicalVisitor((OperatorPlan)lp);
        v.visit();
        TestExperimentalOperatorPlan.assertEquals((String)"load ", (String)v.getVisitPlan());
    }

    @Test
    public void testBinaryOperatorOrder() throws IOException {
        LogicalExpressionPlan ep = new LogicalExpressionPlan();
        ConstantExpression c = new ConstantExpression((OperatorPlan)ep, 10, (Object)new Integer(5));
        ProjectExpression p = new ProjectExpression((OperatorPlan)ep, 10, 0, 0);
        EqualExpression e = new EqualExpression((OperatorPlan)ep, (LogicalExpression)p, (LogicalExpression)c);
        TestExperimentalOperatorPlan.assertEquals((Object)p, (Object)e.getLhs());
        TestExperimentalOperatorPlan.assertEquals((Object)c, (Object)e.getRhs());
    }

    @Test
    public void testExpressionPlanVisitor() throws IOException {
        LogicalExpressionPlan ep = new LogicalExpressionPlan();
        ConstantExpression c = new ConstantExpression((OperatorPlan)ep, 10, (Object)new Integer(5));
        ProjectExpression p = new ProjectExpression((OperatorPlan)ep, 10, 0, 0);
        EqualExpression e = new EqualExpression((OperatorPlan)ep, (LogicalExpression)p, (LogicalExpression)c);
        ConstantExpression c2 = new ConstantExpression((OperatorPlan)ep, 5, (Object)new Boolean("true"));
        new AndExpression((OperatorPlan)ep, (LogicalExpression)e, (LogicalExpression)c2);
        TestExpressionVisitor v = new TestExpressionVisitor((OperatorPlan)ep);
        v.visit();
        TestExperimentalOperatorPlan.assertEquals((String)"and equal project constant constant ", (String)v.getVisitPlan());
    }

    @Test
    public void testExpressionEquality() {
        LogicalExpressionPlan ep1 = new LogicalExpressionPlan();
        ConstantExpression c1 = new ConstantExpression((OperatorPlan)ep1, 10, (Object)new Integer(5));
        ProjectExpression p1 = new ProjectExpression((OperatorPlan)ep1, 10, 0, 0);
        EqualExpression e1 = new EqualExpression((OperatorPlan)ep1, (LogicalExpression)p1, (LogicalExpression)c1);
        ConstantExpression ca1 = new ConstantExpression((OperatorPlan)ep1, 5, (Object)new Boolean("true"));
        AndExpression a1 = new AndExpression((OperatorPlan)ep1, (LogicalExpression)e1, (LogicalExpression)ca1);
        LogicalExpressionPlan ep2 = new LogicalExpressionPlan();
        ConstantExpression c2 = new ConstantExpression((OperatorPlan)ep2, 10, (Object)new Integer(5));
        ProjectExpression p2 = new ProjectExpression((OperatorPlan)ep2, 10, 0, 0);
        EqualExpression e2 = new EqualExpression((OperatorPlan)ep2, (LogicalExpression)p2, (LogicalExpression)c2);
        ConstantExpression ca2 = new ConstantExpression((OperatorPlan)ep2, 5, (Object)new Boolean("true"));
        AndExpression a2 = new AndExpression((OperatorPlan)ep2, (LogicalExpression)e2, (LogicalExpression)ca2);
        TestExperimentalOperatorPlan.assertTrue((boolean)ep1.isEqual((OperatorPlan)ep2));
        TestExperimentalOperatorPlan.assertTrue((boolean)c1.isEqual((Operator)c2));
        TestExperimentalOperatorPlan.assertTrue((boolean)p1.isEqual((Operator)p2));
        TestExperimentalOperatorPlan.assertTrue((boolean)e1.isEqual((Operator)e2));
        TestExperimentalOperatorPlan.assertTrue((boolean)ca1.isEqual((Operator)ca2));
        TestExperimentalOperatorPlan.assertTrue((boolean)a1.isEqual((Operator)a2));
        LogicalExpressionPlan ep3 = new LogicalExpressionPlan();
        ConstantExpression c3 = new ConstantExpression((OperatorPlan)ep3, 10, (Object)new Integer(3));
        ProjectExpression p3 = new ProjectExpression((OperatorPlan)ep3, 10, 0, 1);
        EqualExpression e3 = new EqualExpression((OperatorPlan)ep3, (LogicalExpression)p3, (LogicalExpression)c3);
        ConstantExpression ca3 = new ConstantExpression((OperatorPlan)ep3, 55, (Object)"true");
        AndExpression a3 = new AndExpression((OperatorPlan)ep3, (LogicalExpression)e3, (LogicalExpression)ca3);
        TestExperimentalOperatorPlan.assertFalse((boolean)ep1.isEqual((OperatorPlan)ep3));
        TestExperimentalOperatorPlan.assertFalse((boolean)c1.isEqual((Operator)c3));
        TestExperimentalOperatorPlan.assertFalse((boolean)p1.isEqual((Operator)p3));
        TestExperimentalOperatorPlan.assertFalse((boolean)e1.isEqual((Operator)e3));
        TestExperimentalOperatorPlan.assertFalse((boolean)ca1.isEqual((Operator)ca3));
        TestExperimentalOperatorPlan.assertFalse((boolean)a1.isEqual((Operator)a3));
        LogicalExpressionPlan ep4 = new LogicalExpressionPlan();
        ProjectExpression p4 = new ProjectExpression((OperatorPlan)ep4, 10, 1, 0);
        TestExperimentalOperatorPlan.assertFalse((boolean)ep1.isEqual((OperatorPlan)ep4));
        TestExperimentalOperatorPlan.assertFalse((boolean)p1.isEqual((Operator)p4));
    }

    @Test
    public void testRelationalEquality() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), aschema, lp);
        lp.add((Operator)A);
        LogicalSchema bschema = new LogicalSchema();
        bschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), bschema, lp);
        lp.add((Operator)B);
        LogicalSchema cschema = new LogicalSchema();
        cschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan, 10, 0, 0);
        LogicalExpressionPlan bprojplan = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan, 10, 1, 0);
        MultiMap mm = new MultiMap();
        mm.put((Object)0, (Object)aprojplan);
        mm.put((Object)1, (Object)bprojplan);
        LOJoin C = new LOJoin(lp, mm, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C.neverUseForRealSetSchema(cschema);
        lp.add((Operator)C);
        lp.connect((Operator)A, (Operator)C);
        lp.connect((Operator)B, (Operator)C);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression fy = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 1);
        ConstantExpression fc = new ConstantExpression((OperatorPlan)filterPlan, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fy, (LogicalExpression)fc);
        LOFilter D = new LOFilter(lp, filterPlan);
        D.neverUseForRealSetSchema(cschema);
        lp.add((Operator)D);
        lp.connect((Operator)C, (Operator)D);
        LogicalPlan lp1 = new LogicalPlan();
        LogicalSchema aschema2 = new LogicalSchema();
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A2 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), aschema2, lp1);
        lp1.add((Operator)A2);
        LogicalSchema bschema2 = new LogicalSchema();
        bschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B2 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), bschema2, lp1);
        lp1.add((Operator)B2);
        LogicalSchema cschema2 = new LogicalSchema();
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan2 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan2, 10, 0, 0);
        LogicalExpressionPlan bprojplan2 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan2, 10, 1, 0);
        MultiMap mm2 = new MultiMap();
        mm2.put((Object)0, (Object)aprojplan2);
        mm2.put((Object)1, (Object)bprojplan2);
        LOJoin C2 = new LOJoin(lp1, mm2, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C2.neverUseForRealSetSchema(cschema2);
        lp1.add((Operator)C2);
        lp1.connect((Operator)A2, (Operator)C2);
        lp1.connect((Operator)B2, (Operator)C2);
        LogicalExpressionPlan filterPlan2 = new LogicalExpressionPlan();
        ProjectExpression fy2 = new ProjectExpression((OperatorPlan)filterPlan2, 10, 0, 1);
        ConstantExpression fc2 = new ConstantExpression((OperatorPlan)filterPlan2, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)filterPlan2, (LogicalExpression)fy2, (LogicalExpression)fc2);
        LOFilter D2 = new LOFilter(lp1, filterPlan2);
        D2.neverUseForRealSetSchema(cschema2);
        lp1.add((Operator)D2);
        lp1.connect((Operator)C2, (Operator)D2);
        TestExperimentalOperatorPlan.assertTrue((boolean)lp.isEqual((OperatorPlan)lp1));
    }

    @Test
    public void testLoadEqualityDifferentFuncSpecCtorArgs() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LOLoad load2 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "z"})), aschema1, lp);
        lp.add((Operator)load2);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load2));
    }

    @Test
    public void testLoadEqualityDifferentNumFuncSpecCstorArgs() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LOLoad load3 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", "x")), aschema1, lp);
        lp.add((Operator)load3);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load3));
    }

    @Test
    public void testLoadEqualityDifferentFunctionNames() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LOLoad load4 = new LOLoad(new FileSpec("/abc", new FuncSpec("foobar", new String[]{"x", "z"})), aschema1, lp);
        lp.add((Operator)load4);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load4));
    }

    @Test
    public void testLoadEqualityDifferentFileName() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LOLoad load5 = new LOLoad(new FileSpec("/def", new FuncSpec("foo", new String[]{"x", "z"})), aschema1, lp);
        lp.add((Operator)load5);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load5));
    }

    @Test
    public void testRelationalEqualityDifferentSchema() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LogicalSchema aschema2 = new LogicalSchema();
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 55));
        LOLoad load6 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "z"})), aschema2, lp);
        lp.add((Operator)load6);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load6));
    }

    @Test
    public void testRelationalEqualityNullSchemas() {
        LogicalPlan lp = new LogicalPlan();
        LOLoad load7 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), null, lp);
        lp.add((Operator)load7);
        LOLoad load8 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), null, lp);
        lp.add((Operator)load8);
        TestExperimentalOperatorPlan.assertTrue((boolean)load7.isEqual((Operator)load8));
    }

    @Test
    public void testRelationalEqualityOneNullOneNotNullSchema() {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad load1 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "y"})), aschema1, lp);
        lp.add((Operator)load1);
        LOLoad load9 = new LOLoad(new FileSpec("/abc", new FuncSpec("foo", new String[]{"x", "z"})), null, lp);
        lp.add((Operator)load9);
        TestExperimentalOperatorPlan.assertFalse((boolean)load1.isEqual((Operator)load9));
    }

    @Test
    public void testFilterDifferentPredicates() {
        LogicalPlan lp = new LogicalPlan();
        LogicalExpressionPlan fp1 = new LogicalExpressionPlan();
        ProjectExpression fy1 = new ProjectExpression((OperatorPlan)fp1, 10, 0, 1);
        ConstantExpression fc1 = new ConstantExpression((OperatorPlan)fp1, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)fp1, (LogicalExpression)fy1, (LogicalExpression)fc1);
        LOFilter D1 = new LOFilter(lp, fp1);
        LogicalSchema cschema = new LogicalSchema();
        cschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        D1.neverUseForRealSetSchema(cschema);
        lp.add((Operator)D1);
        LogicalExpressionPlan fp2 = new LogicalExpressionPlan();
        ProjectExpression fy2 = new ProjectExpression((OperatorPlan)fp2, 10, 0, 1);
        ConstantExpression fc2 = new ConstantExpression((OperatorPlan)fp2, 10, (Object)new Integer(1));
        new EqualExpression((OperatorPlan)fp2, (LogicalExpression)fy2, (LogicalExpression)fc2);
        LOFilter D2 = new LOFilter(lp, fp2);
        D2.neverUseForRealSetSchema(cschema);
        lp.add((Operator)D2);
        TestExperimentalOperatorPlan.assertFalse((boolean)D1.isEqual((Operator)D2));
    }

    @Test
    public void testJoinDifferentJoinTypes() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema jaschema1 = new LogicalSchema();
        jaschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A1 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema1, lp);
        lp.add((Operator)A1);
        LogicalSchema jbschema1 = new LogicalSchema();
        jbschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B1 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema1, lp);
        lp.add((Operator)B1);
        LogicalSchema jcschema1 = new LogicalSchema();
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan1, 10, 0, 0);
        LogicalExpressionPlan bprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan1, 10, 1, 0);
        MultiMap mm1 = new MultiMap();
        mm1.put((Object)0, (Object)aprojplan1);
        mm1.put((Object)1, (Object)bprojplan1);
        LOJoin C1 = new LOJoin(lp, mm1, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C1.neverUseForRealSetSchema(jcschema1);
        lp.add((Operator)C1);
        lp.connect((Operator)A1, (Operator)C1);
        lp.connect((Operator)B1, (Operator)C1);
        LogicalSchema jaschema2 = new LogicalSchema();
        jaschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A2 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema2, lp);
        lp.add((Operator)A2);
        LogicalSchema jbschema2 = new LogicalSchema();
        jbschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B2 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema2, lp);
        lp.add((Operator)B2);
        LogicalSchema jcschema2 = new LogicalSchema();
        jcschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan2 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan2, 10, 0, 0);
        LogicalExpressionPlan bprojplan2 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan2, 10, 1, 0);
        MultiMap mm2 = new MultiMap();
        mm2.put((Object)0, (Object)aprojplan2);
        mm2.put((Object)1, (Object)bprojplan2);
        LOJoin C2 = new LOJoin(lp, mm2, LOJoin.JOINTYPE.SKEWED, new boolean[]{true, true});
        C2.neverUseForRealSetSchema(jcschema2);
        lp.add((Operator)C2);
        lp.connect((Operator)A2, (Operator)C2);
        lp.connect((Operator)B2, (Operator)C2);
        TestExperimentalOperatorPlan.assertFalse((boolean)C1.isEqual((Operator)C2));
    }

    @Test
    public void testJoinDifferentInner() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema jaschema1 = new LogicalSchema();
        jaschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A1 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema1, lp);
        lp.add((Operator)A1);
        LogicalSchema jbschema1 = new LogicalSchema();
        jbschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B1 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema1, lp);
        lp.add((Operator)B1);
        LogicalSchema jcschema1 = new LogicalSchema();
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan1, 10, 0, 0);
        LogicalExpressionPlan bprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan1, 10, 1, 0);
        MultiMap mm1 = new MultiMap();
        mm1.put((Object)0, (Object)aprojplan1);
        mm1.put((Object)1, (Object)bprojplan1);
        LOJoin C1 = new LOJoin(lp, mm1, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C1.neverUseForRealSetSchema(jcschema1);
        lp.add((Operator)C1);
        lp.connect((Operator)A1, (Operator)C1);
        lp.connect((Operator)B1, (Operator)C1);
        LogicalSchema jaschema3 = new LogicalSchema();
        jaschema3.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A3 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema3, lp);
        lp.add((Operator)A3);
        LogicalSchema jbschema3 = new LogicalSchema();
        jbschema3.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B3 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema3, lp);
        lp.add((Operator)B3);
        LogicalSchema jcschema3 = new LogicalSchema();
        jcschema3.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema3.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan3 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan3, 10, 0, 0);
        LogicalExpressionPlan bprojplan3 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan3, 10, 1, 0);
        MultiMap mm3 = new MultiMap();
        mm3.put((Object)0, (Object)aprojplan3);
        mm3.put((Object)1, (Object)bprojplan3);
        LOJoin C3 = new LOJoin(lp, mm3, LOJoin.JOINTYPE.HASH, new boolean[]{true, false});
        C3.neverUseForRealSetSchema(jcschema3);
        lp.add((Operator)C3);
        lp.connect((Operator)A3, (Operator)C3);
        lp.connect((Operator)B3, (Operator)C3);
        TestExperimentalOperatorPlan.assertFalse((boolean)C1.isEqual((Operator)C3));
    }

    @Test
    public void testJoinDifferentNumInputs() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema jaschema1 = new LogicalSchema();
        jaschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A1 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema1, lp);
        lp.add((Operator)A1);
        LogicalSchema jbschema1 = new LogicalSchema();
        jbschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B1 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema1, lp);
        lp.add((Operator)B1);
        LogicalSchema jcschema1 = new LogicalSchema();
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema1.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan1, 10, 0, 0);
        LogicalExpressionPlan bprojplan1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan1, 10, 1, 0);
        MultiMap mm1 = new MultiMap();
        mm1.put((Object)0, (Object)aprojplan1);
        mm1.put((Object)1, (Object)bprojplan1);
        LOJoin C1 = new LOJoin(lp, mm1, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C1.neverUseForRealSetSchema(jcschema1);
        lp.add((Operator)C1);
        lp.connect((Operator)A1, (Operator)C1);
        lp.connect((Operator)B1, (Operator)C1);
        LogicalSchema jaschema5 = new LogicalSchema();
        jaschema5.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A5 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema5, lp);
        lp.add((Operator)A5);
        LogicalSchema jbschema5 = new LogicalSchema();
        jbschema5.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad B5 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema5, lp);
        lp.add((Operator)B5);
        LogicalSchema jbetaschema5 = new LogicalSchema();
        jbetaschema5.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LOLoad Beta5 = new LOLoad(new FileSpec("/ghi", new FuncSpec("PigStorage", "\t")), jbetaschema5, lp);
        lp.add((Operator)Beta5);
        LogicalSchema jcschema5 = new LogicalSchema();
        jcschema5.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema5.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan5 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan5, 10, 0, 0);
        LogicalExpressionPlan bprojplan5 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan5, 10, 1, 0);
        LogicalExpressionPlan betaprojplan5 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)betaprojplan5, 10, 1, 0);
        MultiMap mm5 = new MultiMap();
        mm5.put((Object)0, (Object)aprojplan5);
        mm5.put((Object)1, (Object)bprojplan5);
        mm5.put((Object)2, (Object)betaprojplan5);
        LOJoin C5 = new LOJoin(lp, mm5, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C5.neverUseForRealSetSchema(jcschema5);
        lp.add((Operator)C5);
        lp.connect((Operator)A5, (Operator)C5);
        lp.connect((Operator)B5, (Operator)C5);
        lp.connect((Operator)Beta5, (Operator)C5);
        TestExperimentalOperatorPlan.assertFalse((boolean)C1.isEqual((Operator)C5));
    }

    @Test
    public void testJoinDifferentJoinKeys() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema jaschema6 = new LogicalSchema();
        jaschema6.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A6 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema6, lp);
        lp.add((Operator)A6);
        LogicalSchema jbschema6 = new LogicalSchema();
        jbschema6.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        jbschema6.addField(new LogicalSchema.LogicalFieldSchema("z", null, 15));
        LOLoad B6 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema6, lp);
        lp.add((Operator)B6);
        LogicalSchema jcschema6 = new LogicalSchema();
        jcschema6.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema6.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan6, 10, 0, 0);
        LogicalExpressionPlan bprojplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan6, 10, 1, 0);
        LogicalExpressionPlan b2projplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)b2projplan6, 10, 1, 1);
        MultiMap mm6 = new MultiMap();
        mm6.put((Object)0, (Object)aprojplan6);
        mm6.put((Object)1, (Object)bprojplan6);
        mm6.put((Object)1, (Object)b2projplan6);
        LOJoin C6 = new LOJoin(lp, mm6, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C6.neverUseForRealSetSchema(jcschema6);
        lp.add((Operator)C6);
        lp.connect((Operator)A6, (Operator)C6);
        lp.connect((Operator)B6, (Operator)C6);
        LogicalSchema jaschema7 = new LogicalSchema();
        jaschema7.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A7 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema7, lp);
        lp.add((Operator)A7);
        LogicalSchema jbschema7 = new LogicalSchema();
        jbschema7.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        jbschema7.addField(new LogicalSchema.LogicalFieldSchema("z", null, 15));
        LOLoad B7 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema7, lp);
        lp.add((Operator)B7);
        LogicalSchema jcschema7 = new LogicalSchema();
        jcschema7.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema7.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan7 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan7, 10, 0, 0);
        LogicalExpressionPlan bprojplan7 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan7, 10, 1, 1);
        LogicalExpressionPlan b2projplan7 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)b2projplan7, 10, 1, 0);
        MultiMap mm7 = new MultiMap();
        mm7.put((Object)0, (Object)aprojplan7);
        mm7.put((Object)1, (Object)bprojplan7);
        mm7.put((Object)1, (Object)b2projplan7);
        LOJoin C7 = new LOJoin(lp, mm7, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C7.neverUseForRealSetSchema(jcschema7);
        lp.add((Operator)C7);
        lp.connect((Operator)A7, (Operator)C7);
        lp.connect((Operator)B7, (Operator)C7);
        TestExperimentalOperatorPlan.assertFalse((boolean)C6.isEqual((Operator)C7));
    }

    @Test
    public void testJoinDifferentNumJoinKeys() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema jaschema6 = new LogicalSchema();
        jaschema6.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A6 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema6, lp);
        lp.add((Operator)A6);
        LogicalSchema jbschema6 = new LogicalSchema();
        jbschema6.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        jbschema6.addField(new LogicalSchema.LogicalFieldSchema("z", null, 15));
        LOLoad B6 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema6, lp);
        lp.add((Operator)B6);
        LogicalSchema jcschema6 = new LogicalSchema();
        jcschema6.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema6.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan6, 10, 0, 0);
        LogicalExpressionPlan bprojplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan6, 10, 1, 0);
        LogicalExpressionPlan b2projplan6 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)b2projplan6, 10, 1, 1);
        MultiMap mm6 = new MultiMap();
        mm6.put((Object)0, (Object)aprojplan6);
        mm6.put((Object)1, (Object)bprojplan6);
        mm6.put((Object)1, (Object)b2projplan6);
        LOJoin C6 = new LOJoin(lp, mm6, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C6.neverUseForRealSetSchema(jcschema6);
        lp.add((Operator)C6);
        lp.connect((Operator)A6, (Operator)C6);
        lp.connect((Operator)B6, (Operator)C6);
        LogicalSchema jaschema8 = new LogicalSchema();
        jaschema8.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A8 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), jaschema8, lp);
        lp.add((Operator)A8);
        LogicalSchema jbschema8 = new LogicalSchema();
        jbschema8.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        jbschema8.addField(new LogicalSchema.LogicalFieldSchema("z", null, 15));
        LOLoad B8 = new LOLoad(new FileSpec("/def", new FuncSpec("PigStorage", "\t")), jbschema8, lp);
        lp.add((Operator)B8);
        LogicalSchema jcschema8 = new LogicalSchema();
        jcschema8.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        jcschema8.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        LogicalExpressionPlan aprojplan8 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)aprojplan8, 10, 0, 0);
        LogicalExpressionPlan bprojplan8 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)bprojplan8, 10, 1, 0);
        MultiMap mm8 = new MultiMap();
        mm8.put((Object)0, (Object)aprojplan8);
        mm8.put((Object)1, (Object)bprojplan8);
        LOJoin C8 = new LOJoin(lp, mm8, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C8.neverUseForRealSetSchema(jcschema8);
        lp.add((Operator)C8);
        lp.connect((Operator)A8, (Operator)C8);
        lp.connect((Operator)B8, (Operator)C8);
        TestExperimentalOperatorPlan.assertFalse((boolean)C6.isEqual((Operator)C8));
    }

    @Test
    public void testRelationalSameOpDifferentPreds() throws IOException {
        LogicalPlan lp1 = new LogicalPlan();
        LogicalSchema aschema1 = new LogicalSchema();
        aschema1.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        LOLoad A1 = new LOLoad(new FileSpec("/abc", new FuncSpec("/fooload", new String[]{"x", "y"})), aschema1, lp1);
        lp1.add((Operator)A1);
        LogicalExpressionPlan fp1 = new LogicalExpressionPlan();
        ProjectExpression fy1 = new ProjectExpression((OperatorPlan)fp1, 10, 0, 0);
        ConstantExpression fc1 = new ConstantExpression((OperatorPlan)fp1, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)fp1, (LogicalExpression)fy1, (LogicalExpression)fc1);
        LOFilter D1 = new LOFilter(lp1, fp1);
        LogicalSchema cschema = new LogicalSchema();
        cschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        D1.neverUseForRealSetSchema(cschema);
        lp1.add((Operator)D1);
        lp1.connect((Operator)A1, (Operator)D1);
        LogicalPlan lp2 = new LogicalPlan();
        LOLoad A2 = new LOLoad(new FileSpec("/abc", new FuncSpec("/foo", new String[]{"x", "z"})), null, lp2);
        lp2.add((Operator)A2);
        LogicalExpressionPlan fp2 = new LogicalExpressionPlan();
        ProjectExpression fy2 = new ProjectExpression((OperatorPlan)fp2, 10, 0, 0);
        ConstantExpression fc2 = new ConstantExpression((OperatorPlan)fp2, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)fp2, (LogicalExpression)fy2, (LogicalExpression)fc2);
        LOFilter D2 = new LOFilter(lp2, fp2);
        D2.neverUseForRealSetSchema(cschema);
        lp2.add((Operator)D2);
        lp2.connect((Operator)A2, (Operator)D2);
        TestExperimentalOperatorPlan.assertFalse((boolean)D1.isEqual((Operator)D2));
    }

    private static class TestExpressionVisitor
    extends LogicalExpressionVisitor {
        StringBuffer bf = new StringBuffer();

        protected TestExpressionVisitor(OperatorPlan plan) {
            super(plan, (PlanWalker)new DepthFirstWalker(plan));
        }

        public void visitAnd(AndExpression andExpr) {
            this.bf.append("and ");
        }

        public void visitEqual(EqualExpression equal) {
            this.bf.append("equal ");
        }

        public void visitProject(ProjectExpression project) {
            this.bf.append("project ");
        }

        public void visitConstant(ConstantExpression constant) {
            this.bf.append("constant ");
        }

        String getVisitPlan() {
            return this.bf.toString();
        }
    }

    private static class TestLogicalVisitor
    extends LogicalPlanVisitor {
        StringBuffer bf = new StringBuffer();

        protected TestLogicalVisitor(OperatorPlan plan) {
            super(plan, (PlanWalker)new DepthFirstWalker(plan));
        }

        public void visitLOLoad(LOLoad load) {
            this.bf.append("load ");
        }

        String getVisitPlan() {
            return this.bf.toString();
        }
    }

    private static class SillyVisitor
    extends PlanVisitor {
        StringBuffer buf = new StringBuffer();

        protected SillyVisitor(OperatorPlan plan, PlanWalker walker) {
            super(plan, walker);
        }

        public void visitSillyOperator(SillyOperator so) {
            this.buf.append(so.getName());
        }

        public String getVisitPattern() {
            return this.buf.toString();
        }
    }

    private static class SillyOperator
    extends Operator {
        private String name;

        SillyOperator(String n, SillyPlan p) {
            super(n, (OperatorPlan)p);
            this.name = n;
        }

        public void accept(PlanVisitor v) {
            if (v instanceof SillyVisitor) {
                ((SillyVisitor)v).visitSillyOperator(this);
            }
        }

        public boolean isEqual(Operator operator) {
            return this.name.compareTo(operator.getName()) == 0;
        }
    }

    private static class SillyPlan
    extends BaseOperatorPlan {
        SillyPlan() {
        }
    }
}

