/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.experimental.plan.BaseOperatorPlan;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.PlanVisitor;
import org.apache.pig.experimental.plan.optimizer.Rule;
import org.apache.pig.experimental.plan.optimizer.Transformer;

public class TestExperimentalRule
extends TestCase {
    OperatorPlan plan = null;
    Operator join;

    public void setUp() {
        this.plan = new SillyPlan();
        OP_Load l1 = new OP_Load("p1", this.plan);
        this.plan.add((Operator)l1);
        OP_Load l2 = new OP_Load("p2", this.plan);
        this.plan.add((Operator)l2);
        OP_Join j1 = new OP_Join("j1", this.plan);
        this.plan.add((Operator)j1);
        OP_Filter f1 = new OP_Filter("f1", this.plan);
        this.plan.add((Operator)f1);
        OP_Filter f2 = new OP_Filter("f2", this.plan);
        this.plan.add((Operator)f2);
        OP_Split t1 = new OP_Split("t1", this.plan);
        this.plan.add((Operator)t1);
        OP_Filter f3 = new OP_Filter("f3", this.plan);
        this.plan.add((Operator)f3);
        OP_Filter f4 = new OP_Filter("f4", this.plan);
        this.plan.add((Operator)f4);
        OP_Store s1 = new OP_Store("s1", this.plan);
        this.plan.add((Operator)s1);
        OP_Store s2 = new OP_Store("s2", this.plan);
        this.plan.add((Operator)s2);
        this.plan.connect((Operator)l1, (Operator)j1);
        this.plan.connect((Operator)l2, (Operator)j1);
        this.plan.connect((Operator)j1, (Operator)f1);
        this.plan.connect((Operator)f1, (Operator)f2);
        this.plan.connect((Operator)f2, (Operator)t1);
        this.plan.connect((Operator)t1, (Operator)f3);
        this.plan.connect((Operator)t1, (Operator)f4);
        this.plan.connect((Operator)f3, (Operator)s1);
        this.plan.connect((Operator)f4, (Operator)s2);
        this.join = j1;
    }

    public void testMultiNode() throws Exception {
        OP_Load l3 = new OP_Load("p3", this.plan);
        OP_Filter f5 = new OP_Filter("f5", this.plan);
        this.plan.add((Operator)l3);
        this.plan.add((Operator)f5);
        this.plan.connect((Operator)l3, (Operator)f5);
        this.plan.connect((Operator)f5, this.join);
        SillyPlan pattern = new SillyPlan();
        OP_Load op1 = new OP_Load("mmm1", (OperatorPlan)pattern);
        OP_Filter op2 = new OP_Filter("mmm2", (OperatorPlan)pattern);
        OP_Join op3 = new OP_Join("mmm3", (OperatorPlan)pattern);
        pattern.add(op1);
        pattern.add(op2);
        pattern.add(op3);
        pattern.connect(op1, op3);
        pattern.connect(op2, op3);
        SillyRule r = new SillyRule("basic", (OperatorPlan)pattern);
        List l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)1, (int)l.size());
        OperatorPlan match = (OperatorPlan)l.get(0);
        TestExperimentalRule.assertEquals((int)match.size(), (int)3);
        TestExperimentalRule.assertEquals((int)match.getSinks().size(), (int)1);
        TestExperimentalRule.assertEquals(match.getSinks().get(0), (Object)this.join);
        TestExperimentalRule.assertEquals((int)match.getSources().size(), (int)2);
        TestExperimentalRule.assertTrue((((Operator)match.getSources().get(0)).getClass().equals(OP_Load.class) || ((Operator)match.getSources().get(0)).equals((Object)f5) ? 1 : 0) != 0);
        TestExperimentalRule.assertTrue((((Operator)match.getSources().get(1)).getClass().equals(OP_Load.class) || ((Operator)match.getSources().get(1)).equals((Object)f5) ? 1 : 0) != 0);
        TestExperimentalRule.assertNotSame(match.getSources().get(0), match.getSources().get(1));
    }

    public void testSingleNodeMatch() {
        SillyPlan pattern = new SillyPlan();
        pattern.add(new OP_Load("mmm", (OperatorPlan)pattern));
        SillyRule r = new SillyRule("basic", (OperatorPlan)pattern);
        List l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)2);
        Operator m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((m1.getName().equals("p1") || m1.getName().equals("p2") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)1);
        Operator m2 = (Operator)((OperatorPlan)l.get(1)).getSources().get(0);
        TestExperimentalRule.assertTrue((m2.getName().equals("p1") || m2.getName().equals("p2") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(1)).size(), (int)1);
        TestExperimentalRule.assertNotSame((Object)m1.getName(), (Object)m2.getName());
        pattern = new SillyPlan();
        pattern.add(new OP_Filter("mmm", (OperatorPlan)pattern));
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)4);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((m1.getName().equals("f1") || m1.getName().equals("f2") || m1.getName().equals("f3") || m1.getName().equals("f4") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)1);
        m2 = (Operator)((OperatorPlan)l.get(1)).getSources().get(0);
        TestExperimentalRule.assertTrue((m1.getName().equals("f1") || m1.getName().equals("f2") || m1.getName().equals("f3") || m1.getName().equals("f4") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(1)).size(), (int)1);
        TestExperimentalRule.assertNotSame((Object)m1.getName(), (Object)m2.getName());
        pattern = new SillyPlan();
        pattern.add(new OP_Store("mmm", (OperatorPlan)pattern));
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)2);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((m1.getName().equals("s1") || m1.getName().equals("s2") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)1);
        m2 = (Operator)((OperatorPlan)l.get(1)).getSources().get(0);
        TestExperimentalRule.assertTrue((m2.getName().equals("s1") || m2.getName().equals("s2") ? 1 : 0) != 0);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(1)).size(), (int)1);
        TestExperimentalRule.assertNotSame((Object)m1.getName(), (Object)m2.getName());
        pattern = new SillyPlan();
        pattern.add(new OP_Split("mmm", (OperatorPlan)pattern));
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)1);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((boolean)m1.getName().equals("t1"));
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)1);
        pattern = new SillyPlan();
        pattern.add(new OP_Join("mmm", (OperatorPlan)pattern));
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)1);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((boolean)m1.getName().equals("j1"));
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)1);
    }

    public void testTwoNodeMatch() {
        SillyPlan pattern = new SillyPlan();
        pattern.add(new OP_Load("mmm1", (OperatorPlan)pattern));
        pattern.add(new OP_Load("mmm2", (OperatorPlan)pattern));
        SillyRule r = new SillyRule("basic", (OperatorPlan)pattern);
        List l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSources().size(), (int)2);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSinks().size(), (int)2);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)2);
        Operator m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((m1.getName().equals("p1") || m1.getName().equals("p2") ? 1 : 0) != 0);
        Operator m2 = (Operator)((OperatorPlan)l.get(0)).getSources().get(1);
        TestExperimentalRule.assertTrue((m2.getName().equals("p1") || m2.getName().equals("p2") ? 1 : 0) != 0);
        TestExperimentalRule.assertNotSame((Object)m1.getName(), (Object)m2.getName());
        pattern = new SillyPlan();
        OP s1 = new OP_Join("mmm1", (OperatorPlan)pattern);
        OP s2 = new OP_Filter("mmm2", (OperatorPlan)pattern);
        pattern.add(s1);
        pattern.add(s2);
        pattern.connect(s1, s2);
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSources().size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSinks().size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)2);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((boolean)m1.getName().equals("j1"));
        m2 = (Operator)((OperatorPlan)l.get(0)).getSinks().get(0);
        TestExperimentalRule.assertTrue((boolean)m2.getName().equals("f1"));
        pattern = new SillyPlan();
        s1 = new OP_Filter("mmm1", (OperatorPlan)pattern);
        s2 = new OP_Store("mmm2", (OperatorPlan)pattern);
        pattern.add(s1);
        pattern.add(s2);
        pattern.connect(s1, s2);
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)2, (int)l.size());
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSources().size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSinks().size(), (int)1);
        pattern = new SillyPlan();
        s1 = new OP_Load("mmm1", (OperatorPlan)pattern);
        s2 = new OP_Load("mmm2", (OperatorPlan)pattern);
        OP s3 = new OP_Join("jjj", (OperatorPlan)pattern);
        pattern.add(s1);
        pattern.add(s2);
        pattern.add(s3);
        pattern.connect(s1, s3);
        pattern.connect(s2, s3);
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)l.size(), (int)1);
        pattern = new SillyPlan();
        s1 = new OP_Split("mmm1", (OperatorPlan)pattern);
        s2 = new OP_Filter("mmm2", (OperatorPlan)pattern);
        s3 = new OP_Filter("mmm3", (OperatorPlan)pattern);
        pattern.add(s1);
        pattern.add(s2);
        pattern.add(s3);
        pattern.connect(s1, s2);
        pattern.connect(s1, s3);
        r = new SillyRule("basic", (OperatorPlan)pattern);
        l = r.match(this.plan);
        TestExperimentalRule.assertEquals((int)1, (int)l.size());
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSources().size(), (int)1);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).getSinks().size(), (int)2);
        TestExperimentalRule.assertEquals((int)((OperatorPlan)l.get(0)).size(), (int)3);
        m1 = (Operator)((OperatorPlan)l.get(0)).getSources().get(0);
        TestExperimentalRule.assertTrue((boolean)m1.getName().equals("t1"));
        m2 = (Operator)((OperatorPlan)l.get(0)).getSinks().get(0);
        TestExperimentalRule.assertTrue((m2.getName().equals("f3") || m2.getName().equals("f4") ? 1 : 0) != 0);
        m2 = (Operator)((OperatorPlan)l.get(0)).getSinks().get(1);
        TestExperimentalRule.assertTrue((m2.getName().equals("f3") || m2.getName().equals("f4") ? 1 : 0) != 0);
    }

    private static class OP_Join
    extends OP {
        OP_Join(String n, OperatorPlan p) {
            super(n, p);
        }
    }

    private static class OP_Store
    extends OP {
        OP_Store(String n, OperatorPlan p) {
            super(n, p);
        }
    }

    private static class OP_Split
    extends OP {
        OP_Split(String n, OperatorPlan p) {
            super(n, p);
        }
    }

    private static class OP_Filter
    extends OP {
        OP_Filter(String n, OperatorPlan p) {
            super(n, p);
        }
    }

    private static class OP_Load
    extends OP {
        OP_Load(String n, OperatorPlan p) {
            super(n, p);
        }
    }

    private static class OP
    extends Operator {
        OP(String n, OperatorPlan p) {
            super(n, p);
        }

        public void accept(PlanVisitor v) {
        }

        public boolean isEqual(Operator operator) {
            return false;
        }
    }

    private static class SillyPlan
    extends BaseOperatorPlan {
        SillyPlan() {
        }

        public boolean isEqual(OperatorPlan other) {
            return false;
        }
    }

    private static class SillyRule
    extends Rule {
        public SillyRule(String n, OperatorPlan p) {
            super(n, p);
        }

        public Transformer getNewTransformer() {
            return null;
        }

        protected OperatorPlan buildPattern() {
            return null;
        }
    }
}

