/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestForEach
extends TestCase {
    POForEach fe;
    Tuple t;
    DataBag db;
    DataBag projDB;

    @Before
    public void setUp() throws Exception {
        Random r = new Random();
        this.db = GenRandomData.genRandSmallTupDataBagWithNulls(r, 10, 100);
        this.projDB = TestHelper.projectBag(this.db, 0);
        this.fe = GenPhyOp.topForEachOPWithPlan(0, (Tuple)this.db.iterator().next());
        POProject proj = GenPhyOp.exprProject();
        proj.setColumn(0);
        proj.setResultType((byte)110);
        proj.setOverloaded(true);
        DefaultTuple t = new DefaultTuple();
        t.append((Object)this.db);
        proj.attachInput((Tuple)t);
        ArrayList<POProject> inputs = new ArrayList<POProject>();
        inputs.add(proj);
        this.fe.setInputs(inputs);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNextTuple() throws ExecException, IOException {
        int size = 0;
        Result res = this.fe.getNext(this.t);
        while (res.returnStatus != 3) {
            Tuple t = (Tuple)res.result;
            TestForEach.assertEquals((boolean)true, (boolean)TestHelper.bagContains(this.projDB, t));
            ++size;
            res = this.fe.getNext(this.t);
        }
        TestForEach.assertEquals((boolean)true, ((long)size == this.db.size() ? 1 : 0) != 0);
    }
}

