/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

public class TestForEachNestedPlanLocal
extends TestCase {
    private String initString = "local";
    private PigServer pig;
    Boolean[] nullFlags = new Boolean[]{false, true};

    public TestForEachNestedPlanLocal() throws Throwable {
        this.pig = new PigServer(this.initString);
    }

    @Test
    public void testInnerOrderBy() throws Exception {
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Running testInnerOrderBy with nullFlags set to :" + this.nullFlags[i]);
            File tmpFile = this.genDataSetFile1(this.nullFlags[i]);
            this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "'; ");
            this.pig.registerQuery("b = group a by $0; ");
            this.pig.registerQuery("c = foreach b {      c1 = order $1 by *;     generate flatten(c1); };");
            Iterator it = this.pig.openIterator("c");
            Tuple t = null;
            int count = 0;
            while (it.hasNext()) {
                t = (Tuple)it.next();
                System.out.println(count + ":" + t);
                ++count;
            }
            Assert.assertEquals((int)count, (int)30);
        }
    }

    @Test
    public void testInnerLimit() throws Exception {
        File tmpFile = this.genDataSetFileOneGroup();
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = group a by $0; ");
        this.pig.registerQuery("c = foreach b {      c1 = limit $1 5;     generate COUNT(c1); };");
        Iterator it = this.pig.openIterator("c");
        Tuple t = null;
        long[] count = new long[3];
        for (int i = 0; i < 3 && it.hasNext(); ++i) {
            t = (Tuple)it.next();
            count[i] = (Long)t.get(0);
        }
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)5L, (long)count[0]);
        Assert.assertEquals((long)5L, (long)count[1]);
        Assert.assertEquals((long)3L, (long)count[2]);
    }

    private File genDataSetFile1(boolean withNulls) throws IOException {
        int dataLength = 30;
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        Random r = new Random();
        for (int i = 0; i < dataLength; ++i) {
            data[i] = new String[2];
            data[i][0] = withNulls && (double)r.nextInt(dataLength) < 0.3 * (double)dataLength ? "" : formatter.format(i % 10);
            data[i][1] = formatter.format((dataLength - i) / 2);
        }
        return TestHelper.createTempFile(data);
    }

    private File genDataSetFileOneGroup() throws IOException {
        File fp1 = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(fp1));
        ps.println("lost\tjack");
        ps.println("lost\tkate");
        ps.println("lost\tsawyer");
        ps.println("lost\tdesmond");
        ps.println("lost\thurley");
        ps.println("lost\tlocke");
        ps.println("lost\tsun");
        ps.println("lost\tcharlie");
        ps.println("lost\tjin");
        ps.println("lost\tben");
        ps.println("lotr\tfrodo");
        ps.println("lotr\tsam");
        ps.println("lotr\tmerry");
        ps.println("lotr\tpippen");
        ps.println("lotr\tbilbo");
        ps.println("3stooges\tlarry");
        ps.println("3stooges\tmoe");
        ps.println("3stooges\tcurly");
        ps.close();
        return fp1;
    }
}

