/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.junit.Before;
import org.junit.Test;

public class TestHBaseStorage
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestHBaseStorage.class);
    private MiniCluster cluster = MiniCluster.buildCluster();
    private HBaseConfiguration conf;
    private MiniHBaseCluster hbaseCluster;
    private MiniZooKeeperCluster zooKeeperCluster;
    private PigServer pig;
    static final int NUM_REGIONSERVERS = 1;
    private static final String TESTTABLE = "pigtable";
    private static final String COLUMNFAMILY = "pig:";
    private static final String TESTCOLUMN_A = "pig:col_a";
    private static final String TESTCOLUMN_B = "pig:col_b";
    private static final String TESTCOLUMN_C = "pig:col_c";
    private static final HColumnDescriptor family = new HColumnDescriptor("pig:");
    private static final int TEST_ROW_COUNT = 100;

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new HBaseConfiguration(ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()));
        this.conf.set("fs.default.name", this.cluster.getFileSystem().getUri().toString());
        Path parentdir = this.cluster.getFileSystem().getHomeDirectory();
        this.conf.set("hbase.rootdir", parentdir.toString());
        this.conf.setInt("hbase.server.thread.wakefrequency", 2000);
        this.conf.setInt("hbase.master.lease.period", 10000);
        this.conf.setLong("hbase.client.pause", 15000L);
        try {
            this.hBaseClusterSetup();
        }
        catch (Exception e) {
            if (this.hbaseCluster != null) {
                this.hbaseCluster.shutdown();
            }
            throw e;
        }
        this.pig = new PigServer(ExecType.MAPREDUCE, ConfigurationUtil.toProperties((Configuration)this.conf));
    }

    protected void hBaseClusterSetup() throws Exception {
        this.zooKeeperCluster = new MiniZooKeeperCluster();
        int clientPort = this.zooKeeperCluster.startup(new File("build/test"));
        this.conf.set("hbase.zookeeper.property.clientPort", clientPort + "");
        this.hbaseCluster = new MiniHBaseCluster(this.conf, 1);
        while (true) {
            try {
                new HTable(this.conf, HConstants.META_TABLE_NAME);
            }
            catch (IOException e) {
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    protected void tearDown() throws Exception {
        this.deleteTable();
        super.tearDown();
        try {
            HConnectionManager.deleteConnectionInfo((HBaseConfiguration)this.conf, (boolean)true);
            if (this.hbaseCluster != null) {
                try {
                    this.hbaseCluster.shutdown();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Closing mini hbase cluster", (Throwable)e);
                }
            }
            if (this.zooKeeperCluster != null) {
                try {
                    this.zooKeeperCluster.shutdown();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Closing zookeeper cluster", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.pig.shutdown();
    }

    @Test
    public void testLoadFromHBase() throws IOException, ExecException {
        this.prepareTable();
        this.pig.registerQuery("a = load 'hbase://pigtable' using org.apache.pig.backend.hadoop.hbase.HBaseStorage('pig:col_a pig:col_b pig:col_c') as (col_a, col_b:int, col_c);");
        Iterator it = this.pig.openIterator("a");
        int count = 0;
        LOG.info((Object)"LoadFromHBase Starting");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            LOG.info((Object)("LoadFromHBase " + t));
            String col_a = ((DataByteArray)t.get(0)).toString();
            int col_b = (Integer)t.get(1);
            String col_c = ((DataByteArray)t.get(2)).toString();
            TestHBaseStorage.assertEquals((String)String.valueOf(count), (String)col_a);
            TestHBaseStorage.assertEquals((int)count, (int)col_b);
            TestHBaseStorage.assertEquals((String)("TEXT" + count), (String)col_c);
            ++count;
        }
        TestHBaseStorage.assertEquals((int)100, (int)count);
        System.err.println("LoadFromHBase done");
    }

    @Test
    public void testBackwardsCompatibility() throws IOException, ExecException {
        this.prepareTable();
        this.pig.registerQuery("a = load 'pigtable' using org.apache.pig.backend.hadoop.hbase.HBaseStorage('pig:col_a pig:col_b pig:col_c') as (col_a, col_b:int, col_c);");
        Iterator it = this.pig.openIterator("a");
        int count = 0;
        LOG.info((Object)"LoadFromHBase Starting");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            LOG.info((Object)("LoadFromHBase " + t));
            String col_a = ((DataByteArray)t.get(0)).toString();
            int col_b = (Integer)t.get(1);
            String col_c = ((DataByteArray)t.get(2)).toString();
            TestHBaseStorage.assertEquals((String)String.valueOf(count), (String)col_a);
            TestHBaseStorage.assertEquals((int)count, (int)col_b);
            TestHBaseStorage.assertEquals((String)("TEXT" + count), (String)col_c);
            ++count;
        }
        TestHBaseStorage.assertEquals((int)100, (int)count);
        System.err.println("LoadFromHBase done");
    }

    private void prepareTable() throws IOException {
        HTableDescriptor tabledesc = new HTableDescriptor(TESTTABLE);
        tabledesc.addFamily(family);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        if (admin.tableExists(TESTTABLE)) {
            this.deleteTable();
        }
        admin.createTable(tabledesc);
        HTable table = new HTable(this.conf, TESTTABLE);
        for (int i = 0; i < 100; ++i) {
            String v = Integer.toString(i);
            BatchUpdate batchUpdate = new BatchUpdate(Bytes.toBytes((String)("00".substring(v.length()) + v)));
            batchUpdate.put(TESTCOLUMN_A, Bytes.toBytes((String)v));
            batchUpdate.put(TESTCOLUMN_B, Bytes.toBytes((String)v));
            batchUpdate.put(TESTCOLUMN_C, Bytes.toBytes((String)("TEXT" + i)));
            table.commit(batchUpdate);
        }
    }

    private void deleteTable() throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        if (admin.tableExists(TESTTABLE)) {
            admin.disableTable(TESTTABLE);
            while (admin.isTableEnabled(TESTTABLE)) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            admin.deleteTable(TESTTABLE);
        }
    }
}

