/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.validators.LogicalPlanValidationExecutor;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestInputOutputFileValidator
extends TestCase {
    private MiniCluster cluster = MiniCluster.buildCluster();

    @Test
    public void testLocalModeInputPositive() throws Throwable {
        PigContext ctx = new PigContext(ExecType.LOCAL, new Properties());
        ctx.connect();
        String inputfile = this.generateTempFile().getAbsolutePath();
        String outputfile = this.generateNonExistenceTempFile().getAbsolutePath();
        LogicalPlan plan = this.genNewLoadStorePlan(inputfile, outputfile, ctx.getFs());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = false;
        LogicalPlanValidationExecutor executor = new LogicalPlanValidationExecutor(plan, ctx, isBeforeOptimizer);
        executor.validate(plan, collector);
        TestInputOutputFileValidator.assertFalse((boolean)collector.hasError());
    }

    @Test
    public void testLocalModeNegative2() throws Throwable {
        PigContext ctx = new PigContext(ExecType.LOCAL, new Properties());
        ctx.connect();
        String inputfile = this.generateTempFile().getAbsolutePath();
        String outputfile = this.generateTempFile().getAbsolutePath();
        LogicalPlan plan = this.genNewLoadStorePlan(inputfile, outputfile, ctx.getDfs());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = false;
        LogicalPlanValidationExecutor executor = new LogicalPlanValidationExecutor(plan, ctx, isBeforeOptimizer);
        try {
            executor.validate(plan, collector);
            TestInputOutputFileValidator.fail((String)"Expected to fail.");
        }
        catch (Exception pve) {
            // empty catch block
        }
        TestInputOutputFileValidator.assertEquals((int)collector.size(), (int)3);
        for (int i = 0; i < collector.size(); ++i) {
            TestInputOutputFileValidator.assertEquals((Object)collector.get(i).getMessageType(), (Object)CompilationMessageCollector.MessageType.Error);
        }
    }

    @Test
    public void testMapReduceModeInputPositive() throws Throwable {
        PigContext ctx = new PigContext(ExecType.MAPREDUCE, this.cluster.getProperties());
        ctx.connect();
        String inputfile = this.createHadoopTempFile(ctx);
        String outputfile = this.createHadoopNonExistenceTempFile(ctx);
        LogicalPlan plan = this.genNewLoadStorePlan(inputfile, outputfile, ctx.getDfs());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = false;
        LogicalPlanValidationExecutor executor = new LogicalPlanValidationExecutor(plan, ctx, isBeforeOptimizer);
        executor.validate(plan, collector);
        TestInputOutputFileValidator.assertFalse((boolean)collector.hasError());
    }

    @Test
    public void testMapReduceModeInputNegative2() throws Throwable {
        PigContext ctx = new PigContext(ExecType.MAPREDUCE, this.cluster.getProperties());
        ctx.connect();
        String inputfile = this.createHadoopTempFile(ctx);
        String outputfile = this.createHadoopTempFile(ctx);
        LogicalPlan plan = this.genNewLoadStorePlan(inputfile, outputfile, ctx.getDfs());
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = false;
        LogicalPlanValidationExecutor executor = new LogicalPlanValidationExecutor(plan, ctx, isBeforeOptimizer);
        try {
            executor.validate(plan, collector);
            TestInputOutputFileValidator.fail((String)"Excepted to fail.");
        }
        catch (Exception e) {
            // empty catch block
        }
        TestInputOutputFileValidator.assertEquals((int)collector.size(), (int)3);
        for (int i = 0; i < collector.size(); ++i) {
            TestInputOutputFileValidator.assertEquals((Object)collector.get(i).getMessageType(), (Object)CompilationMessageCollector.MessageType.Error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPigServerStore() throws Exception {
        String input = "input.txt";
        String output = "output.txt";
        String[] data = new String[]{"hello\tworld"};
        ExecType[] modes = new ExecType[]{ExecType.MAPREDUCE, ExecType.LOCAL};
        PigServer pig = null;
        for (ExecType execType : modes) {
            try {
                if (execType == ExecType.MAPREDUCE) {
                    pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
                } else {
                    Properties props = new Properties();
                    props.put("fs.default.name", "file:///");
                    pig = new PigServer(ExecType.LOCAL, props);
                }
                FileLocalizer.setInitialized((boolean)false);
                Util.deleteFile(pig.getPigContext(), input);
                Util.deleteFile(pig.getPigContext(), output);
                Util.createInputFile(pig.getPigContext(), input, data);
                pig.registerQuery("a = load '" + input + "';");
                pig.store("a", output);
                pig.registerQuery("b = load '" + output + "';");
                Iterator it = pig.openIterator("b");
                Tuple t = (Tuple)it.next();
                Assert.assertEquals((String)"hello", (String)t.get(0).toString());
                Assert.assertEquals((String)"world", (String)t.get(1).toString());
                Assert.assertEquals((boolean)false, (boolean)it.hasNext());
            }
            finally {
                Util.deleteFile(pig.getPigContext(), input);
                Util.deleteFile(pig.getPigContext(), output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPigServerStoreNeg() throws Exception {
        String input = "input.txt";
        String output = "output.txt";
        String[] data = new String[]{"hello\tworld"};
        ExecType[] modes = new ExecType[]{ExecType.MAPREDUCE, ExecType.LOCAL};
        PigServer pig = null;
        for (ExecType execType : modes) {
            try {
                boolean exceptionCaught = false;
                if (execType == ExecType.MAPREDUCE) {
                    pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
                } else {
                    Properties props = new Properties();
                    props.put("fs.default.name", "file:///");
                    pig = new PigServer(ExecType.LOCAL, props);
                }
                Util.deleteFile(pig.getPigContext(), input);
                Util.deleteFile(pig.getPigContext(), output);
                Util.createInputFile(pig.getPigContext(), input, data);
                Util.createInputFile(pig.getPigContext(), output, data);
                try {
                    pig.registerQuery("a = load '" + input + "';");
                    pig.store("a", output);
                }
                catch (Exception e) {
                    TestInputOutputFileValidator.assertEquals((int)6000, (int)LogUtils.getPigException((Throwable)e).getErrorCode());
                    exceptionCaught = true;
                }
                if (exceptionCaught) continue;
                Assert.fail((String)"Expected exception to be caught");
            }
            finally {
                Util.deleteFile(pig.getPigContext(), input);
                Util.deleteFile(pig.getPigContext(), output);
            }
        }
    }

    private LogicalPlan genNewLoadStorePlan(String inputFile, String outputFile, DataStorage dfs) throws Throwable {
        LogicalPlan plan = new LogicalPlan();
        FileSpec filespec1 = new FileSpec(inputFile, new FuncSpec("org.apache.pig.builtin.PigStorage"));
        FileSpec filespec2 = new FileSpec(outputFile, new FuncSpec("org.apache.pig.builtin.PigStorage"));
        LOLoad load = new LOLoad(plan, this.genNewOperatorKeyId(), filespec1, ConfigurationUtil.toConfiguration((Properties)dfs.getConfiguration()));
        LOStore store = new LOStore(plan, this.genNewOperatorKeyId(), filespec2, "new");
        plan.add((Operator)load);
        plan.add((Operator)store);
        plan.connect((Operator)load, (Operator)store);
        return plan;
    }

    private OperatorKey genNewOperatorKeyId() {
        long newId = NodeIdGenerator.getGenerator().getNextNodeId("scope");
        return new OperatorKey("scope", newId);
    }

    private File generateTempFile() throws Throwable {
        File fp1 = File.createTempFile("file", ".txt");
        BufferedWriter bw = new BufferedWriter(new FileWriter(fp1));
        bw.write("hohoho");
        bw.close();
        fp1.deleteOnExit();
        return fp1;
    }

    private File generateNonExistenceTempFile() throws Throwable {
        File fp1 = File.createTempFile("file", ".txt");
        fp1.delete();
        return fp1;
    }

    private String createHadoopTempFile(PigContext ctx) throws Throwable {
        File fp1 = this.generateTempFile();
        ElementDescriptor localElem = ctx.getLfs().asElement(fp1.getAbsolutePath());
        String path = fp1.getAbsolutePath();
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            path = FileLocalizer.parseCygPath((String)path, (int)0);
        }
        ElementDescriptor distribElem = ctx.getDfs().asElement(path);
        localElem.copy(distribElem, null, false);
        return distribElem.toString();
    }

    private String createHadoopNonExistenceTempFile(PigContext ctx) throws Throwable {
        ElementDescriptor distribElem;
        File fp1 = this.generateTempFile();
        String path = fp1.getAbsolutePath();
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            path = FileLocalizer.parseCygPath((String)path, (int)0);
        }
        if ((distribElem = ctx.getDfs().asElement(path)).exists()) {
            distribElem.delete();
        }
        return distribElem.toString();
    }
}

