/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Before;
import org.junit.Test;

public class TestJoin
extends TestCase {
    MiniCluster cluster;
    private PigServer pigServer;
    TupleFactory mTf = TupleFactory.getInstance();
    BagFactory mBf = BagFactory.getInstance();
    ExecType[] execTypes = new ExecType[]{ExecType.LOCAL, ExecType.MAPREDUCE};

    @Before
    public void setUp() throws Exception {
        FileLocalizer.setR((Random)new Random());
    }

    private void setUp(ExecType execType) throws ExecException {
        FileLocalizer.setInitialized((boolean)false);
        if (execType == ExecType.MAPREDUCE) {
            this.cluster = MiniCluster.buildCluster();
            this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        } else if (execType == ExecType.LOCAL) {
            this.pigServer = new PigServer(ExecType.LOCAL);
        }
    }

    private String createInputFile(ExecType execType, String fileNameHint, String[] data) throws IOException {
        String fileName = "";
        if (execType == ExecType.MAPREDUCE) {
            Util.createInputFile(this.cluster, fileNameHint, data);
            fileName = fileNameHint;
        } else if (execType == ExecType.LOCAL) {
            File f = Util.createInputFile("test", fileNameHint, data);
            fileName = "file://" + f.getAbsolutePath();
        }
        return fileName;
    }

    private void deleteInputFile(ExecType execType, String fileName) throws IOException {
        if (execType == ExecType.MAPREDUCE) {
            Util.deleteFile(this.cluster, fileName);
        } else if (execType == ExecType.LOCAL) {
            fileName = fileName.replace("file://", "");
            new File(fileName).delete();
        }
    }

    @Test
    public void testJoinWithMissingFieldsInTuples() throws IOException {
        this.setUp(ExecType.MAPREDUCE);
        String[] input1 = new String[]{"ff ff ff", "", "", "", "", "ff ff ff", "", ""};
        String[] input2 = new String[]{"", "", "", "", ""};
        String firstInput = this.createInputFile(ExecType.MAPREDUCE, "a.txt", input1);
        String secondInput = this.createInputFile(ExecType.MAPREDUCE, "b.txt", input2);
        String script = "a = load 'a.txt'  using PigStorage(' ');b = load 'b.txt'  using PigStorage('\u0001');c = join a by $0, b by $0;";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("c");
        TestJoin.assertFalse((boolean)it.hasNext());
        this.deleteInputFile(ExecType.MAPREDUCE, firstInput);
        this.deleteInputFile(ExecType.MAPREDUCE, secondInput);
    }

    @Test
    public void testJoinUnkownSchema() throws Exception {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String script = "a = load 'a.txt';b = load 'b.txt'; c = join a by $0, b by $0;";
            Util.registerMultiLineQuery(this.pigServer, script);
            Schema schema = this.pigServer.dumpSchema("c");
            TestJoin.assertTrue((schema == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefaultJoin() throws IOException, ParseException {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"hello\t1", "bye\t2", "\t3"};
            String[] input2 = new String[]{"hello\tworld", "good\tmorning", "\tevening"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            Tuple expectedResult = (Tuple)Util.getPigConstant("('hello',1,'hello','world')");
            String script = "a = load '" + firstInput + "' as (n:chararray, a:int); " + "b = load '" + secondInput + "' as (n:chararray, m:chararray); " + "c = join a by $0, b by $0;";
            Util.registerMultiLineQuery(this.pigServer, script);
            Iterator it = this.pigServer.openIterator("c");
            TestJoin.assertEquals((boolean)true, (boolean)it.hasNext());
            TestJoin.assertEquals((Object)expectedResult, it.next());
            TestJoin.assertEquals((boolean)false, (boolean)it.hasNext());
            script = "a = load '" + firstInput + "'; " + "b = load '" + secondInput + "'; " + "c = join a by $0, b by $0;";
            Util.registerMultiLineQuery(this.pigServer, script);
            it = this.pigServer.openIterator("c");
            TestJoin.assertEquals((boolean)true, (boolean)it.hasNext());
            TestJoin.assertEquals((String)expectedResult.toString(), (String)((Tuple)it.next()).toString());
            TestJoin.assertEquals((boolean)false, (boolean)it.hasNext());
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testJoinSchema() throws Exception {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"1\t2", "2\t3", "3\t4"};
            String[] input2 = new String[]{"1\thello", "4\tbye"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            Tuple expectedResult = (Tuple)Util.getPigConstant("(1,2,1,'hello',1,2,1,'hello')");
            String script = "a = load '" + firstInput + "' as (i:int, j:int); " + "b = load '" + secondInput + "' as (k:int, l:chararray); " + "c = join a by $0, b by $0;" + "d = foreach c generate i,j,k,l,a::i as ai,a::j as aj,b::k as bk,b::l as bl;";
            Util.registerMultiLineQuery(this.pigServer, script);
            Iterator it = this.pigServer.openIterator("d");
            TestJoin.assertEquals((boolean)true, (boolean)it.hasNext());
            TestJoin.assertEquals((Object)expectedResult, it.next());
            TestJoin.assertEquals((boolean)false, (boolean)it.hasNext());
            script = "a = load '" + firstInput + "' as (i:int, j:int); " + "b = load '" + secondInput + "' as (i:int, l:chararray); " + "c = join a by $0, b by $0;" + "d = foreach c generate i,j,l,a::i as ai,a::j as aj,b::i as bi,b::l as bl;";
            boolean exceptionThrown = false;
            try {
                Util.registerMultiLineQuery(this.pigServer, script);
            }
            catch (Exception e) {
                PigException pe = LogUtils.getPigException((Throwable)e);
                TestJoin.assertEquals((int)1025, (int)pe.getErrorCode());
                exceptionThrown = true;
            }
            TestJoin.assertEquals((boolean)true, (boolean)exceptionThrown);
            script = "a = load '" + firstInput + "' as (i:int, j:int); " + "b = load '" + secondInput + "' as (i:int, l:chararray); " + "c = join a by $0, b by $0;" + "d = foreach c generate a::i as ai1,j,b::i as bi1,l,a::i as ai2,a::j as aj2,b::i as bi3,b::l as bl3;";
            Util.registerMultiLineQuery(this.pigServer, script);
            it = this.pigServer.openIterator("d");
            TestJoin.assertEquals((boolean)true, (boolean)it.hasNext());
            TestJoin.assertEquals((Object)expectedResult, it.next());
            TestJoin.assertEquals((boolean)false, (boolean)it.hasNext());
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testLeftOuterJoin() throws IOException, ParseException {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"hello\t1", "bye\t2", "\t3"};
            String[] input2 = new String[]{"hello\tworld", "good\tmorning", "\tevening"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"('hello',1,'hello','world')", "('bye',2,null,null)", "(null,3,null,null)"});
            for (int i = 0; i < 2; ++i) {
                String script = "a = load '" + firstInput + "' as (n:chararray, a:int); " + "b = load '" + secondInput + "' as (n:chararray, m:chararray); ";
                script = i == 0 ? script + "c = join a by $0 left outer, b by $0;" : script + "c = join a by $0 left, b by $0;";
                script = script + "d = order c by $1;";
                LogicalPlanTester lpt = new LogicalPlanTester();
                lpt.buildPlan(script);
                if (i != 0) continue;
                Util.registerMultiLineQuery(this.pigServer, script);
                Iterator it = this.pigServer.openIterator("d");
                int counter = 0;
                while (it.hasNext()) {
                    TestJoin.assertEquals((Object)expectedResults.get(counter++), it.next());
                }
                TestJoin.assertEquals((int)expectedResults.size(), (int)counter);
                script = "a = load '" + firstInput + "'; " + "b = load '" + secondInput + "'; ";
                script = i == 0 ? script + "c = join a by $0 left outer, b by $0;" : script + "c = join a by $0 left, b by $0;";
                try {
                    Util.registerMultiLineQuery(this.pigServer, script);
                    continue;
                }
                catch (Exception e) {
                    PigException pe = LogUtils.getPigException((Throwable)e);
                    TestJoin.assertEquals((int)1105, (int)pe.getErrorCode());
                }
            }
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testRightOuterJoin() throws IOException, ParseException {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"hello\t1", "bye\t2", "\t3"};
            String[] input2 = new String[]{"hello\tworld", "good\tmorning", "\tevening"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"(null,null,null,'evening')", "(null,null,'good','morning')", "('hello',1,'hello','world')"});
            for (int i = 0; i < 2; ++i) {
                String script = "a = load '" + firstInput + "' as (n:chararray, a:int); " + "b = load '" + secondInput + "' as (n:chararray, m:chararray); ";
                script = i == 0 ? script + "c = join a by $0 right outer, b by $0;" : script + "c = join a by $0 right, b by $0;";
                script = script + "d = order c by $3;";
                LogicalPlanTester lpt = new LogicalPlanTester();
                lpt.buildPlan(script);
                if (i != 0) continue;
                Util.registerMultiLineQuery(this.pigServer, script);
                Iterator it = this.pigServer.openIterator("d");
                int counter = 0;
                while (it.hasNext()) {
                    TestJoin.assertEquals((Object)expectedResults.get(counter++), it.next());
                }
                TestJoin.assertEquals((int)expectedResults.size(), (int)counter);
                script = "a = load '" + firstInput + "'; " + "b = load '" + secondInput + "'; ";
                script = i == 0 ? script + "c = join a by $0 right outer, b by $0;" : script + "c = join a by $0 right, b by $0;";
                try {
                    Util.registerMultiLineQuery(this.pigServer, script);
                    continue;
                }
                catch (Exception e) {
                    PigException pe = LogUtils.getPigException((Throwable)e);
                    TestJoin.assertEquals((int)1105, (int)pe.getErrorCode());
                }
            }
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testFullOuterJoin() throws IOException, ParseException {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"hello\t1", "bye\t2", "\t3"};
            String[] input2 = new String[]{"hello\tworld", "good\tmorning", "\tevening"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"(null,null,null,'evening')", "(null,null,'good','morning')", "('hello',1,'hello','world')", "('bye',2,null,null)", "(null,3,null,null)"});
            for (int i = 0; i < 2; ++i) {
                String script = "a = load '" + firstInput + "' as (n:chararray, a:int); " + "b = load '" + secondInput + "' as (n:chararray, m:chararray); ";
                script = i == 0 ? script + "c = join a by $0 full outer, b by $0;" : script + "c = join a by $0 full, b by $0;";
                script = script + "d = order c by $1, $3;";
                LogicalPlanTester lpt = new LogicalPlanTester();
                lpt.buildPlan(script);
                if (i != 0) continue;
                Util.registerMultiLineQuery(this.pigServer, script);
                Iterator it = this.pigServer.openIterator("d");
                int counter = 0;
                while (it.hasNext()) {
                    TestJoin.assertEquals((Object)expectedResults.get(counter++), it.next());
                }
                TestJoin.assertEquals((int)expectedResults.size(), (int)counter);
                script = "a = load '" + firstInput + "'; " + "b = load '" + secondInput + "'; ";
                script = i == 0 ? script + "c = join a by $0 full outer, b by $0;" : script + "c = join a by $0 full, b by $0;";
                try {
                    Util.registerMultiLineQuery(this.pigServer, script);
                    continue;
                }
                catch (Exception e) {
                    PigException pe = LogUtils.getPigException((Throwable)e);
                    TestJoin.assertEquals((int)1105, (int)pe.getErrorCode());
                }
            }
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testMultiOuterJoinFailure() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'a.txt' as (n:chararray, a:int); ");
        lpt.buildPlan("b = load 'b.txt' as (n:chararray, m:chararray); ");
        lpt.buildPlan("c = load 'c.txt' as (n:chararray, m:chararray); ");
        String[] types = new String[]{"left", "right", "full"};
        for (int i = 0; i < types.length; ++i) {
            boolean errCaught = false;
            try {
                lpt.buildPlanThrowExceptionOnError("d = join a by $0 " + types[i] + " outer, b by $0, c by $0;");
            }
            catch (Exception e) {
                errCaught = true;
                TestJoin.assertEquals((String)"(left|right|full) outer joins are only supported for two inputs", (String)e.getMessage());
            }
            TestJoin.assertEquals((boolean)true, (boolean)errCaught);
        }
    }

    @Test
    public void testNonRegularOuterJoinFailure() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'a.txt' as (n:chararray, a:int); ");
        lpt.buildPlan("b = load 'b.txt' as (n:chararray, m:chararray); ");
        String[] types = new String[]{"left", "right", "full"};
        String[] joinTypes = new String[]{"replicated", "repl", "merge"};
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < joinTypes.length; ++j) {
                boolean errCaught = false;
                try {
                    lpt.buildPlanThrowExceptionOnError("d = join a by $0 " + types[i] + " outer, b by $0 using \"" + joinTypes[j] + "\" ;");
                }
                catch (Exception e) {
                    errCaught = true;
                    if (j == 0 || j == 1) {
                        TestJoin.assertEquals((boolean)true, (boolean)e.getMessage().contains("does not support (right|full) outer joins"));
                    }
                    TestJoin.assertEquals((boolean)true, (boolean)e.getMessage().contains("does not support (left|right|full) outer joins"));
                }
                if (i == 0 && (j == 0 || j == 1)) {
                    TestJoin.assertEquals((boolean)false, (boolean)errCaught);
                    continue;
                }
                TestJoin.assertEquals((boolean)true, (boolean)errCaught);
            }
        }
    }

    @Test
    public void testJoinTupleFieldKey() throws Exception {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"(1,a)", "(2,aa)"};
            String[] input2 = new String[]{"(1,b)", "(2,bb)"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            String script = "a = load '" + firstInput + "' as (a:tuple(a1:int, a2:chararray));" + "b = load '" + secondInput + "' as (b:tuple(b1:int, b2:chararray));" + "c = join a by a.a1, b by b.b1;";
            Util.registerMultiLineQuery(this.pigServer, script);
            Iterator it = this.pigServer.openIterator("c");
            TestJoin.assertTrue((boolean)it.hasNext());
            Tuple t = (Tuple)it.next();
            TestJoin.assertTrue((boolean)t.toString().equals("((1,a),(1,b))"));
            TestJoin.assertTrue((boolean)it.hasNext());
            t = (Tuple)it.next();
            TestJoin.assertTrue((boolean)t.toString().equals("((2,aa),(2,bb))"));
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testJoinNullTupleFieldKey() throws Exception {
        for (ExecType execType : this.execTypes) {
            this.setUp(execType);
            String[] input1 = new String[]{"1\t", "2\taa"};
            String[] input2 = new String[]{"1\t", "2\taa"};
            String firstInput = this.createInputFile(execType, "a.txt", input1);
            String secondInput = this.createInputFile(execType, "b.txt", input2);
            String script = "a = load '" + firstInput + "' as (a1:int, a2:chararray);" + "b = load '" + secondInput + "' as (b1:int, b2:chararray);" + "c = join a by (a1, a2), b by (b1, b2);";
            Util.registerMultiLineQuery(this.pigServer, script);
            Iterator it = this.pigServer.openIterator("c");
            TestJoin.assertTrue((boolean)it.hasNext());
            Tuple t = (Tuple)it.next();
            TestJoin.assertTrue((boolean)t.toString().equals("(2,aa,2,aa)"));
            TestJoin.assertFalse((boolean)it.hasNext());
            this.deleteInputFile(execType, firstInput);
            this.deleteInputFile(execType, secondInput);
        }
    }

    @Test
    public void testLiteralsForJoinAlgoSpecification1() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'A'; ");
        lpt.buildPlan("b = load 'B'; ");
        LogicalPlan lp = lpt.buildPlan("c = Join a by $0, b by $0 using 'merge'; ");
        TestJoin.assertEquals((Object)LOJoin.JOINTYPE.MERGE, (Object)((LOJoin)lp.getLeaves().get(0)).getJoinType());
    }

    @Test
    public void testLiteralsForJoinAlgoSpecification2() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'A'; ");
        lpt.buildPlan("b = load 'B'; ");
        LogicalPlan lp = lpt.buildPlan("c = Join a by $0, b by $0 using 'hash'; ");
        TestJoin.assertEquals((Object)LOJoin.JOINTYPE.HASH, (Object)((LOJoin)lp.getLeaves().get(0)).getJoinType());
    }

    @Test
    public void testLiteralsForJoinAlgoSpecification5() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'A'; ");
        lpt.buildPlan("b = load 'B'; ");
        LogicalPlan lp = lpt.buildPlan("c = Join a by $0, b by $0 using 'default'; ");
        TestJoin.assertEquals((Object)LOJoin.JOINTYPE.HASH, (Object)((LOJoin)lp.getLeaves().get(0)).getJoinType());
    }

    @Test
    public void testLiteralsForJoinAlgoSpecification3() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'A'; ");
        lpt.buildPlan("b = load 'B'; ");
        LogicalPlan lp = lpt.buildPlan("c = Join a by $0, b by $0 using 'repl'; ");
        TestJoin.assertEquals((Object)LOJoin.JOINTYPE.REPLICATED, (Object)((LOJoin)lp.getLeaves().get(0)).getJoinType());
    }

    @Test
    public void testLiteralsForJoinAlgoSpecification4() {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'A'; ");
        lpt.buildPlan("b = load 'B'; ");
        LogicalPlan lp = lpt.buildPlan("c = Join a by $0, b by $0 using 'replicated'; ");
        TestJoin.assertEquals((Object)LOJoin.JOINTYPE.REPLICATED, (Object)((LOJoin)lp.getLeaves().get(0)).getJoinType());
    }
}

