/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLimitAdjuster {
    private static final MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;

    @Before
    public void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void simpleTest() throws Exception {
        String INPUT_FILE = "input";
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
        w.println("1\torange");
        w.println("2\tapple");
        w.println("3\tcoconut");
        w.println("4\tmango");
        w.println("5\tgrape");
        w.println("6\tpear");
        w.close();
        Util.copyFromLocalToCluster(cluster, INPUT_FILE, INPUT_FILE);
        this.pig.registerQuery("a = load '" + INPUT_FILE + "' as (x:int, y:chararray);");
        this.pig.registerQuery("b = order a by x parallel 2;");
        this.pig.registerQuery("c = limit b 1;");
        this.pig.registerQuery("d = foreach c generate y;");
        List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"('orange')"});
        Iterator iter = this.pig.openIterator("d");
        int counter = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((Object)expectedResults.get(counter++).toString(), (Object)((Tuple)iter.next()).toString());
        }
        Assert.assertEquals((long)expectedResults.size(), (long)counter);
    }
}

