/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.COUNT;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Before;
import org.junit.Test;

public class TestLocal
extends TestCase {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PigServer pig;

    @Before
    protected void setUp() throws Exception {
        this.pig = new PigServer("local");
    }

    @Test
    public void testBigGroupAll() throws Throwable {
        int LOOP_COUNT = 4096;
        File tmpFile = File.createTempFile(this.getName(), ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            ps.println(i);
        }
        ps.close();
        TestLocal.assertEquals((Object)new Double(LOOP_COUNT), (Object)this.bigGroupAll(tmpFile));
        tmpFile.delete();
    }

    @Test
    public void testBigGroupAllWithNull() throws Throwable {
        int LOOP_COUNT = 4096;
        File tmpFile = File.createTempFile(this.getName(), ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        long nonNullCnt = 0L;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 10 == 0) {
                ps.println("");
                continue;
            }
            ps.println(i);
            ++nonNullCnt;
        }
        ps.close();
        TestLocal.assertEquals((Object)new Double(nonNullCnt), (Object)this.bigGroupAll(tmpFile));
        tmpFile.delete();
    }

    @Test
    public Double bigGroupAll(File tmpFile) throws Throwable {
        String query = "foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') all) generate " + COUNT.class.getName() + "($1) ;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        Iterator it = this.pig.openIterator("asdf_id");
        Tuple t = (Tuple)it.next();
        return DataType.toDouble((Object)t.get(0));
    }

    @Test
    public void testStoreFunction() throws Throwable {
        String line;
        File tmpFile = File.createTempFile("test", ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < 10; ++i) {
            ps.println(i + "\t" + i);
        }
        ps.close();
        String query = "foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') generate $0,$1;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        try {
            this.pig.deleteFile("frog");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pig.store("asdf_id", "frog", MyStorage.class.getName() + "()");
        InputStream is = FileLocalizer.open((String)"frog", (PigContext)this.pig.getPigContext());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int i = 0;
        while ((line = br.readLine()) != null) {
            TestLocal.assertEquals((String)line, (String)(Integer.toString(i) + '-' + Integer.toString(i)));
            ++i;
        }
        br.close();
        try {
            this.pig.deleteFile("frog");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testStoreFunctionNoNulls() throws Throwable {
        String[][] data = this.genDataSetFile1(10, false);
        this.storeFunction(data);
    }

    @Test
    public void testStoreFunctionWithNulls() throws Throwable {
        String[][] data = this.genDataSetFile1(10, true);
        this.storeFunction(data);
    }

    public void storeFunction(String[][] data) throws Throwable {
        String line;
        File tmpFile = TestHelper.createTempFile(data);
        String query = "foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "') generate $0,$1;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        try {
            this.pig.deleteFile("frog");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pig.store("asdf_id", "frog", MyStorage.class.getName() + "()");
        InputStream is = FileLocalizer.open((String)"frog", (PigContext)this.pig.getPigContext());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int i = 0;
        while ((line = br.readLine()) != null) {
            TestLocal.assertEquals((String)(data[i][0] + '-' + data[i][1]), (String)line);
            ++i;
        }
        br.close();
        try {
            this.pig.deleteFile("frog");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testQualifiedFunctions() throws Throwable {
        File tmpFile = File.createTempFile("test", ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < 1; ++i) {
            ps.println(i);
        }
        ps.close();
        String query = "foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + MyStorage.class.getName() + "()) by " + MyGroup.class.getName() + "('all')) generate flatten(" + MyApply.class.getName() + "($1)) ;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        Iterator it = this.pig.openIterator("asdf_id");
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestLocal.assertEquals((String)t.get(0).toString(), (String)"Got");
            Integer.parseInt(t.get(1).toString());
            ++count;
        }
        TestLocal.assertEquals((int)10, (int)count);
    }

    @Test
    public void testQualifiedFunctionsWithNulls() throws Throwable {
        File tmpFile = File.createTempFile("test", ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < 1; ++i) {
            if (i % 10 == 0) {
                ps.println("");
                continue;
            }
            ps.println(i);
        }
        ps.close();
        String query = "foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + MyStorage.class.getName() + "()) by " + MyGroup.class.getName() + "('all')) generate flatten(" + MyApply.class.getName() + "($1)) ;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        Iterator it = this.pig.openIterator("asdf_id");
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestLocal.assertEquals((String)t.get(0).toString(), (String)"Got");
            Integer.parseInt(t.get(1).toString());
            ++count;
        }
        TestLocal.assertEquals((int)10, (int)count);
    }

    @Test
    public void testDefinedFunctions() throws Throwable {
        File tmpFile = File.createTempFile("test", ".txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < 1; ++i) {
            ps.println(i);
        }
        ps.close();
        this.pig.registerFunction("foo", new FuncSpec(MyApply.class.getName() + "('foo')"));
        String query = "foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + MyStorage.class.getName() + "()) by " + MyGroup.class.getName() + "('all')) generate flatten(foo($1)) ;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        Iterator it = this.pig.openIterator("asdf_id");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestLocal.assertEquals((String)"foo", (String)t.get(0).toString());
            Integer.parseInt(t.get(1).toString());
            ++count;
        }
        TestLocal.assertEquals((int)count, (int)10);
    }

    @Test
    public void testDefinedFunctionsNoNulls() throws Throwable {
        String[][] data = this.genDataSetFile1(10, false);
        this.definedFunctions(data);
    }

    @Test
    public void testDefinedFunctionsWithNulls() throws Throwable {
        String[][] data = this.genDataSetFile1(10, true);
        this.definedFunctions(data);
    }

    @Test
    public void definedFunctions(String[][] data) throws Throwable {
        File tmpFile = TestHelper.createTempFile(data);
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < 1; ++i) {
            ps.println(i);
        }
        ps.close();
        this.pig.registerFunction("foo", new FuncSpec(MyApply.class.getName() + "('foo')"));
        String query = "foreach (group (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + MyStorage.class.getName() + "()) by " + MyGroup.class.getName() + "('all')) generate flatten(foo($1)) ;";
        System.out.println(query);
        this.pig.registerQuery("asdf_id = " + query);
        Iterator it = this.pig.openIterator("asdf_id");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestLocal.assertEquals((String)"foo", (String)t.get(0).toString());
            if (t.get(1).toString() != "") {
                Integer.parseInt(t.get(1).toString());
            }
            ++count;
        }
        TestLocal.assertEquals((int)count, (int)10);
    }

    private String[][] genDataSetFile1(int dataLength, boolean hasNulls) throws IOException {
        String[][] data = new String[dataLength][];
        if (hasNulls) {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                if (i == 2) {
                    data[i][0] = "";
                    data[i][1] = new Integer(i).toString();
                    continue;
                }
                if (i == 6) {
                    data[i][0] = new Integer(i).toString();
                    data[i][1] = "";
                    continue;
                }
                if (i == 8) {
                    data[i][0] = "";
                    data[i][1] = "";
                    continue;
                }
                data[i][0] = new Integer(i).toString();
                data[i][1] = new Integer(i).toString();
            }
        } else {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                data[i][0] = new Integer(i).toString();
                data[i][1] = new Integer(i).toString();
            }
        }
        return data;
    }

    public static class MyStorage
    extends PigStorage {
        static final int COUNT = 10;
        int count = 0;
        boolean hasNulls = false;

        public void setNulls(boolean hasNulls) {
            this.hasNulls = hasNulls;
        }

        public MyStorage() {
            super("-");
        }

        public Tuple getNext() throws IOException {
            if (this.count < 10) {
                Tuple t = TupleFactory.getInstance().newTuple((Object)Integer.toString(this.count++));
                return t;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyGroup
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                Tuple output = TupleFactory.getInstance().newTuple(1);
                output.set(0, (Object)new String("g"));
                return output;
            }
            catch (ExecException ee) {
                IOException ioe = new IOException(ee.getMessage());
                ioe.initCause(ee);
                throw ioe;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyApply
    extends EvalFunc<DataBag> {
        String field0 = "Got";

        public MyApply() {
        }

        public MyApply(String field0) {
            this.field0 = field0;
        }

        public DataBag exec(Tuple input) throws IOException {
            try {
                DataBag output = BagFactory.getInstance().newDefaultBag();
                for (Tuple t : DataType.toBag((Object)input.get(0))) {
                    Tuple newT = TupleFactory.getInstance().newTuple(2);
                    newT.set(0, (Object)this.field0);
                    newT.set(1, (Object)t.get(0).toString());
                    output.add(newT);
                }
                return output;
            }
            catch (ExecException ee) {
                IOException ioe = new IOException(ee.getMessage());
                ioe.initCause(ee);
                throw ioe;
            }
        }
    }
}

