/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestLocalRearrange
extends TestCase {
    POLocalRearrange lr;
    Tuple t;
    DataBag db;

    @Before
    public void setUp() throws Exception {
        Random r = new Random();
        this.db = GenRandomData.genRandSmallTupDataBag(r, 10, 100);
    }

    private void setUp1() throws PlanException, ExecException {
        this.lr = GenPhyOp.topLocalRearrangeOPWithPlanPlain(0, 0, (Tuple)this.db.iterator().next());
        POProject proj = GenPhyOp.exprProject();
        proj.setColumn(0);
        proj.setResultType((byte)110);
        proj.setOverloaded(true);
        DefaultTuple t = new DefaultTuple();
        t.append((Object)this.db);
        proj.attachInput((Tuple)t);
        ArrayList<POProject> inputs = new ArrayList<POProject>();
        inputs.add(proj);
        this.lr.setInputs(inputs);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNextTuple1() throws ExecException, PlanException {
        this.setUp1();
        int size = 0;
        Result res = this.lr.getNext(this.t);
        while (res.returnStatus != 3) {
            Tuple t = (Tuple)res.result;
            String key = (String)t.get(1);
            Tuple val = (Tuple)t.get(2);
            TestLocalRearrange.assertEquals((int)1, (int)val.size());
            DefaultTuple actualVal = new DefaultTuple();
            actualVal.append((Object)key);
            actualVal.append(val.get(0));
            TestLocalRearrange.assertEquals((byte)0, (byte)((Byte)t.get(0)));
            TestLocalRearrange.assertTrue((boolean)TestHelper.bagContains(this.db, (Tuple)actualVal));
            String inpKey = (String)actualVal.get(0);
            TestLocalRearrange.assertEquals((int)0, (int)inpKey.compareTo((String)t.get(1)));
            ++size;
            res = this.lr.getNext(this.t);
        }
        TestLocalRearrange.assertEquals((long)this.db.size(), (long)size);
    }

    private void setUp2() throws PlanException, ExecException {
        this.lr = GenPhyOp.topLocalRearrangeOPWithPlanPlain(0, 0, (Tuple)this.db.iterator().next());
        List plans = this.lr.getPlans();
        POLocalRearrange lrT = GenPhyOp.topLocalRearrangeOPWithPlanPlain(0, 1, (Tuple)this.db.iterator().next());
        List plansT = lrT.getPlans();
        plans.add(plansT.get(0));
        this.lr.setPlans(plans);
        POProject proj = GenPhyOp.exprProject();
        proj.setColumn(0);
        proj.setResultType((byte)110);
        proj.setOverloaded(true);
        DefaultTuple t = new DefaultTuple();
        t.append((Object)this.db);
        proj.attachInput((Tuple)t);
        ArrayList<POProject> inputs = new ArrayList<POProject>();
        inputs.add(proj);
        this.lr.setInputs(inputs);
    }

    @Test
    public void testGetNextTuple2() throws ExecException, PlanException {
        this.setUp2();
        int size = 0;
        Result res = this.lr.getNext(this.t);
        while (res.returnStatus != 3) {
            Tuple t = (Tuple)res.result;
            Tuple key = (Tuple)t.get(1);
            Tuple val = (Tuple)t.get(2);
            TestLocalRearrange.assertEquals((int)0, (int)val.size());
            TestLocalRearrange.assertEquals((byte)0, (byte)((Byte)t.get(0)));
            val = key;
            TestLocalRearrange.assertTrue((boolean)TestHelper.bagContains(this.db, val));
            Tuple inpKey = TupleFactory.getInstance().newTuple(2);
            inpKey.set(0, val.get(0));
            inpKey.set(1, val.get(1));
            TestLocalRearrange.assertEquals((int)0, (int)inpKey.compareTo((Object)((Tuple)t.get(1))));
            ++size;
            res = this.lr.getNext(this.t);
        }
        TestLocalRearrange.assertEquals((long)this.db.size(), (long)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryJiraPig1194() {
        String INPUT_FILE = "data.txt";
        MiniCluster cluster = MiniCluster.buildCluster();
        try {
            PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
            w.println("10\t2\t3");
            w.println("10\t4\t5");
            w.println("20\t3000\t2");
            w.println("20\t4000\t3");
            w.println("20\t3\t");
            w.println("21\t4\t");
            w.println("22\t5\t");
            w.close();
            Util.copyFromLocalToCluster(cluster, INPUT_FILE, INPUT_FILE);
            PigServer myPig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
            myPig.registerQuery("data = load '" + INPUT_FILE + "' as (a0, a1, a2);");
            myPig.registerQuery("grp = GROUP data BY (((double) a2)/((double) a1) > .001 OR a0 < 11 ? a0 : 0);");
            myPig.registerQuery("res = FOREACH grp GENERATE group, SUM(data.a1), SUM(data.a2);");
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"(0,7000.0,5.0)", "(10,6.0,8.0)", "(null,12.0,null)"});
            Iterator iter = myPig.openIterator("res");
            int counter = 0;
            while (iter.hasNext()) {
                TestLocalRearrange.assertEquals((String)expectedResults.get(counter++).toString(), (String)((Tuple)iter.next()).toString());
            }
            TestLocalRearrange.assertEquals((int)expectedResults.size(), (int)counter);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            new File(INPUT_FILE).delete();
            try {
                Util.deleteFile(cluster, INPUT_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }
}

