/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFAny;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LODefine;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOPrinter;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.SchemaAliasValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.Identity;
import org.junit.Test;

public class TestLogicalPlanBuilder
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    Map<LogicalOperator, LogicalPlan> aliases = new HashMap<LogicalOperator, LogicalPlan>();
    Map<OperatorKey, LogicalOperator> logicalOpTable = new HashMap<OperatorKey, LogicalOperator>();
    Map<String, LogicalOperator> aliasOp = new HashMap<String, LogicalOperator>();
    Map<String, String> fileNameMap = new HashMap<String, String>();
    PigContext pigContext = new PigContext(ExecType.MAPREDUCE, new Properties());

    @Test
    public void testQuery1() {
        String query = "foreach (load 'a') generate $1,$2;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery2() {
        String query = "foreach (load 'a' using " + PigStorage.class.getName() + "(':')) generate $1, 'aoeuaoeu' ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery3() {
        String query = "foreach (cogroup (load 'a') by $1, (load 'b') by $1) generate org.apache.pig.builtin.AVG($1) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery4() {
        String query = "foreach (load 'a') generate AVG($1, $2) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery5() {
        String query = "foreach (group (load 'a') ALL) generate $1 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery6() {
        String query = "foreach (group (load 'a') by $1) generate group, '1' ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery7() {
        String query = "foreach (load 'a' using " + PigStorage.class.getName() + "()) generate $1 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery10() {
        String query = "foreach (cogroup (load 'a') by ($1), (load 'b') by ($1)) generate $1.$1, $2.$1 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery11() {
        String query = " foreach (group (load 'a') by $1, (load 'b') by $2) generate group, AVG($1) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery12() {
        String query = "foreach (load 'a' using " + PigStorage.class.getName() + "()) generate AVG($1) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery13() {
        String query = "foreach (cogroup (load 'a') ALL) generate group ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery14() {
        String query = "foreach (group (load 'a') by ($6, $7)) generate flatten(group) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery15() {
        String query = " foreach (load 'a') generate $1, 'hello', $3 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery100() {
        String query = "define FUNC ARITY();";
        LogicalOperator lo = (LogicalOperator)this.buildPlan(query).getRoots().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(lo instanceof LODefine));
    }

    @Test
    public void testQueryFail1() {
        String query = " foreach (group (A = load 'a') by $1) generate A.'1' ;";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQueryFail2() {
        String query = "foreach group (load 'a') by $1 generate $1.* ;";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQueryFail3() {
        String query = "generate DISTINCT foreach (load 'a');";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQueryFail4() {
        String query = "generate [ORDER BY $0][$3, $4] foreach (load 'a');";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQueryFail5() {
        String query = "generate " + TestApplyFunc.class.getName() + "($2.*) foreach (load 'a');";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery17() {
        String query = "foreach (load 'A')generate " + TestApplyFunc.class.getName() + "($1);";
        this.buildPlan(query);
    }

    @Test
    public void testQuery18() {
        LogicalOperator root;
        String query = "FOREACH (group (load 'a') ALL PARALLEL 16) generate group;";
        LogicalPlan lp = this.buildPlan(query);
        List listOp = lp.getSuccessors((Operator)(root = (LogicalOperator)lp.getRoots().get(0)));
        LogicalOperator lo = (LogicalOperator)listOp.get(0);
        if (lo instanceof LOCogroup) {
            TestLogicalPlanBuilder.assertTrue((((LOCogroup)lo).getRequestedParallelism() == 16 ? 1 : 0) != 0);
        } else {
            TestLogicalPlanBuilder.fail((String)"Error: Unexpected Parse Tree output");
        }
    }

    @Test
    public void testQuery19() {
        this.buildPlan("a = load 'a';");
        this.buildPlan("b = filter a by $1 == '3';");
    }

    @Test
    public void testQuery20() {
        String query = "foreach (load 'a') generate ($1 == '3'? $2 : $3) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery21() {
        this.buildPlan("A = load 'a';");
        this.buildPlan("B = load 'b';");
        this.buildPlan("foreach (cogroup A by ($1), B by ($1)) generate A, flatten(B.($1, $2, $3));");
    }

    @Test
    public void testQuery22() {
        this.buildPlan("A = load 'a';");
        this.buildPlan("B = load 'b';");
        this.buildPlan("C = cogroup A by ($1), B by ($1);");
        String query = "foreach C { B = order B by $0; generate FLATTEN(A), B.($1, $2, $3) ;};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery22Fail() {
        this.buildPlan("A = load 'a' as (a:int, b: double);");
        try {
            this.buildPlan("B = group A by (*, $0);");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Grouping attributes can either be star (*"));
        }
    }

    @Test
    public void testQuery23() {
        this.buildPlan("A = load 'a';");
        this.buildPlan("B = load 'b';");
        this.buildPlan("C = cogroup A by ($1), B by ($1);");
        String query = "foreach C { A = Distinct A; B = FILTER A BY $1 < 'z'; C = FILTER A BY $2 == $3;B = ARRANGE B BY $1;GENERATE A, FLATTEN(B.$0);};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery23Fail() {
        this.buildPlan("A = load 'a' as (a: int, b:double);");
        this.buildPlan("B = load 'b';");
        boolean exceptionThrown = false;
        try {
            this.buildPlan("C = cogroup A by (*, $0), B by ($0, $1);");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("The arity of cogroup/group by columns do not match"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testQuery23Fail2() {
        this.buildPlan("A = load 'a';");
        this.buildPlan("B = load 'b';");
        boolean exceptionThrown = false;
        try {
            this.buildPlan("C = cogroup A by (*, $0), B by ($0, $1);");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Cogroup/Group by * is only allowed if the input has a schema"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testQuery23Fail3() {
        this.buildPlan("A = load 'a' as (a: int, b:double);");
        this.buildPlan("B = load 'b' as (a:int);");
        boolean exceptionThrown = false;
        try {
            this.buildPlan("C = cogroup A by *, B by *;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("The arity of cogroup/group by columns do not match"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testQuery24() {
        this.buildPlan("a = load 'a';");
        String query = "foreach a generate (($0 == $1) ? 'a' : $2), $4 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery25() {
        String query = "foreach (load 'a') {B = FILTER $0 BY (($1 == $2) AND ('a' < 'b'));generate B;};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery26() {
        String query = "foreach (load 'a') generate  ((NOT (($1 == $2) OR ('a' < 'b'))) ? 'a' : $2), 'x' ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery27() {
        String query = "foreach (load 'a'){A = DISTINCT $3.$1; generate " + TestApplyFunc.class.getName() + "($2, $1.($1, $4));" + "};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery28() {
        String query = "foreach (load 'a') generate " + TestApplyFunc.class.getName() + "($2, " + TestApplyFunc.class.getName() + "($2.$3));";
        this.buildPlan(query);
    }

    @Test
    public void testQuery29() {
        String query = "load 'myfile' using " + TestStorageFunc.class.getName() + "() as (col1);";
        this.buildPlan(query);
    }

    @Test
    public void testQuery30() {
        String query = "load 'myfile' using " + TestStorageFunc.class.getName() + "() as (col1, col2);";
        this.buildPlan(query);
    }

    @Test
    public void testQuery31() {
        String query = "load 'myfile' as (col1, col2);";
        this.buildPlan(query);
    }

    @Test
    public void testQuery32() {
        String query = "foreach (load 'myfile' as (col1, col2 : tuple(sub1, sub2), col3 : tuple(bag1))) generate col1 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery33() {
        this.buildPlan("A = load 'a' as (aCol1, aCol2);");
        this.buildPlan("B = load 'b' as (bCol1, bCol2);");
        this.buildPlan("C = cogroup A by (aCol1), B by bCol1;");
        String query = "foreach C generate group, A.aCol1;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery34() {
        this.buildPlan("A = load 'a' as (aCol1, aCol2 : tuple(subCol1, subCol2));");
        this.buildPlan("A = filter A by aCol2 == '1';");
        this.buildPlan("B = load 'b' as (bCol1, bCol2);");
        String query = "foreach (cogroup A by (aCol1), B by bCol1 ) generate A.aCol2, B.bCol2 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery35() {
        String query = "foreach (load 'a' as (col1, col2)) generate col1, col2 ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery36() {
        String query = "foreach (cogroup ( load 'a' as (col1, col2)) by col1) generate $1.(col2, col1);";
        this.buildPlan(query);
    }

    @Test
    public void testQueryFail37() {
        String query = "A = load 'a'; asdasdas";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery38() {
        String query = "c = cross (load 'a'), (load 'b');";
        this.buildPlan(query);
    }

    @Test
    public void testQuery39() {
        this.buildPlan("a = load 'a' as (url, host, rank);");
        this.buildPlan("b = group a by (url,host); ");
        LogicalPlan lp = this.buildPlan("c = foreach b generate flatten(group.url), SUM(a.rank) as totalRank;");
        this.buildPlan("d = filter c by totalRank > '10';");
        this.buildPlan("e = foreach d generate totalRank;");
    }

    @Test
    public void testQueryFail39() {
        this.buildPlan("a = load 'a' as (url, host, rank);");
        this.buildPlan("b = group a by (url,host); ");
        LogicalPlan lp = this.buildPlan("c = foreach b generate flatten(group.url), SUM(a.rank) as totalRank;");
        this.buildPlan("d = filter c by totalRank > '10';");
        try {
            this.buildPlan("e = foreach d generate url;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery40() {
        this.buildPlan("a = FILTER (load 'a') BY IsEmpty($2);");
        this.buildPlan("a = FILTER (load 'a') BY (IsEmpty($2) AND ($3 == $2));");
    }

    @Test
    public void testQueryFail41() {
        this.buildPlan("a = load 'a';");
        try {
            this.buildPlan("b = a as (host,url);");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Currently PIG does not support assigning an existing relation"));
        }
    }

    @Test
    public void testQuery42() {
        this.buildPlan("a = load 'a';");
        this.buildPlan("b = foreach a generate $0 as url, $1 as rank;");
        this.buildPlan("foreach b generate url;");
    }

    @Test
    public void testQuery43() {
        this.buildPlan("a = load 'a' as (url,hitCount);");
        this.buildPlan("b = load 'a' as (url,rank);");
        this.buildPlan("c = cogroup a by url, b by url;");
        this.buildPlan("d = foreach c generate group,flatten(a),flatten(b);");
        this.buildPlan("e = foreach d generate group, a::url, b::url, b::rank, rank;");
    }

    @Test
    public void testQueryFail43() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        try {
            String query = "c = cogroup a by (name, age), b by (height);";
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery44() {
        this.buildPlan("a = load 'a' as (url, pagerank);");
        this.buildPlan("b = load 'b' as (url, query, rank);");
        this.buildPlan("c = cogroup a by (pagerank#'nonspam', url) , b by (rank/'2', url) ;");
        this.buildPlan("foreach c generate group.url;");
    }

    @Test
    public void testQueryFail44() throws Throwable {
        PigServer pig = null;
        try {
            pig = new PigServer("local");
        }
        catch (IOException e) {
            TestLogicalPlanBuilder.assertTrue((boolean)false);
        }
        pig.registerFunction("myTr", new FuncSpec(GFAny.class.getName() + "('tr o 0')"));
        try {
            pig.registerQuery("b = foreach (load 'a') generate myTr(myTr(*));");
        }
        catch (Exception e) {
            return;
        }
        TestLogicalPlanBuilder.assertTrue((boolean)false);
    }

    @Test
    public void testQuery57() {
        String query = "foreach (load 'a') generate ($1+$2), ($1-$2), ($1*$2), ($1/$2), ($1%$2), -($1) ;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery58() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        String query = "foreach b {d = a.name; generate group, d;};";
        this.buildPlan(query);
    }

    @Test
    public void testQueryFail58() {
        this.buildPlan("a = load 'a' as (url, host, rank);");
        this.buildPlan("b = group a by url; ");
        try {
            LogicalPlan lp = this.buildPlan("c = foreach b generate group.url;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery59() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        String query = "c = join a by name, b by name;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery60() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        String query = "c = cross a,b;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery61() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        String query = "c = union a,b;";
        this.buildPlan(query);
    }

    @Test
    public void testQuery62() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        String query = "c = cross a,b;";
        this.buildPlan(query);
        this.buildPlan("d = order c by b::name, height, a::gpa;");
        this.buildPlan("e = order a by name, age, gpa desc;");
        this.buildPlan("f = order a by $0 asc, age, gpa desc;");
        this.buildPlan("g = order a by * asc;");
        this.buildPlan("h = cogroup a by name, b by name;");
        this.buildPlan("i = foreach h {i1 = order a by *; generate i1;};");
    }

    @Test
    public void testQueryFail62() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        String query = "c = cross a,b;";
        this.buildPlan(query);
        try {
            this.buildPlan("d = order c by name, b::name, height, a::gpa;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery63() {
        this.buildPlan("a = load 'a' as (name, details: tuple(age, gpa));");
        this.buildPlan("b = group a by details;");
        String query = "d = foreach b generate group.age;";
        this.buildPlan(query);
        this.buildPlan("e = foreach a generate name, details;");
    }

    @Test
    public void testQueryFail63() {
        String query = "foreach (load 'myfile' as (col1, col2 : (sub1, sub2), col3 : (bag1))) generate col1 ;";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery64() {
        this.buildPlan("a = load 'a' as (name: chararray, details: tuple(age, gpa), mymap: map[]);");
        this.buildPlan("c = load 'a' as (name, details: bag{mytuple: tuple(age: int, gpa)});");
        this.buildPlan("b = group a by details;");
        String query = "d = foreach b generate group.age;";
        this.buildPlan(query);
        this.buildPlan("e = foreach a generate name, details;");
        this.buildPlan("f = LOAD 'myfile' AS (garage: bag{tuple1: tuple(num_tools: int)}, links: bag{tuple2: tuple(websites: chararray)}, page: bag{something_stupid: tuple(yeah_double: double)}, coordinates: bag{another_tuple: tuple(ok_float: float, bite_the_array: bytearray, bag_of_unknown: bag{})});");
    }

    @Test
    public void testQueryFail64() {
        String query = "foreach (load 'myfile' as (col1, col2 : bag{age: int})) generate col1 ;";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery65() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        this.buildPlan("c = cogroup a by (name, age), b by (name, height);");
        this.buildPlan("d = foreach c generate group.name, a.name as aName, b.name as b::name;");
    }

    @Test
    public void testQueryFail65() {
        this.buildPlan("a = load 'a' as (name, age, gpa);");
        this.buildPlan("b = load 'b' as (name, height);");
        this.buildPlan("c = cogroup a by (name, age), b by (name, height);");
        try {
            this.buildPlan("d = foreach c generate group.name, a.name, b.height as age, a.age;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery67() {
        this.buildPlan(" a = load 'input1' as (name, age, gpa);");
        this.buildPlan(" b = foreach a generate age, age * 10L, gpa/0.2f, {(16, 4.0e-2, 'hello')};");
    }

    @Test
    public void testQuery68() {
        this.buildPlan(" a = load 'input1';");
        this.buildPlan(" b = foreach a generate 10, {(16, 4.0e-2, 'hello'), (0.5f, 12l, 'another tuple')};");
    }

    @Test
    public void testQuery69() {
        this.buildPlan(" a = load 'input1';");
        this.buildPlan(" b = foreach a generate {(16, 4.0e-2, 'hello'), (0.5f, 'another tuple', 12L, (1))};");
    }

    @Test
    public void testQuery70() {
        this.buildPlan(" a = load 'input1';");
        this.buildPlan(" b = foreach a generate ['10'#'hello', '4.0e-2'#10L, '0.5f'#(1), 'world'#42, '42'#{('guide')}] as mymap:map[];");
        this.buildPlan(" c = foreach b generate mymap#'10';");
    }

    @Test
    public void testQueryFail67() {
        this.buildPlan(" a = load 'input1' as (name, age, gpa);");
        try {
            this.buildPlan(" b = foreach a generate age, age * 10L, gpa/0.2f, {16, 4.0e-2, 'hello'};");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQueryFail68() {
        this.buildPlan(" a = load 'input1' as (name, age, gpa);");
        try {
            this.buildPlan(" b = foreach a generate {(16 L, 4.0e-2, 'hello'), (0.5f, 'another tuple', 12L, {()})};");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery71() {
        this.buildPlan("split (load 'a') into x if $0 > '7', y if $0 < '7';");
        this.buildPlan("b = foreach x generate $0;");
        this.buildPlan("c = foreach y generate $1;");
    }

    @Test
    public void testQuery72() {
        this.buildPlan("split (load 'a') into x if $0 > '7', y if $0 < '7';");
        this.buildPlan("b = foreach x generate (int)$0;");
        this.buildPlan("c = foreach y generate (bag{})$1;");
        this.buildPlan("d = foreach y generate (int)($1/2);");
        this.buildPlan("e = foreach y generate (bag{tuple(int, float)})($1/2);");
        this.buildPlan("f = foreach x generate (tuple(int, float))($1/2);");
        this.buildPlan("g = foreach x generate (tuple())($1/2);");
        this.buildPlan("h = foreach x generate (chararray)($1/2);");
    }

    @Test
    public void testQueryFail72() {
        this.buildPlan("split (load 'a') into x if $0 > '7', y if $0 < '7';");
        try {
            this.buildPlan("c = foreach y generate (bag)$1;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
        try {
            this.buildPlan("c = foreach y generate (bag{int, float})$1;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
        try {
            this.buildPlan("c = foreach y generate (tuple)$1;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery73() {
        this.buildPlan("split (load 'a') into x if $0 > '7', y if $0 < '7';");
        this.buildPlan("b = filter x by $0 matches '^fred.*';");
        this.buildPlan("c = foreach y generate $0, ($0 matches 'yuri.*' ? $1 - 10 : $1);");
    }

    @Test
    public void testQuery74() {
        this.buildPlan("a = load 'a' as (field1: int, field2: long);");
        this.buildPlan("b = load 'a' as (field1: bytearray, field2: double);");
        this.buildPlan("c = group a by field1, b by field1;");
        this.buildPlan("d = cogroup a by ((field1+field2)*field1), b by field1;");
    }

    @Test
    public void testQuery77() {
        this.buildPlan("limit (load 'a') 100;");
    }

    @Test
    public void testLimitWithLong() {
        this.buildPlan("limit (load 'a') 100L;");
    }

    @Test
    public void testQuery75() {
        this.buildPlan("a = union (load 'a'), (load 'b'), (load 'c');");
        this.buildPlan("b = foreach a {generate $0;} parallel 10;");
    }

    @Test
    public void testQuery76() {
        this.buildPlan("split (load 'a') into x if $0 > '7', y if $0 < '7';");
        this.buildPlan("b = filter x by $0 IS NULL;");
        this.buildPlan("c = filter y by $0 IS NOT NULL;");
        this.buildPlan("d = foreach b generate $0, ($1 IS NULL ? 0 : $1 - 7);");
        this.buildPlan("e = foreach c generate $0, ($1 IS NOT NULL ? $1 - 5 : 0);");
    }

    @Test
    public void testQuery80() {
        this.buildPlan("a = load 'input1' as (name, age, gpa);");
        this.buildPlan("b = filter a by age < '20';");
        this.buildPlan("c = group b by age;");
        String query = "d = foreach c {cf = filter b by gpa < '3.0';cp = cf.gpa;cd = distinct cp;co = order cd by gpa;generate group, flatten(co);};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery81() {
        this.buildPlan("a = load 'input1' using PigStorage() as (name, age, gpa);");
        this.buildPlan("split a into b if name lt 'f', c if (name gte 'f' and name lte 'h'), d if name gt 'h';");
    }

    @Test
    public void testQueryFail81() {
        this.buildPlan("a = load 'input1' using PigStorage() as (name, age, gpa);");
        try {
            this.buildPlan("split a into b if name lt 'f', c if (name ge 'f' and name le 'h'), d if name gt 'h';");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery82() {
        this.buildPlan("a = load 'myfile';");
        this.buildPlan("b = group a by $0;");
        String query = "c = foreach b {c1 = order $1 by *;c2 = $1.$0;generate flatten(c1), c2;};";
        this.buildPlan(query);
    }

    @Test
    public void testQueryFail82() {
        this.buildPlan("a = load 'myfile';");
        this.buildPlan("b = group a by $0;");
        String query = "c = foreach b {c1 = order $1 by *;c2 = $1;generate flatten(c1), c2;};";
        try {
            this.buildPlan(query);
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Exception"));
        }
    }

    @Test
    public void testQuery83() {
        this.buildPlan("a = load 'input1' as (name, age, gpa);");
        this.buildPlan("b = filter a by age < '20';");
        this.buildPlan("c = group b by (name,age);");
        String query = "d = foreach c {cf = filter b by gpa < '3.0';cp = cf.gpa;cd = distinct cp;co = order cd by gpa;generate group, flatten(co);};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery84() {
        this.buildPlan("a = load 'input1' as (name, age, gpa);");
        this.buildPlan("b = filter a by age < '20';");
        this.buildPlan("c = group b by (name,age);");
        String query = "d = foreach c {cf = filter b by gpa < '3.0';cp = cf.$2;cd = distinct cp;co = order cd by gpa;generate group, flatten(co);};";
        this.buildPlan(query);
    }

    @Test
    public void testQuery85() throws FrontendException {
        this.buildPlan("a = load 'myfile' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = group a by (name, age);");
        LOCogroup cogroup = (LOCogroup)lp.getLeaves().get(0);
        Schema.FieldSchema nameFs = new Schema.FieldSchema("name", 50);
        Schema.FieldSchema ageFs = new Schema.FieldSchema("age", 50);
        Schema.FieldSchema gpaFs = new Schema.FieldSchema("gpa", 50);
        Schema groupSchema = new Schema(nameFs);
        groupSchema.add(ageFs);
        Schema.FieldSchema groupFs = new Schema.FieldSchema("group", groupSchema, 110);
        Schema loadSchema = new Schema(nameFs);
        loadSchema.add(ageFs);
        loadSchema.add(gpaFs);
        Schema.FieldSchema bagFs = new Schema.FieldSchema("a", loadSchema, 120);
        Schema cogroupExpectedSchema = new Schema(groupFs);
        cogroupExpectedSchema.add(bagFs);
        TestLogicalPlanBuilder.assertTrue((boolean)cogroup.getSchema().equals((Object)cogroupExpectedSchema));
        lp = this.buildPlan("c = foreach b generate group.name, group.age, COUNT(a.gpa);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema foreachExpectedSchema = new Schema(nameFs);
        foreachExpectedSchema.add(ageFs);
        foreachExpectedSchema.add(new Schema.FieldSchema(null, 15));
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)foreachExpectedSchema));
    }

    @Test
    public void testQuery86() throws FrontendException {
        this.buildPlan("a = load 'myfile' as (name:Chararray, age:Int, gpa:Float);");
        LogicalPlan lp = this.buildPlan("b = group a by (name, age);");
        LOCogroup cogroup = (LOCogroup)lp.getLeaves().get(0);
        Schema.FieldSchema nameFs = new Schema.FieldSchema("name", 55);
        Schema.FieldSchema ageFs = new Schema.FieldSchema("age", 10);
        Schema.FieldSchema gpaFs = new Schema.FieldSchema("gpa", 20);
        Schema groupSchema = new Schema(nameFs);
        groupSchema.add(ageFs);
        Schema.FieldSchema groupFs = new Schema.FieldSchema("group", groupSchema, 110);
        Schema loadSchema = new Schema(nameFs);
        loadSchema.add(ageFs);
        loadSchema.add(gpaFs);
        Schema.FieldSchema bagFs = new Schema.FieldSchema("a", loadSchema, 120);
        Schema cogroupExpectedSchema = new Schema(groupFs);
        cogroupExpectedSchema.add(bagFs);
        TestLogicalPlanBuilder.assertTrue((boolean)cogroup.getSchema().equals((Object)cogroupExpectedSchema));
    }

    @Test
    public void testQuery87() {
        this.buildPlan("a = load 'myfile';");
        this.buildPlan("b = group a by $0;");
        LogicalPlan lp = this.buildPlan("c = foreach b {c1 = order $1 by $1; generate flatten(c1); };");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalPlan nestedPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOProject sortInput = (LOProject)nestedPlan.getRoots().get(0);
        LOSort nestedSort = (LOSort)nestedPlan.getSuccessors((Operator)sortInput).get(0);
        LogicalPlan sortPlan = (LogicalPlan)nestedSort.getSortColPlans().get(0);
        TestLogicalPlanBuilder.assertTrue((sortPlan.getLeaves().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQuery88() {
        this.buildPlan("a = load 'myfile';");
        this.buildPlan("b = group a by $0;");
        LogicalPlan lp = this.buildPlan("c = order b by $1 ;");
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        LOProject project1 = (LOProject)((LogicalPlan)sort.getSortColPlans().get(0)).getLeaves().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getPredecessors((Operator)sort).get(0);
        TestLogicalPlanBuilder.assertEquals((Object)project1.getExpression(), (Object)cogroup);
    }

    @Test
    public void testQuery89() {
        this.buildPlan("a = load 'myfile';");
        this.buildPlan("b = foreach a generate $0, $100;");
        this.buildPlan("c = load 'myfile' as (i: int);");
        this.buildPlan("d = foreach c generate $0 as zero, i;");
    }

    @Test
    public void testQueryFail89() {
        this.buildPlan("c = load 'myfile' as (i: int);");
        try {
            this.buildPlan("d = foreach c generate $0, $5;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Out of bound access"));
        }
    }

    @Test
    public void testQuery90() throws FrontendException, ParseException {
        this.buildPlan("a = load 'myfile' as (name:Chararray, age:Int, gpa:Float);");
        this.buildPlan("b = group a by (name, age);");
        LogicalPlan lp = this.buildPlan("c = foreach b generate flatten(group) as (myname), COUNT(a) as mycount;");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("myname: chararray, age: int, mycount: long")));
        lp = this.buildPlan("c = foreach b generate flatten(group) as (myname, myage), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("myname: chararray, myage: int, mycount: long")));
        lp = this.buildPlan("c = foreach b generate flatten(group) as (), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("group::name: chararray, group::age: int, mycount: long")));
        lp = this.buildPlan("c = foreach b generate flatten(group) as myname, COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("myname: chararray, age: int, mycount: long")));
        lp = this.buildPlan("c = foreach b generate group as mygroup, COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("mygroup:(name: chararray, age: int), mycount: long")));
        lp = this.buildPlan("c = foreach b generate group as mygroup:(myname), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("mygroup:(myname: chararray, age: int), mycount: long")));
        lp = this.buildPlan("c = foreach b generate group as mygroup:(myname, myage), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("mygroup:(myname: chararray, myage: int), mycount: long")));
        lp = this.buildPlan("c = foreach b generate group as mygroup:(), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("mygroup:(name: chararray, age: int), mycount: long")));
        this.buildPlan("c = load 'another_file';");
        this.buildPlan("d = cogroup a by $0, c by $0;");
        lp = this.buildPlan("e = foreach d generate flatten(DIFF(a, c)) as (x, y, z), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("x: bytearray, y: bytearray, z: bytearray, mycount: long")));
        this.buildPlan("c = load 'another_file';");
        this.buildPlan("d = cogroup a by $0, c by $0;");
        lp = this.buildPlan("e = foreach d generate flatten(DIFF(a, c)) as (x: int, y: float, z), COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("x: int, y: float, z: bytearray, mycount: long")));
        this.buildPlan("c = load 'another_file';");
        this.buildPlan("d = cogroup a by $0, c by $0;");
        lp = this.buildPlan("e = foreach d generate flatten(DIFF(a, c)) as x, COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("x: bytearray, mycount: long")));
        this.buildPlan("c = load 'another_file';");
        this.buildPlan("d = cogroup a by $0, c by $0;");
        lp = this.buildPlan("e = foreach d generate flatten(DIFF(a, c)) as x: int, COUNT(a) as mycount;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)foreach.getSchema().equals((Object)Util.getSchemaFromString("x: int, mycount: long")));
    }

    @Test
    public void testQueryFail90() throws FrontendException, ParseException {
        this.buildPlan("a = load 'myfile' as (name:Chararray, age:Int, gpa:Float);");
        this.buildPlan("b = group a by (name, age);");
        try {
            this.buildPlan("c = foreach b generate group as mygroup:(myname, myage, mygpa), COUNT(a) as mycount;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Schema size mismatch"));
        }
        try {
            this.buildPlan("c = foreach b generate group as mygroup:(myname: int, myage), COUNT(a) as mycount;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
        try {
            this.buildPlan("c = foreach b generate group as mygroup:(myname, myage: chararray), COUNT(a) as mycount;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
        try {
            this.buildPlan("c = foreach b generate group as mygroup:{t: (myname, myage)}, COUNT(a) as mycount;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
        try {
            this.buildPlan("c = foreach b generate flatten(group) as (myname, myage, mygpa), COUNT(a) as mycount;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Schema size mismatch"));
        }
    }

    @Test
    public void testQuery91() {
        this.buildPlan("a = load 'myfile' as (name:Chararray, age:Int, gpa:Float);");
        this.buildPlan("b = group a by name;");
        this.buildPlan("c = foreach b generate SUM(a.age) + SUM(a.gpa);");
    }

    @Test
    public void testQuery92() {
        this.buildPlan("a = load 'myfile' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        String query = "c = foreach b {  alias = name#'alias';  af = alias#'first';  al = alias#'last';  generate SUM(a.age) + SUM(a.gpa); };";
    }

    @Test
    public void testQuery93() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        this.buildPlan("c = foreach b generate flatten(a);");
        this.buildPlan("d = foreach c generate name;");
        this.buildPlan("e = foreach d generate name;");
    }

    @Test
    public void testQueryFail93() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        this.buildPlan("c = foreach b generate flatten(a);");
        this.buildPlan("d = foreach c generate name;");
        this.buildPlan("e = foreach d generate a::name;");
    }

    @Test
    public void testQuery94() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = load 'two' as (name, age, somethingelse);");
        this.buildPlan("c = cogroup a by name, b by name;");
        this.buildPlan("d = foreach c generate flatten(a), flatten(b);");
        this.buildPlan("e = foreach d generate a::name, b::name;");
        this.buildPlan("f = foreach d generate gpa, somethingelse, a::gpa, b::somethingelse;");
    }

    @Test
    public void testQueryFail94() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = load 'two' as (name, age, somethingelse);");
        this.buildPlan("c = cogroup a by name, b by name;");
        this.buildPlan("d = foreach c generate flatten(a), flatten(b);");
        try {
            this.buildPlan("e = foreach d generate name;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Found more than one match:"));
        }
    }

    @Test
    public void testQuery95() throws FrontendException, ParseException {
        this.buildPlan("a = load 'myfile' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        LogicalPlan lp = this.buildPlan("c = foreach b {d = order a by $1; generate flatten(d), MAX(a.age) as max_age;};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getPredecessors((Operator)foreach).get(0);
        Schema.FieldSchema bagFs = new Schema.FieldSchema("a", Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray"), 120);
        Schema.FieldSchema groupFs = new Schema.FieldSchema("group", 50);
        Schema cogroupExpectedSchema = new Schema();
        cogroupExpectedSchema.add(groupFs);
        cogroupExpectedSchema.add(bagFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)cogroup.getSchema(), (Schema)cogroupExpectedSchema, (boolean)false, (boolean)false));
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray, max_age: double"), (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery96() throws FrontendException, ParseException {
        this.buildPlan("a = load 'input' as (name, age, gpa);");
        this.buildPlan("b = filter a by age < 20;");
        this.buildPlan("c = group b by age;");
        String query = "d = foreach c {cf = filter b by gpa < 3.0;cd = distinct cf.gpa;co = order cd by $0;generate group, flatten(co);};";
        LogicalPlan lp = this.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ArrayList foreachPlans = foreach.getForEachPlans();
        LogicalPlan flattenPlan = (LogicalPlan)foreachPlans.get(1);
        LogicalOperator project = (LogicalOperator)flattenPlan.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(project instanceof LOProject));
        LogicalOperator sort = (LogicalOperator)flattenPlan.getPredecessors((Operator)project).get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(sort instanceof LOSort));
        LogicalOperator distinct = (LogicalOperator)flattenPlan.getPredecessors((Operator)sort).get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(distinct instanceof LODistinct));
        LogicalOperator nestedForeach = (LogicalOperator)flattenPlan.getPredecessors((Operator)distinct).get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(nestedForeach instanceof LOForEach));
        LogicalPlan nestedForeachPlan = (LogicalPlan)((LOForEach)nestedForeach).getForEachPlans().get(0);
        LogicalOperator nestedProject = (LogicalOperator)nestedForeachPlan.getRoots().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(nestedProject instanceof LOProject));
        TestLogicalPlanBuilder.assertTrue((((LOProject)nestedProject).getCol() == 2 ? 1 : 0) != 0);
        LogicalOperator filter = (LogicalOperator)flattenPlan.getPredecessors((Operator)nestedForeach).get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(filter instanceof LOFilter));
        LogicalPlan comparisonPlan = ((LOFilter)filter).getComparisonPlan();
        LOLesserThan lessThan = (LOLesserThan)comparisonPlan.getLeaves().get(0);
        LOProject filterProject = (LOProject)lessThan.getLhsOperand();
        TestLogicalPlanBuilder.assertTrue((null == comparisonPlan.getPredecessors((Operator)filterProject) ? 1 : 0) != 0);
    }

    @Test
    public void testQuery97() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate 1;");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("x: int"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate 1L;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("x: long"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate 1.0;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("x: double"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate 1.0f;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("x: float"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate 'hello';");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("x: chararray"), (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery98() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate (1);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: int)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate (1L);");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: long)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate (1.0);");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: double)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate (1.0f);");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: float)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate ('hello');");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: chararray)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate ('hello', 1, 1L, 1.0f, 1.0);");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: chararray, y: int, z: long, a: float, b: double)"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate ('hello', {(1), (1.0)});");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("t:(x: chararray, ib:{it:(d: double)})"), (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery99() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate {(1, 'hello'), (2, 'world')};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: int, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1, 'hello'), (1L, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: long, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1, 'hello'), (1.0f, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: float, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1, 'hello'), (1.0, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: double, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1L, 'hello'), (1.0f, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: float, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1L, 'hello'), (1.0, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: double, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1.0f, 'hello'), (1.0, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: double, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1.0, 'hello'), (1.0f, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:(x: double, y: chararray)}"), (boolean)false, (boolean)true));
        lp = this.buildPlan("b = foreach a generate {(1.0, 'hello', 3.14), (1.0f, 'world')};");
        foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("b:{t:()}"), (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery101() {
        String query = "define FUNC ARITY();";
        this.buildPlan(query);
        query = "foreach (load 'data') generate FUNC($0);";
        this.buildPlan(query);
    }

    @Test
    public void testQuery102() {
        this.buildPlan("a = load 'a';");
        this.buildPlan("store a into 'out';");
    }

    @Test
    public void testQuery103() {
        this.buildPlan("a = load 'a';");
        this.buildPlan("store a into 'out' using PigStorage();");
    }

    @Test
    public void testQuery104() {
        this.buildPlan("a = load 'st10k' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        this.buildPlan("c = foreach b generate flatten(a);");
        this.buildPlan("d = filter c by name != 'fred';");
        this.buildPlan("e = group d by name;");
        this.buildPlan("f = foreach e generate flatten(d);");
        this.buildPlan("g = foreach f generate name, d::a::name, a::name;");
    }

    @Test
    public void testQuery105() {
        this.buildPlan("a = load 'st10k' as (name, age, gpa);");
        this.buildPlan("b = group a by name;");
        this.buildPlan("c = foreach b generate flatten(group), COUNT(a) as cnt;");
        this.buildPlan("d = foreach c generate group;");
    }

    @Test
    public void testQuery106() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate *;");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray"), (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery107() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one';");
        LogicalPlan lp = this.buildPlan("b = foreach a generate *;");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)this.checkPlanForProjectStar(foreachPlan));
    }

    @Test
    public void testQuery108() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = group a by *;");
        LOCogroup cogroup = (LOCogroup)lp.getLeaves().get(0);
        Schema groupSchema = Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray");
        Schema bagASchema = Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray");
        Schema.FieldSchema groupFs = new Schema.FieldSchema("group", groupSchema, 110);
        Schema.FieldSchema bagAFs = new Schema.FieldSchema("a", bagASchema, 120);
        Schema expectedSchema = new Schema(groupFs);
        expectedSchema.add(bagAFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)cogroup.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery109() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = load 'two' as (first_name, enrol_age, high_school_gpa);");
        LogicalPlan lp = this.buildPlan("c = group a by *, b by *;");
        LOCogroup cogroup = (LOCogroup)lp.getLeaves().get(0);
        Schema groupSchema = Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray");
        Schema bagASchema = Util.getSchemaFromString("name: bytearray, age: bytearray, gpa: bytearray");
        Schema bagBSchema = Util.getSchemaFromString("first_name: bytearray, enrol_age: bytearray, high_school_gpa: bytearray");
        Schema.FieldSchema groupFs = new Schema.FieldSchema("group", groupSchema, 110);
        Schema.FieldSchema bagAFs = new Schema.FieldSchema("a", bagASchema, 120);
        Schema.FieldSchema bagBFs = new Schema.FieldSchema("b", bagBSchema, 120);
        Schema expectedSchema = new Schema(groupFs);
        expectedSchema.add(bagAFs);
        expectedSchema.add(bagBFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)cogroup.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery110Fail() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = load 'two';");
        LOLoad load = (LOLoad)lp.getLeaves().get(0);
        boolean exceptionThrown = false;
        try {
            lp = this.buildPlan("c = cogroup a by $0, b by *;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Cogroup/Group by * is only allowed if the input has a schema"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testQuery111() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = order a by *;");
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        for (LogicalPlan sortPlan : sort.getSortColPlans()) {
            TestLogicalPlanBuilder.assertTrue((!this.checkPlanForProjectStar(sortPlan) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuery112() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        this.buildPlan("b = group a by *;");
        LogicalPlan lp = this.buildPlan("c = foreach b {a1 = order a by *; generate a1;};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        for (LogicalPlan foreachPlan : foreach.getForEachPlans()) {
            TestLogicalPlanBuilder.assertTrue((this.checkPlanForProjectStar(foreachPlan) ? 1 : 0) != 0);
        }
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOSort sort = (LOSort)foreachPlan.getPredecessors((Operator)foreachPlan.getLeaves().get(0)).get(0);
        for (LogicalPlan sortPlan : sort.getSortColPlans()) {
            TestLogicalPlanBuilder.assertTrue((!this.checkPlanForProjectStar(sortPlan) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuery113() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a {exp1 = age + gpa; exp2 = exp1 + age; generate exp1, exp2;};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        for (LogicalPlan foreachPlan : foreach.getForEachPlans()) {
            this.printPlan(foreachPlan);
            TestLogicalPlanBuilder.assertTrue((!this.checkPlanForProjectStar(foreachPlan) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuery114() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate " + Identity.class.getName() + "(name, age);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema s = new Schema();
        s.add(new Schema.FieldSchema("name", 50));
        s.add(new Schema.FieldSchema("age", 50));
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, s, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery115() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (name, age, gpa);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate " + Identity.class.getName() + "(*);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema s = new Schema();
        s.add(new Schema.FieldSchema("name", 50));
        s.add(new Schema.FieldSchema("age", 50));
        s.add(new Schema.FieldSchema("gpa", 50));
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, s, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery116() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one';");
        LogicalPlan lp = this.buildPlan("b = foreach a generate " + Identity.class.getName() + "($0, $1);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 50));
        s.add(new Schema.FieldSchema(null, 50));
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, s, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testQuery117() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one';");
        LogicalPlan lp = this.buildPlan("b = foreach a generate " + Identity.class.getName() + "(*);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, null, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testNullConsArithExprs() {
        this.buildPlan("a = load 'a' as (x:int, y:double);");
        this.buildPlan("b = foreach a generate x + null, x * null, x / null, x - null, null % x, y + null, y * null, y / null, y - null;");
    }

    @Test
    public void testNullConsBincond1() {
        this.buildPlan("a = load 'a' as (x:int, y:double);");
        this.buildPlan("b = foreach a generate (2 > 1? null : 1), ( 2 < 1 ? null : 1), (2 > 1 ? 1 : null), ( 2 < 1 ? 1 : null);");
    }

    @Test
    public void testNullConsBincond2() {
        this.buildPlan("a = load 'a' as (x:int, y:double);");
        this.buildPlan("b = foreach a generate (null is null ? 1 : 2), ( null is not null ? 2 : 1);");
    }

    @Test
    public void testNullConsForEachGenerate() {
        this.buildPlan("a = load 'a' as (x:int, y:double);");
        this.buildPlan("b = foreach a generate x, null, y, null;");
    }

    @Test
    public void testNullConsOuterJoin() {
        this.buildPlan("a = load 'a' as (x:int, y:chararray);");
        this.buildPlan("b = load 'b' as (u:int, v:chararray);");
        this.buildPlan("c = cogroup a by x, b by u;");
        this.buildPlan("d = foreach c generate flatten((SIZE(a) == 0 ? null : a)), flatten((SIZE(b) == 0 ? null : b));");
    }

    @Test
    public void testNullConsConcatSize() {
        this.buildPlan("a = load 'a' as (x:int, y:double, str:chararray);");
        this.buildPlan("b = foreach a generate SIZE(null), CONCAT(str, null), CONCAT(null, str);");
    }

    @Test
    public void testFilterUdfDefine() {
        this.buildPlan("define isempty IsEmpty();");
        this.buildPlan("a = load 'a' as (x:int, y:double, str:chararray);");
        this.buildPlan("b = filter a by isempty(*);");
    }

    @Test
    public void testLoadUdfDefine() {
        this.buildPlan("define PS PigStorage();");
        this.buildPlan("a = load 'a' using PS as (x:int, y:double, str:chararray);");
        this.buildPlan("b = filter a by IsEmpty(*);");
    }

    @Test
    public void testLoadUdfConstructorArgDefine() {
        this.buildPlan("define PS PigStorage(':');");
        this.buildPlan("a = load 'a' using PS as (x:int, y:double, str:chararray);");
        this.buildPlan("b = filter a by IsEmpty(*);");
    }

    @Test
    public void testStoreUdfDefine() {
        this.buildPlan("define PS PigStorage();");
        this.buildPlan("a = load 'a' using PS as (x:int, y:double, str:chararray);");
        this.buildPlan("b = filter a by IsEmpty(*);");
        this.buildPlan("store b into 'x' using PS;");
    }

    @Test
    public void testStoreUdfConstructorArgDefine() {
        this.buildPlan("define PS PigStorage(':');");
        this.buildPlan(" a = load 'a' using PS as (x:int, y:double, str:chararray);");
        this.buildPlan(" b = filter a by IsEmpty(*);");
        this.buildPlan(" store b into 'x' using PS;");
    }

    @Test
    public void testCastAlias() {
        this.buildPlan("a = load 'one.txt' as (x,y); ");
        this.buildPlan("b =  foreach a generate (int)x, (double)y;");
        this.buildPlan("c = group b by x;");
    }

    @Test
    public void testCast() {
        this.buildPlan("a = load 'one.txt' as (x,y); ");
        this.buildPlan("b = foreach a generate (int)$0, (double)$1;");
        this.buildPlan("c = group b by $0;");
    }

    @Test
    public void testReservedWordsInFunctionNames() {
        String query = "define FUNC org.apache.iterators.foreach();";
        LogicalOperator lo = (LogicalOperator)this.buildPlan(query).getRoots().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(lo instanceof LODefine));
    }

    @Test
    public void testTokenizeSchema() throws FrontendException, ParseException {
        this.buildPlan("a = load 'one' as (f1: chararray);");
        LogicalPlan lp = this.buildPlan("b = foreach a generate TOKENIZE(f1);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema tokenFs = new Schema.FieldSchema("token", 55);
        Schema tupleSchema = new Schema(tokenFs);
        Schema.FieldSchema tupleFs = new Schema.FieldSchema("tuple_of_tokens", tupleSchema, 110);
        Schema bagSchema = new Schema(tupleFs);
        bagSchema.setTwoLevelAccessRequired(true);
        Schema.FieldSchema bagFs = new Schema.FieldSchema("bag_of_tokenTuples", bagSchema, 120);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)new Schema(bagFs), (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyTupleConst() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate ();");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalOperator logOp = (LogicalOperator)((LogicalPlan)foreach.getForEachPlans().get(0)).getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(logOp instanceof LOConst));
        LOConst loConst = (LOConst)logOp;
        TestLogicalPlanBuilder.assertTrue((loConst.getType() == 110 ? 1 : 0) != 0);
        TestLogicalPlanBuilder.assertTrue((boolean)(loConst.getValue() instanceof Tuple));
        TestLogicalPlanBuilder.assertTrue((boolean)loConst.getValue().equals(TupleFactory.getInstance().newTuple()));
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, null, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyMapConst() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate [];");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalOperator logOp = (LogicalOperator)((LogicalPlan)foreach.getForEachPlans().get(0)).getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(logOp instanceof LOConst));
        LOConst loConst = (LOConst)logOp;
        TestLogicalPlanBuilder.assertTrue((loConst.getType() == 100 ? 1 : 0) != 0);
        TestLogicalPlanBuilder.assertTrue((boolean)(loConst.getValue() instanceof Map));
        TestLogicalPlanBuilder.assertTrue((boolean)loConst.getValue().equals(new HashMap()));
        Schema.FieldSchema mapFs = new Schema.FieldSchema(null, null, 100);
        Schema expectedSchema = new Schema(mapFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyBagConst() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate {};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalOperator logOp = (LogicalOperator)((LogicalPlan)foreach.getForEachPlans().get(0)).getLeaves().get(0);
        TestLogicalPlanBuilder.assertTrue((boolean)(logOp instanceof LOConst));
        LOConst loConst = (LOConst)logOp;
        TestLogicalPlanBuilder.assertTrue((loConst.getType() == 120 ? 1 : 0) != 0);
        TestLogicalPlanBuilder.assertTrue((boolean)(loConst.getValue() instanceof DataBag));
        TestLogicalPlanBuilder.assertTrue((boolean)loConst.getValue().equals(BagFactory.getInstance().newDefaultBag()));
        Schema.FieldSchema bagFs = new Schema.FieldSchema(null, null, 120);
        Schema expectedSchema = new Schema(bagFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyTupConstRecursive1() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate (());");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, null, 110);
        Schema tupleSchema = new Schema(tupleFs);
        Schema.FieldSchema tupleFs2 = new Schema.FieldSchema(null, tupleSchema, 110);
        Schema expectedSchema = new Schema(tupleFs2);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyTupConstRecursive2() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate ([]);");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema mapFs = new Schema.FieldSchema(null, null, 100);
        Schema tupleSchema = new Schema(mapFs);
        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, tupleSchema, 110);
        Schema expectedSchema = new Schema(tupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyTupConstRecursive3() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate ({});");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema bagFs = new Schema.FieldSchema(null, null, 120);
        Schema innerSchema = new Schema(bagFs);
        Schema.FieldSchema outerTupleFs = new Schema.FieldSchema(null, innerSchema, 110);
        Schema expectedSchema = new Schema(outerTupleFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testEmptyBagConstRecursive() throws FrontendException {
        LogicalPlan lp = this.buildPlan("a = foreach (load 'b') generate {()};");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        Schema.FieldSchema bagFs = new Schema.FieldSchema(null, null, 110);
        Schema bagSchema = new Schema(bagFs);
        bagSchema.setTwoLevelAccessRequired(true);
        Schema.FieldSchema outerBagFs = new Schema.FieldSchema(null, bagSchema, 120);
        Schema expectedSchema = new Schema(outerBagFs);
        TestLogicalPlanBuilder.assertTrue((boolean)Schema.equals((Schema)foreach.getSchema(), (Schema)expectedSchema, (boolean)false, (boolean)true));
    }

    @Test
    public void testRandomEmptyConst() {
        this.buildPlan("a = foreach (load 'b') generate {({})};");
        this.buildPlan("a = foreach (load 'b') generate ({()});");
        this.buildPlan("a = foreach (load 'b') generate {(),()};");
        this.buildPlan("a = foreach (load 'b') generate ({},{});");
        this.buildPlan("a = foreach (load 'b') generate ((),());");
        this.buildPlan("a = foreach (load 'b') generate ([],[]);");
        this.buildPlan("a = foreach (load 'b') generate {({},{})};");
        this.buildPlan("a = foreach (load 'b') generate {([],[])};");
        this.buildPlan("a = foreach (load 'b') generate (({},{}));");
        this.buildPlan("a = foreach (load 'b') generate (([],[]));");
    }

    @Test
    public void testLimitMultipleOutput() {
        this.buildPlan(" a = load '1.txt' as (a0:int, a1:int, a2:int);");
        this.buildPlan(" b = group a by a0;");
        this.buildPlan(" c = foreach b { c1 = limit a 10;c2 = (c1.a0/c1.a1);c3 = (c1.a0/c1.a2);generate c2, c3;};");
    }

    @Test
    public void testDuplicateSchema1() {
        try {
            LogicalPlan lp = this.buildPlan(" a = load '1.txt' as (a0:int, a0:int);");
            SchemaAliasValidator schemaAliasValidator = new SchemaAliasValidator();
            CompilationMessageCollector collector = new CompilationMessageCollector();
            schemaAliasValidator.validate(lp, collector);
        }
        catch (PlanValidationException e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getCause().getMessage().contains("Duplicate schema"));
            return;
        }
        TestLogicalPlanBuilder.fail();
    }

    @Test
    public void testDuplicateSchema2() {
        try {
            this.buildPlan(" a = load '1.txt' as (a0:int, a1:int);");
            LogicalPlan lp = this.buildPlan(" b = foreach a generate a0, a1 as a0;");
            SchemaAliasValidator schemaAliasValidator = new SchemaAliasValidator();
            CompilationMessageCollector collector = new CompilationMessageCollector();
            schemaAliasValidator.validate(lp, collector);
        }
        catch (PlanValidationException e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getCause().getMessage().contains("Duplicate schema"));
            return;
        }
        TestLogicalPlanBuilder.fail();
    }

    @Test
    public void testCogroupByStarFailure1() {
        boolean exceptionThrown = false;
        try {
            this.buildPlan(" a = load '1.txt' as (a0:int, a1:int);");
            this.buildPlan(" b = load '2.txt'; ");
            this.buildPlan("c = cogroup a by *, b by *;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Cogroup/Group by * is only allowed if the input has a schema"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertEquals((String)"An exception was expected but did not occur", (boolean)true, (boolean)exceptionThrown);
    }

    @Test
    public void testCogroupByStarFailure2() {
        boolean exceptionThrown = false;
        try {
            this.buildPlan(" a = load '1.txt' ;");
            this.buildPlan(" b = load '2.txt' as (b0:int, b1:int); ");
            this.buildPlan("c = cogroup a by *, b by *;");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Cogroup/Group by * is only allowed if the input has a schema"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertEquals((String)"An exception was expected but did not occur", (boolean)true, (boolean)exceptionThrown);
    }

    @Test
    public void testCogroupByIncompatibleSchemaFailure() {
        boolean exceptionThrown = false;
        try {
            this.buildPlan(" a = load '1.txt' as (a0:int, a1:int);");
            this.buildPlan(" b = load '2.txt' as (a0:int, a1:chararray); ");
            this.buildPlan("c = cogroup a by (a0,a1), b by (a0,a1);");
        }
        catch (AssertionFailedError e) {
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("Cogroup column"));
            TestLogicalPlanBuilder.assertTrue((boolean)e.getMessage().contains("has incompatible types"));
            exceptionThrown = true;
        }
        TestLogicalPlanBuilder.assertEquals((String)"An exception was expected but did not occur", (boolean)true, (boolean)exceptionThrown);
    }

    private void printPlan(LogicalPlan lp) {
        LOPrinter graphPrinter = new LOPrinter(System.err, lp);
        System.err.println("Printing the logical plan");
        try {
            graphPrinter.visit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        System.err.println();
    }

    private boolean checkPlanForProjectStar(LogicalPlan lp) {
        List leaves = lp.getLeaves();
        for (LogicalOperator op : leaves) {
            if (!(op instanceof LOProject) || !((LOProject)op).isStar()) continue;
            return true;
        }
        return false;
    }

    public LogicalPlan buildPlan(String query) {
        return this.buildPlan(query, LogicalPlanBuilder.class.getClassLoader());
    }

    public LogicalPlan buildPlan(String query, ClassLoader cldr) {
        LogicalPlanBuilder.classloader = cldr;
        try {
            this.pigContext.connect();
            LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pigContext);
            LogicalPlan lp = builder.parse("Test-Plan-Builder", query, this.aliases, this.logicalOpTable, this.aliasOp, this.fileNameMap);
            List roots = lp.getRoots();
            if (roots.size() > 0) {
                for (LogicalOperator op : roots) {
                    if (op instanceof LOLoad || op instanceof LODefine) continue;
                    throw new Exception("Cannot have a root that is not the load or define operator. Found " + op.getClass().getName());
                }
            }
            TestLogicalPlanBuilder.assertNotNull((Object)(lp != null ? 1 : 0));
            return lp;
        }
        catch (IOException e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestLogicalPlanBuilder.fail((String)("IOException: " + (pe == null ? e.getMessage() : pe.getMessage())));
        }
        catch (Exception e) {
            this.log.error((Object)e);
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestLogicalPlanBuilder.fail((String)(e.getClass().getName() + ": " + (pe == null ? e.getMessage() : pe.getMessage()) + " -- " + query));
        }
        return null;
    }

    public static class TestStorageFunc
    extends LoadFunc {
        public Tuple getNext() throws IOException {
            return null;
        }

        public InputFormat getInputFormat() throws IOException {
            return null;
        }

        public LoadCaster getLoadCaster() throws IOException {
            return null;
        }

        public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        }

        public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
            return null;
        }

        public void setLocation(String location, Job job) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestApplyFunc
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            Tuple output = TupleFactory.getInstance().newTuple(input.getAll());
            return output;
        }
    }
}

