/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompilerException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.builtin.AVG;
import org.apache.pig.builtin.COUNT;
import org.apache.pig.builtin.SUM;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFCross;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.test.PigStorageNoDefCtor;
import org.apache.pig.test.TestMergeJoin;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMRCompiler
extends TestCase {
    static PigContext pc = new PigContext();
    static final int MAX_SIZE = 100000;
    static final long SEED = 1013L;
    static Random r;
    LogicalPlanTester planTester = new LogicalPlanTester();
    private boolean generate = false;

    @Before
    public void setUp() throws ExecException {
        GenPhyOp.setR(r);
        GenPhyOp.setPc(pc);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testRun1() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan part1 = new PhysicalPlan();
        POLoad lC = GenPhyOp.topLoadOp();
        POFilter fC = GenPhyOp.topFilterOp();
        fC.setRequestedParallelism(20);
        POLocalRearrange lrC = GenPhyOp.topLocalRearrangeOp();
        lrC.setRequestedParallelism(10);
        POGlobalRearrange grC = GenPhyOp.topGlobalRearrangeOp();
        POPackage pkC = GenPhyOp.topPackageOp();
        part1.add((Operator)lC);
        part1.add((Operator)fC);
        part1.connect((PhysicalOperator)lC, (PhysicalOperator)fC);
        part1.add((Operator)lrC);
        part1.connect((PhysicalOperator)fC, (PhysicalOperator)lrC);
        part1.add((Operator)grC);
        part1.connect((PhysicalOperator)lrC, (PhysicalOperator)grC);
        part1.add((Operator)pkC);
        part1.connect((PhysicalOperator)grC, (PhysicalOperator)pkC);
        POPackage pkD = GenPhyOp.topPackageOp();
        pkD.setRequestedParallelism(20);
        POLocalRearrange lrD = GenPhyOp.topLocalRearrangeOp();
        lrD.setRequestedParallelism(30);
        POGlobalRearrange grD = GenPhyOp.topGlobalRearrangeOp();
        POLoad lD = GenPhyOp.topLoadOp();
        part1.add((Operator)lD);
        part1.add((Operator)lrD);
        part1.connect((PhysicalOperator)lD, (PhysicalOperator)lrD);
        part1.add((Operator)grD);
        part1.connect((PhysicalOperator)lrD, (PhysicalOperator)grD);
        part1.add((Operator)pkD);
        part1.connect((PhysicalOperator)grD, (PhysicalOperator)pkD);
        POPackage pkCD = GenPhyOp.topPackageOp();
        POLocalRearrange lrCD1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lrCD2 = GenPhyOp.topLocalRearrangeOp();
        POGlobalRearrange grCD = GenPhyOp.topGlobalRearrangeOp();
        part1.add((Operator)lrCD1);
        part1.add((Operator)lrCD2);
        part1.connect((PhysicalOperator)pkC, (PhysicalOperator)lrCD1);
        part1.connect((PhysicalOperator)pkD, (PhysicalOperator)lrCD2);
        part1.add((Operator)grCD);
        part1.connect((PhysicalOperator)lrCD1, (PhysicalOperator)grCD);
        part1.connect((PhysicalOperator)lrCD2, (PhysicalOperator)grCD);
        part1.add((Operator)pkCD);
        part1.connect((PhysicalOperator)grCD, (PhysicalOperator)pkCD);
        POLoad lA = GenPhyOp.topLoadOp();
        POLoad lB = GenPhyOp.topLoadOp();
        POFilter fA = GenPhyOp.topFilterOp();
        POLocalRearrange lrA = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lrB = GenPhyOp.topLocalRearrangeOp();
        POGlobalRearrange grAB = GenPhyOp.topGlobalRearrangeOp();
        POPackage pkAB = GenPhyOp.topPackageOp();
        POFilter fAB = GenPhyOp.topFilterOp();
        POUnion unABC = GenPhyOp.topUnionOp();
        php.add((Operator)lA);
        php.add((Operator)lB);
        php.add((Operator)fA);
        php.connect((PhysicalOperator)lA, (PhysicalOperator)fA);
        php.add((Operator)lrA);
        php.add((Operator)lrB);
        php.connect((PhysicalOperator)fA, (PhysicalOperator)lrA);
        php.connect((PhysicalOperator)lB, (PhysicalOperator)lrB);
        php.add((Operator)grAB);
        php.connect((PhysicalOperator)lrA, (PhysicalOperator)grAB);
        php.connect((PhysicalOperator)lrB, (PhysicalOperator)grAB);
        php.add((Operator)pkAB);
        php.connect((PhysicalOperator)grAB, (PhysicalOperator)pkAB);
        php.add((Operator)fAB);
        php.connect((PhysicalOperator)pkAB, (PhysicalOperator)fAB);
        php.merge((OperatorPlan)part1);
        ArrayList<PhysicalOperator> leaves = new ArrayList<PhysicalOperator>();
        for (PhysicalOperator phyOp : php.getLeaves()) {
            leaves.add(phyOp);
        }
        php.add((Operator)unABC);
        for (PhysicalOperator physicalOperator : leaves) {
            php.connect(physicalOperator, (PhysicalOperator)unABC);
        }
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)unABC, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC10.gld");
    }

    public void testRun2() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan part1 = new PhysicalPlan();
        POLoad lC = GenPhyOp.topLoadOp();
        POFilter fC = GenPhyOp.topFilterOp();
        POLocalRearrange lrC = GenPhyOp.topLocalRearrangeOp();
        POGlobalRearrange grC = GenPhyOp.topGlobalRearrangeOp();
        POPackage pkC = GenPhyOp.topPackageOp();
        part1.add((Operator)lC);
        part1.add((Operator)fC);
        part1.connect((PhysicalOperator)lC, (PhysicalOperator)fC);
        part1.add((Operator)lrC);
        part1.connect((PhysicalOperator)fC, (PhysicalOperator)lrC);
        part1.add((Operator)grC);
        part1.connect((PhysicalOperator)lrC, (PhysicalOperator)grC);
        part1.add((Operator)pkC);
        part1.connect((PhysicalOperator)grC, (PhysicalOperator)pkC);
        POPackage pkD = GenPhyOp.topPackageOp();
        POLocalRearrange lrD = GenPhyOp.topLocalRearrangeOp();
        POGlobalRearrange grD = GenPhyOp.topGlobalRearrangeOp();
        POLoad lD = GenPhyOp.topLoadOp();
        part1.add((Operator)lD);
        part1.add((Operator)lrD);
        part1.connect((PhysicalOperator)lD, (PhysicalOperator)lrD);
        part1.add((Operator)grD);
        part1.connect((PhysicalOperator)lrD, (PhysicalOperator)grD);
        part1.add((Operator)pkD);
        part1.connect((PhysicalOperator)grD, (PhysicalOperator)pkD);
        part1.connect((PhysicalOperator)pkD, (PhysicalOperator)grC);
        POLoad lA = GenPhyOp.topLoadOp();
        POLoad lB = GenPhyOp.topLoadOp();
        POFilter fA = GenPhyOp.topFilterOp();
        POLocalRearrange lrA = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lrB = GenPhyOp.topLocalRearrangeOp();
        POGlobalRearrange grAB = GenPhyOp.topGlobalRearrangeOp();
        POPackage pkAB = GenPhyOp.topPackageOp();
        POFilter fAB = GenPhyOp.topFilterOp();
        POUnion unABC = GenPhyOp.topUnionOp();
        php.add((Operator)lA);
        php.add((Operator)lB);
        php.add((Operator)fA);
        php.connect((PhysicalOperator)lA, (PhysicalOperator)fA);
        php.add((Operator)lrA);
        php.add((Operator)lrB);
        php.connect((PhysicalOperator)fA, (PhysicalOperator)lrA);
        php.connect((PhysicalOperator)lB, (PhysicalOperator)lrB);
        php.add((Operator)grAB);
        php.connect((PhysicalOperator)lrA, (PhysicalOperator)grAB);
        php.connect((PhysicalOperator)lrB, (PhysicalOperator)grAB);
        php.add((Operator)pkAB);
        php.connect((PhysicalOperator)grAB, (PhysicalOperator)pkAB);
        php.add((Operator)fAB);
        php.connect((PhysicalOperator)pkAB, (PhysicalOperator)fAB);
        php.merge((OperatorPlan)part1);
        ArrayList<PhysicalOperator> leaves = new ArrayList<PhysicalOperator>();
        for (PhysicalOperator phyOp : php.getLeaves()) {
            leaves.add(phyOp);
        }
        php.add((Operator)unABC);
        for (PhysicalOperator physicalOperator : leaves) {
            php.connect(physicalOperator, (PhysicalOperator)unABC);
        }
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)unABC, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC11.gld");
    }

    public void testSpl1() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POLoad lA = GenPhyOp.topLoadOp();
        POSplit spl = GenPhyOp.topSplitOp();
        php.add((Operator)lA);
        php.add((Operator)spl);
        php.connect((PhysicalOperator)lA, (PhysicalOperator)spl);
        POFilter fl1 = GenPhyOp.topFilterOp();
        POFilter fl2 = GenPhyOp.topFilterOp();
        php.add((Operator)fl1);
        php.add((Operator)fl2);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl1);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl2);
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lr2 = GenPhyOp.topLocalRearrangeOp();
        php.add((Operator)lr1);
        php.add((Operator)lr2);
        php.connect((PhysicalOperator)fl1, (PhysicalOperator)lr1);
        php.connect((PhysicalOperator)fl2, (PhysicalOperator)lr2);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.add((Operator)gr);
        php.connect((PhysicalOperator)lr1, (PhysicalOperator)gr);
        php.connect((PhysicalOperator)lr2, (PhysicalOperator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.add((Operator)pk);
        php.connect((PhysicalOperator)gr, (PhysicalOperator)pk);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)pk, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC12.gld");
    }

    public void testSpl2() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POLoad lA = GenPhyOp.topLoadOp();
        POSplit spl = GenPhyOp.topSplitOp();
        php.add((Operator)lA);
        php.add((Operator)spl);
        php.connect((PhysicalOperator)lA, (PhysicalOperator)spl);
        POFilter fl1 = GenPhyOp.topFilterOp();
        POFilter fl2 = GenPhyOp.topFilterOp();
        php.add((Operator)fl1);
        php.add((Operator)fl2);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl1);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl2);
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lr2 = GenPhyOp.topLocalRearrangeOp();
        php.add((Operator)lr1);
        php.add((Operator)lr2);
        php.connect((PhysicalOperator)fl1, (PhysicalOperator)lr1);
        php.connect((PhysicalOperator)fl2, (PhysicalOperator)lr2);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.addAsLeaf((Operator)pk);
        POSplit sp2 = GenPhyOp.topSplitOp();
        php.addAsLeaf((Operator)sp2);
        POFilter fl3 = GenPhyOp.topFilterOp();
        POFilter fl4 = GenPhyOp.topFilterOp();
        php.add((Operator)fl3);
        php.add((Operator)fl4);
        php.connect((PhysicalOperator)sp2, (PhysicalOperator)fl3);
        php.connect((PhysicalOperator)sp2, (PhysicalOperator)fl4);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC13.gld");
    }

    public void testSpl3() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POLoad lA = GenPhyOp.topLoadOp();
        POSplit spl = GenPhyOp.topSplitOp();
        php.add((Operator)lA);
        php.add((Operator)spl);
        php.connect((PhysicalOperator)lA, (PhysicalOperator)spl);
        POFilter fl1 = GenPhyOp.topFilterOp();
        fl1.setRequestedParallelism(10);
        POFilter fl2 = GenPhyOp.topFilterOp();
        fl2.setRequestedParallelism(20);
        php.add((Operator)fl1);
        php.add((Operator)fl2);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl1);
        php.connect((PhysicalOperator)spl, (PhysicalOperator)fl2);
        POSplit sp11 = GenPhyOp.topSplitOp();
        POSplit sp21 = GenPhyOp.topSplitOp();
        php.add((Operator)sp11);
        php.add((Operator)sp21);
        php.connect((PhysicalOperator)fl1, (PhysicalOperator)sp11);
        php.connect((PhysicalOperator)fl2, (PhysicalOperator)sp21);
        POFilter fl11 = GenPhyOp.topFilterOp();
        fl11.setRequestedParallelism(10);
        POFilter fl21 = GenPhyOp.topFilterOp();
        fl21.setRequestedParallelism(20);
        POFilter fl22 = GenPhyOp.topFilterOp();
        fl22.setRequestedParallelism(30);
        php.add((Operator)fl11);
        php.add((Operator)fl21);
        php.add((Operator)fl22);
        php.connect((PhysicalOperator)sp11, (PhysicalOperator)fl11);
        php.connect((PhysicalOperator)sp21, (PhysicalOperator)fl21);
        php.connect((PhysicalOperator)sp21, (PhysicalOperator)fl22);
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        lr1.setRequestedParallelism(40);
        POLocalRearrange lr21 = GenPhyOp.topLocalRearrangeOp();
        lr21.setRequestedParallelism(15);
        POLocalRearrange lr22 = GenPhyOp.topLocalRearrangeOp();
        lr22.setRequestedParallelism(35);
        php.add((Operator)lr1);
        php.add((Operator)lr21);
        php.add((Operator)lr22);
        php.connect((PhysicalOperator)fl11, (PhysicalOperator)lr1);
        php.connect((PhysicalOperator)fl21, (PhysicalOperator)lr21);
        php.connect((PhysicalOperator)fl22, (PhysicalOperator)lr22);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        pk.setRequestedParallelism(25);
        php.addAsLeaf((Operator)pk);
        POSplit sp2 = GenPhyOp.topSplitOp();
        php.addAsLeaf((Operator)sp2);
        POFilter fl3 = GenPhyOp.topFilterOp();
        fl3.setRequestedParallelism(100);
        POFilter fl4 = GenPhyOp.topFilterOp();
        fl4.setRequestedParallelism(80);
        php.add((Operator)fl3);
        php.add((Operator)fl4);
        php.connect((PhysicalOperator)sp2, (PhysicalOperator)fl3);
        php.connect((PhysicalOperator)sp2, (PhysicalOperator)fl4);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC14.gld");
    }

    public void testSim1() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POLoad ld = GenPhyOp.topLoadOp();
        php.add((Operator)ld);
        PhysicalPlan grpChain1 = GenPhyOp.grpChain();
        php.merge((OperatorPlan)grpChain1);
        php.connect((PhysicalOperator)ld, (PhysicalOperator)grpChain1.getRoots().get(0));
        PhysicalOperator leaf = (PhysicalOperator)php.getLeaves().get(0);
        PhysicalPlan grpChain2 = GenPhyOp.grpChain();
        php.merge((OperatorPlan)grpChain2);
        php.connect(leaf, (PhysicalOperator)grpChain2.getRoots().get(0));
        leaf = (PhysicalOperator)php.getLeaves().get(0);
        POFilter fl = GenPhyOp.topFilterOp();
        php.add((Operator)fl);
        php.connect(leaf, (PhysicalOperator)fl);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)fl, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC1.gld");
    }

    public void testSim2() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)un, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC2.gld");
    }

    public void testSim3() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)un, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC3.gld");
    }

    public void intTestSim4() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        PhysicalPlan ldFil2 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)un);
        php.merge((OperatorPlan)ldFil2);
        php.connect((PhysicalOperator)ldFil2.getLeaves().get(0), (PhysicalOperator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)un, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC4.gld");
    }

    public void testSim5() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        PhysicalPlan ldFil2 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.merge((OperatorPlan)ldFil2);
        POUnion un = GenPhyOp.topUnionOp();
        php.addAsLeaf((Operator)un);
        POStore st = GenPhyOp.topStoreOp();
        php.add((Operator)st);
        php.connect((PhysicalOperator)un, (PhysicalOperator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC5.gld");
    }

    public void testSim6() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lr2 = GenPhyOp.topLocalRearrangeOp();
        ldGrpChain1.addAsLeaf((Operator)lr1);
        ldGrpChain2.addAsLeaf((Operator)lr2);
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.addAsLeaf((Operator)pk);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC6.gld");
    }

    public void testSim7() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lr2 = GenPhyOp.topLocalRearrangeOp();
        ldGrpChain1.addAsLeaf((Operator)lr1);
        ldGrpChain2.addAsLeaf((Operator)lr2);
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.addAsLeaf((Operator)pk);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC7.gld");
    }

    public void testSim8() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldGrpChain1 = GenPhyOp.loadedGrpChain();
        PhysicalPlan ldGrpChain2 = GenPhyOp.loadedGrpChain();
        POLocalRearrange lr1 = GenPhyOp.topLocalRearrangeOp();
        POLocalRearrange lr2 = GenPhyOp.topLocalRearrangeOp();
        ldGrpChain1.addAsLeaf((Operator)lr1);
        ldGrpChain2.addAsLeaf((Operator)lr2);
        php.merge((OperatorPlan)ldGrpChain1);
        php.merge((OperatorPlan)ldGrpChain2);
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        PhysicalPlan ldFil2 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)gr);
        php.merge((OperatorPlan)ldFil2);
        php.connect((PhysicalOperator)ldFil2.getLeaves().get(0), (PhysicalOperator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.addAsLeaf((Operator)pk);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC8.gld");
    }

    public void testSim9() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POGlobalRearrange gr = GenPhyOp.topGlobalRearrangeOp();
        php.addAsLeaf((Operator)gr);
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        PhysicalPlan ldFil2 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)gr);
        php.merge((OperatorPlan)ldFil2);
        php.connect((PhysicalOperator)ldFil2.getLeaves().get(0), (PhysicalOperator)gr);
        POPackage pk = GenPhyOp.topPackageOp();
        php.addAsLeaf((Operator)pk);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC9.gld");
    }

    public void testSortUDF1() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        String funcName = WeirdComparator.class.getName();
        POUserComparisonFunc comparator = new POUserComparisonFunc(new OperatorKey("", r.nextLong()), -1, null, new FuncSpec(funcName));
        POSort sort = new POSort(new OperatorKey("", r.nextLong()), -1, ldFil1.getLeaves(), null, new ArrayList(), comparator);
        sort.setRequestedParallelism(20);
        PhysicalPlan nesSortPlan = new PhysicalPlan();
        POProject topPrj = new POProject(new OperatorKey("", r.nextLong()));
        topPrj.setColumn(1);
        topPrj.setOverloaded(true);
        topPrj.setResultType((byte)110);
        nesSortPlan.add((Operator)topPrj);
        POProject prjStar2 = new POProject(new OperatorKey("", r.nextLong()));
        prjStar2.setResultType((byte)110);
        prjStar2.setStar(true);
        nesSortPlan.add((Operator)prjStar2);
        nesSortPlan.connect((PhysicalOperator)topPrj, (PhysicalOperator)prjStar2);
        ArrayList<PhysicalPlan> nesSortPlanLst = new ArrayList<PhysicalPlan>();
        nesSortPlanLst.add(nesSortPlan);
        sort.setSortPlans(nesSortPlanLst);
        php.add((Operator)sort);
        php.connect((PhysicalOperator)ldFil1.getLeaves().get(0), (PhysicalOperator)sort);
        ArrayList<String> udfs = new ArrayList<String>();
        udfs.add(COUNT.class.getName());
        udfs.add(SUM.class.getName());
        POForEach fe3 = GenPhyOp.topForEachOPWithUDF(udfs);
        php.add((Operator)fe3);
        php.connect((PhysicalOperator)sort, (PhysicalOperator)fe3);
        PhysicalPlan grpChain1 = GenPhyOp.grpChain();
        php.merge((OperatorPlan)grpChain1);
        php.connect((PhysicalOperator)fe3, (PhysicalOperator)grpChain1.getRoots().get(0));
        udfs.clear();
        udfs.add(AVG.class.getName());
        POForEach fe4 = GenPhyOp.topForEachOPWithUDF(udfs);
        php.addAsLeaf((Operator)fe4);
        PhysicalPlan grpChain2 = GenPhyOp.grpChain();
        php.merge((OperatorPlan)grpChain2);
        php.connect((PhysicalOperator)fe4, (PhysicalOperator)grpChain2.getRoots().get(0));
        udfs.clear();
        udfs.add(GFCross.class.getName());
        POForEach fe5 = GenPhyOp.topForEachOPWithUDF(udfs);
        php.addAsLeaf((Operator)fe5);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC15.gld");
    }

    public void testDistinct1() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        php.merge((OperatorPlan)ldFil1);
        PODistinct op = new PODistinct(new OperatorKey("", r.nextLong()), -1, null);
        php.addAsLeaf((Operator)op);
        PhysicalPlan grpChain1 = GenPhyOp.grpChain();
        php.merge((OperatorPlan)grpChain1);
        php.connect((PhysicalOperator)op, (PhysicalOperator)grpChain1.getRoots().get(0));
        PODistinct op1 = new PODistinct(new OperatorKey("", r.nextLong()), -1, null);
        php.addAsLeaf((Operator)op1);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC16.gld");
    }

    public void testLimit() throws Exception {
        PhysicalPlan php = new PhysicalPlan();
        POLoad lC = GenPhyOp.topLoadOp();
        php.add((Operator)lC);
        POLimit op = new POLimit(new OperatorKey("", r.nextLong()), -1, null);
        php.add((Operator)op);
        php.connect((PhysicalOperator)lC, (PhysicalOperator)op);
        POStore st = GenPhyOp.topStoreOp();
        php.addAsLeaf((Operator)st);
        this.run(php, "test/org/apache/pig/test/data/GoldenFiles/MRC17.gld");
    }

    @Test
    public void testMRCompilerErr() throws Exception {
        this.planTester.buildPlan("a = load 'input';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $0 > 5;");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        pp.remove((PhysicalOperator)pp.getRoots().get(0));
        try {
            Util.buildMRPlan(new PhysicalPlan(), pc);
            TestMRCompiler.fail((String)"Expected failure.");
        }
        catch (MRCompilerException mrce) {
            TestMRCompiler.assertTrue((mrce.getErrorCode() == 2053 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMRCompilerErr1() throws Exception {
        PhysicalPlan pp = new PhysicalPlan();
        PhysicalPlan ldFil1 = GenPhyOp.loadedFilter();
        pp.merge((OperatorPlan)ldFil1);
        POSplit op = GenPhyOp.topSplitOp();
        pp.addAsLeaf((Operator)op);
        try {
            Util.buildMRPlan(pp, pc);
            TestMRCompiler.fail((String)"Expected failure.");
        }
        catch (MRCompilerException mrce) {
            TestMRCompiler.assertTrue((mrce.getErrorCode() == 2025 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNumReducersInLimit() throws Exception {
        this.planTester.buildPlan("a = load 'input';");
        this.planTester.buildPlan("b = order a by $0;");
        this.planTester.buildPlan("c = limit b 10;");
        LogicalPlan lp = this.planTester.buildPlan("store c into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        int count = 1;
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        TestMRCompiler.assertTrue((count == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testNumReducersInLimitWithParallel() throws Exception {
        this.planTester.buildPlan("a = load 'input';");
        this.planTester.buildPlan("b = order a by $0 parallel 2;");
        this.planTester.buildPlan("c = limit b 10;");
        LogicalPlan lp = this.planTester.buildPlan("store c into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        int count = 1;
        while (mrPlan.getSuccessors((Operator)mrOper) != null) {
            mrOper = (MapReduceOper)mrPlan.getSuccessors((Operator)mrOper).get(0);
            ++count;
        }
        TestMRCompiler.assertTrue((count == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testUDFInJoin() throws Exception {
        this.planTester.buildPlan("a = load 'input1' using BinStorage();");
        this.planTester.buildPlan("b = load 'input2';");
        this.planTester.buildPlan("c = join a by $0, b by $0;");
        LogicalPlan lp = this.planTester.buildPlan("store c into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        MapReduceOper mrOper = (MapReduceOper)mrPlan.getRoots().get(0);
        TestMRCompiler.assertTrue((mrOper.UDFs.size() == 2 ? 1 : 0) != 0);
        TestMRCompiler.assertTrue((mrOper.UDFs.size() == 2 ? 1 : 0) != 0);
        TestMRCompiler.assertTrue((boolean)mrOper.UDFs.contains("BinStorage"));
        TestMRCompiler.assertTrue((boolean)mrOper.UDFs.contains("org.apache.pig.builtin.PigStorage"));
    }

    @Test
    public void testMergeJoin() throws Exception {
        this.planTester.buildPlan("a = load '/tmp/input1';");
        this.planTester.buildPlan("b = load '/tmp/input2';");
        this.planTester.buildPlan("c = join a by $0, b by $0 using \"merge\";");
        LogicalPlan lp = this.planTester.buildPlan("store c into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        this.run(pp, "test/org/apache/pig/test/data/GoldenFiles/MRC18.gld");
    }

    @Test
    public void testMergeJoinWithIndexableLoadFunc() throws Exception {
        this.planTester.buildPlan("a = load '/tmp/input1';");
        this.planTester.buildPlan("b = load '/tmp/input2' using " + TestMergeJoin.DummyIndexableLoader.class.getName() + ";");
        this.planTester.buildPlan("c = join a by $0, b by $0 using \"merge\";");
        LogicalPlan lp = this.planTester.buildPlan("store c into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mp = Util.buildMRPlan(pp, pc);
        TestMRCompiler.assertEquals((String)"Checking number of MR Jobs for merge join with IndexableLoadFunc:", (int)1, (int)mp.size());
    }

    @Test
    public void testCastFuncShipped() throws Exception {
        this.planTester.buildPlan("a = load '/tmp/input1' using " + PigStorageNoDefCtor.class.getName() + "('\t') as (a0, a1, a2);");
        this.planTester.buildPlan("b = group a by a0;");
        this.planTester.buildPlan("c = foreach b generate flatten(a);");
        this.planTester.buildPlan("d = order c by a0;");
        this.planTester.buildPlan("e = foreach d generate a1+a2;");
        LogicalPlan lp = this.planTester.buildPlan("store e into '/tmp';");
        this.planTester.typeCheckPlan(lp);
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mp = Util.buildMRPlan(pp, pc);
        MapReduceOper op = (MapReduceOper)mp.getLeaves().get(0);
        TestMRCompiler.assertTrue((boolean)op.UDFs.contains(new FuncSpec(PigStorageNoDefCtor.class.getName()) + "('\t')"));
    }

    private void run(PhysicalPlan pp, String expectedFile) throws Exception {
        String goldenPlan = null;
        int MAX_SIZE = 100000;
        MRCompiler comp = new MRCompiler(pp, pc);
        comp.compile();
        MROperPlan mrp = comp.getMRPlan();
        PlanPrinter ppp = new PlanPrinter((OperatorPlan)mrp);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ppp.print((OutputStream)baos);
        String compiledPlan = baos.toString();
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream(expectedFile);
            fos.write(baos.toByteArray());
            return;
        }
        byte[] b = new byte[MAX_SIZE];
        FileInputStream fis = new FileInputStream(expectedFile);
        int len = fis.read(b);
        goldenPlan = new String(b, 0, len);
        if (goldenPlan.charAt(len - 1) == '\n') {
            goldenPlan = goldenPlan.substring(0, len - 1);
        }
        pp.explain((OutputStream)System.out);
        System.out.println();
        System.out.println("<<<" + compiledPlan + ">>>");
        System.out.println("-------------");
        System.out.println("Golden");
        System.out.println("<<<" + goldenPlan + ">>>");
        System.out.println("-------------");
        TestMRCompiler.assertEquals((String)goldenPlan, (String)compiledPlan);
    }

    static {
        try {
            pc.connect();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
        r = new Random(1013L);
    }

    public static class WeirdComparator
    extends ComparisonFunc {
        public int compare(Tuple t1, Tuple t2) {
            int result = 0;
            try {
                int i1 = (Integer)t1.get(1);
                int i2 = (Integer)t2.get(1);
                result = (i1 - 50) * (i1 - 50) - (i2 - 50) * (i2 - 50);
            }
            catch (ExecException e) {
                e.printStackTrace();
            }
            return result;
        }
    }
}

