/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

public class TestMapReduce2
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());

    @Test
    public void testUnion1() throws Exception {
        File tmpFile1 = this.genDataSetFile(false, 30);
        File tmpFile2 = this.genDataSetFile(false, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("c = union a, b; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion1WithNulls() throws Exception {
        File tmpFile1 = this.genDataSetFile(true, 30);
        File tmpFile2 = this.genDataSetFile(true, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("c = union a, b; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion2() throws Exception {
        File tmpFile1 = this.genDataSetFile(false, 30);
        File tmpFile2 = this.genDataSetFile(false, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("a1 = foreach a generate $0, $1; ");
        this.pig.registerQuery("b1 = foreach b generate $0, $1; ");
        this.pig.registerQuery("c = union a1, b1; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion2WithNulls() throws Exception {
        File tmpFile1 = this.genDataSetFile(true, 30);
        File tmpFile2 = this.genDataSetFile(true, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("a1 = foreach a generate $0, $1; ");
        this.pig.registerQuery("b1 = foreach b generate $0, $1; ");
        this.pig.registerQuery("c = union a1, b1; ");
        this.verifyUnion("c", 80);
    }

    public void verifyUnion(String id, int actualCount) throws Exception {
        Iterator it = this.pig.openIterator(id);
        Tuple t = null;
        int count = 0;
        while (it.hasNext()) {
            t = (Tuple)it.next();
            System.out.println(count + ":" + t);
            ++count;
        }
        Assert.assertEquals((int)count, (int)actualCount);
    }

    private File genDataSetFile(boolean hasNulls, int dataLength) throws IOException {
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        if (hasNulls) {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                if (i % 7 == 0) {
                    data[i][0] = "";
                    data[i][1] = formatter.format(dataLength - i);
                    continue;
                }
                if (i % 10 == 0) {
                    data[i][0] = formatter.format(i % 10);
                    data[i][1] = "";
                    continue;
                }
                if (i % 13 == 0) {
                    data[i][0] = "";
                    data[i][1] = "";
                    continue;
                }
                data[i][0] = formatter.format(i % 10);
                data[i][1] = formatter.format(dataLength - i);
            }
        } else {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                data[i][0] = formatter.format(i % 10);
                data[i][1] = formatter.format(dataLength - i);
            }
        }
        return TestHelper.createTempFile(data);
    }
}

