/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.ExecType;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMergeJoin {
    private static final String INPUT_FILE = "testMergeJoinInput.txt";
    private static final String INPUT_FILE2 = "testMergeJoinInput2.txt";
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();

    public TestMergeJoin() throws ExecException, IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Before
    public void setUp() throws Exception {
        int LOOP_SIZE = 3;
        String[] input = new String[LOOP_SIZE * LOOP_SIZE];
        int k = 0;
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            String si = i + "";
            for (int j = 1; j <= LOOP_SIZE; ++j) {
                input[k++] = si + "\t" + j;
            }
        }
        Util.createInputFile(this.cluster, INPUT_FILE, input);
        Util.createInputFile(this.cluster, INPUT_FILE2, new String[]{"2"});
    }

    @After
    public void tearDown() throws Exception {
        Util.deleteFile(this.cluster, INPUT_FILE);
        Util.deleteFile(this.cluster, INPUT_FILE2);
    }

    @Test
    public void testRecursiveFileListing() throws IOException {
        Util.createInputFile(this.cluster, "foo/bar/test.dat", new String[]{"2"});
        this.pigServer.registerQuery("A = LOAD 'foo';");
        this.pigServer.registerQuery("B = LOAD 'foo';");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using 'merge';");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
        Util.deleteFile(this.cluster, "foo/bar/test.dat");
    }

    @Test
    public void testMergeJoinSimplest() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinOnMultiFields() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinWithExpr() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by ($0+10), B by ($0+10) using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by ($0+10), B by ($0+10);");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinOutWithSchema() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinOutWithFilters() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("C = FILTER A by $1 > 1;");
        this.pigServer.registerQuery("D = FILTER B by $1 > 1;");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("E = join C by $0, D by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("E = join C by $0, D by $0;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinOutWithProjects() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (f1,f2);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt'as (f1,f2);");
        this.pigServer.registerQuery("C = foreach A generate f1;");
        this.pigServer.registerQuery("D = foreach B generate f1;");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("E = join C by f1, D by f1 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("E = join C by f1, D by f1;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoinOutPipeline() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (f1:int,f2:int);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (f1:int,f2:int);");
        DataBag dbmrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        this.pigServer.registerQuery("G = LOAD 'testMergeJoinInput.txt' as (f1:int,f2:int);");
        this.pigServer.registerQuery("H = LOAD 'testMergeJoinInput.txt' as (f1:int,f2:int);");
        this.pigServer.registerQuery("D = join G by $0, H by $0 using \"merge\";");
        this.pigServer.registerQuery("E = union C,D;");
        this.pigServer.registerQuery("F = filter E by 1 == 1;");
        Iterator iter = this.pigServer.openIterator("F");
        while (iter.hasNext()) {
            dbmrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        this.pigServer.registerQuery("D = join A by $0, B by $0;");
        this.pigServer.registerQuery("E = union C,D;");
        this.pigServer.registerQuery("F = filter E by 1 == 1;");
        iter = this.pigServer.openIterator("F");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbmrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbmrj, dbshj));
    }

    @Test
    public void testMergeJoinWithNulls() throws IOException {
        String[] input = new String[]{"\t2", "1\t2", "1\t2", "\t2", "3\t2", "\t", "5\t", "7\t", "7\t1"};
        Util.createInputFile(this.cluster, "temp_file", input);
        this.pigServer.registerQuery("A = LOAD 'temp_file';");
        this.pigServer.registerQuery("B = LOAD 'temp_file';");
        DataBag dbmrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbmrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Util.deleteFile(this.cluster, "temp_file");
        Assert.assertEquals((long)dbmrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbmrj, dbshj));
    }

    @Test
    public void testMergeJoinWithMRBoundaryLater() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        this.pigServer.registerQuery("D = group C by $0;");
        this.pigServer.registerQuery("E = filter D by $0 > 0;");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        this.pigServer.registerQuery("D = group C by $0 ;");
        this.pigServer.registerQuery("E = filter D by $0 > 0;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    @Test
    public void testMergeJoin3Way() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (id, name, n);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (id, name);");
        this.pigServer.registerQuery("C = LOAD 'testMergeJoinInput.txt' as (id, name);");
        try {
            this.pigServer.registerQuery("D = join A by id, B by id, C by id using \"merge\";");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            Assert.assertEquals((int)1000, (int)pe.getErrorCode());
            return;
        }
        Assert.fail((String)"Should throw exception, do not support 3 way join");
    }

    @Test
    public void testMergeJoinFailure1() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (id, name, n);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (id, name);");
        this.pigServer.registerQuery("C = ORDER A by $0 parallel 5;");
        this.pigServer.registerQuery("D = join A by id, C by id using \"merge\";");
        try {
            this.pigServer.openIterator("D");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            Assert.assertEquals((int)1103, (int)pe.getErrorCode());
            return;
        }
        Assert.fail((String)"Should fail to compile");
    }

    @Test
    public void testMergeJoinFailure2() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (id, name, n);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (id, name);");
        this.pigServer.registerQuery("C = GROUP B by id;");
        this.pigServer.registerQuery("D = join A by id, C by $0 using \"merge\";");
        try {
            this.pigServer.openIterator("D");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            Assert.assertEquals((int)1103, (int)pe.getErrorCode());
            return;
        }
        Assert.fail((String)"Should fail to compile");
    }

    @Test
    public void testEmptyRightFile() throws IOException {
        DataBag dbmrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        Util.createInputFile(this.cluster, "temp_file", new String[0]);
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'temp_file';");
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        this.pigServer.openIterator("C");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbmrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbmrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbmrj, dbshj));
        Util.deleteFile(this.cluster, "temp_file");
    }

    @Test
    public void testParallelism() throws Exception {
        LogicalPlanTester tester = new LogicalPlanTester();
        tester.buildPlan("A = LOAD 'testMergeJoinInput.txt';");
        tester.buildPlan("B = LOAD 'testMergeJoinInput.txt';");
        tester.buildPlan("C = join A by $0, B by $0 using \"merge\" parallel 50;");
        LogicalPlan lp = tester.buildPlan("store C into 'out';");
        PigContext pc = new PigContext(ExecType.MAPREDUCE, this.cluster.getProperties());
        pc.connect();
        MROperPlan mro = Util.buildMRPlan(Util.buildPhysicalPlan(lp, pc), pc);
        Assert.assertEquals((int)1, (int)((MapReduceOper)mro.getRoots().get(0)).getRequestedParallelism());
    }

    @Test
    public void testIndexer() throws IOException {
        Util.createInputFile(this.cluster, "temp_file1", new String[]{"1"});
        Util.createInputFile(this.cluster, "temp_file2", new String[]{"2"});
        Util.createInputFile(this.cluster, "temp_file3", new String[]{"10"});
        this.pigServer.registerQuery("A = LOAD 'temp_file*' as (a:int);");
        this.pigServer.registerQuery("B = LOAD 'temp_file*' as (a:int);");
        DataBag dbmrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbmrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Util.deleteFile(this.cluster, "temp_file1");
        Util.deleteFile(this.cluster, "temp_file2");
        Util.deleteFile(this.cluster, "temp_file3");
        Assert.assertEquals((long)dbmrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbmrj, dbshj));
    }

    @Test
    public void testExpression() throws IOException {
        Util.createInputFile(this.cluster, "temp_file1", new String[]{"8", "9"});
        Util.createInputFile(this.cluster, "temp_file2", new String[]{"10", "11"});
        Util.createInputFile(this.cluster, "temp_file3", new String[]{"20"});
        Util.createInputFile(this.cluster, "leftinput", new String[]{"9", "11"});
        this.pigServer.registerQuery("A = LOAD 'leftinput' as (a:int);");
        this.pigServer.registerQuery("B = LOAD 'temp_file*' as (a:int);");
        DataBag dbmrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0 + 10, B by $0 + 10 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbmrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0 + 10, B by $0 + 10;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Util.deleteFile(this.cluster, "temp_file1");
        Util.deleteFile(this.cluster, "temp_file2");
        Util.deleteFile(this.cluster, "temp_file3");
        Util.deleteFile(this.cluster, "leftinput");
        Assert.assertEquals((long)dbmrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbmrj, dbshj));
    }

    @Test
    public void testExpressionFail() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'leftinput' as (a:int);");
        this.pigServer.registerQuery("B = LOAD 'temp_file*' using " + DummyIndexableLoader.class.getName() + "() as (a:int);");
        boolean exceptionThrown = false;
        try {
            this.pigServer.registerQuery("C = join A by $0 + 10, B by $0 + 10 using \"merge\";");
            Iterator iter = this.pigServer.openIterator("C");
        }
        catch (Exception e) {
            e.printStackTrace();
            PigException pe = LogUtils.getPigException((Throwable)e);
            Assert.assertEquals((int)1106, (int)pe.getErrorCode());
            exceptionThrown = true;
        }
        Assert.assertEquals((boolean)true, (boolean)exceptionThrown);
    }

    @Test
    public void testMergeJoinSch1() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt' as (x:int,y:int);");
        Schema mjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        mjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertEquals((boolean)true, (boolean)shjSch.equals((Object)mjSch));
    }

    @Test
    public void testMergeJoinSch2() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        Schema mjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"merge\";");
        mjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertTrue((shjSch == null ? 1 : 0) != 0);
    }

    @Test
    public void testMergeJoinWithCommaSeparatedFilePaths() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'temp_file,righinput_file' using " + DummyIndexableLoader.class.getName() + "();");
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testMergeJoinEmptyIndex() throws IOException {
        DataBag dbMergeJoin = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("A = LOAD 'testMergeJoinInput2.txt';");
        this.pigServer.registerQuery("B = LOAD 'testMergeJoinInput.txt';");
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"merge\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbMergeJoin.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbMergeJoin.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbMergeJoin, dbshj));
    }

    public static class DummyIndexableLoader
    extends LoadFunc
    implements IndexableLoadFunc {
        public void close() throws IOException {
        }

        public void seekNear(Tuple keys) throws IOException {
        }

        public Tuple getNext() throws IOException {
            return null;
        }

        public void initialize(Configuration conf) throws IOException {
        }

        public InputFormat getInputFormat() throws IOException {
            return null;
        }

        public LoadCaster getLoadCaster() throws IOException {
            return null;
        }

        public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        }

        public void setLocation(String location, Job job) throws IOException {
        }
    }
}

