/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POIsNull;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestNull
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public static boolean test(byte type) throws ExecException {
        Random r = new Random();
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setResultType(type);
        Tuple dummyTuple = TupleFactory.getInstance().newTuple(1);
        lt.attachInput(dummyTuple);
        POIsNull isNullExpr = GenPhyOp.compIsNullExpr();
        isNullExpr.setExpr((ExpressionOperator)lt);
        isNullExpr.setOperandType(type);
        switch (type) {
            case 120: {
                DataBag inp1 = GenRandomData.genRandSmallTupDataBag(r, 10, 100);
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
            case 5: {
                Boolean inp1 = r.nextBoolean();
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                ret = DataType.compare((Object)inp1, null) == 0;
                return res.result.equals(true);
            }
            case 50: {
                DataByteArray inp1 = GenRandomData.genRandDBA(r);
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                ret = DataType.compare((Object)inp1, null) == 0;
                return res.result.equals(true);
            }
            case 55: {
                String inp1 = GenRandomData.genRandString(r);
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                ret = DataType.compare((Object)inp1, null) == 0;
                return res.result.equals(true);
            }
            case 25: {
                Double inp1 = r.nextDouble();
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                ret = DataType.compare((Object)inp1, null) == 0;
                return res.result.equals(true);
            }
            case 20: {
                Float inp1 = Float.valueOf(r.nextFloat());
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
            case 10: {
                Integer inp1 = r.nextInt();
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
            case 15: {
                Long inp1 = r.nextLong();
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
            case 100: {
                Map<String, Object> inp1 = GenRandomData.genRandMap(r, 10);
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue(inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare(inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
            case 110: {
                Tuple inp1 = GenRandomData.genRandSmallBagTuple(r, 10, 100);
                Result res = isNullExpr.getNext((Boolean)null);
                if (!((Boolean)res.result).booleanValue()) {
                    return false;
                }
                lt.setValue((Object)inp1);
                res = isNullExpr.getNext((Boolean)null);
                Boolean ret = DataType.compare((Object)inp1, null) == 0;
                if (!res.result.equals(ret)) {
                    return false;
                }
                lt.setValue((Object)null);
                res = isNullExpr.getNext((Boolean)null);
                return res.result.equals(true);
            }
        }
        return true;
    }

    @Test
    public void testOperator() throws ExecException {
        int TRIALS = 10;
        byte[] types = DataType.genAllTypes();
        Map map = DataType.genTypeToNameMap();
        long t1 = System.currentTimeMillis();
        for (byte b : types) {
            boolean succ = true;
            for (int i = 0; i < TRIALS; ++i) {
                succ &= TestNull.test(b);
            }
            TestNull.assertEquals((boolean)true, (boolean)succ);
        }
    }
}

