/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanPrinter;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.PlanOptimizer;
import org.apache.pig.impl.plan.optimizer.Rule;
import org.apache.pig.impl.plan.optimizer.RuleOperator;
import org.apache.pig.impl.plan.optimizer.RulePlan;
import org.apache.pig.impl.plan.optimizer.Transformer;
import org.junit.Test;

public class TestOperatorPlan
extends TestCase {
    private int mNextKey = 0;
    private static final String SCOPE = "RULE";
    private static NodeIdGenerator nodeIdGen = NodeIdGenerator.getGenerator();
    public static int MAX_OPTIMIZATION_ITERATIONS = 250;

    @Test
    public void testAddRemove() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        for (int i = 0; i < 3; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        List roots = plan.getRoots();
        for (int i = 0; i < 3; ++i) {
            TestOperatorPlan.assertTrue((String)("Roots should contain operator " + i), (boolean)roots.contains(ops[i]));
        }
        List leaves = plan.getLeaves();
        for (int i = 0; i < 3; ++i) {
            TestOperatorPlan.assertTrue((String)("Leaves should contain operator " + i), (boolean)leaves.contains(ops[i]));
        }
        TestOperatorPlan.assertNull((Object)plan.getSuccessors(ops[1]));
        TestOperatorPlan.assertNull((Object)plan.getPredecessors(ops[1]));
        HashSet s = new HashSet();
        Iterator j = plan.iterator();
        while (j.hasNext()) {
            s.add(j.next());
        }
        for (int i = 0; i < 3; ++i) {
            TestOperatorPlan.assertTrue((String)("Iterator should contain operator " + i), (boolean)s.contains(ops[i]));
        }
        TOperator op = (TOperator)plan.getOperator(new OperatorKey("", 1L));
        TestOperatorPlan.assertEquals((String)"Expected to get back ops[1]", (Object)ops[1], (Object)op);
        OperatorKey opkey = new OperatorKey("", 1L);
        TestOperatorPlan.assertTrue((String)"Expected to get back key for ops[1]", (boolean)opkey.equals((Object)plan.getOperatorKey(ops[1])));
        plan.remove(ops[2]);
        TestOperatorPlan.assertEquals((String)"Should only have two roots now.", (int)2, (int)plan.getRoots().size());
        TestOperatorPlan.assertEquals((String)"Should only have two leaves now.", (int)2, (int)plan.getLeaves().size());
        j = plan.iterator();
        int k = 0;
        while (j.hasNext()) {
            j.next();
            ++k;
        }
        TestOperatorPlan.assertEquals((String)"Iterator should only return two now", (int)2, (int)k);
        plan.remove(ops[0]);
        plan.remove(ops[1]);
        TestOperatorPlan.assertEquals((String)"Should only have no roots now.", (int)0, (int)plan.getRoots().size());
        TestOperatorPlan.assertEquals((String)"Should only have no leaves now.", (int)0, (int)plan.getLeaves().size());
        j = plan.iterator();
        TestOperatorPlan.assertFalse((String)"Iterator should return nothing now", (boolean)j.hasNext());
    }

    @Test
    public void testInsertBetween() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        for (int i = 0; i < 3; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[2]);
        List p = plan.getPredecessors(ops[0]);
        TestOperatorPlan.assertNull((Object)p);
        p = plan.getSuccessors(ops[0]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        Iterator i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[2], i.next());
        p = plan.getPredecessors(ops[1]);
        TestOperatorPlan.assertNull((Object)p);
        p = plan.getSuccessors(ops[1]);
        TestOperatorPlan.assertNull((Object)p);
        p = plan.getPredecessors(ops[2]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[0], i.next());
        p = plan.getSuccessors(ops[2]);
        TestOperatorPlan.assertNull((Object)p);
        plan.insertBetween(ops[0], ops[1], ops[2]);
        p = plan.getPredecessors(ops[0]);
        TestOperatorPlan.assertNull((Object)p);
        p = plan.getSuccessors(ops[0]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[1], i.next());
        p = plan.getPredecessors(ops[1]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[0], i.next());
        p = plan.getSuccessors(ops[1]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[2], i.next());
        p = plan.getPredecessors(ops[2]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[1], i.next());
        p = plan.getSuccessors(ops[2]);
        TestOperatorPlan.assertNull((Object)p);
    }

    @Test
    public void testInsertBetweenNegative() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[4];
        for (int i = 0; i < 4; ++i) {
            ops[i] = new MultiOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        boolean caughtIt = false;
        try {
            plan.insertBetween(ops[0], ops[3], ops[2]);
        }
        catch (PlanException pe) {
            caughtIt = true;
        }
        TestOperatorPlan.assertTrue((boolean)caughtIt);
    }

    @Test
    public void testLinearGraph() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[5];
        for (int i = 0; i < 5; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
            if (i <= 0) continue;
            plan.connect(ops[i - 1], ops[i]);
        }
        SingleOperator bogus = new SingleOperator("X");
        boolean sawError = false;
        try {
            plan.connect(ops[2], bogus);
        }
        catch (PlanException ioe) {
            TestOperatorPlan.assertEquals((String)"Attempt to connect operator X which is not in the plan.", (String)ioe.getMessage());
            sawError = true;
        }
        TestOperatorPlan.assertTrue((String)"Should have caught an error when we tried to connect a node that was not in the plan", (boolean)sawError);
        List roots = plan.getRoots();
        TestOperatorPlan.assertEquals((int)1, (int)roots.size());
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        List leaves = plan.getLeaves();
        TestOperatorPlan.assertEquals((int)1, (int)leaves.size());
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[4]);
        plan.add(bogus);
        sawError = false;
        try {
            plan.connect(bogus, ops[1]);
        }
        catch (PlanException ioe) {
            TestOperatorPlan.assertEquals((String)"Attempt to give operator of type org.apache.pig.test.TestOperatorPlan$SingleOperator multiple inputs.  This operator does not support multiple inputs.", (String)ioe.getMessage());
            sawError = true;
        }
        TestOperatorPlan.assertTrue((String)"Should have caught an error when we tried to connect a second input to a Single", (boolean)sawError);
        sawError = false;
        try {
            plan.connect(ops[0], bogus);
        }
        catch (PlanException ioe) {
            TestOperatorPlan.assertEquals((String)"Attempt to give operator of type org.apache.pig.test.TestOperatorPlan$SingleOperator multiple outputs.  This operator does not support multiple outputs.", (String)ioe.getMessage());
            sawError = true;
        }
        TestOperatorPlan.assertTrue((String)"Should have caught an error when we tried to connect a second output to a org.apache.pig.test.TestOperatorPlan$SingleOperator", (boolean)sawError);
        plan.remove(bogus);
        List s = plan.getSuccessors(ops[1]);
        TestOperatorPlan.assertEquals((int)1, (int)s.size());
        Iterator i = s.iterator();
        TestOperatorPlan.assertEquals((Object)ops[2], i.next());
        List p = plan.getPredecessors(ops[1]);
        TestOperatorPlan.assertEquals((int)1, (int)p.size());
        i = p.iterator();
        TestOperatorPlan.assertEquals((Object)ops[0], i.next());
        TestOperatorPlan.assertEquals((String)"Nodes: 0 1 2 3 4 FromEdges: 0->1 1->2 2->3 3->4 ToEdges: 1->0 2->1 3->2 4->3 ", (String)plan.display());
        TVisitor visitor = new TDepthVisitor(plan);
        visitor.visit();
        TestOperatorPlan.assertEquals((String)"0 1 2 3 4 ", (String)visitor.getJournal());
        visitor = new TDependVisitor(plan);
        visitor.visit();
        TestOperatorPlan.assertEquals((String)"0 1 2 3 4 ", (String)visitor.getJournal());
        plan.disconnect(ops[2], ops[3]);
        TestOperatorPlan.assertEquals((String)"Nodes: 0 1 2 3 4 FromEdges: 0->1 1->2 3->4 ToEdges: 1->0 2->1 4->3 ", (String)plan.display());
        plan.remove(ops[1]);
        TestOperatorPlan.assertEquals((String)"Nodes: 0 2 3 4 FromEdges: 3->4 ToEdges: 4->3 ", (String)plan.display());
    }

    @Test
    public void testDAG() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        for (int i = 0; i < 6; ++i) {
            ops[i] = new MultiOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        plan.connect(ops[2], ops[3]);
        plan.connect(ops[3], ops[4]);
        plan.connect(ops[3], ops[5]);
        List roots = plan.getRoots();
        TestOperatorPlan.assertEquals((int)2, (int)roots.size());
        TestOperatorPlan.assertTrue((boolean)roots.contains(ops[0]));
        TestOperatorPlan.assertTrue((boolean)roots.contains(ops[1]));
        List leaves = plan.getLeaves();
        TestOperatorPlan.assertEquals((int)2, (int)leaves.size());
        TestOperatorPlan.assertTrue((boolean)leaves.contains(ops[4]));
        TestOperatorPlan.assertTrue((boolean)leaves.contains(ops[5]));
        ArrayList s = new ArrayList(plan.getSuccessors(ops[3]));
        TestOperatorPlan.assertEquals((int)2, (int)s.size());
        TestOperatorPlan.assertTrue((boolean)s.contains(ops[4]));
        TestOperatorPlan.assertTrue((boolean)s.contains(ops[5]));
        s = new ArrayList(plan.getPredecessors(ops[2]));
        TestOperatorPlan.assertEquals((int)2, (int)s.size());
        TestOperatorPlan.assertTrue((boolean)s.contains(ops[0]));
        TestOperatorPlan.assertTrue((boolean)s.contains(ops[1]));
        TestOperatorPlan.assertEquals((String)"Nodes: 0 1 2 3 4 5 FromEdges: 0->2 1->2 2->3 3->4 3->5 ToEdges: 2->0 2->1 3->2 4->3 5->3 ", (String)plan.display());
        TVisitor visitor = new TDepthVisitor(plan);
        visitor.visit();
        String result = visitor.getJournal();
        TestOperatorPlan.assertTrue((result.equals("1 2 3 4 5 0 ") || result.equals("1 2 3 5 4 0 ") || result.equals("0 2 3 4 5 1 ") || result.equals("0 2 3 5 4 1 ") ? 1 : 0) != 0);
        visitor = new TDependVisitor(plan);
        visitor.visit();
        result = visitor.getJournal();
        TestOperatorPlan.assertTrue((result.equals("0 1 2 3 4 5 ") || result.equals("0 1 2 3 5 4 ") ? 1 : 0) != 0);
        plan.disconnect(ops[2], ops[3]);
        TestOperatorPlan.assertEquals((String)"Nodes: 0 1 2 3 4 5 FromEdges: 0->2 1->2 3->4 3->5 ToEdges: 2->0 2->1 4->3 5->3 ", (String)plan.display());
        plan.remove(ops[2]);
        TestOperatorPlan.assertEquals((String)"Nodes: 0 1 3 4 5 FromEdges: 3->4 3->5 ToEdges: 4->3 5->3 ", (String)plan.display());
    }

    @Test
    public void testOptimizerDifferentNodes() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        ops[2] = new SingleOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerDifferentEdges() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerMatches() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerMatchesAny() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, RuleOperator.NodeType.ANY_NODE, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerMatchesPart() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[4];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new SingleOperator("3");
        plan.add(ops[2]);
        ops[3] = new MultiOperator("4");
        plan.add(ops[3]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        plan.connect(ops[2], ops[3]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerOptionalMatches() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)transformer.mTransformed);
    }

    @Test
    public void testOptimizerOptionalMissing() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        plan.connect(ops[0], ops[1]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform transformer = new AlwaysTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)transformer.mTransformed);
    }

    @Test
    public void testCheck() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        NeverTransform transformer = new NeverTransform(plan);
        Rule r = new Rule(rulePlan, (Transformer)transformer, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)transformer.mTransformed);
    }

    @Test
    public void testReplace() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        ops[3] = new MultiOperator("4");
        plan.add(ops[3]);
        ops[4] = new MultiOperator("5");
        plan.add(ops[4]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        plan.connect(ops[2], ops[3]);
        plan.connect(ops[2], ops[4]);
        ops[5] = new MultiOperator("6");
        plan.replace(ops[2], ops[5]);
        TestOperatorPlan.assertEquals((String)"Nodes: 1 2 4 5 6 FromEdges: 1->6 2->6 6->4 6->5 ToEdges: 4->6 5->6 6->1 6->2 ", (String)plan.display());
    }

    @Test
    public void testReplaceNoConnections() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[4];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        ops[3] = new MultiOperator("4");
        plan.replace(ops[1], ops[3]);
        TestOperatorPlan.assertEquals((String)"Nodes: 1 3 4 FromEdges: 1->3 ToEdges: 3->1 ", (String)plan.display());
    }

    @Test
    public void testMultiInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testIsomorphicMultiInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testMultiInputMultiOutputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[0], ops[1]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testMultiOutputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new SingleOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[0], ops[2]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_1);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeMultiOutputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        plan.connect(ops[0], ops[1]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_1);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeMultiOutputPattern1() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new MultiOperator("2");
        plan.add(ops[1]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[0], ops[1]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleMultiInputPatternInDisconnectedGraph() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[3], ops[5]);
        plan.connect(ops[4], ops[5]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == 2 * MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == 2 * MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleMultiInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[7];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[3], ops[5]);
        plan.connect(ops[4], ops[5]);
        ops[6] = new MultiOperator("7");
        plan.add(ops[6]);
        plan.connect(ops[2], ops[6]);
        plan.connect(ops[5], ops[6]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == 2 * MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == 2 * MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testSingleMultiInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new MultiOperator("5");
        plan.add(ops[4]);
        plan.connect(ops[3], ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[4], ops[5]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testDiamondPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[4];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new SingleOperator("3");
        plan.add(ops[2]);
        ops[3] = new MultiOperator("4");
        plan.add(ops[3]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[3]);
        plan.connect(ops[2], ops[3]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_1);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testDiamondWithEdgePattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[5];
        ops[0] = new MultiOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new SingleOperator("3");
        plan.add(ops[2]);
        ops[3] = new MultiOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[3]);
        plan.connect(ops[2], ops[3]);
        plan.connect(ops[3], ops[4]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_1);
        rulePlan.connect((Operator)multiOperator_1, (Operator)singleOperator_2);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_2);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testComplexInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[5], ops[3]);
        plan.connect(ops[5], ops[4]);
        plan.connect(ops[2], ops[5]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        RuleOperator singleOperator_3 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_4 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_3);
        rulePlan.add((Operator)singleOperator_4);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_2, (Operator)singleOperator_3);
        rulePlan.connect((Operator)multiOperator_2, (Operator)singleOperator_4);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertTrue((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == MAX_OPTIMIZATION_ITERATIONS ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeComplexInputPattern() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[5], ops[3]);
        plan.connect(ops[5], ops[4]);
        plan.connect(ops[2], ops[5]);
        RulePlan rulePlan = new RulePlan();
        RuleOperator singleOperator_1 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_2 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_1 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_1);
        rulePlan.add((Operator)singleOperator_2);
        rulePlan.add((Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_1, (Operator)multiOperator_1);
        rulePlan.connect((Operator)singleOperator_2, (Operator)multiOperator_1);
        RuleOperator singleOperator_3 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator singleOperator_4 = new RuleOperator(SingleOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        RuleOperator multiOperator_2 = new RuleOperator(MultiOperator.class, new OperatorKey(SCOPE, nodeIdGen.getNextNodeId(SCOPE)));
        rulePlan.add((Operator)singleOperator_3);
        rulePlan.add((Operator)singleOperator_4);
        rulePlan.add((Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_2, (Operator)singleOperator_3);
        rulePlan.connect((Operator)multiOperator_2, (Operator)singleOperator_4);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        rulePlan.connect((Operator)multiOperator_1, (Operator)multiOperator_2);
        AlwaysTransform alwaysTransform = new AlwaysTransform(plan);
        Rule r1 = new Rule(rulePlan, (Transformer)alwaysTransform, "TestRule");
        NeverTransform neverTransform = new NeverTransform(plan);
        Rule r2 = new Rule(rulePlan, (Transformer)neverTransform, "TestRule");
        TOptimizer optimizer = new TOptimizer(plan);
        optimizer.addRule(r1);
        optimizer.addRule(r2);
        optimizer.optimize();
        TestOperatorPlan.assertFalse((boolean)alwaysTransform.mTransformed);
        TestOperatorPlan.assertTrue((alwaysTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
        TestOperatorPlan.assertFalse((boolean)neverTransform.mTransformed);
        TestOperatorPlan.assertTrue((neverTransform.getNumberOfChecks() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSwapRootsInDisconnectedGraph() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.swap(ops[0], ops[1]);
        ArrayList roots = (ArrayList)plan.getRoots();
        for (int i = 0; i < roots.size(); ++i) {
            TestOperatorPlan.assertEquals(roots.get(i), (Object)ops[i]);
        }
    }

    @Test
    public void testSimpleSwap() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[2];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.swap(ops[0], ops[1]);
        ArrayList roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[1]);
        List rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[0]);
        ArrayList leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[0]);
        List leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[1]);
        plan.swap(ops[0], ops[1]);
        roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[1]);
        leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[1]);
        leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[0]);
    }

    @Test
    public void testSimpleSwap2() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        plan.swap(ops[0], ops[2]);
        ArrayList roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[2]);
        List rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[1]);
        ArrayList leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[0]);
        List leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[1]);
        plan.swap(ops[0], ops[2]);
        roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[1]);
        leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[2]);
        leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[1]);
    }

    @Test
    public void testSimpleSwap3() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        plan.swap(ops[1], ops[2]);
        ArrayList roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        List rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[2]);
        ArrayList leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[1]);
        List leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[2]);
        plan.swap(ops[1], ops[2]);
        roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[1]);
        leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[2]);
        leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[1]);
    }

    @Test
    public void testSimpleSwap4() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[3];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        plan.swap(ops[0], ops[1]);
        ArrayList roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[1]);
        List rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[0]);
        ArrayList leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[2]);
        List leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[0]);
        plan.swap(ops[0], ops[1]);
        roots = (ArrayList)plan.getRoots();
        TestOperatorPlan.assertEquals(roots.get(0), (Object)ops[0]);
        rootSuccessors = plan.getSuccessors((Operator)roots.get(0));
        TestOperatorPlan.assertEquals(rootSuccessors.get(0), (Object)ops[1]);
        leaves = (ArrayList)plan.getLeaves();
        TestOperatorPlan.assertEquals(leaves.get(0), (Object)ops[2]);
        leafPredecessors = plan.getPredecessors((Operator)leaves.get(0));
        TestOperatorPlan.assertEquals(leafPredecessors.get(0), (Object)ops[1]);
    }

    @Test
    public void testNegativeSimpleSwap() throws Exception {
        int i;
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[5];
        for (i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
        }
        for (i = 0; i < ops.length - 2; ++i) {
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        try {
            plan.swap(ops[0], ops[3]);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.swap(ops[3], ops[0]);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.swap(ops[4], ops[3]);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.swap(ops[0], null);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1092 ? 1 : 0) != 0);
        }
        try {
            plan.swap(null, ops[0]);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1092 ? 1 : 0) != 0);
        }
        try {
            plan.swap(null, null);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1092 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNegativeSimpleSwap1() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[6];
        ops[0] = new SingleOperator("1");
        plan.add(ops[0]);
        ops[1] = new SingleOperator("2");
        plan.add(ops[1]);
        ops[2] = new MultiOperator("3");
        plan.add(ops[2]);
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[2]);
        ops[3] = new SingleOperator("4");
        plan.add(ops[3]);
        ops[4] = new SingleOperator("5");
        plan.add(ops[4]);
        ops[5] = new MultiOperator("6");
        plan.add(ops[5]);
        plan.connect(ops[5], ops[3]);
        plan.connect(ops[5], ops[4]);
        plan.connect(ops[2], ops[5]);
        try {
            plan.swap(ops[0], ops[2]);
            TestOperatorPlan.fail((String)"Expected exception for multi-input operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
        try {
            plan.swap(ops[2], ops[0]);
            TestOperatorPlan.fail((String)"Expected exception for multi-input operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
        try {
            plan.swap(ops[2], ops[5]);
            TestOperatorPlan.fail((String)"Expected exception for multi-input operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
        try {
            plan.swap(ops[5], ops[2]);
            TestOperatorPlan.fail((String)"Expected exception for multi-output operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
        try {
            plan.swap(ops[5], ops[3]);
            TestOperatorPlan.fail((String)"Expected exception for multi-output operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
        try {
            plan.swap(ops[3], ops[5]);
            TestOperatorPlan.fail((String)"Expected exception for multi-output operator.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1093 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testpushBefore() throws Exception {
        for (int index = 0; index < 4; ++index) {
            TPlan plan = new TPlan();
            TOperator[] ops = new TOperator[11];
            for (int i = 0; i < ops.length - 2; ++i) {
                ops[i] = new SingleOperator(Integer.toString(i + 1));
                plan.add(ops[i]);
            }
            ops[9] = new MultiOperator("10");
            plan.add(ops[9]);
            ops[10] = new MultiOperator("11");
            plan.add(ops[10]);
            plan.connect(ops[0], ops[9]);
            plan.connect(ops[1], ops[9]);
            plan.connect(ops[2], ops[9]);
            plan.connect(ops[3], ops[9]);
            plan.connect(ops[9], ops[4]);
            plan.connect(ops[9], ops[10]);
            plan.connect(ops[9], ops[5]);
            plan.connect(ops[10], ops[6]);
            plan.connect(ops[10], ops[7]);
            plan.connect(ops[10], ops[8]);
            plan.pushBefore(ops[9], ops[10], index);
            HashSet<TOperator> rootSet = new HashSet<TOperator>();
            rootSet.add(ops[0]);
            rootSet.add(ops[1]);
            rootSet.add(ops[2]);
            rootSet.add(ops[3]);
            HashSet expectedRootSet = new HashSet(plan.getRoots());
            rootSet.retainAll(expectedRootSet);
            TestOperatorPlan.assertTrue((rootSet.size() == 4 ? 1 : 0) != 0);
            HashSet<TOperator> leafSet = new HashSet<TOperator>();
            leafSet.add(ops[4]);
            leafSet.add(ops[5]);
            leafSet.add(ops[6]);
            leafSet.add(ops[7]);
            leafSet.add(ops[8]);
            HashSet expectedLeafSet = new HashSet(plan.getLeaves());
            leafSet.retainAll(expectedLeafSet);
            TestOperatorPlan.assertTrue((leafSet.size() == 5 ? 1 : 0) != 0);
            List m10Predecessors = plan.getPredecessors(ops[9]);
            TestOperatorPlan.assertTrue((m10Predecessors.get(index) == ops[10] ? 1 : 0) != 0);
            List m11Predecessors = plan.getPredecessors(ops[10]);
            TestOperatorPlan.assertTrue((m11Predecessors.get(0) == ops[index] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testpushBefore2() throws Exception {
        for (int outerIndex = 0; outerIndex < 2; ++outerIndex) {
            for (int index = 0; index < 2; ++index) {
                TPlan plan = new TPlan();
                TOperator[] ops = new TOperator[11];
                for (int i = 0; i < ops.length - 2; ++i) {
                    ops[i] = new SingleOperator(Integer.toString(i + 1));
                    plan.add(ops[i]);
                }
                ops[9] = new MultiOperator("10");
                plan.add(ops[9]);
                ops[10] = new MultiOperator("11");
                plan.add(ops[10]);
                plan.connect(ops[0], ops[9]);
                plan.connect(ops[1], ops[9]);
                plan.connect(ops[2], ops[9]);
                plan.connect(ops[3], ops[9]);
                plan.connect(ops[9], ops[4]);
                plan.connect(ops[9], ops[10]);
                plan.connect(ops[9], ops[5]);
                plan.connect(ops[10], ops[6]);
                plan.connect(ops[10], ops[7]);
                plan.connect(ops[10], ops[8]);
                int secondNodeIndex = outerIndex + 4;
                plan.pushBefore(ops[9], ops[secondNodeIndex], index);
                HashSet<TOperator> rootSet = new HashSet<TOperator>();
                rootSet.add(ops[0]);
                rootSet.add(ops[1]);
                rootSet.add(ops[2]);
                rootSet.add(ops[3]);
                HashSet expectedRootSet = new HashSet(plan.getRoots());
                rootSet.retainAll(expectedRootSet);
                TestOperatorPlan.assertTrue((rootSet.size() == 4 ? 1 : 0) != 0);
                HashSet<TOperator> leafSet = new HashSet<TOperator>();
                for (int leafIndex = 4; leafIndex < 9; ++leafIndex) {
                    if (leafIndex == secondNodeIndex) continue;
                    leafSet.add(ops[leafIndex]);
                }
                HashSet expectedLeafSet = new HashSet(plan.getLeaves());
                leafSet.retainAll(expectedLeafSet);
                TestOperatorPlan.assertTrue((leafSet.size() == 4 ? 1 : 0) != 0);
                List outerIndexNodePredecessors = plan.getPredecessors(ops[secondNodeIndex]);
                TestOperatorPlan.assertTrue((outerIndexNodePredecessors.get(0) == ops[index] ? 1 : 0) != 0);
                List m10Predecessors = plan.getPredecessors(ops[9]);
                TestOperatorPlan.assertTrue((m10Predecessors.get(index) == ops[secondNodeIndex] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNegativePushBefore() throws Exception {
        int i;
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[5];
        for (i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
        }
        for (i = 0; i < ops.length - 2; ++i) {
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        try {
            plan.pushBefore(ops[0], ops[3], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushBefore(ops[3], ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushBefore(ops[4], ops[3], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushBefore(ops[0], null, 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(null, ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(null, null, 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNegativePushBefore2() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[11];
        for (int i = 0; i < ops.length - 2; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i + 1));
            plan.add(ops[i]);
        }
        ops[9] = new MultiOperator("10");
        plan.add(ops[9]);
        ops[10] = new MultiOperator("11");
        plan.add(ops[10]);
        plan.connect(ops[0], ops[9]);
        plan.connect(ops[1], ops[9]);
        plan.connect(ops[2], ops[9]);
        plan.connect(ops[3], ops[9]);
        plan.connect(ops[9], ops[4]);
        plan.connect(ops[9], ops[10]);
        plan.connect(ops[9], ops[5]);
        plan.connect(ops[10], ops[6]);
        plan.connect(ops[10], ops[7]);
        plan.connect(ops[10], ops[8]);
        try {
            plan.pushBefore(ops[0], ops[9], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having null predecessors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1086 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(ops[10], ops[6], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having one predecessor");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1086 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(ops[9], ops[10], 4);
            TestOperatorPlan.fail((String)"Expected exception for inputNum exceeding number of predecessors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1087 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(ops[9], ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator having null predecessors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1088 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(ops[9], ops[9], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator having more than one predecessor");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1088 ? 1 : 0) != 0);
        }
        try {
            plan.pushBefore(ops[9], ops[8], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator not being a successor of first operator");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1089 ? 1 : 0) != 0);
        }
        plan.disconnect(ops[9], ops[4]);
        plan.disconnect(ops[9], ops[5]);
        MultiInputSingleOutputOperator miso = new MultiInputSingleOutputOperator("12");
        plan.replace(ops[9], miso);
        try {
            plan.pushBefore(miso, ops[10], 0);
            TestOperatorPlan.fail((String)"Expected exception for trying to connect multiple outputs to the first operator");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1091 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testpushAfter() throws Exception {
        for (int index = 0; index < 3; ++index) {
            TPlan plan = new TPlan();
            TOperator[] ops = new TOperator[11];
            for (int i = 0; i < ops.length - 2; ++i) {
                ops[i] = new SingleOperator(Integer.toString(i + 1));
                plan.add(ops[i]);
            }
            ops[9] = new MultiOperator("10");
            plan.add(ops[9]);
            ops[10] = new MultiOperator("11");
            plan.add(ops[10]);
            plan.connect(ops[0], ops[9]);
            plan.connect(ops[1], ops[9]);
            plan.connect(ops[2], ops[9]);
            plan.connect(ops[3], ops[9]);
            plan.connect(ops[9], ops[10]);
            plan.connect(ops[4], ops[10]);
            plan.connect(ops[5], ops[10]);
            plan.connect(ops[10], ops[6]);
            plan.connect(ops[10], ops[7]);
            plan.connect(ops[10], ops[8]);
            plan.pushAfter(ops[10], ops[9], index);
            HashSet<TOperator> rootSet = new HashSet<TOperator>();
            rootSet.add(ops[0]);
            rootSet.add(ops[1]);
            rootSet.add(ops[2]);
            rootSet.add(ops[3]);
            rootSet.add(ops[4]);
            rootSet.add(ops[5]);
            HashSet expectedRootSet = new HashSet(plan.getRoots());
            rootSet.retainAll(expectedRootSet);
            TestOperatorPlan.assertTrue((rootSet.size() == 6 ? 1 : 0) != 0);
            HashSet<TOperator> leafSet = new HashSet<TOperator>();
            leafSet.add(ops[6]);
            leafSet.add(ops[7]);
            leafSet.add(ops[8]);
            HashSet expectedLeafSet = new HashSet(plan.getLeaves());
            leafSet.retainAll(expectedLeafSet);
            TestOperatorPlan.assertTrue((leafSet.size() == 3 ? 1 : 0) != 0);
            List m10Successors = plan.getSuccessors(ops[9]);
            TestOperatorPlan.assertTrue((m10Successors.get(0) == ops[index + 6] ? 1 : 0) != 0);
            List m11Successors = plan.getSuccessors(ops[10]);
            TestOperatorPlan.assertTrue((m11Successors.get(index) == ops[9] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testpushAfter1() throws Exception {
        for (int outerIndex = 0; outerIndex < 2; ++outerIndex) {
            for (int index = 0; index < 3; ++index) {
                TPlan plan = new TPlan();
                TOperator[] ops = new TOperator[11];
                for (int i = 0; i < ops.length - 2; ++i) {
                    ops[i] = new SingleOperator(Integer.toString(i + 1));
                    plan.add(ops[i]);
                }
                ops[9] = new MultiOperator("10");
                plan.add(ops[9]);
                ops[10] = new MultiOperator("11");
                plan.add(ops[10]);
                plan.connect(ops[0], ops[9]);
                plan.connect(ops[1], ops[9]);
                plan.connect(ops[2], ops[9]);
                plan.connect(ops[3], ops[9]);
                plan.connect(ops[9], ops[10]);
                plan.connect(ops[4], ops[10]);
                plan.connect(ops[5], ops[10]);
                plan.connect(ops[10], ops[6]);
                plan.connect(ops[10], ops[7]);
                plan.connect(ops[10], ops[8]);
                int secondNodeIndex = outerIndex + 4;
                plan.pushAfter(ops[10], ops[secondNodeIndex], index);
                HashSet<TOperator> rootSet = new HashSet<TOperator>();
                rootSet.add(ops[0]);
                rootSet.add(ops[1]);
                rootSet.add(ops[2]);
                rootSet.add(ops[3]);
                for (int rootIndex = 0; rootIndex < 6; ++rootIndex) {
                    if (rootIndex == secondNodeIndex) continue;
                    rootSet.add(ops[rootIndex]);
                }
                HashSet expectedRootSet = new HashSet(plan.getRoots());
                rootSet.retainAll(expectedRootSet);
                TestOperatorPlan.assertTrue((rootSet.size() == 5 ? 1 : 0) != 0);
                HashSet<TOperator> leafSet = new HashSet<TOperator>();
                leafSet.add(ops[6]);
                leafSet.add(ops[7]);
                leafSet.add(ops[8]);
                HashSet expectedLeafSet = new HashSet(plan.getLeaves());
                leafSet.retainAll(expectedLeafSet);
                TestOperatorPlan.assertTrue((leafSet.size() == 3 ? 1 : 0) != 0);
                List outerIndexNodeSuccessors = plan.getSuccessors(ops[secondNodeIndex]);
                TestOperatorPlan.assertTrue((outerIndexNodeSuccessors.get(0) == ops[index + 6] ? 1 : 0) != 0);
                List m11Successors = plan.getSuccessors(ops[10]);
                TestOperatorPlan.assertTrue((m11Successors.get(index) == ops[secondNodeIndex] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNegativePushAfter() throws Exception {
        int i;
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[5];
        for (i = 0; i < ops.length; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i));
        }
        for (i = 0; i < ops.length - 2; ++i) {
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[1]);
        plan.connect(ops[1], ops[2]);
        try {
            plan.pushAfter(ops[0], ops[3], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushAfter(ops[3], ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushAfter(ops[4], ops[3], 0);
            TestOperatorPlan.fail((String)"Expected exception for node not in plan.");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((boolean)pe.getMessage().contains("not in the plan"));
        }
        try {
            plan.pushAfter(ops[0], null, 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(null, ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(null, null, 0);
            TestOperatorPlan.fail((String)"Expected exception for having null as one of the inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1085 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNegativePushAfter2() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[11];
        for (int i = 0; i < ops.length - 2; ++i) {
            ops[i] = new SingleOperator(Integer.toString(i + 1));
            plan.add(ops[i]);
        }
        ops[9] = new MultiOperator("10");
        plan.add(ops[9]);
        ops[10] = new MultiOperator("11");
        plan.add(ops[10]);
        plan.connect(ops[0], ops[9]);
        plan.connect(ops[1], ops[9]);
        plan.connect(ops[2], ops[9]);
        plan.connect(ops[3], ops[9]);
        plan.connect(ops[9], ops[10]);
        plan.connect(ops[4], ops[10]);
        plan.connect(ops[5], ops[10]);
        plan.connect(ops[10], ops[6]);
        plan.connect(ops[10], ops[7]);
        plan.connect(ops[10], ops[8]);
        try {
            plan.pushAfter(ops[6], ops[9], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having null successors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1086 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[0], ops[9], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having no inputs");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1088 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[9], ops[6], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having one successor");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1086 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[6], ops[10], 0);
            TestOperatorPlan.fail((String)"Expected exception for first operator having one successors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1086 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[10], ops[9], 4);
            TestOperatorPlan.fail((String)"Expected exception for outputNum exceeding the number of outputs of first operator");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1087 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[10], ops[6], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator having null successors");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1088 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[10], ops[10], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator having more than one successor");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1088 ? 1 : 0) != 0);
        }
        try {
            plan.pushAfter(ops[10], ops[0], 0);
            TestOperatorPlan.fail((String)"Expected exception for second operator not being a predecessor of first operator");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1089 ? 1 : 0) != 0);
        }
        plan.disconnect(ops[4], ops[10]);
        plan.disconnect(ops[5], ops[10]);
        MultiOutputSingleInputOperator mosi = new MultiOutputSingleInputOperator("12");
        plan.replace(ops[10], mosi);
        try {
            plan.pushAfter(mosi, ops[9], 0);
            TestOperatorPlan.fail((String)"Expected exception for trying to connect multiple inputs to the first operator");
        }
        catch (PlanException pe) {
            TestOperatorPlan.assertTrue((pe.getErrorCode() == 1091 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPushBefore2() throws Exception {
        TPlan plan = new TPlan();
        TOperator[] ops = new TOperator[]{new SingleOperator("Load0"), new SingleOperator("Load1"), new SingleOperator("ForEach0"), new SingleOperator("ForEach1"), new MultiOperator("Join"), new SingleOperator("Filter")};
        for (int i = 0; i < 6; ++i) {
            plan.add(ops[i]);
        }
        plan.connect(ops[0], ops[2]);
        plan.connect(ops[1], ops[3]);
        plan.connect(ops[2], ops[4]);
        plan.connect(ops[3], ops[4]);
        plan.connect(ops[4], ops[5]);
        try {
            plan.pushBefore(ops[4], ops[5], 0);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            PlanPrinter planPrinter = new PlanPrinter(ps, (OperatorPlan)plan);
            planPrinter.visit();
            TestOperatorPlan.assertFalse((boolean)baos.toString().equals(""));
        }
        catch (PlanException planException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NeverTransform
    extends Transformer<TOperator, TPlan> {
        public boolean mTransformed;
        private int mNumChecks;

        NeverTransform(TPlan plan) {
            super((OperatorPlan)plan);
            this.mTransformed = false;
            this.mNumChecks = 0;
        }

        public boolean check(List<TOperator> nodes) {
            ++this.mNumChecks;
            return false;
        }

        public void transform(List<TOperator> nodes) {
            this.mTransformed = true;
        }

        public int getNumberOfChecks() {
            return this.mNumChecks;
        }

        public void reset() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AlwaysTransform
    extends Transformer<TOperator, TPlan> {
        public boolean mTransformed;
        private int mNumChecks;

        AlwaysTransform(TPlan plan) {
            super((OperatorPlan)plan);
            this.mTransformed = false;
            this.mNumChecks = 0;
        }

        public boolean check(List<TOperator> nodes) {
            ++this.mNumChecks;
            return true;
        }

        public void transform(List<TOperator> nodes) {
            this.mTransformed = true;
        }

        public int getNumberOfChecks() {
            return this.mNumChecks;
        }

        public void reset() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TOptimizer
    extends PlanOptimizer<TOperator, TPlan> {
        public TOptimizer(TPlan plan) {
            super((OperatorPlan)plan, MAX_OPTIMIZATION_ITERATIONS);
        }

        public void addRule(Rule rule) {
            this.mRules.add(rule);
        }
    }

    class TDependVisitor
    extends TVisitor {
        TDependVisitor(TPlan plan) {
            super(plan, (PlanWalker<TOperator, TPlan>)new DependencyOrderWalker((OperatorPlan)plan));
        }
    }

    class TDepthVisitor
    extends TVisitor {
        TDepthVisitor(TPlan plan) {
            super(plan, (PlanWalker<TOperator, TPlan>)new DepthFirstWalker((OperatorPlan)plan));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class TVisitor
    extends PlanVisitor<TOperator, TPlan> {
        protected StringBuilder mJournal;

        TVisitor(TPlan plan, PlanWalker<TOperator, TPlan> walker) {
            super((OperatorPlan)plan, walker);
            this.mJournal = new StringBuilder();
        }

        public void visit(SingleOperator so) throws VisitorException {
            this.mJournal.append(so.name());
            this.mJournal.append(' ');
        }

        public void visit(MultiOperator mo) throws VisitorException {
            this.mJournal.append(mo.name());
            this.mJournal.append(' ');
        }

        public void visit(MultiInputSingleOutputOperator miso) throws VisitorException {
            this.mJournal.append(miso.name());
            this.mJournal.append(' ');
        }

        public void visit(MultiOutputSingleInputOperator mosi) throws VisitorException {
            this.mJournal.append(mosi.name());
            this.mJournal.append(' ');
        }

        public String getJournal() {
            return this.mJournal.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TPlan
    extends OperatorPlan<TOperator> {
        TPlan() {
        }

        public String display() {
            Iterator j;
            TreeSet ts2;
            StringBuilder buf = new StringBuilder();
            buf.append("Nodes: ");
            TreeSet<Object> ts = new TreeSet(this.mOps.keySet());
            for (TOperator tOperator : ts) {
                buf.append(tOperator.name());
                buf.append(' ');
            }
            buf.append("FromEdges: ");
            ts = new TreeSet(this.mFromEdges.keySet());
            for (TOperator tOperator : ts) {
                ts2 = new TreeSet(this.mFromEdges.get((Object)tOperator));
                j = ts2.iterator();
                while (j.hasNext()) {
                    buf.append(tOperator.name());
                    buf.append("->");
                    buf.append(((TOperator)j.next()).name());
                    buf.append(' ');
                }
            }
            buf.append("ToEdges: ");
            ts = new TreeSet(this.mToEdges.keySet());
            for (TOperator tOperator : ts) {
                ts2 = new TreeSet(this.mToEdges.get((Object)tOperator));
                j = ts2.iterator();
                while (j.hasNext()) {
                    buf.append(tOperator.name());
                    buf.append("->");
                    buf.append(((TOperator)j.next()).name());
                    buf.append(' ');
                }
            }
            return buf.toString();
        }
    }

    class MultiOutputSingleInputOperator
    extends TOperator {
        MultiOutputSingleInputOperator(String name) {
            super(name);
        }

        public boolean supportsMultipleInputs() {
            return false;
        }

        public boolean supportsMultipleOutputs() {
            return true;
        }

        public void visit(PlanVisitor v) throws VisitorException {
            ((TVisitor)v).visit(this);
        }

        public String name() {
            return this.mName;
        }
    }

    class MultiInputSingleOutputOperator
    extends TOperator {
        MultiInputSingleOutputOperator(String name) {
            super(name);
        }

        public boolean supportsMultipleInputs() {
            return true;
        }

        public boolean supportsMultipleOutputs() {
            return false;
        }

        public void visit(PlanVisitor v) throws VisitorException {
            ((TVisitor)v).visit(this);
        }

        public String name() {
            return this.mName;
        }
    }

    class MultiOperator
    extends TOperator {
        MultiOperator(String name) {
            super(name);
        }

        public boolean supportsMultipleInputs() {
            return true;
        }

        public boolean supportsMultipleOutputs() {
            return true;
        }

        public void visit(PlanVisitor v) throws VisitorException {
            ((TVisitor)v).visit(this);
        }

        public String name() {
            return this.mName;
        }
    }

    class SingleOperator
    extends TOperator {
        SingleOperator(String name) {
            super(name);
        }

        public boolean supportsMultipleInputs() {
            return false;
        }

        public boolean supportsMultipleOutputs() {
            return false;
        }

        public void visit(PlanVisitor v) throws VisitorException {
            ((TVisitor)v).visit(this);
        }

        public String name() {
            return this.mName;
        }
    }

    abstract class TOperator
    extends Operator
    implements Comparable {
        protected String mName;

        TOperator(String name) {
            super(new OperatorKey("", (long)TestOperatorPlan.this.mNextKey++));
            this.mName = name;
        }

        public int compareTo(Object o) {
            if (!(o instanceof TOperator)) {
                return -1;
            }
            TOperator other = (TOperator)o;
            return this.mName.compareTo(other.mName);
        }
    }
}

