/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.junit.Test;

public class TestOrderBy
extends TestCase {
    private static final int DATALEN = 1024;
    private String[][] DATA = new String[2][1024];
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;
    private File tmpFile;

    public TestOrderBy() throws Throwable {
        DecimalFormat myFormatter = new DecimalFormat("0000000");
        for (int i = 0; i < 1024; ++i) {
            this.DATA[0][i] = myFormatter.format(i);
            this.DATA[1][i] = myFormatter.format(1024 - i - 1);
        }
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    protected void setUp() throws Exception {
        this.tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile));
        for (int i = 0; i < 1024; ++i) {
            ps.println("1\t" + this.DATA[1][i] + "\t" + this.DATA[0][i]);
        }
        ps.close();
    }

    protected void tearDown() throws Exception {
        this.tmpFile.delete();
    }

    private void verify(String query, boolean descending) throws Exception {
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("myid");
        int col = descending ? 1 : 0;
        for (int i = 0; i < 1024; ++i) {
            Tuple t = (Tuple)it.next();
            int value = DataType.toInteger((Object)t.get(1));
            TestOrderBy.assertEquals((int)Integer.parseInt(this.DATA[col][i]), (int)value);
        }
        TestOrderBy.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testTopLevelOrderBy_Star_NoUsing() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY *;", false);
    }

    @Test
    public void testTopLevelOrderBy_Col1_NoUsing() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $1;", false);
    }

    @Test
    public void testTopLevelOrderBy_Col2_NoUsing() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2;", true);
    }

    @Test
    public void testTopLevelOrderBy_Col21_NoUsing() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2, $1;", true);
    }

    @Test
    public void testTopLevelOrderBy_Star_Using() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY * USING org.apache.pig.test.OrdAsc;", false);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY * USING org.apache.pig.test.OrdDesc;", true);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY * USING org.apache.pig.test.OrdDescNumeric;", true);
    }

    @Test
    public void testTopLevelOrderBy_Col1_Using() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $1 USING org.apache.pig.test.OrdAsc;", false);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $1 USING org.apache.pig.test.OrdDesc;", true);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $1 USING org.apache.pig.test.OrdDescNumeric;", true);
    }

    @Test
    public void testTopLevelOrderBy_Col2_Using() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2 USING org.apache.pig.test.OrdAsc;", true);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2 USING org.apache.pig.test.OrdDesc;", false);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2 USING org.apache.pig.test.OrdDescNumeric;", false);
    }

    @Test
    public void testTopLevelOrderBy_Col21_Using() throws Exception {
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2, $1 USING org.apache.pig.test.OrdAsc;", true);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2, $1 USING org.apache.pig.test.OrdDesc;", false);
        this.verify("myid = order (load 'file:" + this.tmpFile + "') BY $2, $1 USING org.apache.pig.test.OrdDescNumeric;", false);
    }

    @Test
    public void testNestedOrderBy_Star_NoUsing() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY *; generate flatten(D); };", false);
    }

    @Test
    public void testNestedOrderBy_Col1_NoUsing() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $1; generate flatten(D); };", false);
    }

    @Test
    public void testNestedOrderBy_Col2_NoUsing() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2; generate flatten(D); };", true);
    }

    @Test
    public void testNestedOrderBy_Col21_NoUsing() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2, $1; generate flatten(D); };", true);
    }

    @Test
    public void testNestedOrderBy_Star_Using() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY * USING " + "org.apache.pig.test.OrdAsc; generate flatten(D); };", false);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY * USING " + "org.apache.pig.test.OrdDesc; generate flatten(D); };", true);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY * USING " + "org.apache.pig.test.OrdDescNumeric; generate flatten(D); };", true);
    }

    @Test
    public void testNestedOrderBy_Col1_Using() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $1 USING " + "org.apache.pig.test.OrdAsc; generate flatten(D); };", false);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $1 USING " + "org.apache.pig.test.OrdDesc; generate flatten(D); };", true);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $1 USING " + "org.apache.pig.test.OrdDescNumeric; generate flatten(D); };", true);
    }

    @Test
    public void testNestedOrderBy_Col2_Using() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2 USING " + "org.apache.pig.test.OrdAsc; generate flatten(D); };", true);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2 USING " + "org.apache.pig.test.OrdDesc; generate flatten(D); };", false);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2 USING " + "org.apache.pig.test.OrdDescNumeric; generate flatten(D); };", false);
    }

    @Test
    public void testNestedOrderBy_Col21_Using() throws Exception {
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2, $1 USING " + "org.apache.pig.test.OrdAsc; generate flatten(D); };", true);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2, $1 USING " + "org.apache.pig.test.OrdDesc; generate flatten(D); };", false);
        this.verify("myid = foreach (group (load 'file:" + this.tmpFile + "') by $0) { D = ORDER $1 BY $2, $1 USING " + "org.apache.pig.test.OrdDescNumeric; generate flatten(D); };", false);
    }
}

