/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.Test;

public class TestPOMapLookUp
extends TestCase {
    Random r = new Random();
    Map<String, Object> map;

    @Test
    public void testMapLookUp() throws PlanException, ExecException {
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        POMapLookUp op = new POMapLookUp(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)op);
        plan.add((Operator)prj);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        for (int i = 0; i < 10; ++i) {
            this.map = GenRandomData.genRandMap(this.r, 10);
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append(this.map);
            for (Map.Entry<String, Object> e : this.map.entrySet()) {
                op.setLookUpKey(e.getKey());
                plan.attachInput(t);
                Result res = op.getNext(this.map);
                TestPOMapLookUp.assertEquals((Object)e.getValue(), (Object)res.result);
            }
        }
    }
}

