/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;

public class TestPONegative
extends TestCase {
    DataBag bag = BagFactory.getInstance().newDefaultBag();
    Random r = new Random();
    TupleFactory tf = TupleFactory.getInstance();
    MiniCluster miniCluster = MiniCluster.buildCluster();
    final int MAX = 10;

    public void testPONegInt() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextInt());
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)10);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)10);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            Integer expected = -((Integer)t.get(0)).intValue();
            int output = (Integer)pn.getNext((Integer)expected).result;
            TestPONegative.assertEquals((int)expected, (int)output);
        }
    }

    public void testPONegIntAndNull() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextInt());
            this.bag.add(t);
            if (this.r.nextInt(3) % 3 != 0) continue;
            t = this.tf.newTuple();
            t.append(null);
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)10);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)10);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            if (t.get(0) == null) {
                Integer output = (Integer)pn.getNext((Integer)((Integer)null)).result;
                TestPONegative.assertEquals(null, (Object)output);
                continue;
            }
            Integer expected = -((Integer)t.get(0)).intValue();
            int output = (Integer)pn.getNext((Integer)expected).result;
            TestPONegative.assertEquals((int)expected, (int)output);
        }
    }

    public void testPONegLong() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextLong());
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)15);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)15);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            Long expected = -((Long)t.get(0)).longValue();
            long output = (Long)pn.getNext((Long)expected).result;
            TestPONegative.assertEquals((long)expected, (long)output);
        }
    }

    public void testPONegLongAndNull() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextLong());
            this.bag.add(t);
            if (this.r.nextInt(3) % 3 != 0) continue;
            t = this.tf.newTuple();
            t.append(null);
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)15);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)15);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            if (t.get(0) == null) {
                Long output = (Long)pn.getNext((Long)((Long)null)).result;
                TestPONegative.assertEquals(null, (Object)output);
                continue;
            }
            Long expected = -((Long)t.get(0)).longValue();
            long output = (Long)pn.getNext((Long)expected).result;
            TestPONegative.assertEquals((long)expected, (long)output);
        }
    }

    public void testPONegDouble() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextDouble());
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)25);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)25);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            Double expected = -((Double)t.get(0)).doubleValue();
            double output = (Double)pn.getNext((Double)expected).result;
            TestPONegative.assertEquals((Object)expected, (Object)output);
        }
    }

    public void testPONegDoubleAndNull() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)this.r.nextDouble());
            this.bag.add(t);
            if (this.r.nextInt(3) % 3 != 0) continue;
            t = this.tf.newTuple();
            t.append(null);
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)25);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)25);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            if (t.get(0) == null) {
                Double output = (Double)pn.getNext((Double)((Double)null)).result;
                TestPONegative.assertEquals(null, (Object)output);
                continue;
            }
            Double expected = -((Double)t.get(0)).doubleValue();
            double output = (Double)pn.getNext((Double)expected).result;
            TestPONegative.assertEquals((Object)expected, (Object)output);
        }
    }

    public void testPONegFloat() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)Float.valueOf(this.r.nextFloat()));
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)20);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)20);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            Float expected = Float.valueOf(-((Float)t.get(0)).floatValue());
            float output = ((Float)pn.getNext((Float)expected).result).floatValue();
            TestPONegative.assertEquals((Object)Float.valueOf(expected.floatValue()), (Object)Float.valueOf(output));
        }
    }

    public void testPONegFloatAndNull() throws PlanException, ExecException {
        for (int i = 0; i < 10; ++i) {
            Tuple t = this.tf.newTuple();
            t.append((Object)Float.valueOf(this.r.nextFloat()));
            this.bag.add(t);
            if (this.r.nextInt(3) % 3 != 0) continue;
            t = this.tf.newTuple();
            t.append(null);
            this.bag.add(t);
        }
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        prj.setResultType((byte)20);
        PONegative pn = new PONegative(new OperatorKey("", this.r.nextLong()), -1, (ExpressionOperator)prj);
        pn.setResultType((byte)20);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)pn);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)pn);
        for (Tuple t : this.bag) {
            plan.attachInput(t);
            if (t.get(0) == null) {
                Float output = (Float)pn.getNext((Float)((Float)null)).result;
                TestPONegative.assertEquals(null, (Object)output);
                continue;
            }
            Float expected = Float.valueOf(-((Float)t.get(0)).floatValue());
            float output = ((Float)pn.getNext((Float)expected).result).floatValue();
            TestPONegative.assertEquals((Object)Float.valueOf(expected.floatValue()), (Object)Float.valueOf(output));
        }
    }

    public void testPONegType() throws Exception {
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.miniCluster.getProperties());
        File f = Util.createInputFile("tmp", "", new String[]{"a", "b", "c"});
        pig.registerQuery("a = load '" + Util.generateURI(f.toString(), pig.getPigContext()) + "';");
        pig.registerQuery("b = foreach a generate SIZE(-1);");
        Iterator it = pig.openIterator("b");
        int i = 0;
        while (it.hasNext()) {
            TestPONegative.assertEquals((Object)1L, (Object)((Tuple)it.next()).get(0));
            ++i;
        }
        TestPONegative.assertEquals((int)3, (int)i);
    }
}

