/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.parameters.ParseException;
import org.junit.Test;

public class TestParamSubPreproc
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private BufferedReader pigIStream;
    private FileWriter pigOStream;
    private FileInputStream pigExResultStream;
    private String basedir = "test/org/apache/pig/test/data";

    public TestParamSubPreproc(String name) {
        super(name);
    }

    @Test
    public void testCmdlineParam() throws Exception {
        this.log.info((Object)"Starting test testCmdlineParam() ...");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date=20080228"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testFileParam() throws Exception {
        this.log.info((Object)"Starting test  testFileParam()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = new String[]{this.basedir + "/ConfFile1.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution from config file failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution from config file failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testShellCommand() throws Exception {
        this.log.info((Object)"Starting test testShellCommand()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input4.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResultDefault.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testPigParamNotResolved() throws Exception {
        block2: {
            this.log.info((Object)"Starting test testPigParamNotResolved()");
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input3.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            try {
                ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            }
            catch (RuntimeException e) {
                if (!e.getMessage().equals("Undefined parameter : 4")) break block2;
                TestParamSubPreproc.fail((String)"Pig supported parameter $4 should not have been resolved.");
            }
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testUndefinedParam() throws Exception {
        this.log.info((Object)"Starting test testUndefinedParam()");
        ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
        this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input2.pig"));
        this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
        String[] arg = null;
        String[] argFiles = null;
        try {
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            TestParamSubPreproc.fail((String)"Should have thrown an Undefined parameter exception");
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.assertEquals((String)e.getMessage(), (String)"Undefined parameter : param");
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testSubstitutionWithinValue() throws Exception {
        this.log.info((Object)"Starting test  testSubstitutionWithinValue()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputSubstitutionWithinValue.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = new String[]{this.basedir + "/ConfFile1.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult4.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution within a value failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution within a value failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testSubstitutionWithinShellCommand() throws Exception {
        this.log.info((Object)"Starting test testSubstitutionWithinShellCommand()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputSubstitutionWithinShellCommand.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult4.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testCmdlineParamPriortoDeclare() throws Exception {
        this.log.info((Object)"Starting test testCmdlineParamPriortoDeclare()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input2.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"param='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResultCmdLnPriorDeclare.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution of command line arg. prior to declare stmt failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution of command line arg. prior to declare stmt failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testCmdnameAsParamDeclare() throws Exception {
        this.log.info((Object)"Starting test testCmdnameAsParamDeclare()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputCmdnameAsParamDeclare.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult4.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution for a command with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution for a command with shell command failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testMultipleCmdlineParam() throws Exception {
        this.log.info((Object)"Starting test testCmdnameAsParamDeclare()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='092487'", "date='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testFileParamsFromMultipleFiles() throws Exception {
        this.log.info((Object)"Starting test testFileParamsFromMultipleFiles()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = new String[]{this.basedir + "/ConfFile1.txt", this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Parameter substitution from multiple config files failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Parameter substitution from multiple config files failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testSameParamInMultipleFiles() throws Exception {
        this.log.info((Object)"Starting test testSameParamInMultipleFiles()");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = new String[]{this.basedir + "/ConfFile3.txt", this.basedir + "/ConfFile2.txt", this.basedir + "/ConfFile1.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Same Parameter substitution from multiple config files failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Same Parameter substitution from multiple config files failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testMultipleParamsFromSingleFile() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = new String[]{this.basedir + "/ConfFileSameParamMultipleTimes.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testEmptyCommentLineinConfigfile() throws Exception {
        ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
        this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
        this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
        String[] arg = null;
        String[] argFiles = new String[]{this.basedir + "/ConfFileWithEmptyComments.txt"};
        try {
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testInvalidLineinConfigfile() throws Exception {
        ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
        this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
        this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
        String[] arg = null;
        String[] argFiles = new String[]{this.basedir + "/ConfFileWithInvalidLines.txt"};
        try {
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            TestParamSubPreproc.fail((String)"Should have thrown an exception");
        }
        catch (ParseException e) {
            TestParamSubPreproc.assertTrue((boolean)e.getMessage().startsWith("Encountered \" <IDENTIFIER> \"is \"\" at line 2, column 6."));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testValidLinesinConfigfile() throws Exception {
        ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
        this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleParams.pig"));
        this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
        String[] arg = null;
        String[] argFiles = new String[]{this.basedir + "/ConfFileWithValidLines.txt"};
        try {
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineFileCombo() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = new String[]{this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineFileComboDuplicate() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = new String[]{this.basedir + "/ConfFileDuplicates.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineFileDeclareCombo() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputThreeParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = new String[]{this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineFileDeclareComboDuplicates() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputThreeParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'", "tableName=\"skip this\""};
            String[] argFiles = new String[]{this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testMultipleDeclareScope() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputMultipleDeclares.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResultMulDecs.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testDefaultParam() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputDefault.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineFileDeclareDefaultComboDuplicates() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputThreeParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'", "tableName=\"skip this\""};
            String[] argFiles = new String[]{this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testMultipleParamsinSingleLine() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputThreeParams.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = new String[]{this.basedir + "/ConfFile2.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testSubstituteWithinLiteral() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testEscaping() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputEscape.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult2.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }

    @Test
    public void testCmdlineParamWithInlineCmd() throws Exception {
        this.log.info((Object)"Starting test testCmdlineParamWithInlineCmd() ...");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input1.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date=`perl -e 'print \"20080228\n20070101\"' | head -n 1`"};
            if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                arg[0] = "date=`perl -e 'print \\\"20080228\n20070101\\\"' | head -n 1`";
            }
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testNoVars() throws Exception {
        this.log.info((Object)"Starting test testNoVars() ...");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputNoVars.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = null;
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/inputNoVars.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testComplexVals() throws Exception {
        this.log.info((Object)"Starting test testComplexVals() ...");
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/input5.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"loadfile = /user/pig/tests/data/singlefile/textdoc.txt"};
            String[] argFiles = new String[]{this.basedir + "/ConfFileComplexVal.txt"};
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResult3.txt");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Command line parameter substitution failed. Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
        this.log.info((Object)"Done");
    }

    @Test
    public void testCommentWithParam() throws Exception {
        try {
            String resLine;
            String exLine;
            ParameterSubstitutionPreprocessor ps = new ParameterSubstitutionPreprocessor(50);
            this.pigIStream = new BufferedReader(new FileReader(this.basedir + "/inputComment.pig"));
            this.pigOStream = new FileWriter(this.basedir + "/output1.pig");
            String[] arg = new String[]{"date='20080228'"};
            String[] argFiles = null;
            ps.genSubstitutedFile(this.pigIStream, (Writer)this.pigOStream, arg, argFiles);
            FileInputStream pigResultStream = new FileInputStream(this.basedir + "/output1.pig");
            this.pigExResultStream = new FileInputStream(this.basedir + "/ExpectedResultComment.pig");
            BufferedReader inExpected = new BufferedReader(new InputStreamReader(this.pigExResultStream));
            BufferedReader inResult = new BufferedReader(new InputStreamReader(pigResultStream));
            int lineNum = 0;
            while (true) {
                ++lineNum;
                exLine = inExpected.readLine();
                resLine = inResult.readLine();
                if (exLine == null || resLine == null) break;
                TestParamSubPreproc.assertEquals((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum), (String)exLine.trim(), (String)resLine.trim());
            }
            if (exLine != null || resLine != null) {
                TestParamSubPreproc.fail((String)("Expected : " + exLine + " , but got : " + resLine + " in line num : " + lineNum));
            }
            inExpected.close();
            inResult.close();
        }
        catch (ParseException e) {
            TestParamSubPreproc.fail((String)("Got ParseException : " + e.getMessage()));
        }
        catch (RuntimeException e) {
            TestParamSubPreproc.fail((String)("Got RuntimeException : " + e.getMessage()));
        }
        catch (Error e) {
            TestParamSubPreproc.fail((String)("Got error : " + e.getMessage()));
        }
    }
}

