/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PColFilterExtractor;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPartitionFilterOptimization
extends TestCase {
    LogicalPlanTester lpTester;

    protected void setUp() throws Exception {
        this.lpTester = new LogicalPlanTester();
        this.lpTester.buildPlan("a = load 'foo' as (srcid, mrkt, dstid, name, age);");
    }

    @Test
    public void testSimpleMixed() throws FrontendException {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by srcid == 10 and name == 'foo';");
        this.test(lp, Arrays.asList("srcid"), "(srcid == 10)", "(name == 'foo')");
    }

    @Test
    public void testNoPartFilter() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by age == 20 and name == 'foo';");
        this.test(lp, Arrays.asList("srcid"), null, "((age == 20) and (name == 'foo'))");
    }

    @Test
    public void testOnlyPartFilter1() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by srcid > 20 and mrkt == 'us';");
        this.test(lp, Arrays.asList("srcid", "mrkt"), "((srcid > 20) and (mrkt == 'us'))", null);
    }

    @Test
    public void testOnlyPartFilter2() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by mrkt == 'us';");
        this.test(lp, Arrays.asList("srcid", "mrkt"), "(mrkt == 'us')", null);
    }

    @Test
    public void testOnlyPartFilter3() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by srcid == 20 or mrkt == 'us';");
        this.test(lp, Arrays.asList("srcid", "mrkt"), "((srcid == 20) or (mrkt == 'us'))", null);
    }

    @Test
    public void testMixed1() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (age < 20 and  mrkt == 'us') and (srcid == 10 and name == 'foo');");
        this.test(lp, Arrays.asList("srcid", "mrkt"), "((mrkt == 'us') and (srcid == 10))", "((age < 20) and (name == 'foo'))");
    }

    @Test
    public void testMixed2() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (age >= 20 and  mrkt == 'us') and (srcid == 10 and dstid == 15);");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "((mrkt == 'us') and ((srcid == 10) and (dstid == 15)))", "(age >= 20)");
    }

    @Test
    public void testMixed3() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by age >= 20 and  mrkt == 'us' and srcid == 10;");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "((mrkt == 'us') and (srcid == 10))", "(age >= 20)");
    }

    @Test
    public void testMixed4() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by age >= 20 and  mrkt == 'us' and name == 'foo' and srcid == dstid;");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "((mrkt == 'us') and (srcid == dstid))", "((age >= 20) and (name == 'foo'))");
    }

    @Test
    public void testMixed5() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (srcid == 10 or mrkt == 'us') and name == 'foo' and dstid == 30;");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "(((srcid == 10) or (mrkt == 'us')) and (dstid == 30))", "(name == 'foo')");
    }

    @Test
    public void testMixed6() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by dstid == 30 and (srcid == 10 or mrkt == 'us') and name == 'foo';");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "((dstid == 30) and ((srcid == 10) or (mrkt == 'us')))", "(name == 'foo')");
    }

    @Test
    public void testMixedArith() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by mrkt == 'us' and srcid * 10 == 150 + 20 and age != 15;");
        this.test(lp, Arrays.asList("srcid", "dstid", "mrkt"), "((mrkt == 'us') and ((srcid * 10) == (150 + 20)))", "(age != 15)");
    }

    @Test
    public void testNegPColConditionWithNonPCol() throws Exception {
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by srcid > age;");
        this.negativeTest(lp, Arrays.asList("srcid"), 1111);
        lp = this.lpTester.buildPlan("b = filter a by srcid + age == 20;");
        this.negativeTest(lp, Arrays.asList("srcid"), 1111);
        lp = this.lpTester.buildPlan("b = filter a by srcid > 10 or name == 'foo';");
        this.negativeTest(lp, Arrays.asList("srcid"), 1111);
    }

    @Test
    public void testNegPColInWrongPlaces() throws Exception {
        int expectedErrCode = 1112;
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (srcid > 10 and name == 'foo') or dstid == 10;");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid"), expectedErrCode);
        expectedErrCode = 1110;
        lp = this.lpTester.buildPlan("b = filter a by CONCAT(mrkt, '_10') == 'US_10' and age == 20;");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
        lp = this.lpTester.buildPlan("b = filter a by mrkt matches '.*us.*' and age < 15;");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
        lp = this.lpTester.buildPlan("b = filter a by (int)mrkt == 10 and name matches '.*foo.*';");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
        lp = this.lpTester.buildPlan("b = filter a by (mrkt == 'us' ? age : age + 10) == 40 and name matches '.*foo.*';");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
        lp = this.lpTester.buildPlan("b = filter a by (mrkt is null) and name matches '.*foo.*';");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
        lp = this.lpTester.buildPlan("b = filter a by (mrkt is not null) and name matches '.*foo.*';");
        this.negativeTest(lp, Arrays.asList("srcid", "dstid", "mrkt"), expectedErrCode);
    }

    @Test
    public void testColNameMapping1() throws Exception {
        TestLoader.partFilter = null;
        this.lpTester.buildPlan("a = load 'foo' using " + TestLoader.class.getName() + "('srcid:int, mrkt:chararray, dstid:int, name:chararray, age:int', " + "'srcid,mrkt') as (f1, f2, f3, f4, f5);");
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (f5 >= 20 and f2 == 'us') and (f1 == 10 and f3 == 15);");
        this.lpTester.typeCheckPlan(lp);
        this.lpTester.optimizePlan(lp);
        TestPartitionFilterOptimization.assertEquals((String)"checking partition filter:", (String)"((mrkt == 'us') and (srcid == 10))", (String)TestLoader.partFilter.toString());
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        String actual = PColFilterExtractor.getExpression((ExpressionOperator)((ExpressionOperator)filter.getComparisonPlan().getLeaves().get(0))).toString().toLowerCase();
        TestPartitionFilterOptimization.assertEquals((String)"checking trimmed filter expression:", (String)"((f5 >= 20) and (f3 == 15))", (String)actual);
    }

    @Test
    public void testColNameMapping2() throws Exception {
        TestLoader.partFilter = null;
        this.lpTester.buildPlan("a = load 'foo' using " + TestLoader.class.getName() + "('srcid:int, mrkt:chararray, dstid:int, name:chararray, age:int', " + "'srcid') as (f1, f2, f3, f4, f5);");
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by f5 >= 20 and f2 == 'us' and f3 == 15;");
        this.lpTester.typeCheckPlan(lp);
        this.lpTester.optimizePlan(lp);
        TestPartitionFilterOptimization.assertEquals((String)"checking partition filter:", null, (Object)TestLoader.partFilter);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        String actual = PColFilterExtractor.getExpression((ExpressionOperator)((ExpressionOperator)filter.getComparisonPlan().getLeaves().get(0))).toString().toLowerCase();
        TestPartitionFilterOptimization.assertEquals((String)"checking trimmed filter expression:", (String)"(((f5 >= 20) and (f2 == 'us')) and (f3 == 15))", (String)actual);
    }

    @Test
    public void testColNameMapping3() throws Exception {
        TestLoader.partFilter = null;
        this.lpTester.buildPlan("a = load 'foo' using " + TestLoader.class.getName() + "('srcid:int, mrkt:chararray, dstid:int, name:chararray, age:int', " + "'srcid,mrkt,dstid,age') as (f1, f2, f3, f4, f5);");
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (f5 >= 20 or f2 == 'us') and (f1 == 10 and f3 == 15);");
        this.lpTester.typeCheckPlan(lp);
        this.lpTester.optimizePlan(lp);
        TestPartitionFilterOptimization.assertEquals((String)"checking partition filter:", (String)"(((age >= 20) or (mrkt == 'us')) and ((srcid == 10) and (dstid == 15)))", (String)TestLoader.partFilter.toString());
        Iterator it = lp.iterator();
        TestPartitionFilterOptimization.assertTrue((String)"Checking that filter has been removed since it contained only conditions on partition cols:", (boolean)(it.next() instanceof LOLoad));
        TestPartitionFilterOptimization.assertFalse((String)"Checking that filter has been removed since it contained only conditions on partition cols:", (boolean)it.hasNext());
    }

    @Test
    public void testColNameMapping4() throws Exception {
        TestLoader.partFilter = null;
        this.lpTester.buildPlan("a = load 'foo' using " + TestLoader.class.getName() + "('srcid:int, mrkt:chararray, dstid:int, name:chararray, age:int', " + "'srcid,mrkt') as (f1, f2, f3);");
        LogicalPlan lp = this.lpTester.buildPlan("b = filter a by (age >= 20 and f2 == 'us') and (f1 == 10 and f3 == 15);");
        this.lpTester.typeCheckPlan(lp);
        this.lpTester.optimizePlan(lp);
        TestPartitionFilterOptimization.assertEquals((String)"checking partition filter:", (String)"((mrkt == 'us') and (srcid == 10))", (String)TestLoader.partFilter.toString());
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        String actual = PColFilterExtractor.getExpression((ExpressionOperator)((ExpressionOperator)filter.getComparisonPlan().getLeaves().get(0))).toString().toLowerCase();
        TestPartitionFilterOptimization.assertEquals((String)"checking trimmed filter expression:", (String)"((age >= 20) and (f3 == 15))", (String)actual);
    }

    @Test
    public void testColNameMapping5() throws Exception {
        TestLoader.partFilter = null;
        this.lpTester.buildPlan("a = load 'foo' using " + TestLoader.class.getName() + "('mrkt:chararray, a1:chararray, a2:chararray, srcid:int, bcookie:chararray', " + "'srcid');");
        this.lpTester.buildPlan("b = load 'bar' using " + TestLoader.class.getName() + "('dstid:int, b1:int, b2:int, srcid:int, bcookie:chararray, mrkt:chararray'," + "'srcid');");
        this.lpTester.buildPlan("a1 = filter a by srcid == 10;");
        this.lpTester.buildPlan("b1 = filter b by srcid == 20;");
        this.lpTester.buildPlan("c = join a1 by bcookie, b1 by bcookie;");
        LogicalPlan lp = this.lpTester.buildPlan("d = foreach c generate $4 as bcookie:chararray, $5 as dstid:int, $0 as mrkt:chararray;");
        new PlanSetter(lp).visit();
        this.lpTester.typeCheckPlan(lp);
        this.lpTester.optimizePlan(lp);
        TestPartitionFilterOptimization.assertEquals((String)"checking partition filter:", (String)"(srcid == 20)", (String)TestLoader.partFilter.toString());
        int counter = 0;
        Iterator iter = lp.getKeys().values().iterator();
        while (iter.hasNext()) {
            TestPartitionFilterOptimization.assertTrue((!(iter.next() instanceof LOFilter) ? 1 : 0) != 0);
            ++counter;
        }
        TestPartitionFilterOptimization.assertEquals((int)counter, (int)6);
    }

    private PColFilterExtractor test(LogicalPlan lp, List<String> partitionCols, String expPartFilterString, String expFilterString) throws FrontendException {
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        PColFilterExtractor pColExtractor = new PColFilterExtractor(filter.getComparisonPlan(), partitionCols);
        pColExtractor.visit();
        if (expPartFilterString == null) {
            TestPartitionFilterOptimization.assertEquals((String)"Checking partition column filter:", null, (Object)pColExtractor.getPColCondition());
        } else {
            TestPartitionFilterOptimization.assertEquals((String)"Checking partition column filter:", (String)expPartFilterString.toLowerCase(), (String)pColExtractor.getPColCondition().toString().toLowerCase());
        }
        if (expFilterString == null) {
            TestPartitionFilterOptimization.assertTrue((String)"Check that filter can be removed:", (boolean)pColExtractor.isFilterRemovable());
        } else {
            String actual = PColFilterExtractor.getExpression((ExpressionOperator)((ExpressionOperator)filter.getComparisonPlan().getLeaves().get(0))).toString().toLowerCase();
            TestPartitionFilterOptimization.assertEquals((String)"checking trimmed filter expression:", (String)expFilterString, (String)actual);
        }
        return pColExtractor;
    }

    private void negativeTest(LogicalPlan lp, List<String> partitionCols, int expectedErrorCode) {
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        PColFilterExtractor pColExtractor = new PColFilterExtractor(filter.getComparisonPlan(), partitionCols);
        try {
            pColExtractor.visit();
        }
        catch (Exception e) {
            TestPartitionFilterOptimization.assertEquals((String)"Checking if exception has right error code", (int)expectedErrorCode, (int)LogUtils.getPigException((Throwable)e).getErrorCode());
            return;
        }
        TestPartitionFilterOptimization.fail((String)"Exception expected!");
    }

    public static class TestLoader
    extends LoadFunc
    implements LoadMetadata {
        Schema schema;
        String[] partCols;
        static Expression partFilter = null;

        public TestLoader(String schemaString, String commaSepPartitionCols) throws ParseException {
            this.schema = Util.getSchemaFromString(schemaString);
            this.partCols = commaSepPartitionCols.split(",");
        }

        public InputFormat getInputFormat() throws IOException {
            return null;
        }

        public Tuple getNext() throws IOException {
            return null;
        }

        public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        }

        public void setLocation(String location, Job job) throws IOException {
        }

        public String[] getPartitionKeys(String location, Job job) throws IOException {
            return this.partCols;
        }

        public ResourceSchema getSchema(String location, Job job) throws IOException {
            return new ResourceSchema(this.schema);
        }

        public ResourceStatistics getStatistics(String location, Job job) throws IOException {
            return null;
        }

        public void setPartitionFilter(Expression partitionFilter) throws IOException {
            partFilter = partitionFilter;
        }
    }
}

