/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestPhyOp
extends TestCase {
    PhysicalOperator op;
    PhysicalOperator inpOp;
    Tuple t;

    @Before
    public void setUp() throws Exception {
        this.op = GenPhyOp.topFilterOp();
        this.inpOp = GenPhyOp.topFilterOpWithExPlan(25, 10);
        this.t = GenRandomData.genRandSmallBagTuple(new Random(), 10, 100);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testProcessInput() throws ExecException {
        Result res = this.op.processInput();
        TestPhyOp.assertEquals((byte)3, (byte)res.returnStatus);
        this.op.attachInput(this.t);
        res = this.op.processInput();
        TestPhyOp.assertEquals((byte)0, (byte)res.returnStatus);
        TestPhyOp.assertEquals((Object)this.t, (Object)res.result);
        this.op.detachInput();
        res = this.op.processInput();
        TestPhyOp.assertEquals((byte)3, (byte)res.returnStatus);
        ArrayList<PhysicalOperator> inp = new ArrayList<PhysicalOperator>();
        inp.add(this.inpOp);
        this.op.setInputs(inp);
        this.op.processInput();
        TestPhyOp.assertEquals((byte)3, (byte)res.returnStatus);
        this.inpOp.attachInput(this.t);
        res = this.op.processInput();
        TestPhyOp.assertEquals((byte)0, (byte)res.returnStatus);
        TestPhyOp.assertEquals((Object)this.t, (Object)res.result);
        this.inpOp.detachInput();
        res = this.op.processInput();
        TestPhyOp.assertEquals((byte)3, (byte)res.returnStatus);
    }
}

