/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestPi
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    File datFile;
    private long defaultBlockSize = new Configuration().getLong("dfs.block.size", 0L);
    private long total = (this.defaultBlockSize >> 20) / 10L << 20;
    private int inCircle = 0;
    MiniCluster cluster = MiniCluster.buildCluster();
    private long totalLength = 0L;
    private long totalLengthTest = 0L;
    PigServer pig;
    String fileName;
    String tmpFile1;

    @Before
    protected void setUp() throws Exception {
        this.log.info((Object)"Generating test data...");
        this.log.info((Object)("Default block size = " + this.defaultBlockSize));
        this.log.info((Object)("Total no. of iterations to run for test data = " + this.total));
        this.datFile = File.createTempFile("PiTest", ".dat");
        FileOutputStream dat = new FileOutputStream(this.datFile);
        Random rand = new Random();
        int i = 0;
        while ((long)i < this.total) {
            double y1;
            StringBuffer sb = new StringBuffer();
            Double x = new Double(rand.nextDouble());
            Double y = new Double(rand.nextDouble());
            double x1 = x - 0.5;
            double sq_dist = x1 * x1 + (y1 = y - 0.5) * y1;
            if (sq_dist <= 0.25) {
                ++this.inCircle;
            }
            this.totalLength += (long)String.valueOf(sq_dist).length();
            sb.append(x.toString() + ":" + y.toString() + "\n");
            dat.write(sb.toString().getBytes());
            ++i;
        }
        dat.close();
        try {
            this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        }
        catch (ExecException e) {
            IOException ioe = new IOException("Failed to create Pig Server");
            ioe.initCause(e);
            throw ioe;
        }
        this.fileName = "'" + FileLocalizer.hadoopify((String)this.datFile.toString(), (PigContext)this.pig.getPigContext()) + "'";
        this.tmpFile1 = "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pig.getPigContext()).toString() + "'";
        this.datFile.delete();
    }

    @After
    protected void tearDown() throws Exception {
    }

    @Test
    public void testPi() throws Exception {
        this.pig.registerQuery("A = load " + this.fileName + " using PigStorage(':');");
        this.pig.registerQuery("B = foreach A generate $0 - '0.5' as d1, $1 - '0.5' as d2;");
        this.pig.registerQuery("C = foreach B generate $0 * $0 as m1, $1 * $1 as m2;");
        this.pig.registerQuery("D = foreach C generate $0 + $1 as s1;");
        this.pig.registerQuery("D = foreach D generate $0, ARITY($0);");
        this.pig.store("D", this.tmpFile1);
        this.pig.registerQuery("E = filter D by $0 <= '0.25';");
        this.pig.registerQuery("F = group D by $1;");
        this.pig.registerQuery("G = group E by $1;");
        this.pig.registerQuery("J = foreach F generate COUNT($1);");
        this.pig.registerQuery("K = foreach G generate COUNT($1);");
        Iterator Total = this.pig.openIterator("J");
        Iterator InCircle = this.pig.openIterator("K");
        int totalPoints = DataType.toInteger((Object)((Tuple)Total.next()).get(0));
        int inCirclePoints = DataType.toInteger((Object)((Tuple)InCircle.next()).get(0));
        this.log.info((Object)("Value of PI = " + 4.0 * (double)this.inCircle / (double)this.total));
        this.log.info((Object)("Value of PI (From Test data) = " + 4.0 * (double)inCirclePoints / (double)totalPoints));
        Iterator lengthTest = this.pig.openIterator("D");
        while (lengthTest.hasNext()) {
            Tuple temp = (Tuple)lengthTest.next();
            this.totalLengthTest += (long)temp.get(0).toString().length();
        }
        TestPi.assertEquals((long)totalPoints, (long)this.total);
        TestPi.assertEquals((int)inCirclePoints, (int)this.inCircle);
        TestPi.assertEquals((long)this.totalLengthTest, (long)this.totalLength);
    }
}

