/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.parser.QueryParser;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.Util;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPigScriptParser
extends TestCase {
    @Test
    public void testParserWithEscapeCharacters() throws Exception {
        HashMap<LogicalOperator, LogicalPlan> aliases = new HashMap<LogicalOperator, LogicalPlan>();
        HashMap<OperatorKey, LogicalOperator> opTable = new HashMap<OperatorKey, LogicalOperator>();
        HashMap<String, LogicalOperator> aliasOp = new HashMap<String, LogicalOperator>();
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        PigContext pigContext = new PigContext(ExecType.LOCAL, new Properties());
        pigContext.connect();
        String tempFile = this.prepareTempFile();
        String query = String.format("A = LOAD '%s' ;", Util.encodeEscape(tempFile));
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        QueryParser parser = new QueryParser((InputStream)in, pigContext, "scope", aliases, opTable, aliasOp, fileNameMap);
        LogicalPlan lp = parser.Parse();
        query = "B1 = filter A by $0 eq 'This is a test string' ;";
        this.checkParsedConstContent(aliases, opTable, pigContext, aliasOp, fileNameMap, query, "This is a test string");
        query = "B2 = filter A by $0 eq 'This is a test \\'string' ;";
        this.checkParsedConstContent(aliases, opTable, pigContext, aliasOp, fileNameMap, query, "This is a test 'string");
        query = "B2 = filter A by $0 eq 'This is a test \\\\.string' ;";
        this.checkParsedConstContent(aliases, opTable, pigContext, aliasOp, fileNameMap, query, "This is a test \\.string");
        query = "B3 = filter A by $0 eq 'This is a test \\nstring' ;";
        this.checkParsedConstContent(aliases, opTable, pigContext, aliasOp, fileNameMap, query, "This is a test \nstring");
        query = "B4 = filter A by $0 eq 'This is a test \\uD30C\\uC774string' ;";
        this.checkParsedConstContent(aliases, opTable, pigContext, aliasOp, fileNameMap, query, "This is a test \ud30c\uc774string");
    }

    @Test
    public void testDefineUDF() throws Exception {
        String[] inputData = new String[]{"dshfdskfwww.xyz.com/sportsjoadfjdslpdshfdskfwww.xyz.com/sportsjoadfjdsl", "kas;dka;sd", "jsjsjwww.xyz.com/sports", "jsdLSJDcom/sports", "wwwJxyzMcom/sports"};
        File f = Util.createFile(inputData);
        String[] queryLines = new String[]{"define minelogs org.apache.pig.test.RegexGroupCount('www\\\\.xyz\\\\.com/sports');", "A = load 'file://" + f.getAbsolutePath() + "'  using PigStorage() as (source : chararray);", "B = foreach A generate minelogs(source) as sportslogs;"};
        PigServer ps = new PigServer(ExecType.LOCAL);
        for (String line : queryLines) {
            ps.registerQuery(line);
        }
        Iterator it = ps.openIterator("B");
        int[] expectedResults = new int[]{2, 0, 1, 0, 0};
        int i = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestPigScriptParser.assertEquals((Object)expectedResults[i++], (Object)t.get(0));
        }
    }

    private void checkParsedConstContent(Map<LogicalOperator, LogicalPlan> aliases, Map<OperatorKey, LogicalOperator> opTable, PigContext pigContext, Map<String, LogicalOperator> aliasOp, Map<String, String> fileNameMap, String query, String expectedContent) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        QueryParser parser = new QueryParser((InputStream)in, pigContext, "scope", aliases, opTable, aliasOp, fileNameMap);
        LogicalPlan lp = parser.Parse();
        LogicalOperator root = (LogicalOperator)lp.getRoots().get(0);
        LogicalOperator filter = (LogicalOperator)lp.getSuccessors((Operator)root).get(0);
        LogicalPlan comparisonPlan = ((LOFilter)filter).getComparisonPlan();
        List comparisonPlanRoots = comparisonPlan.getRoots();
        LogicalOperator compRootOne = (LogicalOperator)comparisonPlanRoots.get(0);
        LogicalOperator compRootTwo = (LogicalOperator)comparisonPlanRoots.get(1);
        if (compRootOne instanceof LOConst) {
            TestPigScriptParser.assertTrue((String)"Must be equal", (boolean)((String)((LOConst)compRootOne).getValue()).equals(expectedContent));
        } else {
            TestPigScriptParser.assertTrue((String)"Must be equal", (boolean)((String)((LOConst)compRootTwo).getValue()).equals(expectedContent));
        }
    }

    private String prepareTempFile() throws IOException {
        File inputFile = File.createTempFile("test", "txt");
        inputFile.deleteOnExit();
        PrintStream ps = new PrintStream(new FileOutputStream(inputFile));
        ps.println("hohoho");
        ps.close();
        return inputFile.getPath();
    }
}

