/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPigServer
extends TestCase {
    private PigServer pig = null;
    MiniCluster cluster = MiniCluster.buildCluster();
    private File stdOutRedirectedFile;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    @Before
    public void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.stdOutRedirectedFile = new File("stdout.redirected");
        try {
            if (!this.stdOutRedirectedFile.createNewFile()) {
                TestPigServer.fail((String)"Unable to create input files");
            }
        }
        catch (IOException e) {
            TestPigServer.fail((String)("Unable to create input files:" + e.getMessage()));
        }
    }

    @After
    public void tearDown() throws Exception {
        this.pig = null;
        this.stdOutRedirectedFile.delete();
    }

    private static void verifyStringContained(List<URL> list, String name, boolean included) {
        Iterator<URL> iter = list.iterator();
        boolean nameIsSubstring = false;
        int count = 0;
        while (iter.hasNext()) {
            if (!iter.next().toString().contains(name)) continue;
            nameIsSubstring = true;
            ++count;
        }
        if (included) {
            TestPigServer.assertTrue((boolean)nameIsSubstring);
            TestPigServer.assertTrue((count == 1 ? 1 : 0) != 0);
        } else {
            TestPigServer.assertFalse((boolean)nameIsSubstring);
        }
    }

    private static void createFakeJarFile(String location, String name) throws IOException {
        TestPigServer.assertFalse((boolean)new File(name).canRead());
        System.err.println("Location: " + location);
        TestPigServer.assertTrue((boolean)new File(location).mkdirs());
        TestPigServer.assertTrue((boolean)new File(location + FILE_SEPARATOR + name).createNewFile());
    }

    private static void registerNewResource(String file) throws Exception {
        URL urlToAdd = new File(file).toURI().toURL();
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method addMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addMethod.setAccessible(true);
        addMethod.invoke((Object)sysLoader, urlToAdd);
    }

    @Test
    public void testRegisterJarFileNotPresent() throws Throwable {
        String jarName = "BadFileNameTestJarNotPresent.jar";
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, false);
        boolean exceptionRaised = false;
        try {
            this.pig.registerJar(jarName);
        }
        catch (IOException e) {
            exceptionRaised = true;
        }
        TestPigServer.assertTrue((boolean)exceptionRaised);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, false);
    }

    @Test
    public void testRegisterJarLocalDir() throws Throwable {
        String dir1 = "test1_register_jar_local";
        String dir2 = "test2_register_jar_local";
        String jarLocation = dir1 + FILE_SEPARATOR + dir2 + FILE_SEPARATOR;
        String jarName = "TestRegisterJarLocal.jar";
        TestPigServer.createFakeJarFile(jarLocation, jarName);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, false);
        boolean exceptionRaised = false;
        try {
            this.pig.registerJar(jarLocation + jarName);
        }
        catch (IOException e) {
            exceptionRaised = true;
        }
        TestPigServer.assertFalse((boolean)exceptionRaised);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, true);
        TestPigServer.assertTrue((boolean)new File(jarLocation + jarName).delete());
        new File(dir1 + FILE_SEPARATOR + dir2).delete();
        new File(dir1).delete();
    }

    @Test
    public void testRegisterJarFromResources() throws Throwable {
        String dir = "test_register_jar_res_dir";
        String subDir1 = "test_register_jar_res_sub_dir1";
        String subDir2 = "test_register_jar_res_sub_dir2";
        String jarName = "TestRegisterJarFromRes.jar";
        String jarLocation1 = dir + FILE_SEPARATOR + subDir1 + FILE_SEPARATOR;
        String jarLocation2 = dir + FILE_SEPARATOR + subDir2 + FILE_SEPARATOR;
        TestPigServer.createFakeJarFile(jarLocation1, jarName);
        TestPigServer.createFakeJarFile(jarLocation2, jarName);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, false);
        TestPigServer.registerNewResource(jarLocation1);
        TestPigServer.registerNewResource(jarLocation2);
        boolean exceptionRaised = false;
        try {
            this.pig.registerJar(jarName);
        }
        catch (IOException e) {
            exceptionRaised = true;
        }
        TestPigServer.assertFalse((boolean)exceptionRaised);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, true);
        TestPigServer.assertTrue((boolean)new File(jarLocation1 + jarName).delete());
        TestPigServer.assertTrue((boolean)new File(jarLocation2 + jarName).delete());
        new File(jarLocation1).delete();
        new File(jarLocation2).delete();
        new File(dir).delete();
    }

    @Test
    public void testRegisterJarResourceInJar() throws Throwable {
        String dir = "test_register_jar_res_in_jar";
        String subDir = "sub_dir";
        String jarName = "TestRegisterJarNonEmpty.jar";
        String className = "TestRegisterJar";
        String javaSrc = "package " + subDir + "; class " + className + " { }";
        new File(dir + FILE_SEPARATOR + subDir).mkdirs();
        FileOutputStream outStream = new FileOutputStream(new File(dir + FILE_SEPARATOR + subDir + FILE_SEPARATOR + className + ".java"));
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        outWriter.write(javaSrc);
        outWriter.close();
        int status = Util.executeJavaCommand("javac " + dir + FILE_SEPARATOR + subDir + FILE_SEPARATOR + className + ".java");
        TestPigServer.assertTrue((status == 0 ? 1 : 0) != 0);
        new File(dir + FILE_SEPARATOR + subDir + FILE_SEPARATOR + className + ".java").delete();
        status = Util.executeJavaCommand("jar -cf " + dir + FILE_SEPARATOR + jarName + " " + "-C " + dir + " " + subDir);
        TestPigServer.assertTrue((status == 0 ? 1 : 0) != 0);
        new File(dir + FILE_SEPARATOR + subDir + FILE_SEPARATOR + className + ".class").delete();
        new File(dir + FILE_SEPARATOR + subDir).delete();
        TestPigServer.registerNewResource(dir + FILE_SEPARATOR + jarName);
        boolean exceptionRaised = false;
        try {
            this.pig.registerJar("sub_dir/TestRegisterJar.class");
        }
        catch (IOException e) {
            exceptionRaised = true;
        }
        TestPigServer.assertFalse((boolean)exceptionRaised);
        TestPigServer.verifyStringContained(this.pig.getPigContext().extraJars, jarName, true);
        new File(dir + FILE_SEPARATOR + jarName).delete();
        new File(dir).delete();
    }

    @Test
    public void testDescribeLoad() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        System.setOut(out);
        this.pig.dumpSchema("a");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("a: {field1: int,field2: float,field3: chararray}") ? 1 : 0) != 0);
        }
        reader.close();
    }

    @Test
    public void testDescribeFilter() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = filter a by field1 > 10;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("b: {field1: int,field2: float,field3: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeDistinct() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = distinct a ;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("b: {field1: int,field2: float,field3: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeSort() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = order a by * desc;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("b: {field1: int,field2: float,field3: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeLimit() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = limit a 10;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("b: {field1: int,field2: float,field3: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeForeach() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = foreach a generate field1 + 10;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("b: {int}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeForeachFail() throws Throwable {
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = foreach a generate field1 + 10;");
        try {
            this.pig.dumpSchema("c");
            TestPigServer.fail((String)"Error expected");
        }
        catch (Exception e) {
            TestPigServer.assertTrue((boolean)e.getMessage().contains("Unable to describe schema for alias c"));
        }
    }

    @Test
    public void testDescribeForeachNoSchema() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' ;");
        this.pig.registerQuery("b = foreach a generate *;");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("Schema for b unknown.") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeCogroup() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = load 'b' as (field4, field5: double, field6: chararray );");
        this.pig.registerQuery("c = cogroup a by field1, b by field4;");
        System.setOut(out);
        this.pig.dumpSchema("c");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("c: {group: int,a: {field1: int,field2: float,field3: chararray},b: {field4: bytearray,field5: double,field6: chararray}}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeCross() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = load 'b' as (field4, field5: double, field6: chararray );");
        this.pig.registerQuery("c = cross a, b;");
        System.setOut(out);
        this.pig.dumpSchema("c");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("c: {a::field1: int,a::field2: float,a::field3: chararray,b::field4: bytearray,b::field5: double,b::field6: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeJoin() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = load 'b' as (field4, field5: double, field6: chararray );");
        this.pig.registerQuery("c = join a by field1, b by field4;");
        System.setOut(out);
        this.pig.dumpSchema("c");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertEquals((String)"c: {a::field1: int,a::field2: float,a::field3: chararray,b::field4: bytearray,b::field5: double,b::field6: chararray}", (String)s);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeUnion() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (field1: int, field2: float, field3: chararray );");
        this.pig.registerQuery("b = load 'b' as (field4, field5: double, field6: chararray );");
        this.pig.registerQuery("c = union a, b;");
        System.setOut(out);
        this.pig.dumpSchema("c");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            TestPigServer.assertTrue((s.equals("c: {field1: int,field2: double,field3: chararray}") ? 1 : 0) != 0);
        }
        ((InputStream)fileWithStdOutContents).close();
    }

    @Test
    public void testDescribeComplex() throws Throwable {
        String s;
        PrintStream console = System.out;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.stdOutRedirectedFile)));
        this.pig.registerQuery("a = load 'a' as (site: chararray, count: int, itemCounts: bag { itemCountsTuple: tuple (type: chararray, typeCount: int, f: float, m: map[]) } ) ;");
        this.pig.registerQuery("b = foreach a generate site, count, FLATTEN(itemCounts);");
        System.setOut(out);
        this.pig.dumpSchema("b");
        out.close();
        System.setOut(console);
        DataInputStream fileWithStdOutContents = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stdOutRedirectedFile)));
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileWithStdOutContents));
        while ((s = reader.readLine()) != null) {
            s = s.replaceAll("^.*\\{", "");
            s = s.replaceAll("\\}$", "");
            Schema actual = Util.getSchemaFromString(s);
            Schema expected = Util.getSchemaFromString("site: chararray,count: int,itemCounts::type: chararray,itemCounts::typeCount: int,itemCounts::f: float,itemCounts::m: map[ ]");
            TestPigServer.assertEquals((Object)expected, (Object)actual);
        }
        ((InputStream)fileWithStdOutContents).close();
    }
}

