/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.ExecType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.PigExecTestCase;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestPigSplit
extends PigExecTestCase {
    String inputFileName;

    public TestPigSplit() {
        this.execType = ExecType.MAPREDUCE;
    }

    private void createInput(String[] data) throws IOException {
        if (this.execType == ExecType.MAPREDUCE) {
            Util.createInputFile(this.cluster, this.inputFileName, data);
        } else if (this.execType == ExecType.LOCAL) {
            Util.createLocalInputFile(this.inputFileName, data);
        } else {
            throw new IOException("unknown exectype:" + this.execType.toString());
        }
    }

    protected void tearDown() throws Exception {
        if (this.execType == ExecType.MAPREDUCE) {
            Util.deleteFile(this.cluster, this.inputFileName);
        } else if (this.execType == ExecType.LOCAL) {
            new File(this.inputFileName).delete();
        } else {
            throw new IOException("unknown exectype:" + this.execType.toString());
        }
    }

    @Test
    public void notestLongEvalSpec() throws Exception {
        this.inputFileName = "notestLongEvalSpec-input.txt";
        this.createInput(new String[]{"0\ta"});
        this.pigServer.registerQuery("a = load '" + this.inputFileName + "';");
        for (int i = 0; i < 500; ++i) {
            this.pigServer.registerQuery("a = filter a by $0 == '1';");
        }
        Iterator iter = this.pigServer.openIterator("a");
        if (iter.hasNext()) {
            throw new Exception();
        }
    }

    @Test
    public void testSchemaWithSplit() throws Exception {
        this.inputFileName = "testSchemaWithSplit-input.txt";
        String[] input = new String[]{"2", "12", "42"};
        this.createInput(input);
        this.pigServer.registerQuery("a = load '" + this.inputFileName + "' as (value:chararray);");
        this.pigServer.registerQuery("split a into b if value < '20', c if value > '10';");
        this.pigServer.registerQuery("b1 = order b by value;");
        this.pigServer.registerQuery("c1 = order c by value;");
        Iterator iter = this.pigServer.openIterator("b1");
        TestPigSplit.assertTrue((String)"b1 has an element", (boolean)iter.hasNext());
        TestPigSplit.assertEquals((String)"first item in b1", (Object)((Tuple)iter.next()).get(0), (Object)"12");
        TestPigSplit.assertTrue((String)"b1 has an element", (boolean)iter.hasNext());
        TestPigSplit.assertEquals((String)"second item in b1", (Object)((Tuple)iter.next()).get(0), (Object)"2");
        TestPigSplit.assertFalse((String)"b1 is over", (boolean)iter.hasNext());
        iter = this.pigServer.openIterator("c1");
        TestPigSplit.assertTrue((String)"c1 has an element", (boolean)iter.hasNext());
        TestPigSplit.assertEquals((String)"first item in c1", (Object)((Tuple)iter.next()).get(0), (Object)"12");
        TestPigSplit.assertTrue((String)"c1 has an element", (boolean)iter.hasNext());
        TestPigSplit.assertEquals((String)"second item in c1", (Object)((Tuple)iter.next()).get(0), (Object)"2");
        TestPigSplit.assertTrue((String)"c1 has an element", (boolean)iter.hasNext());
        TestPigSplit.assertEquals((String)"third item in c1", (Object)((Tuple)iter.next()).get(0), (Object)"42");
        TestPigSplit.assertFalse((String)"c1 is over", (boolean)iter.hasNext());
    }

    @Test
    public void testLongEvalSpec() throws Exception {
        this.inputFileName = "testLongEvalSpec-input.txt";
        String[] input = new String[500];
        for (int i = 0; i < 500; ++i) {
            input[i] = "0\ta";
        }
        this.createInput(input);
        this.pigServer.registerQuery("a = load '" + this.inputFileName + "';");
        this.pigServer.registerQuery("a = filter a by $0 == '1';");
        Iterator iter = this.pigServer.openIterator("a");
        if (iter.hasNext()) {
            throw new Exception();
        }
    }
}

