/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.tools.pigstats.PigStats;

public class TestPigStats
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBytesWritten_JIRA_1027() {
        File outputFile = null;
        try {
            outputFile = File.createTempFile("JIAR_1027", ".out");
            String filePath = outputFile.getAbsolutePath();
            outputFile.delete();
            PigServer pig = new PigServer(ExecType.LOCAL);
            pig.registerQuery("A = load 'test/org/apache/pig/test/data/passwd';");
            PigStats stats = pig.store("A", filePath).getStatistics();
            File dataFile = new File(outputFile.getAbsoluteFile() + File.separator + "part-00000");
            TestPigStats.assertEquals((long)dataFile.length(), (long)stats.getBytesWritten());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            TestPigStats.fail((String)"IOException happened");
        }
        finally {
            if (outputFile != null) {
                this.deleteDirectory(outputFile);
            }
        }
    }

    private void deleteDirectory(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }
}

