/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.junit.Before;
import org.junit.Test;

public class TestPinOptions
extends TestCase {
    protected PigServer pigServer;

    @Before
    protected void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.LOCAL);
    }

    @Test
    public void testPinnedJoinOption() throws IOException {
        String[] joinTypes = new String[]{"hash", "repl", "merge", "skewed", "default"};
        String[] expectedJoinTypes = new String[]{"HASH", "REPLICATED", "MERGE", "SKEWED", "HASH"};
        for (int i = 0; i < joinTypes.length; ++i) {
            this.pigServer.setBatchOn();
            this.pigServer.registerQuery("a = load '/tmp' as (foo, bar);");
            this.pigServer.registerQuery("b = load '/tmp' as (foo, bar);");
            this.pigServer.registerQuery("c = join a by foo, b by foo using \"" + joinTypes[i] + "\";");
            LogicalOperator op = this.getOpByAlias((LogicalPlan)this.pigServer.getAliases().get("c"), "c");
            TestPinOptions.assertTrue((String)("did " + joinTypes[i] + " join get pinned? "), (boolean)op.isPinnedOption(LOJoin.OPTION_JOIN));
            TestPinOptions.assertEquals((String)"did the right join type get set? ", (String)((LOJoin)op).getJoinType().toString(), (String)expectedJoinTypes[i]);
            this.pigServer.discardBatch();
        }
    }

    @Test
    public void testNotPinnedJinOption() throws IOException {
        this.pigServer.registerQuery("a = load '/tmp' as (foo, bar);");
        this.pigServer.registerQuery("b = load '/tmp' as (foo, bar);");
        this.pigServer.registerQuery("c = join a by foo, b by foo;");
        LogicalOperator op = this.getOpByAlias((LogicalPlan)this.pigServer.getAliases().get("c"), "c");
        TestPinOptions.assertEquals((String)"default join should be hash", (String)((LOJoin)op).getJoinType().toString(), (String)"HASH");
        TestPinOptions.assertFalse((boolean)op.isPinnedOption(LOJoin.OPTION_JOIN));
    }

    @Test
    public void testGroupOptions() throws IOException {
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("a = load '/tmp' as (foo, bar);");
        this.pigServer.registerQuery("b = group a by foo;");
        LogicalOperator op = this.getOpByAlias((LogicalPlan)this.pigServer.getAliases().get("b"), "b");
        TestPinOptions.assertFalse((boolean)op.isPinnedOption(LOCogroup.OPTION_GROUPTYPE));
        this.pigServer.discardBatch();
        this.pigServer.setBatchOn();
        this.pigServer.registerQuery("a = load '/tmp' as (foo, bar);");
        this.pigServer.registerQuery("b = group a by foo using \"collected\";");
        op = this.getOpByAlias((LogicalPlan)this.pigServer.getAliases().get("b"), "b");
        TestPinOptions.assertTrue((boolean)op.isPinnedOption(LOCogroup.OPTION_GROUPTYPE));
        this.pigServer.discardBatch();
    }

    private LogicalOperator getOpByAlias(LogicalPlan lp, String alias) {
        for (LogicalOperator op : lp) {
            if (!op.getAlias().equals(alias)) continue;
            return op;
        }
        return null;
    }
}

