/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.After;
import org.junit.Test;

public class TestProjectionMap
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    LogicalPlanTester planTester = new LogicalPlanTester();
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @After
    public void tearDown() throws Exception {
        this.planTester.reset();
    }

    @Test
    public void testQueryForeach1() {
        String query = "foreach (load 'a') generate $1,$2;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getAddedFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach2() {
        String query = "foreach (load 'a' using " + PigStorage.class.getName() + "(':')) generate $1, 'aoeuaoeu' ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)foreachAddedFields.get(0) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroup1() {
        String query = "foreach (cogroup (load 'a') by $1, (load 'b') by $1) generate org.apache.pig.builtin.AVG($1) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 2 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getMappedFields() == null ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields().size() == 3 ? 1 : 0) != 0);
        int expectedColumn = 0;
        for (Pair removedField : foreachRemovedFields) {
            TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
            TestProjectionMap.assertTrue(((Integer)removedField.second == expectedColumn++ ? 1 : 0) != 0);
        }
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)foreachAddedFields.get(0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupAll() throws Exception {
        String query = "foreach (group (load 'a') ALL) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields == null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMappedFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMappedFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)foreachMappedFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields.size() == 1 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 0 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup2() {
        String query = "foreach (group (load 'a') by $1) generate group, '1' ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields.size() == 1 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 1 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)foreachAddedFields.get(0) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroup2() {
        String query = "foreach (cogroup (load 'a') by ($1), (load 'b') by ($1)) generate $1.$1, $2.$1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 2 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 2 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields.size() == 1 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 0 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup3() {
        String query = "foreach (group (load 'a') by ($6, $7)) generate flatten(group) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList mapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 6 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)1)).getInputColumn().second == 7 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        mapValues = (ArrayList)foreachMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)mapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields.size() == 1 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 1 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        ProjectionMap filterProjectionMap = filter.getProjectionMap();
        TestProjectionMap.assertTrue((!filterProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if $0 == '3', c if $1 == '3';");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)load).get(0);
        ProjectionMap splitProjectionMap = split.getProjectionMap();
        TestProjectionMap.assertTrue((!splitProjectionMap.changes() ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        ProjectionMap splitbProjectionMap = splitb.getProjectionMap();
        TestProjectionMap.assertTrue((!splitbProjectionMap.changes() ? 1 : 0) != 0);
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        ProjectionMap splitcProjectionMap = splitc.getProjectionMap();
        TestProjectionMap.assertTrue((!splitcProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        ProjectionMap sortProjectionMap = sort.getProjectionMap();
        TestProjectionMap.assertTrue((!sortProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryLimitNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)load).get(0);
        ProjectionMap sortProjectionMap = sort.getProjectionMap();
        TestProjectionMap.assertTrue((!sortProjectionMap.changes() ? 1 : 0) != 0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        ProjectionMap limitProjectionMap = limit.getProjectionMap();
        TestProjectionMap.assertTrue((!limitProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctNoSchema() {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LODistinct distinct = (LODistinct)lp.getLeaves().get(0);
        ProjectionMap distinctProjectionMap = distinct.getProjectionMap();
        TestProjectionMap.assertTrue((!distinctProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema() {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "`;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getLeaves().get(0);
        ProjectionMap streamProjectionMap = stream.getProjectionMap();
        TestProjectionMap.assertTrue((streamProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema1() {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getLeaves().get(0);
        ProjectionMap streamProjectionMap = stream.getProjectionMap();
        TestProjectionMap.assertTrue((streamProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach3() {
        String query = "foreach (load 'a') generate ($1 == '3'? $2 : $3) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getMappedFields() == null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)foreachAddedFields.get(0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach4() {
        this.planTester.buildPlan("A = load 'a';");
        this.planTester.buildPlan("B = load 'b';");
        LogicalPlan lp = this.planTester.buildPlan("foreach (cogroup A by ($1), B by ($1)) generate A, flatten(B.($1, $2, $3));");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList cogroupMapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 2 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        ArrayList foreachMapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        for (int i = 1; i < 4; ++i) {
            foreachMapValues = (ArrayList)foreachMapFields.get((Object)i);
            TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
            TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 2 ? 1 : 0) != 0);
        }
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields().size() == 1 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 0 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeach5() {
        this.planTester.buildPlan("A = load 'a';");
        this.planTester.buildPlan("B = load 'b';");
        this.planTester.buildPlan("C = cogroup A by ($1), B by ($1);");
        String query = "foreach C { B = order B by $0; generate FLATTEN(A), B.($1, $2, $3) ;};";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList cogroupMapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((cogroupProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 2 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        ArrayList foreachMapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachProjectionMap.getRemovedFields().size() == 2 ? 1 : 0) != 0);
        Pair removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 0 ? 1 : 0) != 0);
        removedField = (Pair)foreachRemovedFields.get(1);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 2 ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields.size() == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)foreachAddedFields.get(0) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossNoSchema() {
        String query = "c = cross (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap crossProjectionMap = cross.getProjectionMap();
        TestProjectionMap.assertTrue((crossProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionNoSchema() {
        String query = "c = union (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap unionProjectionMap = union.getProjectionMap();
        TestProjectionMap.assertTrue((unionProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinNoSchema() {
        String query = "c = join (load 'a') by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap frjoinProjectionMap = frjoin.getProjectionMap();
        TestProjectionMap.assertTrue((frjoinProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinNoSchema() {
        String query = "c = join (load 'a') by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap joinProjectionMap = join.getProjectionMap();
        TestProjectionMap.assertTrue((joinProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        ProjectionMap filterProjectionMap = filter.getProjectionMap();
        TestProjectionMap.assertTrue((filterProjectionMap != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((!filterProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if url == '3', c if hitCount == '3';");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)load).get(0);
        ProjectionMap splitProjectionMap = split.getProjectionMap();
        TestProjectionMap.assertTrue((!splitProjectionMap.changes() ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        ProjectionMap splitbProjectionMap = splitb.getProjectionMap();
        TestProjectionMap.assertTrue((!splitbProjectionMap.changes() ? 1 : 0) != 0);
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        ProjectionMap splitcProjectionMap = splitc.getProjectionMap();
        TestProjectionMap.assertTrue((!splitcProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        ProjectionMap sortProjectionMap = sort.getProjectionMap();
        TestProjectionMap.assertTrue((sortProjectionMap != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((!sortProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryLimitWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)load).get(0);
        ProjectionMap sortProjectionMap = sort.getProjectionMap();
        TestProjectionMap.assertTrue((sortProjectionMap != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((!sortProjectionMap.changes() ? 1 : 0) != 0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        ProjectionMap limitProjectionMap = limit.getProjectionMap();
        TestProjectionMap.assertTrue((limitProjectionMap != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((!limitProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LODistinct distinct = (LODistinct)lp.getLeaves().get(0);
        ProjectionMap distinctProjectionMap = distinct.getProjectionMap();
        TestProjectionMap.assertTrue((distinctProjectionMap != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((!distinctProjectionMap.changes() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema() {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getLeaves().get(0);
        ProjectionMap streamProjectionMap = stream.getProjectionMap();
        TestProjectionMap.assertTrue((streamProjectionMap.changes() ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((streamProjectionMap.getMappedFields() == null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((streamProjectionMap.getRemovedFields() == null ? 1 : 0) != 0);
        List streamAddedFields = streamProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((streamAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)streamAddedFields.get(0) == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)streamAddedFields.get(1) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema1() {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadProjectionMap = load.getProjectionMap();
        TestProjectionMap.assertTrue((!loadProjectionMap.changes() ? 1 : 0) != 0);
        LOStream stream = (LOStream)lp.getLeaves().get(0);
        ProjectionMap streamProjectionMap = stream.getProjectionMap();
        TestProjectionMap.assertTrue((streamProjectionMap.changes() ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((streamProjectionMap.getMappedFields() == null ? 1 : 0) != 0);
        List streamRemovedFields = streamProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((streamRemovedFields.size() == 2 ? 1 : 0) != 0);
        Pair removedField = (Pair)streamRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 0 ? 1 : 0) != 0);
        removedField = (Pair)streamRemovedFields.get(1);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 1 ? 1 : 0) != 0);
        List streamAddedFields = streamProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((streamAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)streamAddedFields.get(0) == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)streamAddedFields.get(1) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryImplicitJoinWithSchema() {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url,rank);");
        this.planTester.buildPlan("c = cogroup a by url, b by url;");
        LogicalPlan lp = this.planTester.buildPlan("d = foreach c generate group,flatten(a),flatten(b);");
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap cogroupProjectionMap = cogroup.getProjectionMap();
        TestProjectionMap.assertTrue((cogroupProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap cogroupMapFields = cogroupProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((cogroupMapFields != null ? 1 : 0) != 0);
        ArrayList cogroupMapValues = (ArrayList)cogroupMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)cogroupMapValues.get((int)1)).getInputColumn().second == 0 ? 1 : 0) != 0);
        List cogroupRemovedFields = cogroupProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((cogroupRemovedFields.size() == 2 ? 1 : 0) != 0);
        Pair removedField = (Pair)cogroupRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 1 ? 1 : 0) != 0);
        removedField = (Pair)cogroupRemovedFields.get(1);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 1 ? 1 : 0) != 0);
        List cogroupAddedFields = cogroupProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((cogroupAddedFields.size() == 2 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(0) == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)cogroupAddedFields.get(1) == 2 ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        MultiMap foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        ArrayList foreachMapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)2);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)3);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 2 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)4);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 2 ? 1 : 0) != 0);
        List foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields == null ? 1 : 0) != 0);
        List foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
        lp = this.planTester.buildPlan("e = foreach d generate group, a::url, b::url, b::rank, rank;");
        foreach = (LOForEach)lp.getLeaves().get(0);
        foreachProjectionMap = foreach.getProjectionMap();
        TestProjectionMap.assertTrue((foreachProjectionMap.changes() ? 1 : 0) != 0);
        foreachMapFields = foreachProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((foreachMapFields != null ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)2);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 3 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)3);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 4 ? 1 : 0) != 0);
        foreachMapValues = (ArrayList)foreachMapFields.get((Object)4);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)foreachMapValues.get((int)0)).getInputColumn().second == 4 ? 1 : 0) != 0);
        foreachRemovedFields = foreachProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((foreachRemovedFields != null ? 1 : 0) != 0);
        TestProjectionMap.assertTrue((foreachRemovedFields.size() == 1 ? 1 : 0) != 0);
        removedField = (Pair)foreachRemovedFields.get(0);
        TestProjectionMap.assertTrue(((Integer)removedField.first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)removedField.second == 2 ? 1 : 0) != 0);
        foreachAddedFields = foreachProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((foreachAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithSchema() {
        String query = "c = cross (load 'a' as (url, hitcount)), (load 'b' as (url, rank));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap crossProjectionMap = cross.getProjectionMap();
        TestProjectionMap.assertTrue((crossProjectionMap != null ? 1 : 0) != 0);
        MultiMap crossMapFields = crossProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((crossMapFields != null ? 1 : 0) != 0);
        ArrayList crossMapValues = (ArrayList)crossMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        crossMapValues = (ArrayList)crossMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        crossMapValues = (ArrayList)crossMapFields.get((Object)2);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        crossMapValues = (ArrayList)crossMapFields.get((Object)3);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)crossMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List crossRemovedFields = crossProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((crossRemovedFields == null ? 1 : 0) != 0);
        List crossAddedFields = crossProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((crossAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithSchema() {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b' as (url, rank));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap unionProjectionMap = union.getProjectionMap();
        TestProjectionMap.assertTrue((unionProjectionMap != null ? 1 : 0) != 0);
        MultiMap unionMapFields = unionProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((unionMapFields != null ? 1 : 0) != 0);
        ArrayList unionMapValues = (ArrayList)unionMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)1)).getInputColumn().second == 0 ? 1 : 0) != 0);
        unionMapValues = (ArrayList)unionMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)1)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)unionMapValues.get((int)1)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List unionRemovedFields = unionProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((unionRemovedFields == null ? 1 : 0) != 0);
        List unionAddedFields = unionProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((unionAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap frjoinProjectionMap = frjoin.getProjectionMap();
        TestProjectionMap.assertTrue((frjoinProjectionMap != null ? 1 : 0) != 0);
        MultiMap frjoinMapFields = frjoinProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((frjoinMapFields != null ? 1 : 0) != 0);
        ArrayList frjoinMapValues = (ArrayList)frjoinMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)frjoinMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)frjoinMapFields.get((Object)2);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)frjoinMapFields.get((Object)3);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List frjoinRemovedFields = frjoinProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((frjoinRemovedFields == null ? 1 : 0) != 0);
        List frjoinAddedFields = frjoinProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((frjoinAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap joinProjectionMap = join.getProjectionMap();
        TestProjectionMap.assertTrue((joinProjectionMap != null ? 1 : 0) != 0);
        MultiMap joinMapFields = joinProjectionMap.getMappedFields();
        TestProjectionMap.assertTrue((joinMapFields != null ? 1 : 0) != 0);
        ArrayList frjoinMapValues = (ArrayList)joinMapFields.get((Object)0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)joinMapFields.get((Object)1);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 0 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)joinMapFields.get((Object)2);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 0 ? 1 : 0) != 0);
        frjoinMapValues = (ArrayList)joinMapFields.get((Object)3);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().first == 1 ? 1 : 0) != 0);
        TestProjectionMap.assertTrue(((Integer)((ProjectionMap.Column)frjoinMapValues.get((int)0)).getInputColumn().second == 1 ? 1 : 0) != 0);
        List joinRemovedFields = joinProjectionMap.getRemovedFields();
        TestProjectionMap.assertTrue((joinRemovedFields == null ? 1 : 0) != 0);
        List joinAddedFields = joinProjectionMap.getAddedFields();
        TestProjectionMap.assertTrue((joinAddedFields == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithMixedSchema() {
        String query = "c = cross (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOCross cross = (LOCross)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap crossProjectionMap = cross.getProjectionMap();
        TestProjectionMap.assertTrue((crossProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithMixedSchema() {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOUnion union = (LOUnion)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap unionProjectionMap = union.getProjectionMap();
        TestProjectionMap.assertTrue((unionProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinWithMixedSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap frjoinProjectionMap = frjoin.getProjectionMap();
        TestProjectionMap.assertTrue((frjoinProjectionMap == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithMixedSchema() {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        ProjectionMap loadaProjectionMap = loada.getProjectionMap();
        TestProjectionMap.assertTrue((!loadaProjectionMap.changes() ? 1 : 0) != 0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        ProjectionMap loadbProjectionMap = loadb.getProjectionMap();
        TestProjectionMap.assertTrue((!loadbProjectionMap.changes() ? 1 : 0) != 0);
        LOJoin join = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        ProjectionMap joinProjectionMap = join.getProjectionMap();
        TestProjectionMap.assertTrue((joinProjectionMap == null ? 1 : 0) != 0);
    }
}

