/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.pig.FilterFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.optimizer.PruneColumns;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestPruneColumn
extends TestCase {
    private PigServer pigServer;
    File tmpFile1;
    File tmpFile2;
    File tmpFile3;
    File tmpFile4;
    File tmpFile5;
    File tmpFile6;
    File tmpFile7;
    File tmpFile8;
    File tmpFile9;
    File tmpFile10;
    File logFile;
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @Before
    public void setUp() throws Exception {
        Logger logger = Logger.getLogger(PruneColumns.class);
        logger.removeAllAppenders();
        logger.setLevel(Level.INFO);
        SimpleLayout layout = new SimpleLayout();
        this.logFile = File.createTempFile("log", "");
        FileAppender appender = new FileAppender((Layout)layout, this.logFile.toString(), false, false, 0);
        logger.addAppender((Appender)appender);
        Logger pigStorageWithTraceLogger = Logger.getLogger(PigStorageWithTrace.class);
        pigStorageWithTraceLogger.setLevel(Level.INFO);
        pigStorageWithTraceLogger.addAppender((Appender)appender);
        this.pigServer = new PigServer("local");
        this.tmpFile1 = File.createTempFile("prune", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile1));
        ps.println("1\t2\t3");
        ps.println("2\t5\t2");
        ps.close();
        this.tmpFile2 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile2));
        ps.println("1\t1");
        ps.println("2\t2");
        ps.close();
        this.tmpFile3 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile3));
        ps.println("1\t[key1#1,key2#2]");
        ps.println("2\t[key1#2,key2#4]");
        ps.close();
        this.tmpFile4 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile4));
        ps.println("1\t2\t3");
        ps.println("1\t2\t3");
        ps.close();
        this.tmpFile5 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile5));
        ps.println("1\t2\t3\t4");
        ps.println("2\t3\t4\t5");
        ps.close();
        this.tmpFile6 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile6));
        ps.println("\t2\t3");
        ps.println("2\t3\t4");
        ps.close();
        this.tmpFile7 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile7));
        ps.println("1\t1\t1");
        ps.println("2\t2\t2");
        ps.close();
        this.tmpFile8 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile8));
        ps.println("1\t2\t3\t4");
        ps.println("2\t5\t2\t3");
        ps.close();
        this.tmpFile9 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile9));
        ps.println("1\t[key1#1,key2#2]\t[key3#8,key4#9]");
        ps.println("2\t[key1#2,key2#4]\t[key3#8,key4#9]");
        ps.close();
        this.tmpFile10 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile10));
        ps.println("1\t[1#1,2#1]\t2");
        ps.close();
    }

    public boolean checkLogFileMessage(String[] messages) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.logFile));
            String logMessage = "";
            while ((line = reader.readLine()) != null) {
                logMessage = logMessage + line + "\n";
            }
            for (int i = 0; i < messages.length; ++i) {
                if (logMessage.contains(messages[i])) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean emptyLogFileMessage() {
        if (!this.logFile.exists()) {
            return true;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.logFile));
            while ((line = reader.readLine()) != null) {
                if (line == null || line.equals("")) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Test
    public void testLoadForEach1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = foreach A generate a1, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 5 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "No map keys pruned for A"}));
    }

    @Test
    public void testLoadForEach2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = foreach A generate a0, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A"}));
    }

    @Test
    public void testLoadForEach3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = foreach A generate a0, a1;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue(((Integer)t.get(1) == 5 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $2", "No map keys pruned for A"}));
    }

    @Test
    public void testJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' as (b0:int, b1:int);");
        this.pigServer.registerQuery("C = join A by a1, B by b1;");
        this.pigServer.registerQuery("D = foreach C generate a1, a2, b0, b1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(3));
        TestPruneColumn.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(3).equals(2));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "No map keys pruned for A", "No column pruned for B", "No map keys pruned for B"}));
    }

    @Test
    public void testJoin2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' as (b0:int, b1:int);");
        this.pigServer.registerQuery("C = join A by a1, B by b1;");
        this.pigServer.registerQuery("D = foreach C generate a1, a2, b1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(3));
        TestPruneColumn.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "No map keys pruned for A", "Columns pruned for B: $0", "No map keys pruned for B"}));
    }

    @Test
    public void testForEachFilter() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = filter A by a2==3;");
        this.pigServer.registerQuery("C = foreach B generate a0, a1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(2));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testForEach1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = foreach A generate a0, a1+a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(5));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(7));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testForEach2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = foreach A generate a0 as b0, *;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(1));
        TestPruneColumn.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(3).equals(3));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(1).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(2).equals(5));
        TestPruneColumn.assertTrue((boolean)t.get(3).equals(2));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testSplit1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("split A into B if $0<=1, C if $0>1;");
        this.pigServer.registerQuery("D = foreach B generate $1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $2", "No map keys pruned for A"}));
    }

    @Test
    public void testSplit2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("split A into B if $0<=1, C if $0>1;");
        this.pigServer.registerQuery("D = foreach B generate $1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $2", "No map keys pruned for A"}));
    }

    @Test
    public void testForeachNoSchema1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = foreach A generate $1, $2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForeachNoSchema2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = foreach A generate $1, 'aoeuaoeu';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("aoeuaoeu"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("aoeuaoeu"));
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:int, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1:int);");
        this.pigServer.registerQuery("C = cogroup A by $1, B by $1;");
        this.pigServer.registerQuery("D = foreach C generate AVG($1.$1);");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((t.get(0) == null ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2.0"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("5.0"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A", "Columns pruned for B: $0", "No map keys pruned for B"}));
    }

    @Test
    public void testCoGroup2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:int, a2);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = foreach B generate $1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3),(2,5,2)}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testCoGroup3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:int, a2);");
        this.pigServer.registerQuery("B = group A by $1;");
        this.pigServer.registerQuery("C = foreach B generate $1, '1';");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3)}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(2,5,2)}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testCoGroup4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:int, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1:int);");
        this.pigServer.registerQuery("C = cogroup A by ($1), B by ($1);");
        this.pigServer.registerQuery("D = foreach C generate $1.$1, $2.$1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{(1)}"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(2)}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{(2)}"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(5)}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A", "No column pruned for B", "No map keys pruned for B"}));
    }

    @Test
    public void testCoGroup5() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by (a0, a1);");
        this.pigServer.registerQuery("C = foreach B generate flatten(group);");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("5"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $2", "No map keys pruned for A"}));
    }

    @Test
    public void testDistinct1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile4.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = distinct A;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testStream1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = stream A through `" + simpleEchoStreamingCommand + "`;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testBinCond1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile5.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2, a3);");
        this.pigServer.registerQuery("B = foreach A generate ($1 == '2'? $2 : $3);");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "No map keys pruned for A"}));
    }

    @Test
    public void testCoGroup6() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = cogroup A by ($1), B by ($1);");
        this.pigServer.registerQuery("D = foreach C generate A, flatten(B.($0, $1));");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3)}"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup7() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = cogroup A by ($1), B by ($1);");
        this.pigServer.registerQuery("D = foreach C {B = order B by $0;generate FLATTEN(A), B.($1);};");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)t.get(3).toString().equals("{(2)}"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("5"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(3).toString().equals("{}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCross1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = cross A, B;");
        this.pigServer.registerQuery("D = foreach C generate $0, $3;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(1,1)");
        results.add("(2,1)");
        results.add("(1,2)");
        results.add("(2,2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A", "Columns pruned for B: $1", "No map keys pruned for B"}));
    }

    @Test
    public void testUnion1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile4.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = union A, B;");
        this.pigServer.registerQuery("D = foreach C generate $0, $2;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(1,3)");
        results.add("(2,2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        results.contains(t.toString());
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        results.contains(t.toString());
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        results.contains(t.toString());
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        results.contains(t.toString());
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A", "Columns pruned for B: $1", "No map keys pruned for B"}));
    }

    @Test
    public void testFRJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"replicated\";");
        this.pigServer.registerQuery("D = foreach C generate $0, $3;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A", "Columns pruned for B: $1", "No map keys pruned for B"}));
    }

    @Test
    public void testFilter1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = order A by a1;");
        this.pigServer.registerQuery("C = limit B 10;");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $2", "No map keys pruned for A"}));
    }

    @Test
    public void testFilter2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = filter A by a0+a2 == 4;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A"}));
    }

    @Test
    public void testOrderBy1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = order A by $0;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A"}));
    }

    @Test
    public void testOrderBy2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = order A by *;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testCogroup8() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by *;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("(1,2,3)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("(2,5,2)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testJoin3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile4.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = join A by *, B by * using \"replicated\";");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testLoadForEach4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate *;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A"}));
    }

    @Test
    public void testForEachUDF() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0:chararray, a1:chararray, a2:chararray);");
        this.pigServer.registerQuery("B = foreach A generate StringSize(*);");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    @Test
    public void testOutJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile6.toString(), this.pigServer.getPigContext()) + "' AS (a0:chararray, a1:chararray, a2:chararray);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (a0:chararray, a1:chararray, a2:chararray);");
        this.pigServer.registerQuery("C = join A by $0 left, B by $0;");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(2)");
        results.add("()");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A", "Columns pruned for B: $1, $2", "No map keys pruned for B"}));
    }

    @Test
    public void testFilter3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = filter A by " + MyFilterFunc.class.getName() + "(*) ;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testMapKey1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A generate a0, a1#'key1';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "Map key required for A: $1->[key1]"}));
    }

    @Test
    public void testMapKey2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A generate a1, a1#'key1';");
        this.pigServer.registerQuery("C = foreach B generate $0#'key2', $1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("4"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "Map key required for A: $1->[key2,key1]"}));
    }

    @Test
    public void testMapKey3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A generate a1, a1#'key1';");
        this.pigServer.registerQuery("C = group B all;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("all"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{([key2#2,key1#1],1),([key2#4,key1#2],2)}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "No map keys pruned for A"}));
    }

    @Test
    public void testMapKey4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = limit A 10;");
        this.pigServer.registerQuery("C = foreach B generate $0, $1#'key1';");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "Map key required for A: $1->[key1]"}));
    }

    @Test
    public void testMapKey5() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A generate $0, $1#'key1';");
        this.pigServer.registerQuery("C = stream B through `" + simpleEchoStreamingCommand + "`;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "Map key required for A: $1->[key1]"}));
    }

    @Test
    public void testConstantPlan() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate 1, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $1", "No map keys pruned for A"}));
    }

    @Test
    public void testPlainPlan() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = order A by $0;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("5"));
        TestPruneColumn.assertTrue((boolean)t.get(2).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testBinStorage1() throws Exception {
        File intermediateFile = File.createTempFile("intemediate", "txt");
        intermediateFile.delete();
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.store("A", intermediateFile.toString(), "BinStorage()");
        this.pigServer.registerQuery("A = load '" + intermediateFile.toString() + "' using BinStorage() as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A"}));
        intermediateFile.delete();
    }

    @Test
    public void testBinStorage2() throws Exception {
        File intermediateFile = File.createTempFile("intemediate", "txt");
        intermediateFile.delete();
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.store("A", intermediateFile.toString(), "BinStorage()");
        this.pigServer.registerQuery("A = load '" + intermediateFile.toString() + "' using BinStorage() as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a2, a0, a1;");
        this.pigServer.registerQuery("C = foreach B generate a0, a2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A"}));
        intermediateFile.delete();
    }

    @Test
    public void testProjectCastKeyLookup() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("B = foreach A generate a1#'key1';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "Map key required for A: $1->[key1]"}));
    }

    @Test
    public void testRelayFlattenMap() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A generate flatten(a1);");
        this.pigServer.registerQuery("C = foreach B generate a1#'key1';");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0", "Map key required for A: $1->[key1]"}));
    }

    @Test
    public void testCrossAtLeastOneColumnOneInput() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0:int, a1:int, a2:int);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' as (b0:int, b1:int);");
        this.pigServer.registerQuery("C = cross A, B;");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(1)");
        results.add("(2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1, $2", "No map keys pruned for A", "Columns pruned for B: $1", "No map keys pruned for B"}));
    }

    @Test
    public void testComplex1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile7.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile8.toString(), this.pigServer.getPigContext()) + "' as (b0, b1, b2, b3);");
        this.pigServer.registerQuery("B1 = foreach B generate b2, b0+b3;");
        this.pigServer.registerQuery("C = join A by $0, B1 by $0;");
        this.pigServer.registerQuery("D = order C by $4;");
        this.pigServer.registerQuery("E = foreach D generate $0, $2;");
        this.pigServer.registerQuery("F = filter E by $1<10;");
        this.pigServer.registerQuery("G = group F by $0;");
        this.pigServer.registerQuery("H = foreach G generate $1;");
        Iterator iter = this.pigServer.openIterator("H");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("{(2,2)}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A", "Columns pruned for B: $1", "No map keys pruned for B"}));
    }

    @Test
    public void testCoGroup8() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:int, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1:int);");
        this.pigServer.registerQuery("C = cogroup A by ($1), B by ($1);");
        this.pigServer.registerQuery("D = foreach C generate $0, $1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{}"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{(1,2,3)}"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumn.assertTrue((boolean)t.get(1).toString().equals("{(2,5,2)}"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A", "Columns pruned for B: $0", "No map keys pruned for B"}));
    }

    @Test
    public void testUserDefinedSchema() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS ( c1 : chararray, c2 : int);");
        this.pigServer.registerQuery("B = foreach A generate c1 as c1 : chararray, c2 as c2 : int, 'CA' as state : chararray;");
        this.pigServer.registerQuery("C = foreach B generate c1 as c1 : chararray;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(1)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(2)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A"}));
    }

    @Test
    public void testSharedSchemaObject() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile10.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:map[], a2);");
        this.pigServer.registerQuery("B = foreach A generate a1;");
        this.pigServer.registerQuery("C = limit B 10;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("([2#1,1#1])"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $2", "No map keys pruned for A"}));
    }

    @Test
    public void testJoin4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = join A by a2, B by b2;");
        this.pigServer.registerQuery("D = foreach C generate $0,  $1,  $2;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(1,2,3)");
        results.add("(2,5,2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A", "Columns pruned for B: $0, $1", "No map keys pruned for B"}));
    }

    @Test
    public void testFilter4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2:int);");
        this.pigServer.registerQuery("B = filter A by a2==3;");
        this.pigServer.registerQuery("C = foreach B generate $2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(3)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $1", "No map keys pruned for A"}));
    }

    @Test
    public void testSplit3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2:int);");
        this.pigServer.registerQuery("split A into B if a2==3, C if a2<3;");
        this.pigServer.registerQuery("C = foreach B generate $2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(3)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $1", "No map keys pruned for A"}));
    }

    @Test
    public void testOrderBy3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = order A by a2;");
        this.pigServer.registerQuery("C = foreach B generate a2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(2)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(3)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $1", "No map keys pruned for A"}));
    }

    @Test
    public void testCogroup9() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (c0, c1, c2);");
        this.pigServer.registerQuery("D = cogroup A by a2, B by b2, C by c2;");
        this.pigServer.registerQuery("E = foreach D generate $1, $2;");
        Iterator iter = this.pigServer.openIterator("E");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.toString().equals("({(2,5,2)},{(2,5,2)})"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.toString().equals("({(1,2,3)},{(1,2,3)})"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for C: $0, $1", "No map keys pruned for C"}));
    }

    @Test
    public void testOrderbyWrongSignature() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = order A by a1;");
        this.pigServer.registerQuery("D = join C by a1, B by b0;");
        this.pigServer.registerQuery("E = foreach D generate a1, b0, b1;");
        Iterator iter = this.pigServer.openIterator("E");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(2,2,2)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $0, $2", "No map keys pruned for A", "No column pruned for B", "No map keys pruned for B"}));
    }

    @Test
    public void testUnionMixedPruning() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1:chararray, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b2);");
        this.pigServer.registerQuery("C = foreach B generate b0, 'hello', b2;");
        this.pigServer.registerQuery("D = union A, C;");
        this.pigServer.registerQuery("E = foreach D generate $0, $2;");
        Iterator iter = this.pigServer.openIterator("E");
        HashSet<String> results = new HashSet<String>();
        results.add("(1,3)");
        results.add("(2,2)");
        results.add("(1,1)");
        results.add("(2,2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A", "No column pruned for B", "No map keys pruned for B"}));
    }

    @Test
    public void testUnionMixedSchemaPruning() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0;;");
        this.pigServer.registerQuery("C = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        this.pigServer.registerQuery("E = union B, D;");
        Iterator iter = this.pigServer.openIterator("E");
        HashSet<String> results = new HashSet<String>();
        results.add("(1)");
        results.add("(2)");
        results.add("(1)");
        results.add("(2)");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumn.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForEachFlatten() throws Exception {
        File inputFile = Util.createInputFile("table_testForEachFlatten", "", new String[]{"oiue\tM\t{(3),(4)}\t{(toronto),(montreal)}"});
        this.pigServer.registerQuery("A = load '" + inputFile.toString() + "' as (a0:chararray, a1:chararray, a2:bag{t:tuple(id:chararray)}, a3:bag{t:tuple(loc:chararray)});");
        this.pigServer.registerQuery("B = foreach A generate a0, a1, flatten(a2), flatten(a3), 10;");
        this.pigServer.registerQuery("C = foreach B generate a0, $4;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Columns pruned for A: $1", "No map keys pruned for A"}));
    }

    @Test
    public void testFieldsToReadDuplicatedEntry() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' using " + PigStorageWithTrace.class.getName() + " AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0+a0, a1, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(2.0,2,3)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(4.0,5,2)"));
        TestPruneColumn.assertFalse((boolean)iter.hasNext());
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A", "[0,1,2]"}));
    }

    @Test
    public void testSplit4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0;");
        this.pigServer.registerQuery("C = join A by a0, B by a0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(1,2,3,1)"));
        TestPruneColumn.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumn.assertTrue((boolean)t.toString().equals("(2,5,2,2)"));
        TestPruneColumn.assertTrue((boolean)this.checkLogFileMessage(new String[]{"No column pruned for A", "No map keys pruned for A"}));
    }

    public static class MyFilterFunc
    extends FilterFunc {
        public Boolean exec(Tuple input) {
            return true;
        }
    }

    public static class PigStorageWithTrace
    extends PigStorage {
        public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
            LoadPushDown.RequiredFieldResponse response = super.pushProjection(requiredFieldList);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.info((Object)requiredFieldList);
            return response;
        }
    }
}

