/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.pig.FilterFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.experimental.plan.optimizer.Rule;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestPruneColumnNewLogicalPlan
extends TestCase {
    private PigServer pigServer;
    File tmpFile1;
    File tmpFile2;
    File tmpFile3;
    File tmpFile4;
    File tmpFile5;
    File tmpFile6;
    File tmpFile7;
    File tmpFile8;
    File tmpFile9;
    File tmpFile10;
    File logFile;
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @Before
    public void setUp() throws Exception {
        Logger logger = Logger.getLogger(Rule.class);
        logger.removeAllAppenders();
        logger.setLevel(Level.INFO);
        SimpleLayout layout = new SimpleLayout();
        this.logFile = File.createTempFile("log", "");
        FileAppender appender = new FileAppender((Layout)layout, this.logFile.toString(), false, false, 0);
        logger.addAppender((Appender)appender);
        Logger pigStorageWithTraceLogger = Logger.getLogger(PigStorageWithTrace.class);
        pigStorageWithTraceLogger.setLevel(Level.INFO);
        pigStorageWithTraceLogger.addAppender((Appender)appender);
        this.pigServer = new PigServer("local");
        this.pigServer.getPigContext().getProperties().setProperty("pig.usenewlogicalplan", "true");
        this.tmpFile1 = File.createTempFile("prune", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile1));
        ps.println("1\t2\t3");
        ps.println("2\t5\t2");
        ps.close();
        this.tmpFile2 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile2));
        ps.println("1\t1");
        ps.println("2\t2");
        ps.close();
        this.tmpFile3 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile3));
        ps.println("1\t[key1#1,key2#2]");
        ps.println("2\t[key1#2,key2#4]");
        ps.close();
        this.tmpFile4 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile4));
        ps.println("1\t2\t3");
        ps.println("1\t2\t3");
        ps.close();
        this.tmpFile5 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile5));
        ps.println("1\t2\t3\t4");
        ps.println("2\t3\t4\t5");
        ps.close();
        this.tmpFile6 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile6));
        ps.println("\t2\t3");
        ps.println("2\t3\t4");
        ps.close();
        this.tmpFile7 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile7));
        ps.println("1\t1\t1");
        ps.println("2\t2\t2");
        ps.close();
        this.tmpFile8 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile8));
        ps.println("1\t2\t3\t4");
        ps.println("2\t5\t2\t3");
        ps.close();
        this.tmpFile9 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile9));
        ps.println("1\t[key1#1,key2#2]\t[key3#8,key4#9]");
        ps.println("2\t[key1#2,key2#4]\t[key3#8,key4#9]");
        ps.close();
        this.tmpFile10 = File.createTempFile("prune", "txt");
        ps = new PrintStream(new FileOutputStream(this.tmpFile10));
        ps.println("1\t[1#1,2#1]\t2");
        ps.close();
    }

    public boolean checkLogFileMessage(String[] messages) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.logFile));
            String logMessage = "";
            while ((line = reader.readLine()) != null) {
                logMessage = logMessage + line + "\n";
            }
            for (int i = 0; i < messages.length; ++i) {
                if (logMessage.contains(messages[i])) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean emptyLogFileMessage() {
        if (!this.logFile.exists()) {
            return true;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.logFile));
            while ((line = reader.readLine()) != null) {
                if (line == null || line.equals("")) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Test
    public void testLoadForEach1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate (int)a1, (int)a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 3 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 5 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Load fields [1,2]"}));
    }

    @Test
    public void testLoadForEach2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate (int)a0, (int)a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 3 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Load fields [0,2]"}));
    }

    @Test
    public void testLoadForEach3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate (int)a0, (int)a1;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(0) == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue(((Integer)t.get(1) == 5 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Load fields [0,1]"}));
    }

    @Test
    public void testJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (int)a0, (int)a1, (int)a2;");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' as (b0, b1);");
        this.pigServer.registerQuery("B2 = foreach B generate (int)b0, (int)b1;");
        this.pigServer.registerQuery("C = join A2 by a1, B2 by b1;");
        this.pigServer.registerQuery("D = foreach C generate a1, a2, b0, b1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(3));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(3).equals(2));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [1,2]"}));
    }

    @Test
    public void testJoin2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (int)a0, (int)a1, (int)a2;");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' as (b0, b1);");
        this.pigServer.registerQuery("B2 = foreach B generate (int)b0, (int)b1;");
        this.pigServer.registerQuery("C = join A2 by a1, B2 by b1;");
        this.pigServer.registerQuery("D = foreach C generate a1, a2, b1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(3));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [1,2]", "Loader for B is pruned. Load fields [1]"}));
    }

    @Test
    public void testForEachFilter() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (int)a0, (int)a1, (int)a2;");
        this.pigServer.registerQuery("B = filter A2 by a2==3;");
        this.pigServer.registerQuery("C = foreach B generate a0, a1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(2));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForEach1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (int)a0, (int)a1, (int)a2;");
        this.pigServer.registerQuery("B = foreach A2 generate a0, a1+a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(5));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(7));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForEach2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (int)a0, (int)a1, (int)a2;");
        this.pigServer.registerQuery("B = foreach A2 generate a0 as b0, *;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(1));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(3).equals(3));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 4 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).equals(5));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(3).equals(2));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForeachNoSchema1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = foreach A generate $1, $2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testForeachNoSchema2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = foreach A generate $1, 'aoeuaoeu';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("aoeuaoeu"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("aoeuaoeu"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("A1 = foreach A generate a0,(int)a1,a2;");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("B1 = foreach B generate b0,(int)b1;");
        this.pigServer.registerQuery("C = cogroup A1 by $1, B1 by $1;");
        this.pigServer.registerQuery("D = foreach C generate AVG($1.$1);");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((t.get(0) == null ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2.0"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("5.0"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for B is pruned. Load fields [1]"}));
    }

    @Test
    public void testCoGroup2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A all;");
        this.pigServer.registerQuery("C = foreach B generate $1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3),(2,5,2)}"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by $1;");
        this.pigServer.registerQuery("C = foreach B generate $1, '1';");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(2,5,2)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("A1 = foreach A generate a0,(int)a1,a2;");
        this.pigServer.registerQuery("B1 = foreach B generate b0,(int)b1;");
        this.pigServer.registerQuery("C = cogroup A1 by ($1), B1 by ($1);");
        this.pigServer.registerQuery("D = foreach C generate $1.$1, $2.$1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{(1)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(2)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{(2)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(5)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{}"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testCoGroup5() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by (a0, a1);");
        this.pigServer.registerQuery("C = foreach B generate flatten(group);");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("5"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0,1]"}));
    }

    @Test
    public void testBinCond1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile5.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2, a3);");
        this.pigServer.registerQuery("B = foreach A generate ($1 == '2'? $2 : $3);");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("3"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [1,2,3]"}));
    }

    @Test
    public void testCoGroup6() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = cogroup A by ($1), B by ($1);");
        this.pigServer.registerQuery("D = foreach C generate A, flatten(B.($0, $1));");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 3 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("{(1,2,3)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(2).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testFRJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"replicated\";");
        this.pigServer.registerQuery("D = foreach C generate $0, $3;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0]", "Loader for B is pruned. Load fields [0]"}));
    }

    @Test
    public void testFilter2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = filter A by a0+a2 == 4;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0,2]"}));
    }

    @Test
    public void testCogroup8() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by *;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("(1,2,3)"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("(2,5,2)"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testJoin3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile4.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = join A by *, B by * using \"replicated\";");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testLoadForEach4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate *;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0]"}));
    }

    @Test
    public void testForEachUDF() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("A2 = foreach A generate (chararray)a0, (chararray)a1, (chararray)a2;");
        this.pigServer.registerQuery("B = foreach A2 generate StringSize(*);");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testOutJoin1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile6.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("C = join A by $0 left, B by $0;");
        this.pigServer.registerQuery("D = foreach C generate $0;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(2)");
        results.add("()");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0]", "Loader for B is pruned. Load fields [0]"}));
    }

    @Test
    public void testFilter3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = filter A by " + MyFilterFunc.class.getName() + "(*) ;");
        this.pigServer.registerQuery("C = foreach B generate $0;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    @Test
    public void testMapKey1() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("A1 = foreach A generate (int)a0,(map[])a1;");
        File newTmpFile = File.createTempFile("pruneBinStorage", ".txt");
        newTmpFile.delete();
        this.pigServer.store("A1", Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()), "BinStorage()");
        this.pigServer.registerQuery("A2 = load '" + Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()) + "' using BinStorage() as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A2 generate a0, a1#'key1';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(1));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).equals(2));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A2 is pruned. Load fields [0,1]", "Map key required for A2: $1->[key1]"}));
    }

    @Test
    public void testMapKey2() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("A1 = foreach A generate (int)a0,(map[])a1;");
        File newTmpFile = File.createTempFile("pruneBinStorage", ".txt");
        newTmpFile.delete();
        this.pigServer.store("A1", Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()), "BinStorage()");
        this.pigServer.registerQuery("A2 = load '" + Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()) + "' using BinStorage() as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A2 generate a1, a1#'key1';");
        this.pigServer.registerQuery("C = foreach B generate $0#'key2', $1;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("4"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A2 is pruned. Load fields [1]", "Map key required for A2: $1->[key2, key1]"}));
    }

    @Test
    public void testMapKey3() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("A1 = foreach A generate (int)a0,(map[])a1;");
        File newTmpFile = File.createTempFile("pruneBinStorage", ".txt");
        newTmpFile.delete();
        this.pigServer.store("A1", Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()), "BinStorage()");
        this.pigServer.registerQuery("A2 = load '" + Util.generateURI(newTmpFile.toString(), this.pigServer.getPigContext()) + "' using BinStorage() as (a0:int, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A2 generate a1, a1#'key1';");
        this.pigServer.registerQuery("C = group B all;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("all"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{([key2#2,key1#1],1),([key2#4,key1#2],2)}"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A2 is pruned. Load fields [1]"}));
    }

    @Test
    public void testConstantPlan() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate 1, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [2]"}));
    }

    @Test
    public void testBinStorage1() throws Exception {
        File intermediateFile = File.createTempFile("intemediate", "txt");
        intermediateFile.delete();
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.store("A", intermediateFile.toString(), "BinStorage()");
        this.pigServer.registerQuery("A = load '" + intermediateFile.toString() + "' using BinStorage() as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0]"}));
        intermediateFile.delete();
    }

    @Test
    public void testBinStorage2() throws Exception {
        File intermediateFile = File.createTempFile("intemediate", "txt");
        intermediateFile.delete();
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' as (a0, a1, a2);");
        this.pigServer.store("A", intermediateFile.toString(), "BinStorage()");
        this.pigServer.registerQuery("A = load '" + intermediateFile.toString() + "' using BinStorage() as (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a2, a0, a1;");
        this.pigServer.registerQuery("C = foreach B generate a0, a2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("3"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0,2]"}));
        intermediateFile.delete();
    }

    @Test
    public void testProjectCastKeyLookup() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("B = foreach A generate a1#'key1';");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [1]"}));
    }

    @Test
    public void testRelayFlattenMap() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile3.toString(), this.pigServer.getPigContext()) + "' as (a0, a1);");
        this.pigServer.registerQuery("A1 = foreach A generate a0,(map[])a1;");
        File tmpBinFile = File.createTempFile("pruneBinStorage", ".txt");
        tmpBinFile.delete();
        this.pigServer.store("A1", Util.generateURI(tmpBinFile.toString(), this.pigServer.getPigContext()), "BinStorage()");
        this.pigServer.registerQuery("A2 = load '" + Util.generateURI(tmpBinFile.toString(), this.pigServer.getPigContext()) + "' using BinStorage() as (a0, a1:map[]);");
        this.pigServer.registerQuery("B = foreach A2 generate flatten(a1);");
        this.pigServer.registerQuery("C = foreach B generate a1#'key1';");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 1 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A2 is pruned. Load fields [1]", "Map key required for A2: $1->[key1]"}));
    }

    @Test
    public void testCoGroup8() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("A1 = foreach A generate a0,(int)a1,a2;");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile2.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1);");
        this.pigServer.registerQuery("B1 = foreach B generate b0,(int)b1;");
        this.pigServer.registerQuery("C = cogroup A1 by ($1), B1 by ($1);");
        this.pigServer.registerQuery("D = foreach C generate $0, $1;");
        Iterator iter = this.pigServer.openIterator("D");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("1"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("2"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{(1,2,3)}"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(0).toString().equals("5"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.get(1).toString().equals("{(2,5,2)}"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for B is pruned. Load fields [1]"}));
    }

    @Test
    public void testUserDefinedSchema() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS ( c1 : chararray, c2 : int);");
        this.pigServer.registerQuery("A1 = foreach A generate (chararray)c1, (int)c2;");
        this.pigServer.registerQuery("B = foreach A1 generate c1 as c1 : chararray, c2 as c2 : int, 'CA' as state : chararray;");
        this.pigServer.registerQuery("C = foreach B generate c1 as c1 : chararray;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(1)"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(2)"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0]"}));
    }

    @Test
    public void testJoin4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = join A by a2, B by b2;");
        this.pigServer.registerQuery("D = foreach C generate $0,  $1,  $2;");
        Iterator iter = this.pigServer.openIterator("D");
        HashSet<String> results = new HashSet<String>();
        results.add("(1,2,3)");
        results.add("(2,5,2)");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)results.contains(t.toString()));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for B is pruned. Load fields [2]"}));
    }

    @Test
    public void testFilter4() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("A1 = foreach A generate a0,a1,(int)a2;");
        this.pigServer.registerQuery("B = filter A1 by a2==3;");
        this.pigServer.registerQuery("C = foreach B generate $2;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(3)"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [2]"}));
    }

    @Test
    public void testCogroup9() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' AS (c0, c1, c2);");
        this.pigServer.registerQuery("D = cogroup A by a2, B by b2, C by c2;");
        this.pigServer.registerQuery("E = foreach D generate $1, $2;");
        Iterator iter = this.pigServer.openIterator("E");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("({(2,5,2)},{(2,5,2)})"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((t.size() == 2 ? 1 : 0) != 0);
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("({(1,2,3)},{(1,2,3)})"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for C is pruned. Load fields [2]"}));
    }

    @Test
    public void testForEachFlatten() throws Exception {
        File inputFile = Util.createInputFile("table_testForEachFlatten", "", new String[]{"oiue\tM\t3", "oiue\tM\t4"});
        this.pigServer.registerQuery("M = load '" + inputFile.toString() + "' as (a0, a1, a2);");
        this.pigServer.registerQuery("N = group M by (a0, a1);");
        this.pigServer.registerQuery("S = foreach N generate FLATTEN(group), M;");
        long time = System.currentTimeMillis();
        this.pigServer.store("S", "tmp" + time, BinStorage.class.getName() + "()");
        this.pigServer.registerQuery("A = load 'tmp" + time + "' using BinStorage() as (a0:chararray, a1:chararray, a2:bag{t:tuple(id:chararray, v:chararray, v2:chararray)});");
        this.pigServer.registerQuery("B = foreach A generate a0, a1, flatten(a2), 10;");
        this.pigServer.registerQuery("C = foreach B generate a0, $5;");
        Iterator iter = this.pigServer.openIterator("C");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(oiue,10)"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.checkLogFileMessage(new String[]{"Loader for A is pruned. Load fields [0,2]"}));
    }

    @Test
    public void testFieldsToReadDuplicatedEntry() throws Exception {
        this.pigServer.registerQuery("A = load '" + Util.generateURI(this.tmpFile1.toString(), this.pigServer.getPigContext()) + "' using " + PigStorageWithTrace.class.getName() + " AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = foreach A generate a0+a0, a1, a2;");
        Iterator iter = this.pigServer.openIterator("B");
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(2.0,2,3)"));
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)t.toString().equals("(4.0,5,2)"));
        TestPruneColumnNewLogicalPlan.assertFalse((boolean)iter.hasNext());
        TestPruneColumnNewLogicalPlan.assertTrue((boolean)this.emptyLogFileMessage());
    }

    public static class MyFilterFunc
    extends FilterFunc {
        public Boolean exec(Tuple input) {
            return true;
        }
    }

    public static class PigStorageWithTrace
    extends PigStorage {
        public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
            LoadPushDown.RequiredFieldResponse response = super.pushProjection(requiredFieldList);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.info((Object)requiredFieldList);
            return response;
        }
    }
}

