/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.PushDownForeachFlatten;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.test.utils.Identity;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Before;
import org.junit.Test;

public class TestPushDownForeachFlatten
extends TestCase {
    final String FILE_BASE_LOCATION = "test/org/apache/pig/test/data/DotFiles/";
    static final int MAX_SIZE = 100000;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    LogicalPlanTester planTester = new LogicalPlanTester();
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @Before
    public void tearDown() {
        this.planTester.reset();
    }

    @Test
    public void testErrorEmptyInput() throws Exception {
        LogicalPlan lp = new LogicalPlan();
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        try {
            pushDownForeach.check(lp.getRoots());
            TestPushDownForeachFlatten.fail((String)"Exception Expected!");
        }
        catch (Exception e) {
            TestPushDownForeachFlatten.assertTrue((((OptimizerException)e).getErrorCode() == 2052 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrorNonForeachInput() throws Exception {
        LogicalPlan lp = this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        try {
            pushDownForeach.check(lp.getRoots());
            TestPushDownForeachFlatten.fail((String)"Exception Expected!");
        }
        catch (Exception e) {
            TestPushDownForeachFlatten.assertTrue((((OptimizerException)e).getErrorCode() == 2005 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testForeachNoFlatten() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        LogicalPlan lp = this.planTester.buildPlan("B = foreach A generate $1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachNoSuccessors() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        LogicalPlan lp = this.planTester.buildPlan("B = foreach A generate flatten($1);");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachStreaming() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate flatten($1);");
        LogicalPlan lp = this.planTester.buildPlan("C = stream B through `" + simpleEchoStreamingCommand + "`;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachDistinct() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate flatten($1);");
        LogicalPlan lp = this.planTester.buildPlan("C = distinct B;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachForeach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten(1);");
        LogicalPlan lp = this.planTester.buildPlan("C = foreach B generate $0;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachFilter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachSplitOutput() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("split B into C if $1 < 18, D if $1 >= 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachLimit() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("B = limit B 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachUnion() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference);");
        LogicalPlan lp = this.planTester.buildPlan("D = union B, C;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCogroup() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference);");
        LogicalPlan lp = this.planTester.buildPlan("D = cogroup B by $0, C by $0;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachGroupBy() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("C = group B by $0;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)load)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("C = order B by $0, $1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)sort).get(0);
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getPredecessors((Operator)sort)));
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getPredecessors((Operator)sort));
        TestPushDownForeachFlatten.assertEquals((Object)foreach, lp.getLeaves().get(0));
        TestPushDownForeachFlatten.assertEquals((Object)sort, lp.getPredecessors((Operator)foreach).get(0));
    }

    @Test
    public void testForeachFlattenAddedColumnSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten(1);");
        LogicalPlan lp = this.planTester.buildPlan("C = order B by $0, $1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getPredecessors((Operator)sort)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachUDFSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $0, $1, " + Identity.class.getName() + "($2) ;");
        LogicalPlan lp = this.planTester.buildPlan("C = order B by $0, $1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getPredecessors((Operator)sort)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCastSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate (chararray)$0, $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("C = order B by $0, $1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getPredecessors((Operator)sort)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("D = cross B, C;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOCross cross = (LOCross)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)cross).get(0);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)cross).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachCross1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("C = foreach B generate $0, $1, flatten($2);");
        this.planTester.buildPlan("D = cross A, C;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(1);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOCross cross = (LOCross)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)cross).get(1);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)cross).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachCross2() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = foreach C generate $0, $1, flatten($2);");
        this.planTester.buildPlan("E = cross B, D;");
        LogicalPlan lp = this.planTester.buildPlan("F = limit E 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachFlattenAddedColumnCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten(1);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = cross B, C;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachUDFCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, flatten($1), " + Identity.class.getName() + "($2) ;");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = cross B, C;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCastCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, (int)$1, $2;");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = cross B, C;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("D = join B by $0, C by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOJoin frjoin = (LOJoin)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)frjoin).get(0);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)frjoin).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachFRJoin1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("C = foreach B generate $0, $1, flatten($2);");
        this.planTester.buildPlan("D = join A by $0, C by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(1);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOJoin frjoin = (LOJoin)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)frjoin).get(1);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)frjoin).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachFRJoin2() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = foreach C generate $0, $1, flatten($2);");
        this.planTester.buildPlan("E = join B by $0, D by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("F = limit E 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachFlattenAddedColumnFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten(1);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachUDFFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, flatten($1), " + Identity.class.getName() + "($2) ;");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCastFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, (int)$1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOJoin join = (LOJoin)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)join).get(0);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)join).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachInnerJoin1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("C = foreach B generate $0, $1, flatten($2);");
        this.planTester.buildPlan("D = join A by $0, C by $0;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(1);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOJoin join = (LOJoin)lp.getPredecessors((Operator)limit).get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)join).get(1);
        Schema limitSchema = limit.getSchema();
        TestPushDownForeachFlatten.assertTrue((boolean)pushDownForeach.check(lp.getSuccessors((Operator)load)));
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() != null ? 1 : 0) != 0);
        pushDownForeach.transform(lp.getSuccessors((Operator)load));
        this.planTester.rebuildSchema(lp);
        for (Boolean b : foreach.getFlatten()) {
            TestPushDownForeachFlatten.assertEquals((boolean)b, (boolean)false);
        }
        LOForEach newForeach = (LOForEach)lp.getSuccessors((Operator)join).get(0);
        List newForeachFlatten = newForeach.getFlatten();
        Map remap = pushDownForeach.getFlattenedColumnMap();
        for (Integer key : remap.keySet()) {
            Integer value = (Integer)remap.get(key);
            TestPushDownForeachFlatten.assertEquals((boolean)((Boolean)newForeachFlatten.get(value)), (boolean)true);
        }
        TestPushDownForeachFlatten.assertTrue((boolean)Schema.equals((Schema)limitSchema, (Schema)limit.getSchema(), (boolean)false, (boolean)true));
    }

    @Test
    public void testForeachInnerJoin2() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = foreach C generate $0, $1, flatten($2);");
        this.planTester.buildPlan("E = join B by $0, D by $0;");
        LogicalPlan lp = this.planTester.buildPlan("F = limit E 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachFlattenAddedColumnInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, $1, flatten(1);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachUDFInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, flatten($1), " + Identity.class.getName() + "($2) ;");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachCastInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa:(letter_grade, point_score));");
        this.planTester.buildPlan("B = foreach A generate $0, (int)$1, flatten($2);");
        this.planTester.buildPlan("C = load 'anotherfile' as (name, age, preference:(course_name, instructor));");
        this.planTester.buildPlan("D = join B by $0, C by $0;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((pushDownForeach.getFlattenedColumnMap() == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeachJoinRequiredField() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (bg:bag{t:tuple(a0,a1)});");
        this.planTester.buildPlan("B = FOREACH A generate flatten($0);");
        this.planTester.buildPlan("C = load '3.txt' AS (c0, c1);");
        this.planTester.buildPlan("D = JOIN B by a1, C by c1;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
    }

    @Test
    public void testForeachRequiredField() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (b{t(a0:chararray,a1:int)});");
        this.planTester.buildPlan("B = foreach A generate flatten($0);");
        LogicalPlan lp = this.planTester.buildPlan("C = order B by $1 desc;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        this.planTester.rebuildSchema(lp);
        PushDownForeachFlatten pushDownForeach = new PushDownForeachFlatten(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.check(lp.getSuccessors((Operator)loada)) ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getSwap() ? 1 : 0) != 0);
        TestPushDownForeachFlatten.assertTrue((!pushDownForeach.getInsertBetween() ? 1 : 0) != 0);
    }

    public static class MyFilterFunc
    extends FilterFunc {
        public Boolean exec(Tuple input) {
            return false;
        }
    }
}

