/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import junit.framework.TestCase;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.PushUpFilter;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Before;
import org.junit.Test;

public class TestPushUpFilter
extends TestCase {
    final String FILE_BASE_LOCATION = "test/org/apache/pig/test/data/DotFiles/";
    static final int MAX_SIZE = 100000;
    LogicalPlanTester planTester = new LogicalPlanTester();
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @Before
    public void tearDown() {
        this.planTester.reset();
    }

    @Test
    public void testErrorEmptyInput() throws Exception {
        LogicalPlan lp = new LogicalPlan();
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        try {
            pushUpFilter.check(lp.getRoots());
            TestPushUpFilter.fail((String)"Exception Expected!");
        }
        catch (Exception e) {
            TestPushUpFilter.assertTrue((((OptimizerException)e).getErrorCode() == 2052 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrorNonFilterInput() throws Exception {
        LogicalPlan lp = this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        try {
            pushUpFilter.check(lp.getRoots());
            TestPushUpFilter.fail((String)"Exception Expected!");
        }
        catch (Exception e) {
            TestPushUpFilter.assertTrue((((OptimizerException)e).getErrorCode() == 2005 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFilterLoad() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        LogicalPlan lp = this.planTester.buildPlan("B = filter A by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterStreaming() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = stream A through `" + simpleEchoStreamingCommand + "`;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = order A by $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getLeaves()));
        TestPushUpFilter.assertTrue((pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        LOSort sort = (LOSort)lp.getPredecessors((Operator)filter).get(0);
        pushUpFilter.transform(lp.getLeaves());
        TestPushUpFilter.assertEquals((Object)sort, lp.getLeaves().get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)sort).get(0));
    }

    @Test
    public void testFilterConstantConditionSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = order A by $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFSort() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = order A by $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter B by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterDistinct() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = distinct A;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getLeaves()));
        TestPushUpFilter.assertTrue((pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        LODistinct distinct = (LODistinct)lp.getPredecessors((Operator)filter).get(0);
        pushUpFilter.transform(lp.getLeaves());
        TestPushUpFilter.assertEquals((Object)distinct, lp.getLeaves().get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)distinct).get(0));
    }

    @Test
    public void testFilterConstantConditionDistinct() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = distinct A;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFDistinct() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = distinct A;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter B by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterForeach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $0 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getLeaves()));
        TestPushUpFilter.assertTrue((pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        LOForEach foreach = (LOForEach)lp.getPredecessors((Operator)filter).get(0);
        pushUpFilter.transform(lp.getLeaves());
        TestPushUpFilter.assertEquals((Object)foreach, lp.getLeaves().get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)foreach).get(0));
    }

    @Test
    public void testFilterForeachAddedField() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, $2, COUNT({(1)});");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $2 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterForeachCast() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate (chararray)$1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $0 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterCastForeach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by (int)$0 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterConstantConditionForeach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFForeach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, $2;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter B by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterForeachFlatten() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = foreach A generate $1, flatten($2);");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $0 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterFilter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = filter A by $0 != 'name';");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterSplitOutput() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("split A into B if $1 < 18, C if $1 >= 18;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter B by $1 < 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterLimit() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = limit A 10;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUnion() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = union A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by $1 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterConstantConditionUnion() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = union A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFUnion() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = union A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cross A, B;");
        this.planTester.buildPlan("D = filter C by $5 < 18;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOCross cross = (LOCross)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 1 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)cross, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)cross).get(1));
    }

    @Test
    public void testFilterCross1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cross A, B;");
        this.planTester.buildPlan("D = filter C by $1 < 18;");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOCross cross = (LOCross)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 0 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)cross, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)cross).get(0));
    }

    @Test
    public void testFilterCross2() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cross A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by $1 < 18 and $5 < 18;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterConstantConditionCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cross A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFCross() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cross A, B;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterCogroup() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by $0 < 'name';");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterConstantConditionCogroup() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFCogroup() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterCogroupOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by $0 < 'name';");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterConstantConditionCogroupOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFCogroupOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = cogroup A by $0, B by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterGroupBy() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $0 < 'name';");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getLeaves()));
        TestPushUpFilter.assertTrue((pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        LOCogroup groupBy = (LOCogroup)lp.getPredecessors((Operator)filter).get(0);
        pushUpFilter.transform(lp.getLeaves());
        TestPushUpFilter.assertEquals((Object)groupBy, lp.getLeaves().get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)groupBy).get(0));
    }

    @Test
    public void testFilterConstantConditionGroupBy() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFGroupBy() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterGroupByOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by $0 < 'name';");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getLeaves()));
        TestPushUpFilter.assertTrue((pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        LOCogroup groupBy = (LOCogroup)lp.getPredecessors((Operator)filter).get(0);
        pushUpFilter.transform(lp.getLeaves());
        TestPushUpFilter.assertEquals((Object)groupBy, lp.getLeaves().get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)groupBy).get(0));
    }

    @Test
    public void testFilterConstantConditionGroupByOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFGroupByOuter() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by $0 outer;");
        LogicalPlan lp = this.planTester.buildPlan("C = filter B by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0 using \"replicated\";");
        this.planTester.buildPlan("D = filter C by $0 < 'name';");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOJoin frjoin = (LOJoin)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 0 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)frjoin, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)frjoin).get(0));
    }

    @Test
    public void testFilterFRJoin1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0 using \"replicated\";");
        this.planTester.buildPlan("D = filter C by $4 < 'name';");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOJoin frjoin = (LOJoin)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 1 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)frjoin, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)frjoin).get(1));
    }

    @Test
    public void testFilterConstantConditionFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFFRJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0 using \"replicated\";");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0;");
        this.planTester.buildPlan("D = filter C by $0 < 'name';");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOJoin join = (LOJoin)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 0 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)join, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)join).get(0));
    }

    @Test
    public void testFilterInnerJoin1() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0;");
        this.planTester.buildPlan("D = filter C by $4 < 'name';");
        LogicalPlan lp = this.planTester.buildPlan("E = limit D 10;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        LOFilter filter = (LOFilter)lp.getPredecessors((Operator)limit).get(0);
        LOJoin join = (LOJoin)lp.getPredecessors((Operator)filter).get(0);
        TestPushUpFilter.assertTrue((boolean)pushUpFilter.check(lp.getPredecessors((Operator)limit)));
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == 1 ? 1 : 0) != 0);
        pushUpFilter.transform(lp.getPredecessors((Operator)limit));
        TestPushUpFilter.assertEquals((Object)join, lp.getPredecessors((Operator)limit).get(0));
        TestPushUpFilter.assertEquals((Object)filter, lp.getPredecessors((Operator)join).get(1));
    }

    @Test
    public void testFilterConstantConditionInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by 1 == 1;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterUDFInnerJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name, age, preference);");
        this.planTester.buildPlan("C = join A by $0, B by $0;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by " + MyFilterFunc.class.getName() + "() ;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterNestedForEach() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = group A by name;");
        this.planTester.buildPlan("C = foreach B generate A.age as age;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by age == 20;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testOutJoin() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (name, age, gpa);");
        this.planTester.buildPlan("B = load 'anotherfile' as (name);");
        this.planTester.buildPlan("C = join A by name LEFT OUTER, B by name;");
        LogicalPlan lp = this.planTester.buildPlan("D = filter C by B::name is null;");
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        PushUpFilter pushUpFilter = new PushUpFilter(lp);
        TestPushUpFilter.assertTrue((!pushUpFilter.check(lp.getLeaves()) ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getSwap() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((!pushUpFilter.getPushBefore() ? 1 : 0) != 0);
        TestPushUpFilter.assertTrue((pushUpFilter.getPushBeforeInput() == -1 ? 1 : 0) != 0);
    }

    public static class MyFilterFunc
    extends FilterFunc {
        public Boolean exec(Tuple input) {
            return false;
        }
    }
}

