/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Test;

public class TestRelevantFields
extends TestCase {
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";
    LogicalPlanTester planTester = new LogicalPlanTester();

    @Test
    public void testQueryForeach1() throws FrontendException {
        String query = "foreach (load 'a') generate $1,$2;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach2() throws FrontendException {
        String query = "foreach (load 'a') generate $1,$2+$3;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)foreachRelevantFields1.getFields().contains(new Pair((Object)0, (Object)2)));
        TestRelevantFields.assertTrue((boolean)foreachRelevantFields1.getFields().contains(new Pair((Object)0, (Object)3)));
    }

    @Test
    public void testQueryForeach3() throws FrontendException {
        String query = "foreach (load 'a') generate $1,CONCAT($2,$3);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)foreachRelevantFields1.getFields().contains(new Pair((Object)0, (Object)2)));
        TestRelevantFields.assertTrue((boolean)foreachRelevantFields1.getFields().contains(new Pair((Object)0, (Object)3)));
    }

    @Test
    public void testQueryCogroup1() throws FrontendException {
        String query = "foreach (cogroup (load 'a') by $1, (load 'b') by $1) generate org.apache.pig.builtin.AVG($1) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)1)));
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields1.getFields().contains(new Pair((Object)1, (Object)1)));
        RequiredFields cogroupRelevantFields10 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields10.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields10.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields10.getFields() == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields11 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(1);
        TestRelevantFields.assertTrue((cogroupRelevantFields11 == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields20 = (RequiredFields)cogroup.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields20 == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields21 = (RequiredFields)cogroup.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((!cogroupRelevantFields21.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields21.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields21.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupAll() throws FrontendException {
        String query = "foreach (group (load 'a') ALL) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getFields() == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup2() throws FrontendException {
        String query = "foreach (group (load 'a') by $1) generate group, '1' ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)1)));
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroup2() throws FrontendException {
        String query = "foreach (cogroup (load 'a') by ($1), (load 'b') by ($1)) generate $1.$1, $2.$1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields01 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields01.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields01.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields01.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields01.getFields().contains(new Pair((Object)0, (Object)1)));
        RequiredFields cogroupRelevantFields02 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((cogroupRelevantFields02.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields02.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields02.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields02.getFields().contains(new Pair((Object)1, (Object)1)));
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields() == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields2 = (RequiredFields)cogroup.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((cogroupRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields2.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroup3() throws FrontendException {
        String query = "foreach (group (load 'a') by ($6, $7)) generate flatten(group) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getFields().size() == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)6)));
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)7)));
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
    }

    public void testQueryFilterNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        List filterRelevantFields0 = filter.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)filterRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)filterRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)filterRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)((RequiredFields)filterRelevantFields0.get(0)).getFields().contains(new Pair((Object)0, (Object)0)));
    }

    @Test
    public void testQuerySplitNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if $0 == '3', c if $1 == '3';");
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields splitRelevantFields = (RequiredFields)split.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitRelevantFields.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitRelevantFields.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitRelevantFields.getFields().size() == 1 ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        RequiredFields splitbRelevantFields0 = (RequiredFields)splitb.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitbRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitbRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitbRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitbRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitbRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields splitbRelevantFields1 = (RequiredFields)splitb.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitbRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitbRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitbRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitbRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        RequiredFields splitcRelevantFields0 = (RequiredFields)splitc.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitcRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitcRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitcRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitcRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields splitcRelevantFields = (RequiredFields)splitc.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitcRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitcRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitcRelevantFields.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitcRelevantFields.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitcRelevantFields.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOSort sort = (LOSort)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields sortRelevantFields0 = (RequiredFields)sort.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields sortRelevantFields1 = (RequiredFields)sort.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
    }

    @Test
    public void testQueryLimitNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        List limitRelevantFields0 = limit.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)limitRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields0.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields0.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields0.get((int)0)).getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        List limitRelevantFields1 = limit.getRelevantInputs(0, 1);
        TestRelevantFields.assertTrue((((RequiredFields)limitRelevantFields1.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields1.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields1.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields1.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields1.get((int)0)).getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LODistinct distinct = (LODistinct)lp.getLeaves().get(0);
        List distinctRelevantFields0 = distinct.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)distinctRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields0.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields0.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields0.get((int)0)).getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        List distinctRelevantFields1 = distinct.getRelevantInputs(0, 1);
        TestRelevantFields.assertTrue((((RequiredFields)distinctRelevantFields1.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields1.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields1.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields1.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields1.get((int)0)).getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema() throws FrontendException {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "`;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields streamRelevantFields = (RequiredFields)stream.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((streamRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!streamRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((streamRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingNoSchema1() throws FrontendException {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields streamRelevantFields = (RequiredFields)stream.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((streamRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!streamRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((streamRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeach4() throws FrontendException {
        this.planTester.buildPlan("A = load 'a';");
        this.planTester.buildPlan("B = load 'b';");
        LogicalPlan lp = this.planTester.buildPlan("foreach (cogroup A by ($1), B by ($1)) generate A, flatten(B.($1, $2, $3));");
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields2 = (RequiredFields)foreach.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields3 = (RequiredFields)foreach.getRelevantInputs(0, 3).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 4) == null ? 1 : 0) != 0);
    }

    @Test
    public void testForeach5() throws FrontendException {
        this.planTester.buildPlan("A = load 'a' AS (a1, a2, a3);");
        this.planTester.buildPlan("B = load 'b' AS (b1, b2, b3, b4);");
        this.planTester.buildPlan("C = cogroup A by ($1), B by ($1);");
        String query = "foreach C { B = order B by $0; generate FLATTEN(A), B.($1, $2, $3) ;};";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields2 = (RequiredFields)foreach.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields3 = (RequiredFields)foreach.getRelevantInputs(0, 3).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossNoSchema() throws FrontendException {
        String query = "c = cross (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCross cross = (LOCross)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionNoSchema() throws FrontendException {
        String query = "c = union (load 'a'), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOUnion union = (LOUnion)lp.getLeaves().get(0);
        RequiredFields unionRelevantFields0 = (RequiredFields)union.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields unionRelevantFields1 = (RequiredFields)union.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields1.getFields().contains(new Pair((Object)1, (Object)0)));
    }

    public void testQueryFRJoinNoSchema() throws FrontendException {
        String query = "c = join (load 'a') by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin frjoin = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinNoSchema() throws FrontendException {
        String query = "c = join (load 'a') by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin join = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by $1 == '3';");
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        List filterRelevantFields0 = filter.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)filterRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)filterRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)filterRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)((RequiredFields)filterRelevantFields0.get(0)).getFields().contains(new Pair((Object)0, (Object)0)));
    }

    @Test
    public void testQuerySplitWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if url == '3', c if hitCount == '3';");
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields splitRelevantFields0 = (RequiredFields)split.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitRelevantFields0.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitRelevantFields0.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields splitRelevantFields1 = (RequiredFields)split.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitRelevantFields1.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitRelevantFields1.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
        TestRelevantFields.assertTrue((split.getRelevantInputs(0, 2) == null ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        RequiredFields splitbRelevantFields = (RequiredFields)splitb.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitbRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitbRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitbRelevantFields.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitbRelevantFields.getFields().contains(new Pair((Object)0, (Object)1)));
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        RequiredFields splitcRelevantFields = (RequiredFields)splitc.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitcRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitcRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitcRelevantFields.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitcRelevantFields.getFields().contains(new Pair((Object)0, (Object)1)));
    }

    @Test
    public void testQueryOrderByWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by $1;");
        LOSort sort = (LOSort)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields sortRelevantFields0 = (RequiredFields)sort.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields sortRelevantFields1 = (RequiredFields)sort.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
    }

    @Test
    public void testQueryLimitWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = order a by $1;");
        LogicalPlan lp = this.planTester.buildPlan("c = limit b 10;");
        LOLimit limit = (LOLimit)lp.getLeaves().get(0);
        List limitRelevantFields0 = limit.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)limitRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields0.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields0.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields0.get((int)0)).getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        List limitRelevantFields1 = limit.getRelevantInputs(0, 1);
        TestRelevantFields.assertTrue((((RequiredFields)limitRelevantFields1.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields1.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)limitRelevantFields1.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields1.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)limitRelevantFields1.get((int)0)).getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryDistinctWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = distinct a;");
        LODistinct distinct = (LODistinct)lp.getLeaves().get(0);
        List distinctRelevantFields0 = distinct.getRelevantInputs(0, 0);
        TestRelevantFields.assertTrue((((RequiredFields)distinctRelevantFields0.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields0.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields0.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields0.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields0.get((int)0)).getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        List distinctRelevantFields1 = distinct.getRelevantInputs(0, 1);
        TestRelevantFields.assertTrue((((RequiredFields)distinctRelevantFields1.get(0)).getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields1.get(0)).getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!((RequiredFields)distinctRelevantFields1.get(0)).getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields1.get((int)0)).getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)((RequiredFields)distinctRelevantFields1.get((int)0)).getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema() throws FrontendException {
        String query = "stream (load 'a') through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields streamRelevantFields = (RequiredFields)stream.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((streamRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!streamRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((streamRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryStreamingWithSchema1() throws FrontendException {
        String query = "stream (load 'a' as (url, hitCount)) through `" + simpleEchoStreamingCommand + "` as (x, y);";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOStream stream = (LOStream)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields streamRelevantFields = (RequiredFields)stream.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((streamRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!streamRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((streamRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryImplicitJoinWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url,rank);");
        this.planTester.buildPlan("c = cogroup a by url, b by url;");
        LogicalPlan lp = this.planTester.buildPlan("d = foreach c generate group,flatten(a),flatten(b);");
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        TestRelevantFields.assertTrue((cogroup.getRelevantInputs(0, 0).size() == 2 ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields00 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields00.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields00.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields00.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)cogroupRelevantFields00.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)cogroupRelevantFields00.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields01 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((!cogroupRelevantFields01.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields01.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields01.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)cogroupRelevantFields01.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)cogroupRelevantFields01.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroup.getRelevantInputs(0, 1).size() == 2 ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields() == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroup.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields2 = (RequiredFields)cogroup.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((cogroupRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields2.getFields() == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroup.getRelevantInputs(0, 2).get(0) == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields2 = (RequiredFields)foreach.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields3 = (RequiredFields)foreach.getRelevantInputs(0, 3).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields3.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields4 = (RequiredFields)foreach.getRelevantInputs(0, 4).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields4.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields4.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields4.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields4.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields4.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 5) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithSchema() throws FrontendException {
        String query = "c = cross (load 'a' as (a, b, c)), (load 'b' as (d, e, f));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCross cross = (LOCross)lp.getLeaves().get(0);
        RequiredFields crossRelevantFields0 = (RequiredFields)cross.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!crossRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 0).get(1) == null ? 1 : 0) != 0);
        RequiredFields crossRelevantFields1 = (RequiredFields)cross.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!crossRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields crossRelevantFields2 = (RequiredFields)cross.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((!crossRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields2.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields2.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 2).get(1) == null ? 1 : 0) != 0);
        RequiredFields crossRelevantFields3 = (RequiredFields)cross.getRelevantInputs(0, 3).get(1);
        TestRelevantFields.assertTrue((!crossRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields3.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields3.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 3).get(0) == null ? 1 : 0) != 0);
        RequiredFields crossRelevantFields4 = (RequiredFields)cross.getRelevantInputs(0, 4).get(1);
        TestRelevantFields.assertTrue((!crossRelevantFields4.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields4.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields4.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields4.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 4).get(0) == null ? 1 : 0) != 0);
        RequiredFields crossRelevantFields5 = (RequiredFields)cross.getRelevantInputs(0, 5).get(1);
        TestRelevantFields.assertTrue((!crossRelevantFields5.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!crossRelevantFields5.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields5.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)crossRelevantFields5.getFields().get((int)0)).second == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 5).get(0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithSchema() throws FrontendException {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b' as (url, rank));";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOUnion union = (LOUnion)lp.getLeaves().get(0);
        RequiredFields unionRelevantFields0 = (RequiredFields)union.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields unionRelevantFields1 = (RequiredFields)union.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields1.getFields().contains(new Pair((Object)1, (Object)0)));
    }

    @Test
    public void testQueryFRJoinSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin frjoin = (LOJoin)lp.getLeaves().get(0);
        RequiredFields frjoinRelevantFields0 = (RequiredFields)frjoin.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 0).get(1) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields1 = (RequiredFields)frjoin.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields2 = (RequiredFields)frjoin.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((!frjoinRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields2.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields2.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 2).get(0) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields3 = (RequiredFields)frjoin.getRelevantInputs(0, 3).get(1);
        TestRelevantFields.assertTrue((!frjoinRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields3.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields3.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 3).get(0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 4) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b' as (url, rank)) by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin join = (LOJoin)lp.getLeaves().get(0);
        RequiredFields joinRelevantFields0 = (RequiredFields)join.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!joinRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 0).get(1) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields1 = (RequiredFields)join.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!joinRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields2 = (RequiredFields)join.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((!joinRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields2.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields2.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 2).get(0) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields3 = (RequiredFields)join.getRelevantInputs(0, 3).get(1);
        TestRelevantFields.assertTrue((!joinRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields3.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields3.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 3).get(0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 4) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCrossWithMixedSchema() throws FrontendException {
        String query = "c = cross (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCross cross = (LOCross)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((cross.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryUnionWithMixedSchema() throws FrontendException {
        String query = "c = union (load 'a' as (url, hitcount)), (load 'b');";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOUnion union = (LOUnion)lp.getLeaves().get(0);
        RequiredFields unionRelevantFields0 = (RequiredFields)union.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields unionRelevantFields1 = (RequiredFields)union.getRelevantInputs(0, 0).get(1);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!unionRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((unionRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)unionRelevantFields1.getFields().contains(new Pair((Object)1, (Object)0)));
    }

    @Test
    public void testQueryFRJoinWithMixedSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0 using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin frjoin = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinWithMixedSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by $0, (load 'b') by $0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin join = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterWithStarNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by COUNT(*) == 3;");
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        RequiredFields filterRelevantFields0 = (RequiredFields)filter.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!filterRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!filterRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((filterRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields filterRelevantFields1 = (RequiredFields)filter.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!filterRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!filterRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((filterRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryOrderByStarNoSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a';");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by *;");
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        RequiredFields sortRelevantFields0 = (RequiredFields)sort.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)sortRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)sortRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields sortRelevantFields1 = (RequiredFields)sort.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)sortRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)sortRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryGroupByStarNoSchema() throws FrontendException {
        String query = "foreach (group (load 'a') by *) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getSuccessors((Operator)cogroup).get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinOnStarNoSchema() throws FrontendException {
        String query = "c = join (load 'a') by *, (load 'b') by * using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin frjoin = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinOnStarNoSchema() throws FrontendException {
        String query = "c = join (load 'a') by *, (load 'b') by *;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin join = (LOJoin)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFilterStarWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = filter a by COUNT(*) == 3;");
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        RequiredFields filterRelevantFields0 = (RequiredFields)filter.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!filterRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!filterRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((filterRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields filterRelevantFields1 = (RequiredFields)filter.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!filterRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!filterRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((filterRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)filterRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitWithStarSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("split a into b if url == '3', c if COUNT(*) == '3';");
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields splitRelevantFields0 = (RequiredFields)split.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitRelevantFields0.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitRelevantFields0.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields splitRelevantFields1 = (RequiredFields)split.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitRelevantFields1.needAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitRelevantFields1.needNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
        TestRelevantFields.assertTrue((split.getRelevantInputs(0, 2) == null ? 1 : 0) != 0);
        LOSplitOutput splitb = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        RequiredFields splitbRelevantFields0 = (RequiredFields)splitb.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitbRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitbRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitbRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitbRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)splitbRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields splitbRelevantFields1 = (RequiredFields)splitb.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitbRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitbRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitbRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitbRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
        LOSplitOutput splitc = (LOSplitOutput)lp.getSuccessors((Operator)split).get(1);
        RequiredFields splitcRelevantFields0 = (RequiredFields)splitc.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!splitcRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitcRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitcRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitcRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields splitcRelevantFields1 = (RequiredFields)splitc.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!splitcRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!splitcRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((splitcRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)splitcRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
    }

    @Test
    public void testQueryOrderByStarWithSchema() throws FrontendException {
        this.planTester.buildPlan("a = load 'a' as (url,hitCount);");
        LogicalPlan lp = this.planTester.buildPlan("b = order a by *;");
        LOSort sort = (LOSort)lp.getLeaves().get(0);
        RequiredFields sortRelevantFields0 = (RequiredFields)sort.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        RequiredFields sortRelevantFields1 = (RequiredFields)sort.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!sortRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((sortRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)sortRelevantFields1.getFields().contains(new Pair((Object)0, (Object)1)));
    }

    @Test
    public void testQueryGroupByStarWithSchema() throws FrontendException {
        String query = "foreach (group (load 'a' as (url, hitCount)) by *) generate $1 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)lp.getRoots().get(0)).get(0);
        RequiredFields cogroupRelevantFields0 = (RequiredFields)cogroup.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields0.getFields().size() == 2 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)0)));
        TestRelevantFields.assertTrue((boolean)cogroupRelevantFields0.getFields().contains(new Pair((Object)0, (Object)1)));
        RequiredFields cogroupRelevantFields1 = (RequiredFields)cogroup.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!cogroupRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroupRelevantFields1.getFields() == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((cogroup.getRelevantInputs(0, 2) == null ? 1 : 0) != 0);
        LOForEach foreach = (LOForEach)lp.getSuccessors((Operator)cogroup).get(0);
        RequiredFields forEachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!forEachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!forEachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((forEachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)forEachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)forEachRelevantFields0.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinOnStarWithSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by *, (load 'b' as (url, rank)) by * using \"replicated\";";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin frjoin = (LOJoin)lp.getLeaves().get(0);
        RequiredFields frjoinRelevantFields0 = (RequiredFields)frjoin.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 0).get(1) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields1 = (RequiredFields)frjoin.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields2 = (RequiredFields)frjoin.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((!frjoinRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields2.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields2.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 2).get(0) == null ? 1 : 0) != 0);
        RequiredFields frjoinRelevantFields3 = (RequiredFields)frjoin.getRelevantInputs(0, 3).get(1);
        TestRelevantFields.assertTrue((!frjoinRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!frjoinRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoinRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields3.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)frjoinRelevantFields3.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 3).get(0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((frjoin.getRelevantInputs(0, 4) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryJoinOnStarWithSchema() throws FrontendException {
        String query = "c = join (load 'a' as (url, hitcount)) by *, (load 'b' as (url, rank)) by *;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOJoin join = (LOJoin)lp.getLeaves().get(0);
        RequiredFields joinRelevantFields0 = (RequiredFields)join.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!joinRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 0).get(1) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields1 = (RequiredFields)join.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!joinRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 1).get(1) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields2 = (RequiredFields)join.getRelevantInputs(0, 2).get(1);
        TestRelevantFields.assertTrue((!joinRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields2.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields2.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 2).get(0) == null ? 1 : 0) != 0);
        RequiredFields joinRelevantFields3 = (RequiredFields)join.getRelevantInputs(0, 3).get(1);
        TestRelevantFields.assertTrue((!joinRelevantFields3.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!joinRelevantFields3.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((joinRelevantFields3.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields3.getFields().get((int)0)).first == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)joinRelevantFields3.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 3).get(0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((join.getRelevantInputs(0, 4) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema() throws FrontendException {
        String query = "foreach (load 'a') generate * ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateCountStarNoSchema() throws FrontendException {
        String query = "foreach (load 'a') generate COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((foreachRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema1() throws FrontendException {
        String query = "foreach (load 'a') generate *, COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarNoSchema2() throws FrontendException {
        String query = "foreach (load 'a') generate *, $0 ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 0) == null ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema() throws FrontendException {
        String query = "foreach (load 'a' as (url, hitCount)) generate * ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreach.getRelevantInputs(0, 2) == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateCountStarWithSchema() throws FrontendException {
        String query = "foreach (load 'a' as (url, hitCount)) generate COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((foreachRelevantFields.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema1() throws FrontendException {
        String query = "foreach (load 'a' as (url, hitCount)) generate *, COUNT(*) ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields2 = (RequiredFields)foreach.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getFields() == null ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachGenerateStarWithSchema2() throws FrontendException {
        String query = "foreach (load 'a' as (url, hitCount)) generate *, url ;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        RequiredFields foreachRelevantFields0 = (RequiredFields)foreach.getRelevantInputs(0, 0).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields0.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields0.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields0.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields1 = (RequiredFields)foreach.getRelevantInputs(0, 1).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields1.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields1.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields1.getFields().get((int)0)).second == 1 ? 1 : 0) != 0);
        RequiredFields foreachRelevantFields2 = (RequiredFields)foreach.getRelevantInputs(0, 2).get(0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedAllFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((!foreachRelevantFields2.getNeedNoFields() ? 1 : 0) != 0);
        TestRelevantFields.assertTrue((foreachRelevantFields2.getFields().size() == 1 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).first == 0 ? 1 : 0) != 0);
        TestRelevantFields.assertTrue(((Integer)((Pair)foreachRelevantFields2.getFields().get((int)0)).second == 0 ? 1 : 0) != 0);
    }
}

