/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloner;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.After;
import org.junit.Test;

public class TestRewire
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    LogicalPlanTester planTester = new LogicalPlanTester();
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @After
    public void tearDown() throws Exception {
        this.planTester.reset();
    }

    @Test
    public void testQueryForeachFilterSwap() throws Exception {
        String query = "filter (foreach (load 'a') generate $1,$2) by $1 > 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOForEach foreach = (LOForEach)lp.getSuccessors((Operator)load).get(0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        lp.swap((Operator)filter, (Operator)foreach);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)load));
        TestRewire.assertTrue((filterProject.getCol() == 2 ? 1 : 0) != 0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOProject foreachProject = (LOProject)foreachPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 1 ? 1 : 0) != 0);
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        foreachProject = (LOProject)foreachPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryForeachFilterSwap1() throws Exception {
        this.planTester.buildPlan("a = foreach (foreach (load 'a') generate $1,$2 )  generate $0, $1;");
        String query = "b = filter a by $1 > 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOForEach foreach = (LOForEach)lp.getSuccessors((Operator)load).get(0);
        LOForEach foreach2 = (LOForEach)lp.getSuccessors((Operator)foreach).get(0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        lp.swap((Operator)filter, (Operator)foreach2);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)foreach));
        TestRewire.assertTrue((filterProject.getCol() == 1 ? 1 : 0) != 0);
        LogicalPlan foreach2Plan = (LogicalPlan)foreach2.getForEachPlans().get(0);
        LOProject foreachProject = (LOProject)foreach2Plan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 0 ? 1 : 0) != 0);
        foreach2Plan = (LogicalPlan)foreach2.getForEachPlans().get(1);
        foreachProject = (LOProject)foreach2Plan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 1 ? 1 : 0) != 0);
        lp.swap((Operator)filter, (Operator)foreach);
        filterRoots = filterPlan.getRoots();
        filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)load));
        TestRewire.assertTrue((filterProject.getCol() == 2 ? 1 : 0) != 0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        foreachProject = (LOProject)foreachPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 1 ? 1 : 0) != 0);
        foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(1);
        foreachProject = (LOProject)foreachPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((foreachProject.getCol() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeQueryForeach1() throws Exception {
        String query = "foreach (load 'a') generate $1,$2;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        try {
            lp.swap((Operator)load, (Operator)foreach);
            TestRewire.fail((String)"Expected failure.");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestRewire.assertTrue((pe.getErrorCode() == 1100 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuerySortFilterSwap() throws Exception {
        String query = "filter (order (load 'a') by $1,$2) by $1 > 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOSort sort = (LOSort)lp.getSuccessors((Operator)load).get(0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        lp.swap((Operator)filter, (Operator)sort);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)load));
        TestRewire.assertTrue((filterProject.getCol() == 1 ? 1 : 0) != 0);
        LogicalPlan sortPlan = (LogicalPlan)sort.getSortColPlans().get(0);
        LOProject sortProject = (LOProject)sortPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)sortProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((sortProject.getCol() == 1 ? 1 : 0) != 0);
        sortPlan = (LogicalPlan)sort.getSortColPlans().get(1);
        sortProject = (LOProject)sortPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)sortProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((sortProject.getCol() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySplitFilterInsertBetween() throws Exception {
        this.planTester.buildPlan("a = load 'a';");
        this.planTester.buildPlan("b = foreach a generate $0, $1, $2;");
        this.planTester.buildPlan("split b into d if $0 == '3', c if $1 == '3';");
        String query = "filter d by $2 > 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        LOForEach foreach = (LOForEach)lp.getSuccessors((Operator)load).get(0);
        LOSplit split = (LOSplit)lp.getSuccessors((Operator)foreach).get(0);
        LOSplitOutput splitd = (LOSplitOutput)lp.getSuccessors((Operator)split).get(0);
        LOFilter filter = (LOFilter)lp.getLeaves().get(0);
        lp.insertBetween((Operator)foreach, (Operator)filter, (Operator)split);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)foreach));
        TestRewire.assertTrue((filterProject.getCol() == 2 ? 1 : 0) != 0);
        LogicalPlan splitdPlan = splitd.getConditionPlan();
        List splitdRoots = splitdPlan.getRoots();
        LOProject splitdProject = splitdRoots.get(0) instanceof LOProject ? (LOProject)splitdRoots.get(0) : (LOProject)splitdRoots.get(1);
        TestRewire.assertTrue((boolean)splitdProject.getExpression().equals((Object)filter));
        TestRewire.assertTrue((splitdProject.getCol() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinFilterPushBefore() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = join a by $0, b by $0 using \"replicated\" ;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $2 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)frjoin).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        lp.pushBefore((Operator)frjoin, (Operator)filter, 0);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)loada));
        TestRewire.assertTrue((filterProject.getCol() == 0 ? 1 : 0) != 0);
        LogicalPlan joinPlan = (LogicalPlan)((List)frjoin.getJoinPlans().get((Object)filter)).get(0);
        LOProject joinProject = (LOProject)joinPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)joinProject.getExpression().equals((Object)filter));
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOProject foreachProject = foreachPlan.getRoots().get(0) instanceof LOProject ? (LOProject)foreachPlan.getRoots().get(0) : (LOProject)foreachPlan.getRoots().get(1);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)frjoin));
        TestRewire.assertTrue((foreachProject.getCol() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryCogroupFilterPushBefore() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = cogroup a by $1, b by $1;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOLoad loadb = (LOLoad)lp.getRoots().get(1);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)cogroup).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        lp.pushBefore((Operator)cogroup, (Operator)filter, 1);
        LogicalPlan filterPlan = filter.getComparisonPlan();
        List filterRoots = filterPlan.getRoots();
        LOProject filterProject = filterRoots.get(0) instanceof LOProject ? (LOProject)filterRoots.get(0) : (LOProject)filterRoots.get(1);
        TestRewire.assertTrue((boolean)filterProject.getExpression().equals((Object)loadb));
        TestRewire.assertTrue((filterProject.getCol() == 1 ? 1 : 0) != 0);
        LogicalPlan cogroupPlan = (LogicalPlan)((List)cogroup.getGroupByPlans().get((Object)filter)).get(0);
        LOProject cogroupProject = (LOProject)cogroupPlan.getRoots().get(0);
        TestRewire.assertTrue((boolean)cogroupProject.getExpression().equals((Object)filter));
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LOProject foreachProject = foreachPlan.getRoots().get(0) instanceof LOProject ? (LOProject)foreachPlan.getRoots().get(0) : (LOProject)foreachPlan.getRoots().get(1);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)cogroup));
        TestRewire.assertTrue((foreachProject.getCol() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryFRJoinFilterPushBeforeNegative() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' ;");
        this.planTester.buildPlan("c = join a by $0, b by $0 using \"replicated\" ;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $2 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOJoin frjoin = (LOJoin)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)frjoin).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        try {
            lp.pushBefore((Operator)frjoin, (Operator)filter, 0);
            TestRewire.fail((String)"Expected failure.");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestRewire.assertTrue((pe.getErrorCode() == 2156 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryCogroupFilterPushBeforeNegative() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' ;");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0;");
        this.planTester.buildPlan("d = filter c by $1 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)cogroup).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        try {
            lp.pushBefore((Operator)cogroup, (Operator)filter, 0);
            TestRewire.fail((String)"Expected failure.");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestRewire.assertTrue((pe.getErrorCode() == 2158 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryCogroupTrimAboveNegative() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        try {
            lp.trimAbove((Operator)cogroup);
            TestRewire.fail((String)"Excepted failure.");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestRewire.assertTrue((pe.getErrorCode() == 1097 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryCogroupTrimAboveNegative1() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = cogroup a by 0, b by 0;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        try {
            lp.trimAbove((Operator)cogroup);
            TestRewire.fail((String)"Excepted failure");
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            TestRewire.assertTrue((pe.getErrorCode() == 1097 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryReplaceFilter() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)cogroup).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        LogicalPlanCloner lpCloner = new LogicalPlanCloner(foreachPlan);
        LogicalPlan foreachPlanClone = lpCloner.getClonedPlan();
        ArrayList<LogicalPlan> newForeachPlans = new ArrayList<LogicalPlan>();
        newForeachPlans.add(foreachPlanClone);
        LOProject newForeachProject = foreachPlanClone.getRoots().get(0) instanceof LOProject ? (LOProject)foreachPlanClone.getRoots().get(0) : (LOProject)foreachPlanClone.getRoots().get(1);
        newForeachProject.setExpression((LogicalOperator)cogroup);
        ArrayList<Boolean> flattenList = new ArrayList<Boolean>();
        flattenList.add(true);
        LOForEach newForeach = new LOForEach(lp, new OperatorKey("", 1000L), newForeachPlans, flattenList);
        lp.replace((Operator)filter, (Operator)newForeach);
        LOProject foreachProject = foreachPlan.getRoots().get(0) instanceof LOProject ? (LOProject)foreachPlan.getRoots().get(0) : (LOProject)foreachPlan.getRoots().get(1);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)newForeach));
        TestRewire.assertTrue((foreachProject.getCol() == 0 ? 1 : 0) != 0);
        TestRewire.assertTrue((boolean)newForeachProject.getExpression().equals((Object)cogroup));
        TestRewire.assertTrue((newForeachProject.getCol() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryReemoveFilterAndReconnect() throws Exception {
        this.planTester.buildPlan("a = load 'a' as (url, hitCount);");
        this.planTester.buildPlan("b = load 'b' as (url, rank);");
        this.planTester.buildPlan("c = cogroup a by $0, b by $0;");
        this.planTester.buildPlan("d = filter c by $0 > 0;");
        String query = "e = foreach d generate $0 + 0;";
        LogicalPlan lp = this.planTester.buildPlan(query);
        this.planTester.setPlan(lp);
        this.planTester.setProjectionMap(lp);
        LOLoad loada = (LOLoad)lp.getRoots().get(0);
        LOCogroup cogroup = (LOCogroup)lp.getSuccessors((Operator)loada).get(0);
        LOFilter filter = (LOFilter)lp.getSuccessors((Operator)cogroup).get(0);
        LOForEach foreach = (LOForEach)lp.getLeaves().get(0);
        LogicalPlan foreachPlan = (LogicalPlan)foreach.getForEachPlans().get(0);
        lp.removeAndReconnect((Operator)filter);
        LOProject foreachProject = foreachPlan.getRoots().get(0) instanceof LOProject ? (LOProject)foreachPlan.getRoots().get(0) : (LOProject)foreachPlan.getRoots().get(1);
        TestRewire.assertTrue((boolean)foreachProject.getExpression().equals((Object)cogroup));
        TestRewire.assertTrue((foreachProject.getCol() == 0 ? 1 : 0) != 0);
    }
}

