/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestSample
extends TestCase {
    private PigServer pig;
    private File tmpFile;
    private String tmpfilepath;
    private int DATALEN = 1024;
    MiniCluster cluster = MiniCluster.buildCluster();

    protected void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.tmpFile = File.createTempFile(this.getName(), ".txt");
        String[] input = new String[this.DATALEN];
        for (int i = 0; i < this.DATALEN; ++i) {
            input[i] = Integer.toString(i);
        }
        this.tmpfilepath = this.tmpFile.getCanonicalPath();
        Util.createInputFile(this.cluster, this.tmpfilepath, input);
    }

    protected void tearDown() throws Exception {
        Util.deleteFile(this.cluster, this.tmpfilepath);
    }

    private void verify(String query, int expected_min, int expected_max) throws Exception {
        System.out.println("[TestSample] Query: " + query);
        this.pig.registerQuery(query);
        int count = 0;
        Iterator it = this.pig.openIterator("myid");
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        boolean closeEnough = expected_min <= count && count <= expected_max;
        System.out.println("[TestSample] Result: " + expected_min + "<=" + count + "<=" + expected_max + " -> " + closeEnough);
        TestSample.assertTrue((String)"Count outside expected range", (boolean)closeEnough);
    }

    @Test
    public void testSample_None() throws Exception {
        this.verify("myid = sample (load '" + this.tmpfilepath + "') 0.0;", 0, 0);
    }

    @Test
    public void testSample_All() throws Exception {
        this.verify("myid = sample (load '" + this.tmpfilepath + "') 1.0;", this.DATALEN, this.DATALEN);
    }

    @Test
    public void testSample_Some() throws Exception {
        this.verify("myid = sample (load '" + this.tmpfilepath + "') 0.5;", this.DATALEN / 3, this.DATALEN * 2 / 3);
    }
}

