/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.logicalLayer.parser.QueryParser;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.junit.Test;

public class TestSchemaParser
extends TestCase {
    @Test
    public void test1() throws ParseException, FrontendException {
        String test = "fieldA: int, fieldB:double,fieldC:bYteaRRay, fieldD:charARRAY";
        Schema schema = this.parseSchema(test);
        TestSchemaParser.assertEquals((int)schema.size(), (int)4);
        this.assertAliases(schema, "fieldA", "fieldB", "fieldC", "fieldD");
        this.assertTypes(schema, 10, 25, 50, 55);
    }

    @Test
    public void test2() throws ParseException, FrontendException {
        String test = "fieldA: bag {tuple1:tuple(a:int,b:long,c:float,d:double)}";
        Schema schema = this.parseSchema(test);
        TestSchemaParser.assertEquals((int)schema.size(), (int)1);
        TestSchemaParser.assertEquals((byte)schema.getField((int)0).type, (byte)120);
        TestSchemaParser.assertEquals((String)schema.getField((int)0).alias, (String)"fieldA");
        Schema inner = schema.getField((int)0).schema;
        TestSchemaParser.assertEquals((int)inner.size(), (int)1);
        this.assertAliases(inner.getField((int)0).schema, "a", "b", "c", "d");
        this.assertTypes(inner.getField((int)0).schema, 10, 15, 20, 25);
    }

    @Test
    public void test3() throws ParseException, FrontendException {
        String test = "tuple1: tuple(a:chararray,b:long), tuple2: tuple(c:int,d:float) ";
        Schema schema = this.parseSchema(test);
        TestSchemaParser.assertEquals((int)schema.size(), (int)2);
        this.assertAliases(schema, "tuple1", "tuple2");
        this.assertTypes(schema, 110, 110);
        Schema inner1 = schema.getField((int)0).schema;
        TestSchemaParser.assertEquals((int)inner1.size(), (int)2);
        this.assertAliases(inner1, "a", "b");
        this.assertTypes(inner1, 55, 15);
        Schema inner2 = schema.getField((int)1).schema;
        TestSchemaParser.assertEquals((int)inner2.size(), (int)2);
        this.assertAliases(inner2, "c", "d");
        this.assertTypes(inner2, 10, 20);
    }

    @Test
    public void test4() throws ParseException, FrontendException {
        String test = "garage: bag{tuple1: tuple(num_tools: int)}, links: int";
        Schema schema = this.parseSchema(test);
        TestSchemaParser.assertEquals((int)schema.size(), (int)2);
        this.assertAliases(schema, "garage", "links");
        this.assertTypes(schema, 120, 10);
        TestSchemaParser.assertEquals((byte)schema.getField((int)0).type, (byte)120);
        Schema inner = schema.getField((int)0).schema;
        TestSchemaParser.assertEquals((int)inner.size(), (int)1);
        TestSchemaParser.assertEquals((byte)inner.getField((int)0).type, (byte)110);
        TestSchemaParser.assertEquals((String)inner.getField((int)0).alias, (String)"tuple1");
        Schema innerInner = inner.getField((int)0).schema;
        TestSchemaParser.assertEquals((int)innerInner.size(), (int)1);
        TestSchemaParser.assertEquals((byte)innerInner.getField((int)0).type, (byte)10);
    }

    private void assertAliases(Schema schema, String ... aliases) throws FrontendException {
        for (int i = 0; i < aliases.length; ++i) {
            TestSchemaParser.assertEquals((String)schema.getField((int)i).alias, (String)aliases[i]);
        }
    }

    private void assertTypes(Schema schema, byte ... types) throws FrontendException {
        for (int i = 0; i < types.length; ++i) {
            TestSchemaParser.assertEquals((byte)schema.getField((int)i).type, (byte)types[i]);
        }
    }

    private Schema parseSchema(String schemaString) throws ParseException {
        ByteArrayInputStream stream = new ByteArrayInputStream(schemaString.getBytes());
        QueryParser parser = new QueryParser((InputStream)stream);
        return parser.TupleSchema();
    }
}

