/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.SecondaryKeyOptimizer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Before;

public class TestSecondarySort
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    static PigContext pc = new PigContext(ExecType.MAPREDUCE, MiniCluster.buildCluster().getProperties());

    @Before
    public void setUp() throws Exception {
        FileLocalizer.setR((Random)new Random());
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    public void testDistinctOptimization1() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = LOAD 'input2' AS (b0, b1, b2);");
        planTester.buildPlan("C = cogroup A by a0, B by b0;");
        planTester.buildPlan("D = foreach C { E = limit A 10; F = E.a1; G = DISTINCT F; generate group, COUNT(G);};");
        LogicalPlan lp = planTester.buildPlan("store D into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization2() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = distinct A; generate group, D;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization3() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = A.a0; E = distinct D; generate group, E;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization4() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = A.a1; E = distinct D; F = distinct E; generate group, F;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 2 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization5() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = A.a1; E = distinct D; F = filter E by $0=='1'; generate group, F;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization6() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1';");
        planTester.buildPlan("B = group A by *;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = D.$1; F = DISTINCT E; generate group, COUNT(F);};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization7() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1';");
        planTester.buildPlan("B = group A by *;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = D.$0; F = DISTINCT E; generate group, COUNT(F);};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization8() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0+$1;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = D.$0; F = DISTINCT E; generate group, COUNT(F);};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testDistinctOptimization9() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' as (a:tuple(a0:int, a1:chararray));");
        planTester.buildPlan("B = group A by a.a1;");
        planTester.buildPlan("C = foreach B { D = A.a; E = DISTINCT D; generate group, COUNT(E);};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 1 ? 1 : 0) != 0);
    }

    public void testSortOptimization1() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = order D by $1; generate group, E;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization2() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = order D by $0; generate group, E;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 0 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization3() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = order D by $1; F = order E by $0; generate group, F;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 2 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization4() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = order D by $0, $1, $2; generate group, E;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization5() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = limit A 10; E = order D by $1; F = order E by $2; generate group, F;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization6() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by $0;");
        planTester.buildPlan("C = foreach B { D = order A by $0 desc; generate group, D;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization7() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0, a1, a2);");
        planTester.buildPlan("B = group A by ($0, $1);");
        planTester.buildPlan("C = foreach B { D = order A by $0, $1 desc; generate group, D;};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testSortOptimization8() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("A = LOAD 'input1' AS (a0);");
        planTester.buildPlan("B = group A all;");
        planTester.buildPlan("C = foreach B { D = order A by $0 desc; generate DIFF(D, D);};");
        LogicalPlan lp = planTester.buildPlan("store C into '/tmp';");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        SecondaryKeyOptimizer so = new SecondaryKeyOptimizer(mrPlan);
        so.visit();
        TestSecondarySort.assertTrue((so.getNumMRUseSecondaryKey() == 1 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getNumSortRemoved() == 2 ? 1 : 0) != 0);
        TestSecondarySort.assertTrue((so.getDistinctChanged() == 0 ? 1 : 0) != 0);
    }

    public void testNestedDistinctEndToEnd1() throws Exception {
        File tmpFile1 = File.createTempFile("test", "txt");
        PrintStream ps1 = new PrintStream(new FileOutputStream(tmpFile1));
        ps1.println("1\t2\t3");
        ps1.println("1\t3\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("2\t3\t4");
        ps1.close();
        File tmpFile2 = File.createTempFile("test", "txt");
        PrintStream ps2 = new PrintStream(new FileOutputStream(tmpFile2));
        ps2.println("1\t4\t4");
        ps2.println("2\t3\t1");
        ps2.close();
        Util.copyFromLocalToCluster(this.cluster, tmpFile1.getCanonicalPath(), tmpFile1.getCanonicalPath());
        Util.copyFromLocalToCluster(this.cluster, tmpFile2.getCanonicalPath(), tmpFile2.getCanonicalPath());
        this.pigServer.registerQuery("A = LOAD '" + tmpFile1.getCanonicalPath() + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = LOAD '" + tmpFile2.getCanonicalPath() + "' AS (b0, b1, b2);");
        this.pigServer.registerQuery("C = cogroup A by a0, B by b0 parallel 2;");
        this.pigServer.registerQuery("D = foreach C { E = limit A 10; F = E.a1; G = DISTINCT F; generate group, COUNT(G);};");
        Iterator iter = this.pigServer.openIterator("D");
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(1,2L)"));
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(2,1L)"));
        TestSecondarySort.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, tmpFile1.getCanonicalPath());
        Util.deleteFile(this.cluster, tmpFile2.getCanonicalPath());
    }

    public void testNestedDistinctEndToEnd2() throws Exception {
        File tmpFile1 = File.createTempFile("test", "txt");
        PrintStream ps1 = new PrintStream(new FileOutputStream(tmpFile1));
        ps1.println("1\t2\t3");
        ps1.println("1\t3\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("2\t3\t4");
        ps1.close();
        Util.copyFromLocalToCluster(this.cluster, tmpFile1.getCanonicalPath(), tmpFile1.getCanonicalPath());
        this.pigServer.registerQuery("A = LOAD '" + tmpFile1.getCanonicalPath() + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by $0 parallel 2;");
        this.pigServer.registerQuery("C = foreach B { D = distinct A; generate group, D;};");
        Iterator iter = this.pigServer.openIterator("C");
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(1,{(1,2,3),(1,2,4),(1,3,4)})"));
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(2,{(2,3,4)})"));
        TestSecondarySort.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, tmpFile1.getCanonicalPath());
    }

    public void testNestedSortEndToEnd1() throws Exception {
        File tmpFile1 = File.createTempFile("test", "txt");
        PrintStream ps1 = new PrintStream(new FileOutputStream(tmpFile1));
        ps1.println("1\t2\t3");
        ps1.println("1\t3\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t2\t4");
        ps1.println("2\t3\t4");
        ps1.close();
        Util.copyFromLocalToCluster(this.cluster, tmpFile1.getCanonicalPath(), tmpFile1.getCanonicalPath());
        this.pigServer.registerQuery("A = LOAD '" + tmpFile1.getCanonicalPath() + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by $0 parallel 2;");
        this.pigServer.registerQuery("C = foreach B { D = limit A 10; E = order D by $1; generate group, E;};");
        Iterator iter = this.pigServer.openIterator("C");
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(1,{(1,2,3),(1,2,4),(1,2,4),(1,2,4),(1,3,4)})"));
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(2,{(2,3,4)})"));
        TestSecondarySort.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, tmpFile1.getCanonicalPath());
    }

    public void testNestedSortEndToEnd2() throws Exception {
        File tmpFile1 = File.createTempFile("test", "txt");
        PrintStream ps1 = new PrintStream(new FileOutputStream(tmpFile1));
        ps1.println("1\t2\t3");
        ps1.println("1\t3\t4");
        ps1.println("1\t4\t4");
        ps1.println("1\t2\t4");
        ps1.println("1\t8\t4");
        ps1.println("2\t3\t4");
        ps1.close();
        Util.copyFromLocalToCluster(this.cluster, tmpFile1.getCanonicalPath(), tmpFile1.getCanonicalPath());
        this.pigServer.registerQuery("A = LOAD '" + tmpFile1.getCanonicalPath() + "' AS (a0, a1, a2);");
        this.pigServer.registerQuery("B = group A by $0 parallel 2;");
        this.pigServer.registerQuery("C = foreach B { D = order A by a1 desc; generate group, D;};");
        Iterator iter = this.pigServer.openIterator("C");
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(1,{(1,8,4),(1,4,4),(1,3,4),(1,2,3),(1,2,4)})"));
        TestSecondarySort.assertTrue((boolean)iter.hasNext());
        TestSecondarySort.assertTrue((boolean)((Tuple)iter.next()).toString().equals("(2,{(2,3,4)})"));
        TestSecondarySort.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, tmpFile1.getCanonicalPath());
    }

    public void testNestedSortMultiQueryEndToEnd1() throws Exception {
        this.pigServer.setBatchOn();
        Util.copyFromLocalToCluster(this.cluster, "test/org/apache/pig/test/data/passwd", "testNestedSortMultiQueryEndToEnd1-input.txt");
        this.pigServer.registerQuery("a = load 'testNestedSortMultiQueryEndToEnd1-input.txt' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int, gid:int);");
        this.pigServer.registerQuery("b = group a by uname parallel 2;");
        this.pigServer.registerQuery("c = group a by gid parallel 2;");
        this.pigServer.registerQuery("d = foreach b generate SUM(a.gid);");
        this.pigServer.registerQuery("e = foreach c { f = order a by uid; generate group, f; };");
        this.pigServer.registerQuery("store d into '/tmp/output1';");
        this.pigServer.registerQuery("store e into '/tmp/output2';");
        List jobs = this.pigServer.executeBatch();
        for (ExecJob job : jobs) {
            TestSecondarySort.assertTrue((job.getStatus() == ExecJob.JOB_STATUS.COMPLETED ? 1 : 0) != 0);
        }
        FileLocalizer.delete((String)"/tmp/output1", (PigContext)this.pigServer.getPigContext());
        FileLocalizer.delete((String)"/tmp/output2", (PigContext)this.pigServer.getPigContext());
        Util.deleteFile(this.cluster, "testNestedSortMultiQueryEndToEnd1-input.txt");
    }

    static {
        try {
            pc.connect();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
    }
}

