/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSplitStore
extends TestCase {
    private PigServer pig;
    private PigContext pigContext;
    private File tmpFile;
    private MiniCluster cluster = MiniCluster.buildCluster();

    public TestSplitStore() throws ExecException, IOException {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigContext = this.pig.getPigContext();
        int LOOP_SIZE = 20;
        this.tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile));
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            ps.println(i);
        }
        ps.close();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test1() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.store("A1", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
        this.pig.store("A2", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
    }

    @Test
    public void test2() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.openIterator("A1");
        this.pig.store("A2", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
    }

    @Test
    public void test3() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.openIterator("A2");
        this.pig.store("A1", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
    }

    @Test
    public void test4() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.store("A1", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
        this.pig.openIterator("A2");
    }

    @Test
    public void test5() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.store("A2", "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "'");
        this.pig.openIterator("A1");
    }

    @Test
    public void test6() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.openIterator("A1");
        this.pig.registerQuery("Store A2 into '" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "';");
    }

    @Test
    public void test7() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.openIterator("A2");
        this.pig.registerQuery("Store A1 into '" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "';");
    }

    @Test
    public void test8() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.registerQuery("Store A1 into '" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "';");
        this.pig.openIterator("A2");
    }

    @Test
    public void test9() throws Exception {
        this.pig.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pig.getPigContext()) + "';");
        this.pig.registerQuery("Split A into A1 if $0<=10, A2 if $0>10;");
        this.pig.registerQuery("Store A2 into '" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pigContext) + "';");
        this.pig.openIterator("A1");
    }
}

