/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;

public class TestStoreOld
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private int LOOP_COUNT = 1024;
    String fileName;
    String tmpFile1;
    String tmpFile2;
    PigServer pig;

    public void testSingleStore() throws Exception {
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.store("A", this.tmpFile1);
        this.pig.registerQuery("B = load " + this.tmpFile1 + ";");
        Iterator iter = this.pig.openIterator("B");
        int i = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestStoreOld.assertEquals((int)DataType.toInteger((Object)t.get(0)), (int)i);
            TestStoreOld.assertEquals((int)DataType.toInteger((Object)t.get(1)), (int)i);
            ++i;
        }
    }

    public void testMultipleStore() throws Exception {
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.store("A", this.tmpFile1);
        this.pig.registerQuery("B = foreach (group A by $0) generate $0, SUM($1.$0);");
        this.pig.store("B", this.tmpFile2);
        this.pig.registerQuery("C = load " + this.tmpFile2 + ";");
        Iterator iter = this.pig.openIterator("C");
        int i = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            ++i;
        }
        TestStoreOld.assertEquals((int)this.LOOP_COUNT, (int)i);
    }

    public void testStoreWithMultipleMRJobs() throws Exception {
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.registerQuery("B = foreach (group A by $0) generate $0, SUM($1.$0);");
        this.pig.registerQuery("C = foreach (group B by $0) generate $0, SUM($1.$0);");
        this.pig.registerQuery("D = foreach (group C by $0) generate $0, SUM($1.$0);");
        this.pig.store("D", this.tmpFile2);
        this.pig.registerQuery("E = load " + this.tmpFile2 + ";");
        Iterator iter = this.pig.openIterator("E");
        int i = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            ++i;
        }
        TestStoreOld.assertEquals((int)this.LOOP_COUNT, (int)i);
    }

    protected void setUp() throws Exception {
        super.setUp();
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        for (int i = 0; i < this.LOOP_COUNT; ++i) {
            pw.println(i + "\t" + i);
        }
        pw.close();
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.fileName = "'" + FileLocalizer.hadoopify((String)f.toString(), (PigContext)this.pig.getPigContext()) + "'";
        this.tmpFile1 = "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pig.getPigContext()).toString() + "'";
        this.tmpFile2 = "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pig.getPigContext()).toString() + "'";
        f.delete();
    }
}

