/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStreamingLocal
extends TestCase {
    private TupleFactory tf = DefaultTupleFactory.getInstance();
    PigServer pigServer;
    private static final String simpleEchoStreamingCommand = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? "perl -ne 'print \\\"$_\\\"'" : "perl -ne 'print \"$_\"'";

    @Before
    protected void setUp() throws Exception {
        this.pigServer = new PigServer("local");
    }

    @After
    protected void tearDown() throws Exception {
        this.pigServer.shutdown();
    }

    private Tuple[] setupExpectedResults(Object[] firstField, Object[] secondField) throws ExecException {
        Assert.assertEquals((long)firstField.length, (long)secondField.length);
        Tuple[] expectedResults = new Tuple[firstField.length];
        for (int i = 0; i < expectedResults.length; ++i) {
            expectedResults[i] = this.tf.newTuple(2);
            expectedResults[i].set(0, firstField[i]);
            expectedResults[i].set(1, secondField[i]);
        }
        return expectedResults;
    }

    @Test
    public void testSimpleMapSideStreaming() throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1", "B,2", "C,3", "D,2", "A,5", "B,5", "C,8", "A,8", "D,8", "A,9"});
        Object[] expectedFirstFields = new String[]{"A", "B", "C", "A", "D", "A"};
        Object[] expectedSecondFields = new Integer[]{5, 5, 8, 8, 8, 9};
        boolean[] withTypes = new boolean[]{true, false};
        for (int i = 0; i < withTypes.length; ++i) {
            Tuple[] expectedResults = null;
            expectedResults = withTypes[i] ? this.setupExpectedResults(expectedFirstFields, expectedSecondFields) : this.setupExpectedResults(Util.toDataByteArrays(expectedFirstFields), Util.toDataByteArrays(expectedSecondFields));
            this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
            this.pigServer.registerQuery("FILTERED_DATA = filter IP by $1 > '3';");
            this.pigServer.registerQuery("S1 = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "`;");
            if (withTypes[i]) {
                this.pigServer.registerQuery("OP = stream S1 through `" + simpleEchoStreamingCommand + "` as (f0:chararray, f1:int);");
            } else {
                this.pigServer.registerQuery("OP = stream S1 through `" + simpleEchoStreamingCommand + "`;");
            }
            Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
        }
    }

    @Test
    public void testSimpleMapSideStreamingWithOutputSchema() throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1", "B,2", "C,3", "D,2", "A,5", "B,5", "C,8", "A,8", "D,8", "A,9"});
        Object[] expectedFirstFields = new String[]{"C", "A", "D", "A"};
        Object[] expectedSecondFields = new Integer[]{8, 8, 8, 9};
        boolean[] withTypes = new boolean[]{true, false};
        for (int i = 0; i < withTypes.length; ++i) {
            Tuple[] expectedResults = null;
            expectedResults = withTypes[i] ? this.setupExpectedResults(expectedFirstFields, expectedSecondFields) : this.setupExpectedResults(Util.toDataByteArrays(expectedFirstFields), Util.toDataByteArrays(expectedSecondFields));
            this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
            this.pigServer.registerQuery("FILTERED_DATA = filter IP by $1 > '3';");
            if (withTypes[i]) {
                this.pigServer.registerQuery("STREAMED_DATA = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "` as (f0:chararray, f1:int);");
            } else {
                this.pigServer.registerQuery("STREAMED_DATA = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "` as (f0, f1);");
            }
            this.pigServer.registerQuery("OP = filter STREAMED_DATA by f1 > 6;");
            Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
        }
    }

    @Test
    public void testSimpleReduceSideStreamingAfterFlatten() throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1", "B,2", "C,3", "D,2", "A,5", "B,5", "C,8", "A,8", "D,8", "A,9"});
        Object[] expectedFirstFields = new String[]{"A", "A", "A", "B", "C", "D"};
        Object[] expectedSecondFields = new Integer[]{5, 8, 9, 5, 8, 8};
        boolean[] withTypes = new boolean[]{true, false};
        for (int i = 0; i < withTypes.length; ++i) {
            Tuple[] expectedResults = null;
            expectedResults = withTypes[i] ? this.setupExpectedResults(expectedFirstFields, expectedSecondFields) : this.setupExpectedResults(Util.toDataByteArrays(expectedFirstFields), Util.toDataByteArrays(expectedSecondFields));
            this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
            this.pigServer.registerQuery("FILTERED_DATA = filter IP by $1 > '3';");
            this.pigServer.registerQuery("GROUPED_DATA = group FILTERED_DATA by $0;");
            this.pigServer.registerQuery("FLATTENED_GROUPED_DATA = foreach GROUPED_DATA generate flatten($1);");
            this.pigServer.registerQuery("S1 = stream FLATTENED_GROUPED_DATA through `" + simpleEchoStreamingCommand + "`;");
            if (withTypes[i]) {
                this.pigServer.registerQuery("OP = stream S1 through `" + simpleEchoStreamingCommand + "` as (f0:chararray, f1:int);");
            } else {
                this.pigServer.registerQuery("OP = stream S1 through `" + simpleEchoStreamingCommand + "`;");
            }
            Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
        }
    }

    @Test
    public void testSimpleOrderedReduceSideStreamingAfterFlatten() throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1,2,3", "B,2,4,5", "C,3,1,2", "D,2,5,2", "A,5,5,1", "B,5,7,4", "C,8,9,2", "A,8,4,5", "D,8,8,3", "A,9,2,5"});
        String[] expectedFirstFields = new String[]{"A", "A", "A", "A", "B", "B", "C", "C", "D", "D"};
        Integer[] expectedSecondFields = new Integer[]{1, 9, 8, 5, 2, 5, 3, 8, 2, 8};
        Integer[] expectedThirdFields = new Integer[]{2, 2, 4, 5, 4, 7, 1, 9, 5, 8};
        Integer[] expectedFourthFields = new Integer[]{3, 5, 5, 1, 5, 4, 2, 2, 2, 3};
        Tuple[] expectedResults = new Tuple[10];
        for (int i = 0; i < expectedResults.length; ++i) {
            expectedResults[i] = this.tf.newTuple(4);
            expectedResults[i].set(0, (Object)expectedFirstFields[i]);
            expectedResults[i].set(1, (Object)expectedSecondFields[i]);
            expectedResults[i].set(2, (Object)expectedThirdFields[i]);
            expectedResults[i].set(3, (Object)expectedFourthFields[i]);
        }
        this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
        this.pigServer.registerQuery("FILTERED_DATA = filter IP by $1 > '3';");
        this.pigServer.registerQuery("S1 = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "`;");
        this.pigServer.registerQuery("S2 = stream S1 through `" + simpleEchoStreamingCommand + "`;");
        this.pigServer.registerQuery("GROUPED_DATA = group IP by $0;");
        this.pigServer.registerQuery("ORDERED_DATA = foreach GROUPED_DATA {   D = order IP BY $2, $3;  generate flatten(D);};");
        this.pigServer.registerQuery("S3 = stream ORDERED_DATA through `" + simpleEchoStreamingCommand + "`;");
        this.pigServer.registerQuery("OP = stream S3 through `" + simpleEchoStreamingCommand + "` as (f0:chararray, f1:int, f2:int, f3:int);");
        Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
    }

    @Test
    public void testSimpleMapSideStreamingWithUnixPipes() throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1", "B,2", "C,3", "D,2", "A,5", "B,5", "C,8", "A,8", "D,8", "A,9"});
        Object[] expectedFirstFields = new String[]{"A", "B", "C", "D", "A", "B", "C", "A", "D", "A"};
        Object[] expectedSecondFields = new Integer[]{1, 2, 3, 2, 5, 5, 8, 8, 8, 9};
        boolean[] withTypes = new boolean[]{true, false};
        for (int i = 0; i < withTypes.length; ++i) {
            Tuple[] expectedResults = null;
            expectedResults = withTypes[i] ? this.setupExpectedResults(expectedFirstFields, expectedSecondFields) : this.setupExpectedResults(Util.toDataByteArrays(expectedFirstFields), Util.toDataByteArrays(expectedSecondFields));
            this.pigServer.registerQuery("define CMD `" + simpleEchoStreamingCommand + " | " + simpleEchoStreamingCommand + "`;");
            this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
            if (withTypes[i]) {
                this.pigServer.registerQuery("OP = stream IP through CMD as (f0:chararray, f1:int);");
            } else {
                this.pigServer.registerQuery("OP = stream IP through CMD;");
            }
            Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
        }
    }

    @Test
    public void testJoinTwoStreamingRelations() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            list.add("A," + i);
        }
        File input = Util.createInputFile("tmp", "", list.toArray(new String[0]));
        Tuple expected = DefaultTupleFactory.getInstance().newTuple(4);
        expected.set(0, (Object)"A");
        expected.set(1, (Object)0);
        expected.set(2, (Object)"A");
        expected.set(3, (Object)0);
        this.pigServer.registerQuery("A = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',') as (a0, a1);");
        this.pigServer.registerQuery("B = stream A through `head -1` as (a0, a1);");
        this.pigServer.registerQuery("C = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',') as (a0, a1);");
        this.pigServer.registerQuery("D = stream C through `head -1` as (a0, a1);");
        this.pigServer.registerQuery("E = join B by a0, D by a0;");
        Iterator iter = this.pigServer.openIterator("E");
        int count = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((Object)expected.toString(), (Object)((Tuple)iter.next()).toString());
            ++count;
        }
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLocalNegativeLoadStoreOptimization() throws Exception {
        this.testNegativeLoadStoreOptimization(ExecType.LOCAL);
    }

    private void testNegativeLoadStoreOptimization(ExecType execType) throws Exception {
        File input = Util.createInputFile("tmp", "", new String[]{"A,1", "B,2", "C,3", "D,2", "A,5", "B,5", "C,8", "A,8", "D,8", "A,9"});
        Object[] expectedFirstFields = new String[]{"A", "B", "C", "A", "D", "A"};
        Object[] expectedSecondFields = new Integer[]{5, 5, 8, 8, 8, 9};
        boolean[] withTypes = new boolean[]{true, false};
        for (int i = 0; i < withTypes.length; ++i) {
            Tuple[] expectedResults = null;
            expectedResults = withTypes[i] ? this.setupExpectedResults(expectedFirstFields, expectedSecondFields) : this.setupExpectedResults(Util.toDataByteArrays(expectedFirstFields), Util.toDataByteArrays(expectedSecondFields));
            this.pigServer.registerQuery("define CMD `" + simpleEchoStreamingCommand + "` input(stdin);");
            this.pigServer.registerQuery("IP = load 'file:" + Util.encodeEscape(input.toString()) + "' using " + PigStorage.class.getName() + "(',');");
            this.pigServer.registerQuery("FILTERED_DATA = filter IP by $1 > '3';");
            if (withTypes[i]) {
                this.pigServer.registerQuery("OP = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "` as (f0:chararray, f1:int);");
            } else {
                this.pigServer.registerQuery("OP = stream FILTERED_DATA through `" + simpleEchoStreamingCommand + "`;");
            }
            Util.checkQueryOutputs(this.pigServer.openIterator("OP"), expectedResults);
        }
    }
}

